/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MPInstance;
import org.compiere.print.ServerReportCtl;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFProcess;

public class ServerProcessCtl
implements Runnable {
    private static CLogger log = CLogger.getCLogger(ServerProcessCtl.class);
    ProcessInfo m_pi;
    private Trx m_trx;
    private boolean managedTrxForJavaProcess = true;

    public ServerProcessCtl(ProcessInfo pi, Trx trx) {
        this.m_pi = pi;
        this.m_trx = trx;
    }

    public static ServerProcessCtl process(ProcessInfo pi, Trx trx) {
        return ServerProcessCtl.process(pi, trx, true);
    }

    public static ServerProcessCtl process(ProcessInfo pi, Trx trx, boolean managedTrxForJavaProcess) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("ServerProcess - " + pi);
        }
        MPInstance instance = null;
        if (pi.getAD_PInstance_ID() <= 0) {
            try {
                instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
            }
            catch (Exception e) {
                pi.setSummary(e.getLocalizedMessage());
                pi.setError(true);
                log.warning(pi.toString());
                return null;
            }
            catch (Error e) {
                pi.setSummary(e.getLocalizedMessage());
                pi.setError(true);
                log.warning(pi.toString());
                return null;
            }
            if (!instance.save()) {
                pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
                pi.setError(true);
                return null;
            }
            pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        } else {
            instance = new MPInstance(Env.getCtx(), pi.getAD_PInstance_ID(), null);
        }
        ServerProcessCtl worker = new ServerProcessCtl(pi, trx);
        worker.setManagedTrxForJavaProcess(managedTrxForJavaProcess);
        worker.run();
        return worker;
    }

    public void start() {
        Thread thread = new Thread(this);
        if (this.m_pi != null) {
            thread.setName(String.valueOf(this.m_pi.getTitle()) + "-" + this.m_pi.getAD_PInstance_ID());
        }
        thread.start();
    }

    @Override
    public void run() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID() + ", Record_ID=" + this.m_pi.getRecord_ID());
        }
        String ProcedureName = "";
        String JasperReport = "";
        int AD_ReportView_ID = 0;
        int AD_Workflow_ID = 0;
        boolean IsReport = false;
        try {
            MPInstance.PInstanceInfo info = MPInstance.getPInstanceInfo(this.m_pi.getAD_PInstance_ID());
            if (info != null) {
                this.m_pi.setTitle(info.name);
                ProcedureName = info.procedureName;
                this.m_pi.setClassName(info.className);
                this.m_pi.setAD_Process_ID(info.AD_Process_ID);
                this.m_pi.setAD_Process_UU(info.AD_Process_UU);
                if (info.isReport) {
                    IsReport = true;
                }
                AD_ReportView_ID = info.AD_ReportView_ID;
                AD_Workflow_ID = info.AD_Workflow_ID;
                int estimate = info.estimate;
                if (estimate != 0) {
                    this.m_pi.setEstSeconds(estimate + 1);
                }
                JasperReport = info.jasperReport;
            } else {
                log.log(Level.SEVERE, "No AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID());
            }
        }
        catch (Throwable e) {
            this.m_pi.setSummary(String.valueOf(Msg.getMsg(Env.getCtx(), "ProcessNoProcedure")) + " " + e.getLocalizedMessage(), true);
            log.log(Level.SEVERE, "run", e);
            return;
        }
        if (ProcedureName == null) {
            ProcedureName = "";
        }
        if (AD_Workflow_ID > 0) {
            this.startWorkflow(AD_Workflow_ID);
            return;
        }
        boolean isJasper = false;
        if (JasperReport != null && JasperReport.trim().length() > 0) {
            isJasper = true;
            if ("org.adempiere.report.jasper.ReportStarter".equals(this.m_pi.getClassName())) {
                this.m_pi.setClassName(null);
            }
        }
        if (this.m_pi.getClassName() != null) {
            if (isJasper) {
                this.m_pi.setReportingProcess(true);
            }
            if (!this.startProcess()) {
                return;
            }
            if (!IsReport && ProcedureName.length() == 0) {
                return;
            }
            if (IsReport && AD_ReportView_ID == 0 && !isJasper) {
                return;
            }
        }
        if (IsReport && ProcedureName.length() > 0) {
            this.m_pi.setReportingProcess(true);
            if (!this.startDBProcess(ProcedureName)) {
                return;
            }
        }
        if (isJasper) {
            this.m_pi.setReportingProcess(true);
            this.m_pi.setClassName("org.adempiere.report.jasper.ReportStarter");
            this.startProcess();
            return;
        }
        if (IsReport) {
            this.m_pi.setReportingProcess(true);
            boolean ok = ServerReportCtl.start(this.m_pi);
            String summ = Util.cleanAmp(Msg.getMsg(Env.getCtx(), "Report"));
            this.m_pi.setSummary(summ, !ok);
        } else {
            if (!this.startDBProcess(ProcedureName)) {
                return;
            }
            ProcessInfoUtil.setSummaryFromDB(this.m_pi);
        }
    }

    protected boolean startWorkflow(int AD_Workflow_ID) {
        MWFProcess wfProcess;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(AD_Workflow_ID) + " - " + this.m_pi);
        }
        boolean started = false;
        if (this.m_trx != null) {
            this.m_pi.setTransactionName(this.m_trx.getTrxName());
        }
        started = (wfProcess = ProcessUtil.startWorkFlow(Env.getCtx(), this.m_pi, AD_Workflow_ID)) != null;
        return started;
    }

    protected boolean startProcess() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.m_pi.toString());
        }
        if (this.m_pi.getClassName().toLowerCase().startsWith("@script:")) {
            return ProcessUtil.startScriptProcess(Env.getCtx(), this.m_pi, this.m_trx);
        }
        return ProcessUtil.startJavaProcess(Env.getCtx(), this.m_pi, this.m_trx, this.managedTrxForJavaProcess);
    }

    protected boolean startDBProcess(String ProcedureName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(ProcedureName) + "(" + this.m_pi.getAD_PInstance_ID() + ")");
        }
        return ProcessUtil.startDatabaseProcedure(this.m_pi, ProcedureName, this.m_trx);
    }

    public void setManagedTrxForJavaProcess(boolean managedTrx) {
        this.managedTrxForJavaProcess = managedTrx;
    }

    public boolean isManagedTrxForJavaProcess() {
        return this.managedTrxForJavaProcess;
    }
}

