/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import org.compiere.util.DB;
import org.compiere.util.Util;

public class ProcessInfoParameter
implements Serializable {
    private static final long serialVersionUID = -5396796617617359891L;
    private String m_ParameterName;
    private Object m_Parameter;
    private Object m_Parameter_To;
    private String m_Info = "";
    private String m_Info_To = "";
    private boolean m_IsNotClause;

    public ProcessInfoParameter(String parameterName, Object parameter, Object parameter_To, String info, String info_To) {
        this(parameterName, parameter, parameter_To, info, info_To, false);
    }

    public ProcessInfoParameter(String parameterName, Object parameter, Object parameter_To, String info, String info_To, boolean isNotClause) {
        this.setParameterName(parameterName);
        this.setParameter(parameter);
        this.setParameter_To(parameter_To);
        this.setInfo(info);
        this.setInfo_To(info_To);
        this.setIsNotClause(isNotClause);
    }

    public String toString() {
        if (this.m_Parameter_To != null || this.m_Info_To.length() > 0) {
            return "ProcessInfoParameter[" + this.m_ParameterName + "=" + this.m_Parameter + (this.m_Parameter == null ? "" : "{" + this.m_Parameter.getClass().getName() + "}") + " (" + this.m_Info + ") - " + this.m_Parameter_To + (this.m_Parameter_To == null ? "" : "{" + this.m_Parameter_To.getClass().getName() + "}") + " (" + this.m_Info_To + ")";
        }
        return "ProcessInfoParameter[" + this.m_ParameterName + "=" + this.m_Parameter + (this.m_Parameter == null ? "" : "{" + this.m_Parameter.getClass().getName() + "}") + " (" + this.m_Info + ")";
    }

    public String getInfo() {
        return this.m_Info;
    }

    public String getInfo_To() {
        return this.m_Info_To;
    }

    public Object getParameter() {
        return this.m_Parameter;
    }

    public int getParameterAsInt() {
        if (this.m_Parameter == null) {
            return 0;
        }
        if (this.m_Parameter instanceof Number) {
            return ((Number)this.m_Parameter).intValue();
        }
        BigDecimal bd = new BigDecimal(this.m_Parameter.toString());
        return bd.intValue();
    }

    public boolean getParameterAsBoolean() {
        if (this.m_Parameter == null) {
            return false;
        }
        if (this.m_Parameter instanceof Boolean) {
            return (Boolean)this.m_Parameter;
        }
        return "Y".equals(this.m_Parameter);
    }

    public Object getParameter_To() {
        return this.m_Parameter_To;
    }

    public int getParameter_ToAsInt() {
        if (this.m_Parameter_To == null) {
            return 0;
        }
        if (this.m_Parameter_To instanceof Number) {
            return ((Number)this.m_Parameter_To).intValue();
        }
        BigDecimal bd = new BigDecimal(this.m_Parameter_To.toString());
        return bd.intValue();
    }

    public boolean getParameter_ToAsBoolean() {
        if (this.m_Parameter_To == null) {
            return false;
        }
        if (this.m_Parameter_To instanceof Boolean) {
            return (Boolean)this.m_Parameter_To;
        }
        return "Y".equals(this.m_Parameter_To);
    }

    public Timestamp getParameter_ToAsTimestamp() {
        if (this.m_Parameter_To == null) {
            return null;
        }
        if (this.m_Parameter_To instanceof Timestamp) {
            return (Timestamp)this.m_Parameter_To;
        }
        return null;
    }

    public Timestamp getParameterAsTimestamp() {
        if (this.m_Parameter == null) {
            return null;
        }
        if (this.m_Parameter instanceof Timestamp) {
            return (Timestamp)this.m_Parameter;
        }
        return null;
    }

    public String getParameter_ToAsString() {
        if (this.m_Parameter_To == null) {
            return null;
        }
        return this.m_Parameter_To.toString();
    }

    public String getParameterAsString() {
        if (this.m_Parameter == null) {
            return null;
        }
        return this.m_Parameter.toString();
    }

    public BigDecimal getParameter_ToAsBigDecimal() {
        if (this.m_Parameter_To == null) {
            return null;
        }
        if (this.m_Parameter_To instanceof BigDecimal) {
            return (BigDecimal)this.m_Parameter_To;
        }
        return new BigDecimal(this.m_Parameter_To.toString());
    }

    public BigDecimal getParameterAsBigDecimal() {
        if (this.m_Parameter == null) {
            return null;
        }
        if (this.m_Parameter instanceof BigDecimal) {
            return (BigDecimal)this.m_Parameter;
        }
        return new BigDecimal(this.m_Parameter.toString());
    }

    public String getParameterName() {
        return this.m_ParameterName;
    }

    public boolean isNotClause() {
        return this.m_IsNotClause;
    }

    public void setInfo(String Info) {
        this.m_Info = Info == null ? "" : Info;
    }

    public void setInfo_To(String Info_To) {
        this.m_Info_To = Info_To == null ? "" : Info_To;
    }

    public void setParameter(Object Parameter2) {
        this.m_Parameter = Parameter2;
    }

    public void setParameter_To(Object Parameter_To) {
        this.m_Parameter_To = Parameter_To;
    }

    public void setParameterName(String ParameterName) {
        this.m_ParameterName = ParameterName;
    }

    public void setIsNotClause(boolean IsNotClause) {
        this.m_IsNotClause = IsNotClause;
    }

    public String getParameterAsCSVInt() {
        return this.getParameterAsCSVInt(this.getParameterAsString());
    }

    public String getParameter_ToAsCSVInt() {
        return this.getParameterAsCSVInt(this.getParameter_ToAsString());
    }

    private String getParameterAsCSVInt(String param) {
        String[] strarr;
        if (Util.isEmpty(param)) {
            return "";
        }
        String[] stringArray = strarr = param.split(",");
        int n = strarr.length;
        int n2 = 0;
        while (n2 < n) {
            String par = stringArray[n2];
            Integer.valueOf(par);
            ++n2;
        }
        return param;
    }

    public String getParameterAsCSVString() {
        return this.getParameterAsCSVString(this.getParameterAsString());
    }

    public String getParameter_ToAsCSVString() {
        return this.getParameterAsCSVString(this.getParameter_ToAsString());
    }

    private String getParameterAsCSVString(String param) {
        if (Util.isEmpty(param)) {
            return "";
        }
        String[] strarr = param.split(",");
        StringBuilder whereValidated = new StringBuilder();
        String[] stringArray = strarr;
        int n = strarr.length;
        int n2 = 0;
        while (n2 < n) {
            String par = stringArray[n2];
            if (whereValidated.length() > 0) {
                whereValidated.append(",");
            }
            whereValidated.append(DB.TO_STRING(par));
            ++n2;
        }
        return whereValidated.toString();
    }

    public int[] getParameterAsIntArray() {
        return this.getParameterAsIntArray(this.getParameterAsString());
    }

    public int[] getParameterToAsIntArray() {
        return this.getParameterAsIntArray(this.getParameter_ToAsString());
    }

    private int[] getParameterAsIntArray(String param) {
        if (Util.isEmpty(param)) {
            return new int[0];
        }
        return Arrays.stream(param.split(",")).mapToInt(Integer::parseInt).toArray();
    }

    public String[] getParameterAsStringArray() {
        return this.getParameterAsStringArray(this.getParameterAsString());
    }

    public String[] getParameterToAsStringArray() {
        return this.getParameterAsStringArray(this.getParameter_ToAsString());
    }

    private String[] getParameterAsStringArray(String param) {
        ArrayList<String> list = new ArrayList<String>();
        if (!Util.isEmpty(param)) {
            String[] stringArray = param.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String par = stringArray[n2];
                list.add(par);
                ++n2;
            }
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

