/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class ProcessInfo
implements Serializable {
    private static final long serialVersionUID = -4648764346588157872L;
    private static final CLogger logger = CLogger.getCLogger(ProcessInfo.class);
    private String m_AD_Process_UU;
    private String m_Title;
    private int m_AD_Process_ID;
    private int m_Table_ID;
    private int m_Record_ID;
    private Integer m_AD_User_ID;
    private Integer m_AD_Client_ID;
    private String m_ClassName = null;
    private int m_AD_PInstance_ID = 0;
    private int m_InfoWindowID = 0;
    private String m_Summary = "";
    private boolean m_Error = false;
    private Serializable m_SerializableObject = null;
    private transient Object m_TransientObject = null;
    private int m_EstSeconds = 5;
    private boolean m_batch = false;
    private boolean m_timeout = false;
    private ArrayList<ProcessInfoLog> m_logs = null;
    private ProcessInfoParameter[] m_parameter = null;
    private String m_transactionName = null;
    private boolean m_printPreview = false;
    private boolean m_reportingProcess = false;
    private File m_pdf_report = null;
    private List<Integer> m_Record_IDs = null;
    private boolean m_export = false;
    private String m_exportFileExtension = null;
    private File m_exportFile = null;
    private boolean m_IsReplaceTabContent = false;
    private int m_rowCount;
    private transient PO m_po = null;
    private String reportType = null;
    private boolean isSummary = false;
    private int languageID = 0;
    private String showHelp = null;
    private int m_AD_Scheduler_ID = 0;
    private boolean isNotifyRecipients = true;
    private String m_PDFfileName;
    private IProcessUI processUI;

    public ProcessInfo(String Title, int AD_Process_ID, int Table_ID, int Record_ID) {
        this.setTitle(Title);
        this.setAD_Process_ID(AD_Process_ID);
        this.setTable_ID(Table_ID);
        this.setRecord_ID(Record_ID);
        this.m_printPreview = Ini.isPropertyBool("PrintPreview");
    }

    public ProcessInfo(String Title, int AD_Process_ID) {
        this(Title, AD_Process_ID, 0, 0);
    }

    public int getLanguageID() {
        return this.languageID;
    }

    public void setLanguageID(int languageID) {
        this.languageID = languageID;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        if (!Util.isEmpty(reportType)) {
            this.reportType = reportType;
        }
    }

    public void setIsSummary(boolean isSummary) {
        this.isSummary = isSummary;
    }

    public boolean isSummary() {
        return this.isSummary;
    }

    public void setShowHelp(String showHelp) {
        this.showHelp = showHelp;
    }

    public String getShowHelp() {
        return this.showHelp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProcessInfo[");
        sb.append(this.m_Title).append(",Process_ID=").append(this.m_AD_Process_ID);
        if (this.m_AD_PInstance_ID != 0) {
            sb.append(",AD_PInstance_ID=").append(this.m_AD_PInstance_ID);
        }
        if (this.m_Record_ID != 0) {
            sb.append(",Record_ID=").append(this.m_Record_ID);
        }
        if (this.m_ClassName != null) {
            sb.append(",ClassName=").append(this.m_ClassName);
        }
        sb.append(",Error=").append(this.isError());
        if (this.m_TransientObject != null) {
            sb.append(",Transient=").append(this.m_TransientObject);
        }
        if (this.m_SerializableObject != null) {
            sb.append(",Serializable=").append(this.m_SerializableObject);
        }
        if (this.m_transactionName != null) {
            sb.append(",Trx=").append(this.m_transactionName);
        }
        sb.append(",Summary=").append(this.getSummary()).append(",Log=").append(this.m_logs == null ? 0 : this.m_logs.size());
        sb.append("]");
        return sb.toString();
    }

    public void setSummary(String summary) {
        this.m_Summary = summary;
    }

    public String getSummary() {
        return Util.cleanAmp(this.m_Summary);
    }

    public void setSummary(String translatedSummary, boolean error) {
        this.setSummary(translatedSummary);
        this.setError(error);
    }

    public void addSummary(String additionalSummary) {
        this.m_Summary = String.valueOf(this.m_Summary) + additionalSummary;
    }

    public void setError(boolean error) {
        this.m_Error = error;
    }

    public boolean isError() {
        return this.m_Error;
    }

    public void setIsBatch(boolean batch) {
        this.m_batch = batch;
    }

    public boolean isBatch() {
        return this.m_batch;
    }

    public void setIsTimeout(boolean timeout) {
        this.m_timeout = timeout;
    }

    public boolean isTimeout() {
        return this.m_timeout;
    }

    public String getLogInfo(boolean html2) {
        if (this.m_logs == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat dateFormat = DisplayType.getDateFormat(15);
        if (html2) {
            sb.append("<table width=\"100%\" border=\"1\" cellspacing=\"0\" cellpadding=\"2\">");
        }
        int i2 = 0;
        while (i2 < this.m_logs.size()) {
            if (html2) {
                sb.append("<tr>");
            } else if (i2 > 0) {
                sb.append("\n");
            }
            ProcessInfoLog log = this.m_logs.get(i2);
            if (log.getP_Date() != null) {
                sb.append(html2 ? "<td>" : "").append(dateFormat.format(log.getP_Date())).append(html2 ? "</td>" : " \t");
            }
            if (log.getP_Number() != null) {
                sb.append(html2 ? "<td>" : "").append(log.getP_Number()).append(html2 ? "</td>" : " \t");
            }
            if (log.getP_Msg() != null) {
                sb.append(html2 ? "<td>" : "").append(Msg.parseTranslation(Env.getCtx(), log.getP_Msg())).append(html2 ? "</td>" : "");
            }
            if (html2) {
                sb.append("</tr>");
            }
            ++i2;
        }
        if (html2) {
            sb.append("</table>");
        }
        return sb.toString();
    }

    public String getLogInfo() {
        return this.getLogInfo(false);
    }

    public int getAD_PInstance_ID() {
        return this.m_AD_PInstance_ID;
    }

    public void setAD_PInstance_ID(int AD_PInstance_ID) {
        this.m_AD_PInstance_ID = AD_PInstance_ID;
    }

    public int getAD_InfoWindow_ID() {
        return this.m_InfoWindowID;
    }

    public void setAD_InfoWindow_ID(int infoWindowID) {
        this.m_InfoWindowID = infoWindowID;
    }

    public int getAD_Process_ID() {
        return this.m_AD_Process_ID;
    }

    public void setAD_Process_ID(int AD_Process_ID) {
        this.m_AD_Process_ID = AD_Process_ID;
    }

    public String getClassName() {
        return this.m_ClassName;
    }

    public void setClassName(String ClassName) {
        this.m_ClassName = ClassName;
        if (this.m_ClassName != null && this.m_ClassName.length() == 0) {
            this.m_ClassName = null;
        }
    }

    public Object getTransientObject() {
        return this.m_TransientObject;
    }

    public void setTransientObject(Object TransientObject) {
        this.m_TransientObject = TransientObject;
    }

    public Serializable getSerializableObject() {
        return this.m_SerializableObject;
    }

    public void setSerializableObject(Serializable SerializableObject) {
        this.m_SerializableObject = SerializableObject;
    }

    public int getEstSeconds() {
        return this.m_EstSeconds;
    }

    public void setEstSeconds(int EstSeconds) {
        this.m_EstSeconds = EstSeconds;
    }

    public int getTable_ID() {
        return this.m_Table_ID;
    }

    public void setTable_ID(int AD_Table_ID) {
        this.m_Table_ID = AD_Table_ID;
    }

    public int getRecord_ID() {
        return this.m_Record_ID;
    }

    public void setRecord_ID(int Record_ID) {
        this.m_Record_ID = Record_ID;
    }

    public String getTitle() {
        return this.m_Title;
    }

    public void setTitle(String Title) {
        this.m_Title = Title;
    }

    public void setAD_Client_ID(int AD_Client_ID) {
        this.m_AD_Client_ID = AD_Client_ID;
    }

    public Integer getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public void setAD_User_ID(int AD_User_ID) {
        this.m_AD_User_ID = AD_User_ID;
    }

    public Integer getAD_User_ID() {
        return this.m_AD_User_ID;
    }

    public ProcessInfoParameter[] getParameter() {
        return this.m_parameter;
    }

    public void setParameter(ProcessInfoParameter[] parameter) {
        this.m_parameter = parameter;
    }

    public void addLog(int Log_ID, int P_ID, Timestamp P_Date, BigDecimal P_Number, String P_Msg, int tableId, int recordId) {
        this.addLog(new ProcessInfoLog(Log_ID, P_ID, P_Date, P_Number, P_Msg, tableId, recordId));
    }

    public void addLog(int P_ID, Timestamp P_Date, BigDecimal P_Number, String P_Msg, int tableId, int recordId) {
        this.addLog(new ProcessInfoLog(P_ID, P_Date, P_Number, P_Msg, tableId, recordId));
    }

    public void addLog(int Log_ID, int P_ID, Timestamp P_Date, BigDecimal P_Number, String P_Msg) {
        this.addLog(new ProcessInfoLog(Log_ID, P_ID, P_Date, P_Number, P_Msg));
    }

    public void addLog(int P_ID, Timestamp P_Date, BigDecimal P_Number, String P_Msg) {
        this.addLog(new ProcessInfoLog(P_ID, P_Date, P_Number, P_Msg));
    }

    public void addLog(ProcessInfoLog logEntry) {
        if (logEntry == null) {
            return;
        }
        if (this.m_logs == null) {
            this.m_logs = new ArrayList();
        }
        this.m_logs.add(logEntry);
    }

    public ProcessInfoLog[] getLogs() {
        if (this.m_logs == null) {
            return null;
        }
        ProcessInfoLog[] logs = new ProcessInfoLog[this.m_logs.size()];
        this.m_logs.toArray(logs);
        return logs;
    }

    public int[] getIDs() {
        if (this.m_logs == null) {
            return null;
        }
        ArrayList<Integer> idsarray = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < this.m_logs.size()) {
            if (this.m_logs.get(i2).getP_ID() > 0) {
                idsarray.add(this.m_logs.get(i2).getP_ID());
            }
            ++i2;
        }
        int[] ids = new int[idsarray.size()];
        int i3 = 0;
        while (i3 < idsarray.size()) {
            ids[i3] = (Integer)idsarray.get(i3);
            ++i3;
        }
        return ids;
    }

    public ArrayList<ProcessInfoLog> getLogList() {
        return this.m_logs;
    }

    public void setLogList(ArrayList<ProcessInfoLog> logs) {
        this.m_logs = logs;
    }

    public String getTransactionName() {
        return this.m_transactionName;
    }

    public String getAD_Process_UU() {
        return this.m_AD_Process_UU;
    }

    public void setAD_Process_UU(String AD_Process_UU) {
        this.m_AD_Process_UU = AD_Process_UU;
    }

    public void setTransactionName(String trxName) {
        this.m_transactionName = trxName;
    }

    public void setPrintPreview(boolean b2) {
        this.m_printPreview = b2;
    }

    public boolean isPrintPreview() {
        return this.m_printPreview;
    }

    public boolean isReportingProcess() {
        return this.m_reportingProcess;
    }

    public void setReportingProcess(boolean f) {
        this.m_reportingProcess = f;
    }

    public void setPDFReport(File f) {
        this.m_pdf_report = f;
    }

    public File getPDFReport() {
        return this.m_pdf_report;
    }

    public boolean isExport() {
        return this.m_export;
    }

    public void setExport(boolean export) {
        this.m_export = export;
    }

    public String getExportFileExtension() {
        return this.m_exportFileExtension;
    }

    public void setExportFileExtension(String exportFileExtension) {
        this.m_exportFileExtension = exportFileExtension;
    }

    public File getExportFile() {
        return this.m_exportFile;
    }

    public void setExportFile(File exportFile) {
        this.m_exportFile = exportFile;
    }

    public List<Integer> getRecord_IDs() {
        return this.m_Record_IDs;
    }

    public void setRecord_IDs(List<Integer> Record_IDs) {
        this.m_Record_IDs = Record_IDs;
    }

    public void setRowCount(int rowCount) {
        this.m_rowCount = rowCount;
    }

    public int getRowCount() {
        return this.m_rowCount;
    }

    public void setPO(PO po) {
        this.m_po = po;
    }

    public PO getPO() {
        return this.m_po;
    }

    public String getPDFFileName() {
        return this.m_PDFfileName;
    }

    public void setPDFFileName(String fileName) {
        this.m_PDFfileName = fileName;
    }

    public boolean isProcessRunning(MPInstancePara[] params) {
        MProcess process = MProcess.get(Env.getCtx(), this.getAD_Process_ID());
        String multipleExecutions = process.getAllowMultipleExecution();
        if (multipleExecutions == null || multipleExecutions.isEmpty()) {
            return false;
        }
        Timestamp lastRebootDate = this.getLastServerRebootDate();
        if (lastRebootDate == null) {
            return false;
        }
        List processInstanceList = new Query(Env.getCtx(), "AD_PInstance", " AD_Process_ID=? AND AD_User_ID=? AND IsProcessing='Y' AND record_ID = ? AND Created > ? ", null).setParameters(this.getAD_Process_ID(), this.getAD_User_ID(), this.getRecord_ID(), lastRebootDate).setClient_ID().setOnlyActiveRecords(true).list();
        if (processInstanceList == null || processInstanceList.isEmpty()) {
            return false;
        }
        if (multipleExecutions.equals("N")) {
            return true;
        }
        if (multipleExecutions.equals("P")) {
            for (MPInstance instance : processInstanceList) {
                if (!instance.equalParameters(params)) continue;
                return true;
            }
        }
        return false;
    }

    private Timestamp getLastServerRebootDate() {
        MSession currentSession = MSession.get(Env.getCtx());
        if (currentSession == null) {
            return null;
        }
        MSession lastServerSession = (MSession)new Query(Env.getCtx(), "AD_Session", " serverName=? AND websession=?", null).setParameters(currentSession.getServerName(), "Server").setOrderBy("AD_Session_ID desc").setOnlyActiveRecords(true).first();
        if (lastServerSession == null) {
            logger.severe("There is no 'Server' record in AD_Session, this can indicate that the server plugin didn't start correctly.  Please verify, this can affect scheduled processes, idempiereMonitor, etc.");
            return null;
        }
        return lastServerSession.getCreated();
    }

    public void setProcessUI(IProcessUI processUI) {
        this.processUI = processUI;
    }

    public IProcessUI getProcessUI() {
        return this.processUI;
    }

    public boolean isReplaceTabContent() {
        return this.m_IsReplaceTabContent;
    }

    public void setReplaceTabContent() {
        this.m_IsReplaceTabContent = !MSysConfig.getBooleanValue("ZK_REPORT_TABLE_OPEN_IN_NEW_TAB", false, Env.getAD_Client_ID(Env.getCtx()));
    }

    public int getAD_Scheduler_ID() {
        return this.m_AD_Scheduler_ID;
    }

    public void setAD_Scheduler_ID(int AD_Scheduler_ID) {
        this.m_AD_Scheduler_ID = AD_Scheduler_ID;
    }

    public boolean isNotifyRecipients() {
        return this.isNotifyRecipients;
    }

    public void setNotifyRecipients(boolean isNotifyRecipients) {
        this.isNotifyRecipients = isNotifyRecipients;
    }
}

