/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.IMFAMechanism;
import org.compiere.model.MMFAMethod;
import org.compiere.model.MMFARegistration;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.Msg;

@Process
public class MFARegister
extends SvrProcess {
    private int p_MFA_Method_ID = 0;
    private String p_ParameterValue = null;
    protected Object[] retArray;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            ProcessInfoParameter para = processInfoParameterArray[n2];
            switch (name = para.getParameterName()) {
                case "MFA_Method_ID": {
                    this.p_MFA_Method_ID = para.getParameterAsInt();
                    break;
                }
                case "ParameterValue": {
                    this.p_ParameterValue = para.getParameterAsString();
                    break;
                }
                default: {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
                }
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("MFA_Method_ID=" + this.p_MFA_Method_ID + ", ParameterValue=" + this.p_ParameterValue);
        }
        MMFAMethod method = new MMFAMethod(this.getCtx(), this.p_MFA_Method_ID, this.get_TrxName());
        IMFAMechanism mechanism = method.getMFAMechanism();
        if (MMFARegistration.alreadyExistsValid(method, null)) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "MFAMethodAlreadyRegistered"));
        }
        this.retArray = mechanism.register(this.getCtx(), method, this.p_ParameterValue, this.get_TrxName());
        if (this.retArray == null || this.retArray.length == 0 || !(this.retArray[0] instanceof String)) {
            throw new AdempiereSystemError("Wrong return from mechanism.validate");
        }
        if (this.processUI == null) {
            int i2 = 0;
            while (i2 < this.retArray.length) {
                if (this.retArray[i2] instanceof String) {
                    String reti = (String)this.retArray[i2];
                    if (reti.startsWith("data:image/png;base64,")) {
                        this.addLog("<img src=\"" + reti + "\" width=\"180\" height=\"180\"/>");
                    } else {
                        this.addLog(reti);
                    }
                } else if (this.retArray[i2] instanceof MMFARegistration) {
                    MMFARegistration reg = (MMFARegistration)this.retArray[i2];
                    this.addLog(0, null, null, Msg.parseTranslation(this.getCtx(), "@Created@: @MFA_Registration_ID@"), 200275, reg.getMFA_Registration_ID());
                }
                ++i2;
            }
        }
        return "@OK@";
    }
}

