/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.List;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRefTable;
import org.compiere.model.MSequence;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;

@Process
public class DatabaseTableRename
extends SvrProcess {
    private int p_AD_Table_ID = 0;
    private String p_NewTableName;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("NewTableName".equals(name)) {
                this.p_NewTableName = para.getParameterAsString();
            } else {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
            }
            ++n2;
        }
        this.p_AD_Table_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MTable table2 = new MTable(this.getCtx(), this.p_AD_Table_ID, this.get_TrxName());
        String oldTableName = table2.getTableName();
        this.log.info(table2.toString());
        if (Util.isEmpty(this.p_NewTableName, true) || this.p_NewTableName.toLowerCase().equals(oldTableName.toLowerCase())) {
            throw new AdempiereException(Util.cleanAmp(Msg.parseTranslation(this.getCtx(), "@NotValid@: @NewTableName@")));
        }
        int cnt = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_Table WHERE LOWER(TableName)=?", this.p_NewTableName.toLowerCase());
        if (cnt > 0) {
            throw new AdempiereException(Util.cleanAmp(Msg.parseTranslation(this.getCtx(), "@AlreadyExists@: @TableName@ = " + this.p_NewTableName)));
        }
        String regex = "(?i)\\b" + oldTableName + "\\.";
        String fullregex = ".*" + regex + ".*";
        List tabs = new Query(this.getCtx(), "AD_Tab", "AD_Table_ID=? AND (WhereClause IS NOT NULL OR OrderByClause IS NOT NULL)", this.get_TrxName()).setParameters(this.p_AD_Table_ID).list();
        for (MTab tab : tabs) {
            String orderByClause;
            boolean changed = false;
            String whereClause = tab.getWhereClause();
            if (whereClause != null && whereClause.matches(fullregex)) {
                whereClause = whereClause.replaceAll(regex, String.valueOf(this.p_NewTableName) + ".");
                tab.setWhereClause(whereClause);
                changed = true;
            }
            if ((orderByClause = tab.getOrderByClause()) != null && orderByClause.matches(fullregex)) {
                orderByClause = orderByClause.replaceAll(regex, String.valueOf(this.p_NewTableName) + ".");
                tab.setOrderByClause(orderByClause);
                changed = true;
            }
            if (!changed) continue;
            tab.saveEx();
            this.addLog(0, null, null, "@Updated@ @AD_Tab_ID@ " + tab.getName(), 106, tab.getAD_Tab_ID());
        }
        List refts = new Query(this.getCtx(), "AD_Ref_Table", "AD_Table_ID=? AND (WhereClause IS NOT NULL OR OrderByClause IS NOT NULL)", this.get_TrxName()).setParameters(this.p_AD_Table_ID).list();
        for (MRefTable reft : refts) {
            String orderByClause;
            boolean changed = false;
            Object whereClause = reft.getWhereClause();
            if (whereClause != null && ((String)whereClause).matches(fullregex)) {
                whereClause = ((String)whereClause).replaceAll(regex, String.valueOf(this.p_NewTableName) + ".");
                reft.setWhereClause((String)whereClause);
                changed = true;
            }
            if ((orderByClause = reft.getOrderByClause()) != null && orderByClause.matches(fullregex)) {
                orderByClause = orderByClause.replaceAll(regex, String.valueOf(this.p_NewTableName) + ".");
                reft.setOrderByClause(orderByClause);
                changed = true;
            }
            if (!changed) continue;
            reft.saveEx();
            this.addLog(0, null, null, "@Updated@ @AD_Reference_ID@ " + reft.getAD_Reference().getName(), 103, reft.getAD_Reference_ID());
        }
        String whereSeq = "(Name=? AND Description=? AND IsTableID='Y') OR (Name=? AND Description=? AND IsTableID='N')";
        List seqs = new Query(this.getCtx(), "AD_Sequence", whereSeq, this.get_TrxName()).setParameters(oldTableName, "Table " + oldTableName, "DocumentNo_" + oldTableName, "DocumentNo/Value for Table " + oldTableName).list();
        for (MSequence seq : seqs) {
            if (seq.isTableID()) {
                seq.setName(this.p_NewTableName);
                seq.setDescription("Table " + this.p_NewTableName);
            } else {
                seq.setName("DocumentNo_" + this.p_NewTableName);
                seq.setDescription("DocumentNo/Value for Table " + this.p_NewTableName);
            }
            seq.saveEx();
            if (seq.getAD_Client_ID() == 0) {
                this.addLog(0, null, null, "@Updated@ @AD_Sequence_ID@ " + seq.getName(), 115, seq.getAD_Sequence_ID());
                continue;
            }
            this.addLog(0, null, null, "@Updated@ @AD_Sequence_ID@ " + seq.getName() + ", @AD_Client_ID@ " + MClient.get(seq.getAD_Client_ID()).getName());
        }
        String colPrefix = oldTableName.toLowerCase();
        List elements = new Query(this.getCtx(), "AD_Element", "LOWER(ColumnName) IN (?, ?)", this.get_TrxName()).setParameters(String.valueOf(colPrefix) + "_id", String.valueOf(colPrefix) + "_uu").setOrderBy("AD_Element_ID").list();
        for (M_Element element : elements) {
            String newColumnName = element.getColumnName().toLowerCase().endsWith("_id") ? String.valueOf(this.p_NewTableName) + "_ID" : String.valueOf(this.p_NewTableName) + "_UU";
            element.renameDBColumn(newColumnName, this.getProcessInfo());
            element.saveEx();
        }
        String sql = "ALTER TABLE " + oldTableName + " RENAME TO " + this.p_NewTableName;
        int rvalue = DB.executeUpdateEx(sql, this.get_TrxName());
        this.addLog(String.valueOf(rvalue) + " - " + sql);
        table2.setTableName(this.p_NewTableName);
        table2.saveEx();
        return "@OK@";
    }
}

