/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.compiere.model.MQuery;
import org.compiere.print.MPrintTableFormat;
import org.compiere.print.PrintData;
import org.compiere.print.layout.BarcodeElement;
import org.compiere.print.layout.Dimension2DImpl;
import org.compiere.print.layout.HTMLElement;
import org.compiere.print.layout.HTMLRenderer;
import org.compiere.print.layout.ImageElement;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.print.layout.PrintDataEvaluatee;
import org.compiere.print.layout.PrintElement;
import org.compiere.print.util.SerializableMatrix;
import org.compiere.print.util.SerializableMatrixImpl;
import org.compiere.report.MReportLine;
import org.compiere.util.Evaluator;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class TableElement
extends PrintElement {
    private static final long serialVersionUID = -4144554863262696285L;
    private ValueNamePair[] m_columnHeader;
    private int[] m_columnMaxWidth;
    private int[] m_columnMaxHeight;
    private String[] m_columnJustification;
    private boolean[] m_fixedWidth;
    private boolean m_multiLineHeader;
    private ArrayList<Integer> m_functionRows;
    private SerializableMatrix<Serializable> m_data;
    private KeyNamePair[] m_pk;
    private String m_pkColumnName;
    private int m_pageNoStart;
    private Rectangle m_firstPage;
    private Rectangle m_nextPages;
    private Boolean[] m_colSuppressRepeats;
    private int m_repeatedColumns;
    private Font m_baseFont;
    private HashMap<Point, Font> m_rowColFont;
    private Color m_baseColor;
    private HashMap<Point, Color> m_rowColColor;
    private Color m_baseBackground;
    private HashMap<Point, Color> m_rowColBackground;
    private MPrintTableFormat m_tFormat;
    private ArrayList<Integer> m_pageBreak;
    private ArrayList<Float> m_columnWidths = new ArrayList();
    private ArrayList<Float> m_rowHeights = new ArrayList();
    private int m_headerHeight = 0;
    private ArrayList<Integer> m_firstRowOnPage = new ArrayList();
    private ArrayList<Integer> m_firstColumnOnPage = new ArrayList();
    private ArrayList<Float> m_pageHeight = new ArrayList();
    private HashMap<Point, NamePair> m_rowColDrillDown = new HashMap();
    private HashMap<Integer, Integer> m_additionalLines;
    private ArrayList<Integer> m_finReportSumRows;
    private HashMap<Point, MReportLine> m_rowColReportLine;
    public static final int HEADER_ROW = -2;
    public static final int ALL = -1;
    private static final int H_GAP = 2;
    private static final int V_GAP = 2;
    private static final boolean DEBUG_PRINT = false;
    private SerializableMatrix<ArrayList<Serializable>> m_printRows = new SerializableMatrixImpl<ArrayList<Serializable>>("PrintRows");
    private ArrayList<String> m_pageLogics;
    private PrintData m_tablePrintData;

    public TableElement(ValueNamePair[] columnHeader, int[] columnMaxWidth, int[] columnMaxHeight, String[] columnJustification, boolean[] fixedWidth, ArrayList<Integer> functionRows, boolean multiLineHeader, SerializableMatrix<Serializable> data, KeyNamePair[] pk, String pkColumnName, int pageNoStart, Rectangle firstPage, Rectangle nextPages, int repeatedColumns, HashMap<Integer, Integer> additionalLines, HashMap<Point, Font> rowColFont, HashMap<Point, Color> rowColColor, HashMap<Point, Color> rowColBackground, MPrintTableFormat tFormat, ArrayList<Integer> pageBreak, Boolean[] colSuppressRepeats, HashMap<Point, MReportLine> rowColReportLine, ArrayList<Integer> finReportSumRows) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Cols=" + columnHeader.length + ", Rows=" + data.getRowCount());
        }
        this.m_colSuppressRepeats = colSuppressRepeats;
        this.m_columnHeader = columnHeader;
        this.m_columnMaxWidth = columnMaxWidth;
        this.m_columnMaxHeight = columnMaxHeight;
        this.m_columnJustification = columnJustification;
        this.m_functionRows = functionRows;
        this.m_fixedWidth = fixedWidth;
        this.m_multiLineHeader = multiLineHeader;
        this.m_data = data;
        this.m_pk = pk;
        this.m_pkColumnName = pkColumnName;
        this.m_pageNoStart = pageNoStart;
        this.m_firstPage = firstPage;
        this.m_nextPages = nextPages;
        this.m_repeatedColumns = repeatedColumns;
        this.m_additionalLines = additionalLines;
        Point pAll = new Point(-1, -1);
        this.m_rowColFont = rowColFont;
        this.m_baseFont = this.m_rowColFont.get(pAll);
        if (this.m_baseFont == null) {
            this.m_baseFont = new Font(null);
        }
        this.m_rowColColor = rowColColor;
        this.m_baseColor = this.m_rowColColor.get(pAll);
        if (this.m_baseColor == null) {
            this.m_baseColor = Color.black;
        }
        this.m_rowColBackground = rowColBackground;
        this.m_baseBackground = this.m_rowColBackground.get(pAll);
        if (this.m_baseBackground == null) {
            this.m_baseBackground = Color.white;
        }
        this.m_tFormat = tFormat;
        this.m_finReportSumRows = finReportSumRows;
        this.m_rowColReportLine = rowColReportLine;
        this.m_pageBreak = pageBreak;
        int i2 = 0;
        while (i2 < this.m_pageBreak.size()) {
            Integer row = this.m_pageBreak.get(i2);
            while (i2 + 1 < this.m_pageBreak.size()) {
                Integer nextRow = this.m_pageBreak.get(i2 + 1);
                if (row + 1 != nextRow) break;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("- removing PageBreak row=" + row);
                }
                this.m_pageBreak.remove(i2);
                row = nextRow;
            }
            ++i2;
        }
        this.waitForLoad(LayoutEngine.IMAGE_TRUE);
        this.waitForLoad(LayoutEngine.IMAGE_FALSE);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean calculateSize() {
        if (this.p_sizeCalculated) {
            return true;
        }
        this.p_width = 0.0f;
        this.m_printRows = new SerializableMatrixImpl<ArrayList<Serializable>>("TableElementPrintRows");
        dynMxColumnWidth = (float)this.m_firstPage.width / 2.0f;
        rows = this.m_data.getRowCount();
        cols = this.m_columnHeader.length;
        dataSizes = new SerializableMatrixImpl<E>("TableElementDimensions");
        headerSizes = new Dimension2DImpl[cols];
        frc = new FontRenderContext(null, true, true);
        dataCol = 0;
        while (dataCol < cols) {
            col = dataCol;
            if (this.m_additionalLines.containsKey(dataCol)) {
                col = this.m_additionalLines.get(dataCol);
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("DataColumn=" + dataCol + ", BelowColumn=" + col);
                }
            }
            colWidth = 0.0f;
            row = 0;
            while (row < rows) {
                this.m_data.setRowIndex(row);
                isNullRow = true;
                for (Serializable element : this.m_data.getRowData()) {
                    if (element == null) continue;
                    isNullRow = false;
                    break;
                }
                if (dataSizes.getRowCount() <= row) {
                    dataSizes.addRow(new ArrayList<E>());
                } else {
                    dataSizes.setRowIndex(row);
                }
                dimensions = dataSizes.getRowData();
                if (dimensions.size() <= dataCol) {
                    dimensions.add(null);
                }
                font = this.getFont(row, dataCol);
                dataItem = this.m_data.getRowData().get(dataCol);
                if (dataItem != null) ** GOTO lbl53
                if (this.m_columnMaxWidth[dataCol] < 0 || !this.m_fixedWidth[col] || isNullRow) {
                    if (this.getReportLine(row, dataCol) != null && this.getReportLine(row, dataCol).isLineTypeBlankLine()) {
                        dimensions.set(dataCol, new Dimension2DImpl());
                        layout = new TextLayout(" ", font, frc);
                        height = layout.getAscent() + layout.getDescent() + layout.getLeading();
                        ((Dimension2DImpl)dimensions.get((int)dataCol)).height = height;
                        ((Dimension2DImpl)dimensions.get(dataCol)).roundUp();
                    } else {
                        dimensions.set(dataCol, new Dimension2DImpl());
                    }
                } else {
                    dataItem = " ";
lbl53:
                    // 2 sources

                    if ((string = dataItem.toString()).length() == 0) {
                        dimensions.set(dataCol, new Dimension2DImpl());
                    } else {
                        this.addPrintLines(row, col, (Serializable)dataItem);
                        dimensions.set(dataCol, new Dimension2DImpl());
                        if (dataItem instanceof Boolean) {
                            ((Dimension2DImpl)dimensions.get(col)).addBelow(LayoutEngine.IMAGE_SIZE);
                        } else if (dataItem instanceof ImageElement) {
                            ((Dimension2DImpl)dimensions.get(col)).addBelow(new Dimension((int)((ImageElement)dataItem).getWidth(), (int)((ImageElement)dataItem).getHeight()));
                            width = (float)Math.ceil(((Dimension2DImpl)dimensions.get(col)).getWidth());
                            if (colWidth < width) {
                                colWidth = width;
                            }
                        } else if (dataItem instanceof BarcodeElement) {
                            ((Dimension2DImpl)dimensions.get(col)).addBelow(new Dimension((int)((BarcodeElement)dataItem).getWidth(), (int)((BarcodeElement)dataItem).getHeight()));
                            if (!((BarcodeElement)dataItem).isAllowOverflow() && colWidth < (width = (float)Math.ceil(((Dimension2DImpl)dimensions.get(col)).getWidth()))) {
                                colWidth = width;
                            }
                        } else {
                            if (this.m_columnMaxWidth[col] == 0 || this.m_columnMaxWidth[col] == -1) {
                                layout = new TextLayout(string, font, frc);
                                width = layout.getAdvance() + 2.0f;
                                height = layout.getAscent() + layout.getDescent() + layout.getLeading();
                                if (width > dynMxColumnWidth) {
                                    this.m_columnMaxWidth[col] = (int)Math.ceil(dynMxColumnWidth);
                                } else if (colWidth < width) {
                                    colWidth = width;
                                }
                                if (dimensions.get(col) == null) {
                                    dimensions.set(col, new Dimension2DImpl());
                                    this.log.log(Level.WARNING, "No Size for r=" + row + ",c=" + col);
                                }
                                ((Dimension2DImpl)dimensions.get(col)).addBelow(width, height);
                            }
                            if (this.m_columnMaxWidth[col] != 0 && this.m_columnMaxWidth[col] != -1) {
                                height = 0.0f;
                                if (HTMLElement.isHTML(string)) {
                                    renderer = HTMLRenderer.get(string);
                                    colWidth = renderer.getWidth();
                                    height = this.m_columnMaxHeight[col] == -1 ? renderer.getHeightOneLine() : renderer.getHeight();
                                    renderer.setAllocation((int)colWidth, (int)height);
                                    this.m_data.getRowData().set(dataCol, renderer);
                                } else {
                                    lines = Pattern.compile("\n", 8).split(string);
                                    lineNo = 0;
                                    while (lineNo < lines.length) {
                                        str = lines[lineNo];
                                        if (str.length() == 0) {
                                            str = " ";
                                        }
                                        aString = new AttributedString(str);
                                        aString.addAttribute(TextAttribute.FONT, font);
                                        iter = aString.getIterator();
                                        measurer = new LineBreakMeasurer(iter, frc);
                                        while (measurer.getPosition() < iter.getEndIndex()) {
                                            layout = measurer.nextLayout(Math.abs(this.m_columnMaxWidth[col]));
                                            width = layout.getAdvance();
                                            if (colWidth < width) {
                                                colWidth = width;
                                            }
                                            lineHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
                                            if (this.m_columnMaxHeight[col] == -1) {
                                                height = lineHeight;
                                                break;
                                            }
                                            if (this.m_columnMaxHeight[col] != 0 && !(height + lineHeight <= (float)this.m_columnMaxHeight[col])) continue;
                                            height += lineHeight;
                                        }
                                        ++lineNo;
                                    }
                                }
                                if (this.m_fixedWidth[col]) {
                                    colWidth = Math.abs(this.m_columnMaxWidth[col]);
                                }
                                ((Dimension2DImpl)dimensions.get(col)).addBelow(colWidth, height);
                            }
                            ((Dimension2DImpl)dimensions.get(col)).roundUp();
                            if (dataItem instanceof NamePair) {
                                this.m_rowColDrillDown.put(new Point(row, col), (NamePair)dataItem);
                            }
                            if (this.log.isLoggable(Level.FINEST)) {
                                this.log.finest("Col=" + col + ", row=" + row + " => " + dimensions.get(col) + " - ColWidth=" + colWidth);
                            }
                        }
                    }
                }
                ++row;
            }
            string = "";
            if (this.m_columnHeader[dataCol] != null) {
                string = this.m_columnHeader[dataCol].toString();
            }
            if (col != dataCol) {
                headerSizes[dataCol] = new Dimension2DImpl();
            } else if (colWidth == 0.0f && this.m_columnMaxWidth[dataCol] < 0 || string.length() == 0) {
                headerSizes[dataCol] = new Dimension2DImpl();
            } else {
                font = this.getFont(-2, dataCol);
                if (!font.isBold()) {
                    font = new Font(font.getName(), 1, font.getSize());
                }
                if (this.m_columnMaxWidth[dataCol] == 0 || this.m_columnMaxWidth[dataCol] == -1 || !this.m_multiLineHeader) {
                    layout = new TextLayout(string, font, frc);
                    width = layout.getAdvance() + 3.0f;
                    height = layout.getAscent() + layout.getDescent() + layout.getLeading();
                    if (width > dynMxColumnWidth) {
                        this.m_columnMaxWidth[dataCol] = (int)Math.ceil(dynMxColumnWidth);
                    } else if (colWidth < width) {
                        colWidth = width;
                    }
                    headerSizes[dataCol] = new Dimension2DImpl(width, height);
                }
                if (this.m_columnMaxWidth[dataCol] != 0 && this.m_columnMaxWidth[dataCol] != -1) {
                    height = 0.0f;
                    lines = Pattern.compile("\n", 8).split(string);
                    lineNo = 0;
                    while (lineNo < lines.length) {
                        aString = new AttributedString(lines[lineNo]);
                        aString.addAttribute(TextAttribute.FONT, font);
                        iter = aString.getIterator();
                        measurer = new LineBreakMeasurer(iter, frc);
                        colWidth = Math.abs(this.m_columnMaxWidth[dataCol]);
                        while (measurer.getPosition() < iter.getEndIndex()) {
                            layout = measurer.nextLayout(colWidth);
                            lineHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
                            if (!this.m_multiLineHeader) {
                                height = lineHeight;
                                break;
                            }
                            height += lineHeight;
                        }
                        ++lineNo;
                    }
                    headerSizes[dataCol] = new Dimension2DImpl(colWidth, height);
                }
            }
            headerSizes[dataCol].roundUp();
            colWidth = (float)Math.ceil(colWidth);
            if (dataCol == 0) {
                colWidth += this.m_tFormat.getVLineStroke().floatValue();
            }
            if (colWidth != 0.0f) {
                colWidth += 4.0f + this.m_tFormat.getVLineStroke().floatValue();
            }
            if (col != dataCol) {
                this.m_columnWidths.add(Float.valueOf(0.0f));
                origWidth = null;
                try {
                    origWidth = this.m_columnWidths.get(col);
                }
                catch (IndexOutOfBoundsException height) {
                    // empty catch block
                }
                if (origWidth == null) {
                    this.log.log(Level.SEVERE, "Column " + dataCol + " below " + col + " - no value for orig width");
                } else if (origWidth.compareTo(Float.valueOf(colWidth)) >= 0) {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Same Width - Col=" + col + " - OrigWidth=" + origWidth + " - Width=" + colWidth + " - Total=" + this.p_width);
                    }
                } else {
                    this.m_columnWidths.set(col, Float.valueOf(colWidth));
                    this.p_width += colWidth - origWidth.floatValue();
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("New Width - Col=" + col + " - OrigWidth=" + origWidth + " - Width=" + colWidth + " - Total=" + this.p_width);
                    }
                }
            } else {
                this.m_columnWidths.add(Float.valueOf(colWidth));
                this.p_width += colWidth;
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Width - Col=" + dataCol + " - Width=" + colWidth + " - Total=" + this.p_width);
                }
            }
            ++dataCol;
        }
        this.p_height = 0.0f;
        row = 0;
        while (row < rows) {
            rowHeight = 0.0f;
            over = 0.0f;
            under = 0.0f;
            dataSizes.setRowIndex(row);
            dimensions = dataSizes.getRowData();
            col = 0;
            while (col < cols) {
                if (((Dimension2DImpl)dimensions.get((int)col)).height > (double)rowHeight) {
                    rowHeight = (float)((Dimension2DImpl)dimensions.get((int)col)).height;
                }
                if (this.getReportLine(row, col) != null) {
                    if ((float)this.getReportLine(row, col).getOverline() > over) {
                        over = this.getReportLine(row, col).getOverline();
                    }
                    if ((float)this.getReportLine(row, col).getUnderline() > under) {
                        under = this.getReportLine(row, col).getUnderline();
                    }
                }
                ++col;
            }
            over = over == 2.0f ? over * this.m_tFormat.getLineStroke().floatValue() + 2.0f : over * this.m_tFormat.getLineStroke().floatValue();
            under = under == 2.0f ? under * this.m_tFormat.getLineStroke().floatValue() + 2.0f : under * this.m_tFormat.getLineStroke().floatValue();
            rowHeight += over + under;
            this.m_rowHeights.add(Float.valueOf(rowHeight += this.m_tFormat.getLineStroke().floatValue() + 4.0f));
            this.p_height += rowHeight;
            ++row;
        }
        this.m_headerHeight = 0;
        col = 0;
        while (col < cols) {
            if (headerSizes[col].height > (double)this.m_headerHeight) {
                this.m_headerHeight = (int)headerSizes[col].height;
            }
            ++col;
        }
        this.m_headerHeight = (int)((float)this.m_headerHeight + (4.0f * this.m_tFormat.getLineStroke().floatValue() + 4.0f));
        this.p_height += (float)this.m_headerHeight;
        this.p_height += this.m_tFormat.getLineStroke().floatValue();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("FirstPage=" + this.m_firstPage + ", NextPages=" + this.m_nextPages);
        }
        if ((float)this.m_firstPage.height >= this.p_height && this.m_pageBreak.size() == 0) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Page Y=1 - PageHeight=" + this.m_firstPage.height + " - TableHeight=" + this.p_height);
            }
            this.m_firstRowOnPage.add(0);
            this.m_pageHeight.add(Float.valueOf(this.p_height));
        } else {
            availableHeight = 0.0f;
            usedHeight = 0.0f;
            firstPage = true;
            addlRows = 0;
            dataRow = 0;
            while (dataRow < this.m_rowHeights.size()) {
                rowHeight = this.m_rowHeights.get(dataRow).floatValue();
                pageBreak = this.isPageBreak(dataRow);
                if (dataRow + 1 == this.m_rowHeights.size()) {
                    availableHeight -= this.m_tFormat.getLineStroke().floatValue();
                }
                if (!pageBreak && availableHeight < rowHeight) {
                    if (availableHeight > 40.0f && rowHeight > 40.0f && this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("- Split (leave on current) Row=" + dataRow + " - Available=" + availableHeight + ", RowHeight=" + rowHeight);
                    }
                    pageBreak = true;
                }
                if (pageBreak) {
                    availableHeight = firstPage != false ? this.m_firstPage.height : this.m_nextPages.height;
                    this.m_firstRowOnPage.add(dataRow + addlRows);
                    if (!firstPage) {
                        this.m_pageHeight.add(Float.valueOf(usedHeight));
                        if (this.log.isLoggable(Level.FINEST)) {
                            this.log.finest("Page Y=" + this.m_pageHeight.size() + " - PageHeight=" + usedHeight);
                        }
                    }
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Page Y=" + this.m_firstRowOnPage.size() + " - Row=" + dataRow + " - force=" + this.isPageBreak(dataRow));
                    }
                    firstPage = false;
                    availableHeight -= (float)this.m_headerHeight;
                    usedHeight += (float)this.m_headerHeight;
                }
                availableHeight -= rowHeight;
                usedHeight += rowHeight;
                if (availableHeight < 0.0f && this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("- Split (move to next) Row=" + dataRow + " - Available=" + availableHeight + ", RowHeight=" + rowHeight);
                }
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Page Y=" + this.m_pageHeight.size() + ", Row=" + dataRow + ",AddlRows=" + addlRows + ", Height=" + rowHeight + " - Available=" + availableHeight + ", Used=" + usedHeight);
                }
                ++dataRow;
            }
            this.m_pageHeight.add(Float.valueOf(usedHeight));
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Page Y=" + this.m_pageHeight.size() + " - PageHeight=" + usedHeight);
            }
        }
        if ((float)this.m_firstPage.width >= this.p_width) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Page X=1 - PageWidth=" + this.m_firstPage.width + " - TableWidth=" + this.p_width);
            }
            this.m_firstColumnOnPage.add(0);
            this.distributeColumns(this.m_firstPage.width - (int)this.p_width, 0, this.m_columnWidths.size());
        } else {
            availableWidth = 0;
            lastStart = 0;
            col = 0;
            while (col < this.m_columnWidths.size()) {
                columnWidth = this.m_columnWidths.get(col).intValue();
                if (availableWidth < columnWidth) {
                    if (col != 0) {
                        this.distributeColumns(availableWidth, lastStart, col);
                    }
                    this.m_firstColumnOnPage.add(col);
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Page X=" + this.m_firstColumnOnPage.size() + " - Col=" + col);
                    }
                    lastStart = col;
                    availableWidth = this.m_firstPage.width;
                    repCol = 0;
                    while (repCol < this.m_repeatedColumns && col > repCol) {
                        repColumnWidth = this.m_columnWidths.get(repCol).floatValue();
                        if ((double)availableWidth < (double)this.m_firstPage.width * 0.5) break;
                        availableWidth = (int)((float)availableWidth - repColumnWidth);
                        ++repCol;
                    }
                }
                availableWidth -= columnWidth;
                ++col;
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Pages=" + this.getPageCount() + " X=" + this.m_firstColumnOnPage.size() + "/Y=" + this.m_firstRowOnPage.size() + " - Width=" + this.p_width + ", Height=" + this.p_height);
        }
        return true;
    }

    private void distributeColumns(int availableWidth, int fromCol, int toCol) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Available=" + availableWidth + ", Columns " + fromCol + "->" + toCol);
        }
        int start = fromCol;
        if (fromCol == 0 && this.m_repeatedColumns > 0) {
            start = this.m_repeatedColumns;
        }
        int totalWidth = availableWidth;
        int col = start;
        while (col < toCol) {
            totalWidth = (int)((float)totalWidth + this.m_columnWidths.get(col).floatValue());
            ++col;
        }
        int remainingWidth = availableWidth;
        int x = 0;
        while (remainingWidth > 0 && x < 5) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("TotalWidth=" + totalWidth + ", Remaining=" + remainingWidth);
            }
            int col2 = start;
            while (col2 < toCol && remainingWidth != 0) {
                int columnWidth = this.m_columnWidths.get(col2).intValue();
                if (columnWidth != 0) {
                    int additionalPart = columnWidth * availableWidth / totalWidth;
                    if (remainingWidth < additionalPart) {
                        this.m_columnWidths.set(col2, Float.valueOf(columnWidth + remainingWidth));
                        remainingWidth = 0;
                    } else {
                        this.m_columnWidths.set(col2, Float.valueOf(columnWidth + additionalPart));
                        remainingWidth -= additionalPart;
                    }
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("  col=" + col2 + " - From " + columnWidth + " to " + this.m_columnWidths.get(col2));
                    }
                }
                ++col2;
            }
            ++x;
        }
        int c = toCol - 1;
        while (remainingWidth != 0 && c >= 0) {
            int columnWidth = this.m_columnWidths.get(c).intValue();
            if (columnWidth > 0) {
                this.m_columnWidths.set(c, Float.valueOf(columnWidth + remainingWidth));
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Final col=" + c + " - From " + columnWidth + " to " + this.m_columnWidths.get(c));
                }
                remainingWidth = 0;
            }
            --c;
        }
    }

    private boolean isPageBreak(int row) {
        int i2 = 0;
        while (i2 < this.m_pageBreak.size()) {
            Integer rr = this.m_pageBreak.get(i2);
            if (rr + 1 == row) {
                return true;
            }
            if (rr > row) {
                return false;
            }
            ++i2;
        }
        return false;
    }

    public void setHeightToLastPage() {
        int lastLayoutPage = this.getPageCount() + this.m_pageNoStart - 1;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("PageCount - Table=" + this.getPageCount() + "(Start=" + this.m_pageNoStart + ") Layout=" + lastLayoutPage + " - Old Height=" + this.p_height);
        }
        this.p_height = this.getHeight(lastLayoutPage);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("New Height=" + this.p_height);
        }
    }

    private Font getFont(int row, int col) {
        Font font = this.m_rowColFont.get(new Point(row, col));
        if (font != null) {
            return font;
        }
        font = this.m_rowColFont.get(new Point(row, -1));
        if (font != null) {
            return font;
        }
        font = this.m_rowColFont.get(new Point(-1, col));
        if (font != null) {
            return font;
        }
        return this.m_baseFont;
    }

    private Color getColor(int row, int col) {
        Color color = this.m_rowColColor.get(new Point(row, col));
        if (color != null) {
            return color;
        }
        color = this.m_rowColColor.get(new Point(row, -1));
        if (color != null) {
            return color;
        }
        color = this.m_rowColColor.get(new Point(-1, col));
        if (color != null) {
            return color;
        }
        return this.m_baseColor;
    }

    private Color getBackground(int row, int col) {
        Color color = this.m_rowColBackground.get(new Point(row, col));
        if (color != null) {
            return color;
        }
        color = this.m_rowColBackground.get(new Point(row, -1));
        if (color != null) {
            return color;
        }
        color = this.m_rowColBackground.get(new Point(-1, col));
        if (color != null) {
            return color;
        }
        return this.m_baseBackground;
    }

    @Override
    public float getHeight(int pageNo) {
        int pageIndex = this.getPageIndex(pageNo);
        int pageYindex = this.getPageYIndex(pageIndex);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Page=" + pageNo + " - PageIndex=" + pageIndex + ", PageYindex=" + pageYindex);
        }
        float pageHeight = this.m_pageHeight.get(pageYindex).floatValue();
        float pageHeightPrevious = 0.0f;
        if (pageYindex > 0) {
            pageHeightPrevious = this.m_pageHeight.get(pageYindex - 1).floatValue();
        }
        float retValue = pageHeight - pageHeightPrevious;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Page=" + pageNo + " - PageIndex=" + pageIndex + ", PageYindex=" + pageYindex + ", Height=" + String.valueOf(retValue));
        }
        return retValue;
    }

    public float getWidth(int pageNo) {
        int pageIndex = this.getPageIndex(pageNo);
        if (pageIndex == 0) {
            return this.m_firstPage.width;
        }
        return this.m_nextPages.width;
    }

    @Override
    public int getPageCount() {
        return this.m_firstRowOnPage.size() * this.m_firstColumnOnPage.size();
    }

    protected int getPageIndex(int pageNo) {
        int index = pageNo - this.m_pageNoStart;
        if (index < 0) {
            this.log.log(Level.SEVERE, "index=" + index, new Exception());
        }
        return index;
    }

    protected int getPageXIndex(int pageIndex) {
        int noXpages = this.m_firstColumnOnPage.size();
        int x = pageIndex % noXpages;
        return x;
    }

    protected int getPageXCount() {
        return this.m_firstColumnOnPage.size();
    }

    protected int getPageYIndex(int pageIndex) {
        int noXpages = this.m_firstColumnOnPage.size();
        int y = (pageIndex - pageIndex % noXpages) / noXpages;
        return y;
    }

    protected int getPageYCount() {
        return this.m_firstRowOnPage.size();
    }

    @Override
    public MQuery getDrillDown(Point relativePoint, int pageNo) {
        NamePair pp;
        if (this.m_rowColDrillDown.size() == 0) {
            return null;
        }
        if (!this.getBounds(pageNo).contains(relativePoint)) {
            return null;
        }
        int row = this.getRow(relativePoint.y, pageNo);
        if (row == -1) {
            return null;
        }
        int col = this.getCol(relativePoint.x, pageNo);
        if (col == -1) {
            return null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Row=" + row + ", Col=" + col + ", PageNo=" + pageNo);
        }
        if ((pp = this.m_rowColDrillDown.get(new Point(row, col))) == null) {
            return null;
        }
        String columnName = MQuery.getZoomColumnName(this.m_columnHeader[col].getID());
        String tableName = MQuery.getZoomTableName(columnName);
        Object code = pp.getID();
        if (pp instanceof KeyNamePair) {
            code = ((KeyNamePair)pp).getKey();
        }
        MQuery query = new MQuery(tableName);
        query.addRestriction(columnName, "=", code, null, pp.toString());
        return query;
    }

    @Override
    public MQuery getDrillAcross(Point relativePoint, int pageNo) {
        if (!this.getBounds(pageNo).contains(relativePoint)) {
            return null;
        }
        int row = this.getRow(relativePoint.y, pageNo);
        if (row == -1) {
            return null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Row=" + row + ", PageNo=" + pageNo);
        }
        if (this.m_pk[row] == null) {
            return null;
        }
        return MQuery.getEqualQuery(this.m_pkColumnName, this.m_pk[row].getKey());
    }

    public Rectangle getBounds(int pageNo) {
        int pageIndex = this.getPageIndex(pageNo);
        int pageYindex = this.getPageYIndex(pageIndex);
        if (pageYindex == 0) {
            return this.m_firstPage;
        }
        return this.m_nextPages;
    }

    private int getRow(int yPos, int pageNo) {
        int pageIndex = this.getPageIndex(pageNo);
        int pageYindex = this.getPageYIndex(pageIndex);
        int curY = (pageYindex == 0 ? this.m_firstPage.y : this.m_nextPages.y) + this.m_headerHeight;
        if (yPos < curY) {
            return -1;
        }
        int firstRow = this.m_firstRowOnPage.get(pageYindex);
        int nextPageRow = this.m_data.getRowCount();
        if (pageYindex + 1 < this.m_firstRowOnPage.size()) {
            nextPageRow = this.m_firstRowOnPage.get(pageYindex + 1);
        }
        int row = firstRow;
        while (row < nextPageRow) {
            int rowHeight = this.m_rowHeights.get(row).intValue();
            if (yPos >= curY && yPos < curY + rowHeight) {
                return row;
            }
            curY += rowHeight;
            ++row;
        }
        return -1;
    }

    private int getCol(int xPos, int pageNo) {
        int colWidth;
        int curX;
        int pageIndex = this.getPageIndex(pageNo);
        int pageXindex = this.getPageXIndex(pageIndex);
        int n = curX = pageXindex == 0 ? this.m_firstPage.x : this.m_nextPages.x;
        if (xPos < curX) {
            return -1;
        }
        int firstColumn = this.m_firstColumnOnPage.get(pageXindex);
        int nextPageColumn = this.m_columnHeader.length;
        if (pageXindex + 1 < this.m_firstColumnOnPage.size()) {
            nextPageColumn = this.m_firstColumnOnPage.get(pageXindex + 1);
        }
        int regularColumnStart = firstColumn;
        int col = 0;
        while (col < this.m_repeatedColumns) {
            colWidth = this.m_columnWidths.get(col).intValue();
            if (xPos >= curX && xPos < curX + colWidth) {
                return col;
            }
            curX += colWidth;
            if (regularColumnStart == col) {
                ++regularColumnStart;
            }
            ++col;
        }
        col = regularColumnStart;
        while (col < nextPageColumn) {
            colWidth = this.m_columnWidths.get(col).intValue();
            if (xPos >= curX && xPos < curX + colWidth) {
                return col;
            }
            curX += colWidth;
            ++col;
        }
        return -1;
    }

    @Override
    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Properties ctx, boolean isView) {
        int colWidth;
        int pageIndex = this.getPageIndex(pageNo);
        int pageXindex = this.getPageXIndex(pageIndex);
        int pageYindex = this.getPageYIndex(pageIndex);
        int firstColumn = this.m_firstColumnOnPage.get(pageXindex);
        int nextPageColumn = this.m_columnHeader.length;
        if (pageXindex + 1 < this.m_firstColumnOnPage.size()) {
            nextPageColumn = this.m_firstColumnOnPage.get(pageXindex + 1);
        }
        if (pageYindex >= this.m_firstRowOnPage.size()) {
            pageYindex = this.m_firstRowOnPage.size() - 1;
        }
        if (pageYindex < 0) {
            return;
        }
        int firstRow = this.m_firstRowOnPage.get(pageYindex);
        int nextPageRow = this.m_data.getRowCount();
        if (pageYindex + 1 < this.m_firstRowOnPage.size()) {
            nextPageRow = this.m_firstRowOnPage.get(pageYindex + 1);
        }
        int startX = (int)pageStart.getX();
        int startY = (int)pageStart.getY();
        startX += pageIndex == 0 ? this.m_firstPage.x : this.m_nextPages.x;
        startY += pageIndex == 0 ? this.m_firstPage.y : this.m_nextPages.y;
        boolean firstColumnPrint = true;
        int regularColumnStart = firstColumn;
        int col = 0;
        while (col < this.m_repeatedColumns && col < this.m_columnWidths.size()) {
            colWidth = this.m_columnWidths.get(col).intValue();
            if (colWidth != 0) {
                this.printColumn(g2D, col, startX, startY, firstColumnPrint, firstRow, nextPageRow, isView);
                startX += colWidth;
                firstColumnPrint = false;
            }
            if (regularColumnStart == col) {
                ++regularColumnStart;
            }
            ++col;
        }
        col = regularColumnStart;
        while (col < nextPageColumn) {
            colWidth = this.m_columnWidths.get(col).intValue();
            if (colWidth != 0) {
                this.printColumn(g2D, col, startX, startY, firstColumnPrint, firstRow, nextPageRow, isView);
                startX += colWidth;
                firstColumnPrint = false;
            }
            ++col;
        }
    }

    private void printColumn(Graphics2D g2D, int col, int origX, int origY, boolean leftVline, int firstRow, int nextPageRow, boolean isView) {
        int curX = origX;
        int curY = origY;
        float colWidth = this.m_columnWidths.get(col).floatValue();
        float netWidth = colWidth - 4.0f - this.m_tFormat.getVLineStroke().floatValue();
        if (leftVline) {
            netWidth -= this.m_tFormat.getVLineStroke().floatValue();
        }
        float rowHeight = this.m_headerHeight;
        float netHeight = rowHeight - 4.0f * this.m_tFormat.getLineStroke().floatValue() + 4.0f;
        String alignment = this.m_columnJustification[col];
        if (leftVline) {
            g2D.setPaint(this.m_tFormat.getVLine_Color());
            g2D.setStroke(this.m_tFormat.getVLine_Stroke());
            if (this.m_tFormat.isPaintBoundaryLines()) {
                g2D.drawLine(origX, (int)((float)origY + this.m_tFormat.getLineStroke().floatValue()), origX, (int)((float)origY + rowHeight - 4.0f * this.m_tFormat.getLineStroke().floatValue()));
            }
            curX = (int)((float)curX + this.m_tFormat.getVLineStroke().floatValue());
        }
        if (this.m_tFormat.isPaintHeaderLines()) {
            g2D.setPaint(this.m_tFormat.getHeaderLine_Color());
            g2D.setStroke(this.m_tFormat.getHeader_Stroke());
            g2D.drawLine(origX, origY, (int)((float)origX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), origY);
        }
        curY = (int)((float)curY + 2.0f * this.m_tFormat.getLineStroke().floatValue());
        Color bg = this.getBackground(-2, col);
        if (!bg.equals(Color.white)) {
            g2D.setPaint(bg);
            g2D.fillRect(curX, (int)((float)curY - this.m_tFormat.getLineStroke().floatValue()), (int)(colWidth - this.m_tFormat.getVLineStroke().floatValue()), (int)(rowHeight - 4.0f * this.m_tFormat.getLineStroke().floatValue()));
        }
        int tempCurY = curY;
        curX += 2;
        curY += 2;
        AttributedString aString = null;
        AttributedCharacterIterator iter = null;
        LineBreakMeasurer measurer = null;
        float usedHeight = 0.0f;
        String headerString = this.m_columnHeader[col].toString();
        if (headerString.length() == 0) {
            headerString = " ";
        }
        aString = new AttributedString(headerString);
        aString.addAttribute(TextAttribute.FONT, this.getFont(-2, col));
        aString.addAttribute(TextAttribute.FOREGROUND, this.getColor(-2, col));
        boolean fastDraw = LayoutEngine.s_FASTDRAW;
        if (fastDraw && !isView && !Util.is8Bit(headerString)) {
            fastDraw = false;
        }
        iter = aString.getIterator();
        measurer = new LineBreakMeasurer(iter, g2D.getFontRenderContext());
        while (measurer.getPosition() < iter.getEndIndex()) {
            TextLayout layout = measurer.nextLayout(netWidth + 2.0f);
            if (iter.getEndIndex() != measurer.getPosition()) {
                fastDraw = false;
            }
            if (alignment.equals("B")) {
                layout = layout.getJustifiedLayout(netWidth + 2.0f);
                fastDraw = false;
            }
            curY = (int)((float)curY + layout.getAscent());
            float penX = curX;
            if (alignment.equals("C")) {
                penX += (netWidth - layout.getAdvance()) / 2.0f;
            } else if (alignment.equals("T") && layout.isLeftToRight() || alignment.equals("L") && !layout.isLeftToRight()) {
                penX += netWidth - layout.getAdvance();
            }
            if (fastDraw) {
                g2D.setFont(this.getFont(-2, col));
                g2D.setColor(this.getColor(-2, col));
                g2D.drawString(iter, penX, (float)curY);
            } else {
                layout.draw(g2D, penX, curY);
            }
            curY = (int)((float)curY + (layout.getDescent() + layout.getLeading()));
            usedHeight += layout.getAscent() + layout.getDescent();
            if (!this.m_multiLineHeader) break;
        }
        curX = (int)((float)curX + (netWidth + 2.0f));
        curY = tempCurY + (int)(rowHeight - 4.0f * this.m_tFormat.getLineStroke().floatValue());
        g2D.setPaint(this.m_tFormat.getVLine_Color());
        g2D.setStroke(this.m_tFormat.getVLine_Stroke());
        if (this.m_tFormat.isPaintVLines()) {
            g2D.drawLine(curX, (int)((float)origY + this.m_tFormat.getLineStroke().floatValue()), curX, (int)((float)origY + rowHeight - 4.0f * this.m_tFormat.getLineStroke().floatValue()));
        }
        curX = (int)((float)curX + this.m_tFormat.getVLineStroke().floatValue());
        if (this.m_tFormat.isPaintHeaderLines()) {
            g2D.setPaint(this.m_tFormat.getHeaderLine_Color());
            g2D.setStroke(this.m_tFormat.getHeader_Stroke());
            g2D.drawLine(origX, curY, (int)((float)origX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), curY);
        }
        curY = (int)((float)curY + 2.0f * this.m_tFormat.getLineStroke().floatValue());
        int row = firstRow;
        while (row < nextPageRow) {
            String pageLogic;
            MReportLine rLine;
            rowHeight = this.m_rowHeights.get(row).floatValue();
            netHeight = rowHeight - 4.0f - this.m_tFormat.getLineStroke().floatValue();
            int rowYstart = curY;
            curX = origX;
            if (leftVline) {
                g2D.setPaint(this.m_tFormat.getVLine_Color());
                g2D.setStroke(this.m_tFormat.getVLine_Stroke());
                if (this.m_tFormat.isPaintBoundaryLines()) {
                    g2D.drawLine(curX, rowYstart, curX, (int)((float)rowYstart + rowHeight - this.m_tFormat.getLineStroke().floatValue()));
                }
                curX = (int)((float)curX + this.m_tFormat.getVLineStroke().floatValue());
            }
            if (!(bg = this.getBackground(row, col)).equals(Color.white)) {
                g2D.setPaint(bg);
                g2D.fillRect(curX, curY, (int)(colWidth - this.m_tFormat.getVLineStroke().floatValue()), (int)(rowHeight - this.m_tFormat.getLineStroke().floatValue()));
            }
            if ((rLine = this.getReportLine(row, col)) != null) {
                if (rLine.getOverline() > 1) {
                    curY = (int)((float)curY - (2.0f + this.m_tFormat.getVLineStroke().floatValue()));
                    g2D.setPaint(this.m_tFormat.getHeaderLine_Color());
                    g2D.setStroke(rLine.getOverlineStroke(this.m_tFormat.getVLineStroke()));
                    g2D.drawLine(curX, (int)((float)curY + this.m_tFormat.getVLineStroke().floatValue()), (int)((float)curX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), (int)((float)curY + this.m_tFormat.getVLineStroke().floatValue()));
                    curY = (int)((float)curY + (2.0f + this.m_tFormat.getVLineStroke().floatValue()));
                }
                if (rLine.getOverline() > 0) {
                    g2D.setPaint(this.m_tFormat.getHeaderLine_Color());
                    g2D.setStroke(rLine.getOverlineStroke(this.m_tFormat.getVLineStroke()));
                    g2D.drawLine(curX, curY, (int)((float)curX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), curY);
                    curY = (int)((float)curY + this.m_tFormat.getVLineStroke().floatValue());
                }
            }
            curX += 2;
            Object[] printItems = this.getPrintItems(row, col);
            float penY = curY += 2;
            boolean suppress = false;
            if (this.m_colSuppressRepeats[col].booleanValue() && row > 0 && row != firstRow) {
                Object[] lastItems = new Object[]{};
                lastItems = this.getPrintItems(row - 1, col);
                if (Arrays.equals(lastItems, printItems)) {
                    suppress = true;
                }
            }
            if (!suppress && this.m_tablePrintData != null && this.m_pageLogics != null && col < this.m_pageLogics.size() && !Util.isEmpty(pageLogic = this.m_pageLogics.get(col), true)) {
                this.m_tablePrintData.setRowIndex(row);
                PrintDataEvaluatee evaluatee = new PrintDataEvaluatee(this.getCurrentPage(), this.m_tablePrintData);
                boolean display = Evaluator.evaluateLogic(evaluatee, pageLogic);
                if (!display) {
                    suppress = true;
                }
            }
            if (!suppress) {
                int index = 0;
                while (index < printItems.length) {
                    if (printItems[index] != null) {
                        if (printItems[index] instanceof ImageElement) {
                            Image imageToDraw = ((ImageElement)printItems[index]).getImage();
                            if (imageToDraw != null) {
                                double scale = ((ImageElement)printItems[index]).getScaleFactor();
                                if (scale != 1.0) {
                                    AffineTransform transform = new AffineTransform();
                                    transform.translate(curX, penY);
                                    transform.scale(scale, scale);
                                    g2D.drawImage(imageToDraw, transform, this);
                                } else {
                                    g2D.drawImage(imageToDraw, curX, (int)penY, this);
                                }
                            }
                        } else if (printItems[index] instanceof BarcodeElement) {
                            BarcodeElement barcodeElement = (BarcodeElement)printItems[index];
                            barcodeElement.paint(g2D, curX, (int)penY);
                        } else if (printItems[index] instanceof Boolean) {
                            int penX = curX + (int)((netWidth - (float)LayoutEngine.IMAGE_SIZE.width) / 2.0f);
                            if (((Boolean)printItems[index]).booleanValue()) {
                                g2D.drawImage(LayoutEngine.IMAGE_TRUE, penX, (int)penY, this);
                            } else {
                                g2D.drawImage(LayoutEngine.IMAGE_FALSE, penX, (int)penY, this);
                            }
                            penY += (float)LayoutEngine.IMAGE_SIZE.height;
                        } else if (printItems[index] instanceof HTMLRenderer) {
                            HTMLRenderer renderer = (HTMLRenderer)printItems[index];
                            Rectangle allocation = new Rectangle((int)colWidth, (int)netHeight);
                            g2D.translate((double)curX, penY);
                            renderer.paint(g2D, allocation);
                            g2D.translate((double)(-curX), -penY);
                            penY = (float)((double)penY + allocation.getHeight());
                        } else {
                            String str = printItems[index].toString();
                            if (str.length() > 0) {
                                usedHeight = 0.0f;
                                String[] lines = Pattern.compile("\n", 8).split(str);
                                int lineNo = 0;
                                while (lineNo < lines.length) {
                                    String thisLine = lines[lineNo];
                                    if (thisLine.length() == 0) {
                                        thisLine = " ";
                                    }
                                    aString = new AttributedString(thisLine);
                                    aString.addAttribute(TextAttribute.FONT, this.getFont(row, col));
                                    if (isView && printItems[index] instanceof NamePair) {
                                        aString.addAttribute(TextAttribute.FOREGROUND, LINK_COLOR);
                                        aString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL, 0, str.length());
                                    } else {
                                        aString.addAttribute(TextAttribute.FOREGROUND, this.getColor(row, col));
                                    }
                                    iter = aString.getIterator();
                                    boolean fastDraw2 = LayoutEngine.s_FASTDRAW;
                                    if (fastDraw2 && !isView && !Util.is8Bit(thisLine)) {
                                        fastDraw2 = false;
                                    }
                                    measurer = new LineBreakMeasurer(iter, g2D.getFontRenderContext());
                                    while (measurer.getPosition() < iter.getEndIndex()) {
                                        TextLayout layout = measurer.nextLayout(netWidth + 2.0f);
                                        if (iter.getEndIndex() != measurer.getPosition()) {
                                            fastDraw2 = false;
                                        }
                                        float lineHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
                                        if (this.m_columnMaxHeight[col] > 0 && !(usedHeight + lineHeight <= (float)this.m_columnMaxHeight[col]) || !(usedHeight + lineHeight <= netHeight)) continue;
                                        if (alignment.equals("B") && measurer.getPosition() < iter.getEndIndex()) {
                                            layout = layout.getJustifiedLayout(netWidth + 2.0f);
                                            fastDraw2 = false;
                                        }
                                        penY += layout.getAscent();
                                        float penX = curX;
                                        if (alignment.equals("C")) {
                                            penX += (netWidth - layout.getAdvance()) / 2.0f;
                                        } else if (alignment.equals("T") && layout.isLeftToRight() || alignment.equals("L") && !layout.isLeftToRight()) {
                                            penX += netWidth - layout.getAdvance();
                                        }
                                        if (fastDraw2) {
                                            g2D.setFont(this.getFont(row, col));
                                            if (isView && printItems[index] instanceof NamePair) {
                                                g2D.setColor(LINK_COLOR);
                                            } else {
                                                g2D.setColor(this.getColor(row, col));
                                            }
                                            g2D.drawString(iter, penX, penY);
                                        } else {
                                            layout.draw(g2D, penX, penY);
                                        }
                                        penY += layout.getDescent() + layout.getLeading();
                                        usedHeight += lineHeight;
                                        if (this.m_columnMaxHeight[col] == -1) break;
                                    }
                                    ++lineNo;
                                }
                            }
                        }
                    }
                    ++index;
                }
            }
            curY = (int)((float)curY + (netHeight + 2.0f));
            curX = (int)((float)curX + (netWidth + 2.0f));
            g2D.setPaint(this.m_tFormat.getVLine_Color());
            g2D.setStroke(this.m_tFormat.getVLine_Stroke());
            if (this.m_tFormat.isPaintVLines()) {
                g2D.drawLine(curX, rowYstart, curX, (int)((float)rowYstart + rowHeight - this.m_tFormat.getLineStroke().floatValue()));
            }
            curX = (int)((float)curX + this.m_tFormat.getVLineStroke().floatValue());
            if (rLine != null && rLine.getUnderline() > 0) {
                if (rLine.getUnderline() > 1) {
                    curY = (int)((float)curY - (2.0f + this.m_tFormat.getVLineStroke().floatValue()));
                    g2D.setPaint(this.m_tFormat.getHeaderLine_Color());
                    g2D.setStroke(rLine.getUnderlineStroke(this.m_tFormat.getVLineStroke()));
                    g2D.drawLine(origX, curY, (int)((float)origX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), curY);
                    curY = (int)((float)curY + (2.0f + this.m_tFormat.getVLineStroke().floatValue()));
                }
                if (rLine.getUnderline() > 0) {
                    g2D.setPaint(this.m_tFormat.getHeaderLine_Color());
                    g2D.setStroke(rLine.getUnderlineStroke(this.m_tFormat.getVLineStroke()));
                    g2D.drawLine(origX, curY, (int)((float)origX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), curY);
                }
            }
            if ((int)((float)rowYstart + rowHeight) > curY) {
                curY = (int)((float)rowYstart + rowHeight);
            }
            if (row == this.m_data.getRowCount() - 1) {
                curY += 4;
                if (this.m_tFormat.isPaintHeaderLines()) {
                    g2D.setPaint(this.m_tFormat.getHeaderLine_Color());
                    g2D.setStroke(this.m_tFormat.getHeader_Stroke());
                    g2D.drawLine(origX, curY, (int)((float)origX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), curY);
                    curY = (int)((float)curY + 2.0f * this.m_tFormat.getLineStroke().floatValue());
                } else {
                    curY = (int)((float)curY + this.m_tFormat.getLineStroke().floatValue());
                }
            } else {
                boolean nextIsFunction = this.m_functionRows.contains(row + 1);
                if (nextIsFunction && this.m_functionRows.contains(row)) {
                    nextIsFunction = false;
                }
                MReportLine nextLine = this.getReportLine(row + 1, col);
                if (nextIsFunction || this.m_finReportSumRows.contains(row + 1) && nextLine != null && nextLine.getOverline() == 0) {
                    g2D.setPaint(this.m_tFormat.getFunctFG_Color());
                    g2D.setStroke(this.m_tFormat.getHLine_Stroke());
                    g2D.drawLine(origX, curY, (int)((float)origX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), curY);
                } else if (this.m_tFormat.isPaintHLines()) {
                    g2D.setPaint(this.m_tFormat.getHLine_Color());
                    g2D.setStroke(this.m_tFormat.getHLine_Stroke());
                    g2D.drawLine(origX, curY, (int)((float)origX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), curY);
                }
                curY = (int)((float)curY + this.m_tFormat.getLineStroke().floatValue());
            }
            ++row;
        }
    }

    private void addPrintLines(int row, int col, Serializable data) {
        while (this.m_printRows.getRowCount() <= row) {
            this.m_printRows.addRow(null);
        }
        this.m_printRows.setRowIndex(row);
        List<ArrayList<Serializable>> columns = this.m_printRows.getRowData();
        if (columns == null) {
            columns = new ArrayList<ArrayList<Serializable>>(this.m_columnHeader.length);
        }
        while (columns.size() <= col) {
            columns.add(null);
        }
        ArrayList<Serializable> coordinate = columns.get(col);
        if (coordinate == null) {
            coordinate = new ArrayList();
        }
        coordinate.add(data);
        columns.set(col, coordinate);
        this.m_printRows.setRowData(columns);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("row=" + row + ", col=" + col + " - Rows=" + this.m_printRows.getRowCount() + ", Cols=" + columns.size() + " - " + data);
        }
    }

    private Object[] getPrintItems(int row, int col) {
        List<ArrayList<Serializable>> columns = null;
        if (this.m_printRows.getRowCount() > row) {
            this.m_printRows.setRowIndex(row);
            columns = this.m_printRows.getRowData();
        }
        if (columns == null) {
            return new Object[0];
        }
        ArrayList<Serializable> coordinate = null;
        if (columns.size() > col) {
            coordinate = columns.get(col);
        }
        if (coordinate == null) {
            return new Object[0];
        }
        return coordinate.toArray();
    }

    private MReportLine getReportLine(int row, int col) {
        MReportLine rLine = this.m_rowColReportLine.get(new Point(row, col));
        if (rLine != null) {
            return rLine;
        }
        return null;
    }

    public void setPageLogics(ArrayList<String> pageLogics) {
        this.m_pageLogics = pageLogics;
    }

    public void setTablePrintData(PrintData printData) {
        this.m_tablePrintData = printData;
    }
}

