/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Properties;
import org.compiere.print.layout.PrintElement;

public class GridElement
extends PrintElement {
    private static final long serialVersionUID = 1744788593309619751L;
    private int m_rowGap = 3;
    private int m_colGap = 5;
    private int m_rows;
    private int m_cols;
    private TextLayout[][] m_textLayout = null;
    private AttributedCharacterIterator[][] m_iterator = null;
    private int[] m_rowHeight = null;
    private int[] m_colWidth = null;
    private FontRenderContext m_frc = new FontRenderContext(null, true, true);

    public GridElement(int rows, int cols) {
        this.m_rows = rows;
        this.m_cols = cols;
        this.m_textLayout = new TextLayout[rows][cols];
        this.m_iterator = new AttributedCharacterIterator[rows][cols];
        this.m_rowHeight = new int[rows];
        this.m_colWidth = new int[cols];
        int r = 0;
        while (r < this.m_rows) {
            this.m_rowHeight[r] = 0;
            int c = 0;
            while (c < this.m_cols) {
                this.m_textLayout[r][c] = null;
                this.m_iterator[r][c] = null;
                ++c;
            }
            ++r;
        }
        int c = 0;
        while (c < this.m_cols) {
            this.m_colWidth[c] = 0;
            ++c;
        }
    }

    public void setData(int row, int col, String stringData, Font font, Paint foreground) {
        if (stringData == null || stringData.length() == 0) {
            return;
        }
        AttributedString aString = new AttributedString(stringData);
        aString.addAttribute(TextAttribute.FONT, font);
        aString.addAttribute(TextAttribute.FOREGROUND, foreground);
        AttributedCharacterIterator iter = aString.getIterator();
        TextLayout layout = new TextLayout(iter, this.m_frc);
        this.setData(row, col, layout, iter);
    }

    private void setData(int row, int col, TextLayout layout, AttributedCharacterIterator iter) {
        if (layout == null) {
            return;
        }
        if (this.p_sizeCalculated) {
            throw new IllegalStateException("Size already calculated");
        }
        if (row < 0 || row >= this.m_rows) {
            throw new ArrayIndexOutOfBoundsException("Row Index=" + row + " Rows=" + this.m_rows);
        }
        if (col < 0 || col >= this.m_cols) {
            throw new ArrayIndexOutOfBoundsException("Column Index=" + col + " Cols=" + this.m_cols);
        }
        this.m_textLayout[row][col] = layout;
        this.m_iterator[row][col] = iter;
        int height = (int)(layout.getAscent() + layout.getDescent() + layout.getLeading()) + 1;
        int width = (int)layout.getAdvance() + 1;
        if (this.m_rowHeight[row] < height) {
            this.m_rowHeight[row] = height;
        }
        if (this.m_colWidth[col] < width) {
            this.m_colWidth[col] = width;
        }
    }

    public void setGap(int rowGap, int colGap) {
        this.m_rowGap = rowGap;
        this.m_colGap = colGap;
    }

    @Override
    protected boolean calculateSize() {
        this.p_height = 0.0f;
        int r = 0;
        while (r < this.m_rows) {
            this.p_height += (float)this.m_rowHeight[r];
            if (this.m_rowHeight[r] > 0) {
                this.p_height += (float)this.m_rowGap;
            }
            ++r;
        }
        this.p_height -= (float)this.m_rowGap;
        this.p_width = 0.0f;
        int c = 0;
        while (c < this.m_cols) {
            this.p_width += (float)this.m_colWidth[c];
            if (this.m_colWidth[c] > 0) {
                this.p_width += (float)this.m_colGap;
            }
            ++c;
        }
        this.p_width -= (float)this.m_colGap;
        return true;
    }

    @Override
    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Properties ctx, boolean isView) {
        Point2D.Double location = this.getAbsoluteLocation(pageStart);
        float y = (float)location.y;
        int row = 0;
        while (row < this.m_rows) {
            float x = (float)location.x;
            int col = 0;
            while (col < this.m_cols) {
                if (this.m_textLayout[row][col] != null) {
                    float yy = y + this.m_textLayout[row][col].getAscent();
                    this.m_textLayout[row][col].draw(g2D, x, yy);
                }
                x += (float)this.m_colWidth[col];
                if (this.m_colWidth[col] > 0) {
                    x += (float)this.m_colGap;
                }
                ++col;
            }
            y += (float)this.m_rowHeight[row];
            if (this.m_rowHeight[row] > 0) {
                y += (float)this.m_rowGap;
            }
            ++row;
        }
    }
}

