/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Properties;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeFactory;
import net.sourceforge.barbecue.BarcodeImageHandler;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.layout.PrintElement;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.impl.qr.QRCodeBean;
import org.krysalis.barcode4j.impl.upcean.UPCABean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class BarcodeElement
extends PrintElement {
    private static final long serialVersionUID = -6825913765885213717L;
    private boolean m_valid = true;
    private Barcode m_barcode = null;
    private boolean m_allowOverflow = true;
    private float m_scaleFactor = 1.0f;
    private AbstractBarcodeBean m_barcodeBean = null;
    private String m_code;

    public BarcodeElement(String code, MPrintFormatItem item) {
        if (code == null || code.length() == 0 || item == null || item.getBarcodeType() == null || item.getBarcodeType().length() == 0) {
            this.m_valid = false;
        }
        this.createBarcode(code, item);
        if (this.m_barcode == null && this.m_barcodeBean == null) {
            this.m_valid = false;
        }
        this.m_allowOverflow = item.isHeightOneLine();
    }

    private void createBarcode(String code, MPrintFormatItem item) {
        String type = item.getBarcodeType();
        try {
            if (type.equals("2o9")) {
                this.m_barcode = BarcodeFactory.create2of7((String)code);
            } else if (type.equals("MON")) {
                this.m_barcode = BarcodeFactory.createMonarch((String)code);
            } else if (type.equals("NW7")) {
                this.m_barcode = BarcodeFactory.createNW7((String)code);
            } else if (type.equals("US4")) {
                this.m_barcode = BarcodeFactory.createUSD4((String)code);
            } else if (type.equals("28A")) {
                this.m_barcode = BarcodeFactory.createCode128A((String)code);
            } else if (type.equals("28B")) {
                this.m_barcode = BarcodeFactory.createCode128B((String)code);
            } else if (type.equals("28C")) {
                this.m_barcode = BarcodeFactory.createCode128C((String)code);
            } else if (type.equals("C28")) {
                this.m_barcode = BarcodeFactory.createCode128((String)code);
            } else if (type.equals("3O9")) {
                this.m_barcode = BarcodeFactory.create3of9((String)code, (boolean)true);
            } else if (type.equals("3o9")) {
                this.m_barcode = BarcodeFactory.create3of9((String)code, (boolean)false);
            } else if (type.equals("C39")) {
                this.m_barcode = BarcodeFactory.createCode39((String)code, (boolean)true);
            } else if (type.equals("c39")) {
                this.m_barcode = BarcodeFactory.createCode39((String)code, (boolean)false);
            } else if (type.equals("US3")) {
                this.m_barcode = BarcodeFactory.createUSD3((String)code, (boolean)true);
            } else if (type.equals("us3")) {
                this.m_barcode = BarcodeFactory.createUSD3((String)code, (boolean)false);
            } else if (type.equals("COD")) {
                this.m_barcode = BarcodeFactory.createCodabar((String)code);
            } else if (type.equals("E28")) {
                this.m_barcode = BarcodeFactory.createEAN128((String)code);
            } else if (type.equals("GTN")) {
                this.m_barcode = BarcodeFactory.createGlobalTradeItemNumber((String)code);
            } else if (type.equals("417")) {
                this.m_barcode = BarcodeFactory.createPDF417((String)code);
            } else if (type.equals("C14")) {
                this.m_barcode = BarcodeFactory.createSCC14ShippingCode((String)code);
            } else if (type.equals("SID")) {
                this.m_barcode = BarcodeFactory.createShipmentIdentificationNumber((String)code);
            } else if (type.equals("C18")) {
                this.m_barcode = BarcodeFactory.createSSCC18((String)code);
            } else if (type.equals("U28")) {
                this.m_barcode = BarcodeFactory.createUCC128((String)"01", (String)code);
            } else if (type.equals("E13")) {
                this.m_barcode = BarcodeFactory.createEAN13((String)code);
            } else if (type.equals("UPA")) {
                this.m_barcodeBean = new UPCABean();
                ((UPCABean)this.m_barcodeBean).setChecksumMode(ChecksumMode.CP_AUTO);
                if (item.isPrintBarcodeText()) {
                    this.m_barcodeBean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
                } else {
                    this.m_barcodeBean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
                }
                this.m_code = code;
            } else if (type.equals("39C")) {
                this.m_barcodeBean = new Code39Bean();
                ((Code39Bean)this.m_barcodeBean).setChecksumMode(ChecksumMode.CP_AUTO);
                if (item.isPrintBarcodeText()) {
                    this.m_barcodeBean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
                } else {
                    this.m_barcodeBean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
                }
                this.m_code = code;
            } else if (type.equals("39c")) {
                this.m_barcodeBean = new Code39Bean();
                ((Code39Bean)this.m_barcodeBean).setChecksumMode(ChecksumMode.CP_IGNORE);
                if (item.isPrintBarcodeText()) {
                    this.m_barcodeBean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
                } else {
                    this.m_barcodeBean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
                }
                this.m_code = code;
            } else if (type.equals("USP")) {
                this.m_barcode = BarcodeFactory.createUSPS((String)code);
            } else if (type.equals("QRC")) {
                this.m_barcodeBean = new QRCodeBean();
                if (item.isPrintBarcodeText()) {
                    this.m_barcodeBean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
                } else {
                    this.m_barcodeBean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
                }
                this.m_code = code;
            } else {
                this.log.warning("Invalid Type" + type);
            }
        }
        catch (Exception e) {
            this.log.warning(String.valueOf(code) + " - " + e.toString());
            this.m_valid = false;
        }
        if (this.m_valid && this.m_barcode != null) {
            MPrintFont mFont;
            if (item.getAD_PrintFont_ID() != 0 && (mFont = MPrintFont.get(item.getAD_PrintFont_ID())) != null) {
                this.m_barcode.setFont(mFont.getFont());
            }
            this.m_barcode.setDrawingText(item.isPrintBarcodeText());
        }
    }

    public boolean isValid() {
        return this.m_valid;
    }

    @Override
    protected boolean calculateSize() {
        this.p_width = 0.0f;
        this.p_height = 0.0f;
        if (this.m_barcode == null && this.m_barcodeBean == null) {
            return true;
        }
        if (this.m_barcode != null) {
            this.p_width = this.m_barcode.getWidth();
            this.p_height = this.m_barcode.getHeight();
            if (this.p_width > 0.0f) {
                this.p_width = this.p_width * 3.0f / 4.0f;
            }
            if (this.p_height > 0.0f) {
                this.p_height = this.p_height * 3.0f / 4.0f;
            }
        } else {
            BarcodeDimension t = this.m_barcodeBean.calcDimensions(this.m_code);
            this.p_width = (float)(t.getWidthPlusQuiet() / (double)25.4f * 72.0);
            this.p_height = (float)(t.getHeight() / (double)25.4f * 72.0);
            this.p_width *= 6.0f;
            this.p_height *= 6.0f;
        }
        if (this.p_width * this.p_height == 0.0f) {
            return true;
        }
        this.m_scaleFactor = 1.0f;
        if (this.p_maxWidth != 0.0f && this.p_width > this.p_maxWidth) {
            this.m_scaleFactor = this.p_maxWidth / this.p_width;
        }
        if (this.p_maxHeight != 0.0f && this.p_height > this.p_maxHeight && this.p_maxHeight / this.p_height < this.m_scaleFactor) {
            this.m_scaleFactor = this.p_maxHeight / this.p_height;
        } else if (this.p_maxHeight != 0.0f && this.m_scaleFactor * this.p_height > this.p_maxHeight) {
            this.m_scaleFactor = this.p_maxHeight / this.p_height;
        }
        this.p_width = this.m_scaleFactor * this.p_width;
        this.p_height = this.m_scaleFactor * this.p_height;
        return true;
    }

    public float getScaleFactor() {
        if (!this.p_sizeCalculated) {
            this.p_sizeCalculated = this.calculateSize();
        }
        return this.m_scaleFactor;
    }

    public boolean isAllowOverflow() {
        return this.m_allowOverflow;
    }

    @Override
    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Properties ctx, boolean isView) {
        if (!this.m_valid || this.m_barcode == null && this.m_barcodeBean == null) {
            return;
        }
        Point2D.Double location = this.getAbsoluteLocation(pageStart);
        int x = (int)location.x;
        if ("T".equals(this.p_FieldAlignmentType)) {
            x = (int)((float)x + (this.p_maxWidth - this.p_width));
        } else if ("C".equals(this.p_FieldAlignmentType)) {
            x = (int)((float)x + (this.p_maxWidth - this.p_width) / 2.0f);
        }
        int y = (int)location.y;
        this.paint(g2D, x, y);
    }

    public void paint(Graphics2D g2D, int x, int y) {
        try {
            BufferedImage image = null;
            if (this.m_barcode != null) {
                image = BarcodeImageHandler.getImage((Barcode)this.m_barcode);
            } else {
                BitmapCanvasProvider provider = new BitmapCanvasProvider(432, 2, true, 0);
                this.m_barcodeBean.generateBarcode((CanvasProvider)provider, this.m_code);
                provider.finish();
                image = provider.getBufferedImage();
            }
            AffineTransform transform = new AffineTransform();
            transform.translate(x, y);
            float scaleFactor = this.m_scaleFactor * 3.0f / 4.0f;
            transform.scale(scaleFactor, scaleFactor);
            g2D.drawImage(image, transform, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        if (this.m_barcode == null) {
            return super.toString();
        }
        return String.valueOf(super.toString()) + " " + this.m_barcode.getData();
    }
}

