/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import java.awt.Color;
import java.awt.Font;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.event.PrintServiceAttributeEvent;
import javax.print.event.PrintServiceAttributeListener;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pdf.Document;
import org.adempiere.print.export.PrintDataExcelExporter;
import org.adempiere.print.export.PrintDataXLSXExporter;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.XhtmlDocument;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.style;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.tbody;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.thead;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MStyle;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.ArchiveEngine;
import org.compiere.print.DataEngine;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.IReportEngineEventListener;
import org.compiere.print.MPrintColor;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.PrintUtil;
import org.compiere.print.ReportEngineEvent;
import org.compiere.print.layout.InstanceAttributeColumn;
import org.compiere.print.layout.InstanceAttributeData;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.print.layout.PrintDataEvaluatee;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ServerProcessCtl;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluator;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class ReportEngine
implements PrintServiceAttributeListener {
    private static CLogger log = CLogger.getCLogger(ReportEngine.class);
    private Properties m_ctx;
    private MPrintFormat m_printFormat;
    private PrintInfo m_info;
    private MQuery m_query;
    private PrintData m_printData;
    private LayoutEngine m_layout = null;
    private String m_printerName = Ini.getProperty("Printer");
    private String m_trxName = null;
    private String m_whereExtended = null;
    private int m_windowNo = 0;
    private int m_language_id = 0;
    private boolean m_summary = false;
    private String m_name = null;
    private boolean m_isReplaceTabContent = false;
    private Map<CSSInfo, List<ColumnInfo>> mapCssInfo = new HashMap<CSSInfo, List<ColumnInfo>>();
    private List<IReportEngineEventListener> eventListeners = new ArrayList<IReportEngineEventListener>();
    public static final int ORDER = 0;
    public static final int SHIPMENT = 1;
    public static final int INVOICE = 2;
    public static final int PROJECT = 3;
    public static final int RFQ = 4;
    public static final int REMITTANCE = 5;
    public static final int CHECK = 6;
    public static final int DUNNING = 7;
    public static final int MANUFACTURING_ORDER = 8;
    public static final int DISTRIBUTION_ORDER = 9;
    public static final int INVENTORY = 10;
    public static final int MOVEMENT = 11;
    private static final String[] DOC_BASETABLES = new String[]{"C_Order", "M_InOut", "C_Invoice", "C_Project", "C_RfQResponse", "C_PaySelectionCheck", "C_PaySelectionCheck", "C_DunningRunEntry", "PP_Order", "DD_Order", "M_Inventory", "M_Movement"};
    private static final String[] DOC_IDS = new String[]{"C_Order_ID", "M_InOut_ID", "C_Invoice_ID", "C_Project_ID", "C_RfQResponse_ID", "C_PaySelectionCheck_ID", "C_PaySelectionCheck_ID", "C_DunningRunEntry_ID", "PP_Order_ID", "DD_Order_ID", "M_Inventory_ID", "M_Movement_ID"};
    private static final int[] DOC_TABLE_ID = new int[]{259, 319, 318, 203, 674, 525, 525, 527, 53027, 53037, 321, 323};
    private String reportType;

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info) {
        this(ctx, pf, query, info, null);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, boolean isSummary) {
        this(ctx, pf, query, info, isSummary, null);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, String trxName) {
        this(ctx, pf, query, info, false, trxName);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, boolean isSummary, String trxName) {
        this(ctx, pf, query, info, false, trxName, 0);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, String trxName, int windowNo) {
        this(ctx, pf, query, info, false, trxName, windowNo);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, boolean isSummary, String trxName, int windowNo) {
        this.m_summary = isSummary;
        if (pf == null) {
            throw new IllegalArgumentException("ReportEngine - no PrintFormat");
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(pf + " -- " + query);
        }
        this.m_ctx = ctx;
        this.m_printFormat = pf;
        this.m_info = info;
        this.m_trxName = trxName;
        this.m_windowNo = windowNo;
        this.initName();
        this.setQuery(query);
    }

    public void addEventListener(IReportEngineEventListener listener) {
        this.eventListeners.add(listener);
    }

    public boolean removeEventListener(IReportEngineEventListener listener) {
        return this.eventListeners.remove(listener);
    }

    public void setPrintFormat(MPrintFormat pf) {
        IReportEngineEventListener[] listeners;
        this.m_printFormat = pf;
        pf.reloadItems();
        if (this.m_layout != null) {
            this.setPrintData();
            this.m_layout.setPrintFormat(pf, false);
            this.m_layout.setPrintData(this.m_printData, this.m_query, true);
        }
        IReportEngineEventListener[] iReportEngineEventListenerArray = listeners = this.eventListeners.toArray(new IReportEngineEventListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IReportEngineEventListener listener = iReportEngineEventListenerArray[n2];
            listener.onPrintFormatChanged(new ReportEngineEvent(this));
            ++n2;
        }
    }

    public void setQuery(MQuery query) {
        IReportEngineEventListener[] listeners;
        this.m_query = query;
        if (query == null) {
            return;
        }
        this.setPrintData();
        if (this.m_layout != null) {
            this.m_layout.setPrintData(this.m_printData, this.m_query, true);
        }
        IReportEngineEventListener[] iReportEngineEventListenerArray = listeners = this.eventListeners.toArray(new IReportEngineEventListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IReportEngineEventListener listener = iReportEngineEventListenerArray[n2];
            listener.onQueryChanged(new ReportEngineEvent(this));
            ++n2;
        }
    }

    public MQuery getQuery() {
        return this.m_query;
    }

    private void setPrintData() {
        if (this.m_query == null) {
            return;
        }
        DataEngine de = new DataEngine(this.m_printFormat.getLanguage(), this.m_trxName, this.m_windowNo);
        this.setPrintData(de.getPrintData(this.m_ctx, this.m_printFormat, this.m_query, this.m_summary));
    }

    public PrintData getPrintData() {
        return this.m_printData;
    }

    public void setPrintData(PrintData printData) {
        if (printData == null) {
            return;
        }
        this.m_printData = printData;
    }

    private void layout() {
        if (this.m_printFormat == null) {
            throw new IllegalStateException("No print format");
        }
        if (this.m_printData == null) {
            throw new IllegalStateException("No print data (Delete Print Format and restart)");
        }
        this.m_layout = new LayoutEngine(this.m_printFormat, this.m_printData, this.m_query, this.m_info, this.m_trxName, this.m_windowNo);
    }

    public LayoutEngine getLayout() {
        if (this.m_layout == null) {
            this.layout();
        }
        return this.m_layout;
    }

    public void initName() {
        MProcess process;
        Language language = this.m_printFormat.getLanguage();
        String processFileNamePattern = this.m_printFormat.get_Translation("FileNamePattern", language.getAD_Language());
        if (this.m_info.getAD_Process_ID() > 0 && (process = new MProcess(Env.getCtx(), this.m_info.getAD_Process_ID(), this.m_trxName)) != null && !Util.isEmpty(process.getFileNamePattern())) {
            processFileNamePattern = process.getFileNamePattern();
        }
        this.m_name = Util.isEmpty(processFileNamePattern) ? this.m_printFormat.get_Translation("Name") : FileUtil.parseTitle(this.m_ctx, processFileNamePattern, this.m_info.getAD_Table_ID(), this.m_info.getRecord_ID(), this.m_windowNo, this.m_trxName);
    }

    public String getName() {
        if (this.m_name == null) {
            this.initName();
        }
        return this.m_name;
    }

    public MPrintFormat getPrintFormat() {
        return this.m_printFormat;
    }

    public PrintInfo getPrintInfo() {
        return this.m_info;
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    public int getRowCount() {
        return this.m_printData.getRowCount();
    }

    public int getColumnCount() {
        if (this.m_layout != null) {
            return this.m_layout.getColumnCount();
        }
        return 0;
    }

    public void print() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.m_info.toString());
        }
        if (this.m_layout == null) {
            this.layout();
        }
        PrintRequestAttributeSet prats = this.m_layout.getPaper().getPrintRequestAttributeSet();
        if (this.m_info.isDocumentCopy() || this.m_info.getCopies() < 1) {
            prats.add(new Copies(1));
        } else {
            prats.add(new Copies(this.m_info.getCopies()));
        }
        Locale locale = Language.getLoginLanguage().getLocale();
        prats.add(new JobName(this.m_printFormat.getName(), locale));
        prats.add(PrintUtil.getJobPriority(this.m_layout.getNumberOfPages(), this.m_info.getCopies(), true));
        try {
            PrinterJob job = this.getPrinterJob(this.m_info.getPrinterName());
            job.setPageable(this.m_layout.getPageable(false));
            try {
                if (this.m_info.isWithDialog() && !job.printDialog(prats)) {
                    return;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Operating System Print Issue, check & try again", e);
                return;
            }
            boolean printCopy = this.m_info.isDocumentCopy() && this.m_info.getCopies() > 1;
            ArchiveEngine.get().archive(this.m_layout, this.m_info);
            PrintUtil.print(job, prats, false, printCopy);
            if (printCopy) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Copy " + (this.m_info.getCopies() - 1));
                }
                prats.add(new Copies(this.m_info.getCopies() - 1));
                job = this.getPrinterJob(this.m_info.getPrinterName());
                job.setPageable(this.m_layout.getPageable(true));
                PrintUtil.print(job, prats, false, false);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public void attributeUpdate(PrintServiceAttributeEvent psae) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("attributeUpdate - " + psae);
        }
    }

    private PrinterJob getPrinterJob(String printerName) {
        if (printerName != null && printerName.length() > 0) {
            return PrintUtil.getPrinterJob(printerName);
        }
        return PrintUtil.getPrinterJob(this.m_printerName);
    }

    public void pageSetupDialog() {
        IReportEngineEventListener[] listeners;
        if (this.m_layout == null) {
            this.layout();
        }
        this.m_layout.pageSetupDialog(this.getPrinterJob(this.m_printerName));
        IReportEngineEventListener[] iReportEngineEventListenerArray = listeners = this.eventListeners.toArray(new IReportEngineEventListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IReportEngineEventListener listener = iReportEngineEventListenerArray[n2];
            listener.onPageSetupChanged(new ReportEngineEvent(this));
            ++n2;
        }
    }

    public void setPrinterName(String printerName) {
        this.m_printerName = printerName == null ? Ini.getProperty("Printer") : printerName;
    }

    public String getPrinterName() {
        return this.m_printerName;
    }

    public boolean createHTML(File file, boolean onlyTable, Language language) {
        return this.createHTML(file, onlyTable, language, null);
    }

    public boolean createHTML(File file, boolean onlyTable, Language language, IHTMLExtension extension) {
        try {
            Language lang = language;
            if (lang == null) {
                lang = Language.getLoginLanguage();
            }
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Ini.getCharset());
            return this.createHTML(new BufferedWriter(fw), onlyTable, lang, extension);
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
            throw new AdempiereException(e);
        }
        return false;
    }

    public boolean createHTML(Writer writer, boolean onlyTable, Language language) {
        return this.createHTML(writer, onlyTable, language, null);
    }

    public boolean createHTML(Writer writer, boolean onlyTable, Language language, IHTMLExtension extension) {
        return this.createHTML(writer, onlyTable, language, extension, false);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean createHTML(Writer writer, boolean onlyTable, Language language, IHTMLExtension extension, boolean isExport) {
        try {
            columns = new ArrayList<Object>();
            asiElements = new ArrayList<Object>();
            columnCount = 0;
            col = 0;
            while (col < this.m_printFormat.getItemCount()) {
                item = this.m_printFormat.getItem(col);
                if (item.isPrinted()) {
                    if (item.isTypeField() && item.isPrintInstanceAttributes()) {
                        asiElement = new InstanceAttributeData(item, columnCount);
                        asiElement.readAttributesData(this.m_printData);
                        asiElements.add(asiElement);
                    } else {
                        columns.add(item);
                        ++columnCount;
                    }
                }
                ++col;
            }
            if (asiElements.size() > 0) {
                columnCreated = 0;
                for (InstanceAttributeData data : asiElements) {
                    instanceColumns = data.getColumns();
                    index = data.getColumnIndex() + columnCreated;
                    for (InstanceAttributeColumn c : instanceColumns) {
                        columns.add(index, c);
                        ++index;
                        ++columnCreated;
                    }
                }
            }
            v0 = cssPrefix = extension != null ? extension.getClassPrefix() : null;
            if (cssPrefix != null && cssPrefix.trim().length() == 0) {
                cssPrefix = null;
            }
            parameterTable = null;
            if (!this.m_printFormat.isForm() && this.m_query != null && this.m_query.isActive()) {
                v1 = rows = this.m_query.getReportProcessQuery() != null ? this.m_query.getReportProcessQuery().getRestrictionCount() : this.m_query.getRestrictionCount();
                if (rows > 0) {
                    parameterTable = new table();
                    if (cssPrefix != null) {
                        parameterTable.setClass(String.valueOf(cssPrefix) + "-parameter-table");
                    } else {
                        parameterTable.setClass("parameter-table");
                    }
                    parameterTable.setNeedClosingTag(false);
                }
            }
            table = new table();
            if (cssPrefix != null) {
                table.setClass(String.valueOf(cssPrefix) + "-table");
            }
            table.setNeedClosingTag(false);
            w = new PrintWriter(writer);
            doc = null;
            minify = MSysConfig.getBooleanValue("HTML_REPORT_MINIFY", true, Env.getAD_Client_ID(this.getCtx()));
            if (onlyTable) {
                w.print(this.compress(table.toString(), minify));
            } else {
                doc = new XhtmlDocument();
                doc.getHtml().setNeedClosingTag(false);
                doc.getBody().setNeedClosingTag(false);
                doc.appendHead("<meta charset=\"UTF-8\" />");
                if (extension != null && !Util.isEmpty(extension.getWebFontLinks(), true)) {
                    doc.appendHead(extension.getWebFontLinks());
                }
                if (extension != null && extension.getStyleURL() != null) {
                    pathStyleFile = extension.getFullPathStyle();
                    path = Paths.get(pathStyleFile, new String[0]);
                    styleLines = Files.readAllLines(path, Ini.getCharset());
                    Files.delete(path);
                    styleBuild = new StringBuilder();
                    for (String styleLine : styleLines) {
                        styleBuild.append(styleLine);
                    }
                    this.appendInlineCss(doc, styleBuild);
                }
                if (extension != null && extension.getScriptURL() != null && !isExport) {
                    jslink = new script();
                    jslink.setLanguage("javascript");
                    jslink.setSrc(extension.getScriptURL());
                    doc.appendHead((Element)jslink);
                }
                if (extension != null && !isExport) {
                    extension.setWebAttribute(doc.getBody());
                }
            }
            if (doc != null) {
                this.mapCssInfo.clear();
                item = null;
                printColIndex = -1;
                col = 0;
                while (col < columns.size()) {
                    colobj = columns.get(col);
                    if (colobj instanceof MPrintFormatItem) {
                        item = (MPrintFormatItem)colobj;
                    } else if (colobj instanceof InstanceAttributeColumn) {
                        item = ((InstanceAttributeColumn)colobj).getPrintFormatItem();
                    }
                    if (item != null) {
                        this.addCssInfo(item, ++printColIndex);
                    }
                    ++col;
                }
                this.appendInlineCss(doc);
                styleBuild = new StringBuilder();
                tf = this.m_printFormat.getTableFormat();
                cssInfo = new CSSInfo(tf.getPageHeader_Font(), tf.getPageHeaderFG_Color());
                if (cssPrefix != null) {
                    if (parameterTable != null) {
                        styleBuild.append("." + cssPrefix + "-parameter-table th").append(cssInfo.getCssRule());
                    }
                    styleBuild.append("." + cssPrefix + "-table th").append(cssInfo.getCssRule());
                } else {
                    if (parameterTable != null) {
                        styleBuild.append("parameter-table th").append(cssInfo.getCssRule());
                    }
                    styleBuild.append("table th").append(cssInfo.getCssRule());
                }
                cssInfo = new CSSInfo(tf.getParameter_Font(), tf.getParameter_Color());
                styleBuild.append(".tr-parameter td").append(cssInfo.getCssRule());
                cssInfo = new CSSInfo(tf.getFunct_Font(), tf.getFunctFG_Color());
                styleBuild.append(".tr-function td").append(cssInfo.getCssRule());
                printFont = MPrintFont.get(this.m_printFormat.getAD_PrintFont_ID());
                base = printFont.getFont();
                newFont = new Font(base.getName(), 0, base.getSize() - 1);
                cssInfo = new CSSInfo(newFont, null);
                styleBuild.append(".tr-level-1 td").append(cssInfo.getCssRule());
                newFont = new Font(base.getName(), 0, base.getSize() - 2);
                cssInfo = new CSSInfo(newFont, null);
                styleBuild.append(".tr-level-2 td").append(cssInfo.getCssRule());
                styleBuild = new StringBuilder(styleBuild.toString().replaceAll(";", "!important;"));
                this.appendInlineCss(doc, styleBuild);
                w.print(this.compress(doc.toString(), minify));
                w.print("<div class='" + cssPrefix + "-flex-container'>");
                paraWrapId = null;
                if (parameterTable != null) {
                    paraWrapId = String.valueOf(cssPrefix) + "-para-table-wrap";
                    w.print("<div id='" + paraWrapId + "'>");
                    w.print(this.compress(parameterTable.toString(), minify));
                    tr = new tr();
                    tr.setClass("tr-parameter");
                    th = new th();
                    tr.addElement((Element)th);
                    th.addElement(String.valueOf(Msg.getMsg(this.getCtx(), "Parameter")) + ":");
                    query = this.m_query;
                    if (this.m_query.getReportProcessQuery() != null) {
                        query = this.m_query.getReportProcessQuery();
                    }
                    r = 0;
                    while (r < query.getRestrictionCount()) {
                        if (r > 0) {
                            tr = new tr();
                            tr.setClass("tr-parameter");
                            td = new td();
                            tr.addElement((Element)td);
                            td.addElement("&nbsp;");
                        }
                        td = new td();
                        tr.addElement((Element)td);
                        td.addElement(query.getInfoName(r));
                        td = new td();
                        tr.addElement((Element)td);
                        td.addElement(query.getInfoOperator(r));
                        td = new td();
                        tr.addElement((Element)td);
                        td.addElement(query.getInfoDisplayAll(r));
                        w.print(this.compress(tr.toString(), minify));
                        ++r;
                    }
                    w.print("</table>");
                    w.print("</div>");
                }
                tableWrapDiv = new StringBuilder();
                tableWrapDiv.append("<div class='").append(cssPrefix).append("-table-wrap' ");
                if (paraWrapId != null) {
                    tableWrapDiv.append("onscroll=\"if (this.scrollTop > 0) document.getElementById('").append(paraWrapId).append("').style.display='none'; ").append("else document.getElementById('").append(paraWrapId).append("').style.display='block';\"");
                }
                tableWrapDiv.append(" >");
                w.print(this.compress(tableWrapDiv.toString(), minify));
                w.print(this.compress(table.toString(), minify));
            }
            thead = new thead();
            tbody = new tbody();
            tbody.setNeedClosingTag(false);
            colSuppressRepeats = this.m_layout == null || this.m_layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats(this.m_printFormat) : this.m_layout.colSuppressRepeats;
            preValues = null;
            if (colSuppressRepeats != null) {
                preValues = new Object[colSuppressRepeats.length];
            }
            printColIndex = -1;
            suppressMap = new HashMap<Integer, th>();
            row = -1;
            while (row < this.m_printData.getRowCount()) {
                tr = new tr();
                if (row != -1) {
                    this.m_printData.setRowIndex(row);
                    if (extension != null && !isExport) {
                        extension.extendRowElement((ConcreteElement)tr, this.m_printData);
                    }
                    if (this.m_printData.isFunctionRow()) {
                        tr.setClass(String.valueOf(cssPrefix) + "-functionrow");
                    } else if (row < this.m_printData.getRowCount() && this.m_printData.isFunctionRow(row + 1)) {
                        tr.setClass(String.valueOf(cssPrefix) + "-lastgrouprow");
                    }
                } else {
                    thead.addElement((Element)tr);
                }
                printColIndex = -1;
                col = 0;
                while (col < columns.size()) {
                    block93: {
                        block96: {
                            block95: {
                                block94: {
                                    colObj = columns.get(col);
                                    item = null;
                                    instanceAttributeColumn = null;
                                    if (colObj instanceof MPrintFormatItem) {
                                        item = (MPrintFormatItem)colObj;
                                    } else if (colObj instanceof InstanceAttributeColumn) {
                                        instanceAttributeColumn = (InstanceAttributeColumn)colObj;
                                        item = instanceAttributeColumn.getPrintFormatItem();
                                    }
                                    if (item == null) break block93;
                                    ++printColIndex;
                                    if (row != -1) break block94;
                                    th = new th();
                                    tr.addElement((Element)th);
                                    columnHeader = instanceAttributeColumn != null ? instanceAttributeColumn.getName() : item.getPrintName(language);
                                    th.addElement(Util.maskHTML(columnHeader));
                                    if (cssPrefix != null && instanceAttributeColumn == null && (column = MColumn.get(this.getCtx(), item.getAD_Column_ID())) != null && column.getAD_Column_ID() > 0 && DisplayType.isNumeric(column.getAD_Reference_ID())) {
                                        th.setClass(String.valueOf(cssPrefix) + "-number");
                                    }
                                    if (item.isSuppressNull()) {
                                        suppressMap.put(printColIndex, th);
                                        th.setID("report-th-" + printColIndex);
                                    }
                                    break block93;
                                }
                                td = new td();
                                tr.addElement((Element)td);
                                AD_FieldStyle_ID = item.getAD_FieldStyle_ID();
                                if (AD_FieldStyle_ID > 0) {
                                    style = MStyle.get(Env.getCtx(), AD_FieldStyle_ID);
                                    lines = style.getStyleLines();
                                    styleBuilder = new StringBuilder();
                                    var35_56 = lines;
                                    var34_55 = lines.length;
                                    var33_51 = 0;
                                    while (var33_51 < var34_55) {
                                        line = var35_56[var33_51];
                                        inlineStyle = line.getInlineStyle().trim();
                                        displayLogic = line.getDisplayLogic();
                                        if (Util.isEmpty(displayLogic) || Evaluator.evaluateLogic(new PrintDataEvaluatee(null, this.m_printData), displayLogic)) {
                                            if (styleBuilder.length() > 0 && styleBuilder.charAt(styleBuilder.length() - 1) != ';') {
                                                styleBuilder.append("; ");
                                            }
                                            styleBuilder.append(inlineStyle);
                                        }
                                        ++var33_51;
                                    }
                                    if (styleBuilder.length() > 0) {
                                        td.setStyle(styleBuilder.toString());
                                    }
                                }
                                v2 = obj = instanceAttributeColumn != null ? instanceAttributeColumn.getPrintDataElement(row) : this.m_printData.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID());
                                if (obj != null && this.isDisplayPFItem(item)) break block95;
                                td.addElement("&nbsp;");
                                if (colSuppressRepeats != null && colSuppressRepeats[printColIndex].booleanValue()) {
                                    preValues[printColIndex] = null;
                                }
                                if (item.isSuppressNull() && obj != null && suppressMap.containsKey(printColIndex)) {
                                    suppressMap.remove(printColIndex);
                                }
                                break block93;
                            }
                            if (!(obj instanceof PrintDataElement)) break block96;
                            pde = obj;
                            value = pde.getValueDisplay(language);
                            if (colSuppressRepeats == null || !colSuppressRepeats[printColIndex].booleanValue()) ** GOTO lbl299
                            if (value.equals(preValues[printColIndex])) {
                                td.addElement("&nbsp;");
                            } else {
                                preValues[printColIndex] = value;
lbl299:
                                // 2 sources

                                if (item.isSuppressNull() && obj != null && suppressMap.containsKey(printColIndex)) {
                                    suppressMap.remove(printColIndex);
                                }
                                if (pde.getColumnName().endsWith("_ID") && extension != null && !isExport) {
                                    isZoom = false;
                                    if (item.getColumnName().equals("Record_ID")) {
                                        tablePDE = this.m_printData.getNode("AD_Table_ID");
                                        if (tablePDE != null && tablePDE instanceof PrintDataElement) {
                                            tableID = -1;
                                            try {
                                                tableID = Integer.parseInt(((PrintDataElement)tablePDE).getValueAsString());
                                            }
                                            catch (Exception e) {
                                                tableID = -1;
                                            }
                                            if (tableID > 0) {
                                                mTable = MTable.get(this.getCtx(), tableID);
                                                tableName = mTable.getTableName();
                                                list = new ArrayList<MColumn>();
                                                var41_67 = mTable.getIdentifierColumns();
                                                var40_65 = var41_67.length;
                                                var39_63 = 0;
                                                while (var39_63 < var40_65) {
                                                    idColumnName = var41_67[var39_63];
                                                    column = mTable.getColumn(idColumnName);
                                                    list.add(column);
                                                    ++var39_63;
                                                }
                                                if (list.size() > 0) {
                                                    displayColumn = new StringBuilder();
                                                    separator = MSysConfig.getValue("IDENTIFIER_SEPARATOR", "_", Env.getAD_Client_ID(Env.getCtx()));
                                                    i = 0;
                                                    while (i < list.size()) {
                                                        identifierColumn = (MColumn)list.get(i);
                                                        if (i > 0) {
                                                            displayColumn.append("||'").append(separator).append("'||");
                                                        }
                                                        displayColumn.append("NVL(").append(DB.TO_CHAR(identifierColumn.getColumnName(), identifierColumn.getAD_Reference_ID(), Env.getAD_Language(Env.getCtx()))).append(",'')");
                                                        ++i;
                                                    }
                                                    sql = new StringBuilder("SELECT ");
                                                    sql.append(displayColumn.toString());
                                                    sql.append(" FROM ").append(tableName);
                                                    sql.append(" WHERE ").append(tableName).append(".").append(tableName).append("_ID=?");
                                                    value = DB.getSQLValueStringEx(null, sql.toString(), new Object[]{Integer.parseInt(value)});
                                                }
                                                foreignColumnName = String.valueOf(tableName) + "_ID";
                                                pde.setForeignColumnName(foreignColumnName);
                                                isZoom = true;
                                            }
                                        }
                                    } else {
                                        isZoom = true;
                                    }
                                    if (isZoom) {
                                        mTable = MTable.get(this.getCtx(), pde.getForeignColumnName().substring(0, pde.getForeignColumnName().length() - 3));
                                        Record_ID = -1;
                                        try {
                                            Record_ID = Integer.parseInt(pde.getValueAsString());
                                        }
                                        catch (Exception e) {
                                            Record_ID = -1;
                                        }
                                        canAccess = null;
                                        if (Record_ID >= 0 && mTable != null) {
                                            AD_Window_ID = Env.getZoomWindowID(mTable.get_ID(), Record_ID);
                                            canAccess = MRole.getDefault().getWindowAccess(AD_Window_ID);
                                        }
                                        if (canAccess == null) {
                                            isZoom = false;
                                        }
                                    }
                                    if (isZoom) {
                                        href = new a("javascript:void(0)");
                                        href.setID(String.valueOf(pde.getColumnName()) + "_" + row + "_a");
                                        td.addElement((Element)href);
                                        href.addElement(Util.maskHTML(value));
                                        if (cssPrefix != null) {
                                            href.setClass(String.valueOf(cssPrefix) + "-href");
                                        }
                                        extension.extendIDColumn(row, (ConcreteElement)td, href, pde);
                                    } else {
                                        td.addElement(Util.maskHTML(value));
                                    }
                                } else {
                                    td.addElement(Util.maskHTML(value));
                                }
                                if (cssPrefix != null) {
                                    if (DisplayType.isNumeric(pde.getDisplayType())) {
                                        td.setClass(String.valueOf(cssPrefix) + "-number");
                                    } else if (DisplayType.isDate(pde.getDisplayType())) {
                                        td.setClass(String.valueOf(cssPrefix) + "-date");
                                    } else {
                                        td.setClass(String.valueOf(cssPrefix) + "-text");
                                    }
                                }
                            }
                            break block93;
                        }
                        if (!(obj instanceof PrintData)) {
                            ReportEngine.log.log(Level.SEVERE, "Element not PrintData(Element) " + obj.getClass());
                        }
                    }
                    ++col;
                }
                if (row == -1) {
                    w.print(this.compress(thead.toString(), minify));
                    w.print(this.compress(tbody.toString(), minify));
                } else {
                    w.print(this.compress(tr.toString(), minify));
                }
                ++row;
            }
            w.print("</tbody>");
            w.print("</table>");
            if (suppressMap.size() > 0) {
                st = new StringBuilder();
                for (th t : suppressMap.values()) {
                    if (st.length() > 0) {
                        st.append(",");
                    }
                    st.append("#").append(t.getAttribute("id"));
                }
                st.append(" {\n\t\tdisplay:none;\n\t}");
                styleTag = new style();
                styleTag.addElement(st.toString());
                w.print(this.compress(styleTag.toString(), minify));
            }
            if (!onlyTable) {
                w.print("</div>");
                w.print("</div>");
                w.print("</body>");
                w.print("</html>");
            }
            w.flush();
            w.close();
        }
        catch (Exception e) {
            ReportEngine.log.log(Level.SEVERE, "(w)", e);
            throw new AdempiereException(e);
        }
        return true;
    }

    private String getCSSFontFamily(String fontFamily) {
        if ("Dialog".equals(fontFamily) || "DialogInput".equals(fontFamily) || "Monospaced".equals(fontFamily)) {
            return "monospace";
        }
        if ("SansSerif".equals(fontFamily)) {
            return "sans-serif";
        }
        if ("Serif".equals(fontFamily)) {
            return "serif";
        }
        return null;
    }

    public boolean createCSV(File file, char delimiter, Language language) {
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Ini.getCharset());
            return this.createCSV(new BufferedWriter(fw), delimiter, language);
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean createCSV(Writer writer, char delimiter, Language language) {
        if (delimiter == '\u0000') {
            delimiter = (char)9;
        }
        try {
            ArrayList<Object> columns = new ArrayList<Object>();
            ArrayList<Object> asiElements = new ArrayList<Object>();
            int columnCount = 0;
            int col = 0;
            while (col < this.m_printFormat.getItemCount()) {
                MPrintFormatItem mPrintFormatItem = this.m_printFormat.getItem(col);
                if (mPrintFormatItem.isPrinted()) {
                    if (mPrintFormatItem.isTypeField() && mPrintFormatItem.isPrintInstanceAttributes()) {
                        InstanceAttributeData asiElement = new InstanceAttributeData(mPrintFormatItem, columnCount);
                        asiElement.readAttributesData(this.m_printData);
                        asiElements.add(asiElement);
                    } else {
                        columns.add(mPrintFormatItem);
                        ++columnCount;
                    }
                }
                ++col;
            }
            if (asiElements.size() > 0) {
                int columnCreated = 0;
                for (InstanceAttributeData instanceAttributeData : asiElements) {
                    List<InstanceAttributeColumn> instanceColumns = instanceAttributeData.getColumns();
                    int index = instanceAttributeData.getColumnIndex() + columnCreated;
                    for (InstanceAttributeColumn c : instanceColumns) {
                        columns.add(index, c);
                        ++index;
                        ++columnCreated;
                    }
                }
            }
            Boolean[] colSuppressRepeats = this.m_layout == null || this.m_layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats(this.m_printFormat) : this.m_layout.colSuppressRepeats;
            Object var8_13 = null;
            if (colSuppressRepeats != null) {
                Object[] objectArray = new Object[colSuppressRepeats.length];
            }
            int printColIndex = -1;
            int row = -1;
            while (row < this.m_printData.getRowCount()) {
                printColIndex = -1;
                StringBuffer sb = new StringBuffer();
                if (row != -1) {
                    this.m_printData.setRowIndex(row);
                }
                boolean first = true;
                int col2 = 0;
                while (col2 < columns.size()) {
                    block21: {
                        String data;
                        block24: {
                            PrintDataElement obj;
                            block25: {
                                void var8_15;
                                block23: {
                                    InstanceAttributeColumn iaColumn;
                                    MPrintFormatItem item;
                                    block22: {
                                        Object colObj = columns.get(col2);
                                        item = null;
                                        iaColumn = null;
                                        if (colObj instanceof InstanceAttributeColumn) {
                                            iaColumn = (InstanceAttributeColumn)colObj;
                                            item = iaColumn.getPrintFormatItem();
                                        } else if (colObj instanceof MPrintFormatItem) {
                                            item = (MPrintFormatItem)colObj;
                                        }
                                        if (item == null) break block21;
                                        if (first) {
                                            first = false;
                                        } else {
                                            sb.append(delimiter);
                                        }
                                        if (row != -1) break block22;
                                        String printName = iaColumn != null ? iaColumn.getName() : item.getPrintName(language);
                                        this.createCSVvalue(sb, delimiter, printName);
                                        break block21;
                                    }
                                    ++printColIndex;
                                    obj = iaColumn != null ? iaColumn.getPrintDataElement(row) : this.m_printData.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID());
                                    data = "";
                                    if (obj != null && this.isDisplayPFItem(item)) break block23;
                                    if (colSuppressRepeats != null && colSuppressRepeats[printColIndex].booleanValue()) {
                                        var8_15[printColIndex] = null;
                                    }
                                    break block24;
                                }
                                if (!(obj instanceof PrintDataElement)) break block25;
                                PrintDataElement pde = obj;
                                data = pde.isPKey() ? pde.getValueAsString() : pde.getValueDisplay(language);
                                if (colSuppressRepeats == null || !colSuppressRepeats[printColIndex].booleanValue()) break block24;
                                if (data.equals(var8_15[printColIndex])) break block21;
                                var8_15[printColIndex] = data;
                                break block24;
                            }
                            if (!(obj instanceof PrintData)) {
                                log.log(Level.SEVERE, "Element not PrintData(Element) " + obj.getClass());
                            }
                        }
                        this.createCSVvalue(sb, delimiter, data);
                    }
                    ++col2;
                }
                writer.write(sb.toString());
                writer.write(Env.NL);
                ++row;
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
            return false;
        }
        return true;
    }

    private void createCSVvalue(StringBuffer sb, char delimiter, String content) {
        if (content == null || content.length() == 0) {
            return;
        }
        boolean needMask = false;
        StringBuilder buff = new StringBuilder();
        char[] chars = content.toCharArray();
        int i2 = 0;
        while (i2 < chars.length) {
            char c = chars[i2];
            if (c == '\"') {
                needMask = true;
                buff.append(c);
            } else if (!(needMask || c != delimiter && Character.isLetterOrDigit(c))) {
                needMask = true;
            }
            buff.append(c);
            ++i2;
        }
        if (needMask) {
            sb.append('\"').append((CharSequence)buff).append('\"');
        } else {
            sb.append((CharSequence)buff);
        }
    }

    public boolean createXML(File file) {
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Ini.getCharset());
            return this.createXML(new BufferedWriter(fw));
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
        }
        return false;
    }

    public boolean createXML(Writer writer) {
        try {
            this.m_printData.createXML(new StreamResult(writer));
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
            return false;
        }
    }

    public File getPDF() {
        return this.getPDF(null);
    }

    public File getPDF(File file) {
        try {
            if (file == null) {
                file = FileUtil.createTempFile(this.makePrefix(this.getName()), ".pdf");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        if (this.createPDF(file)) {
            return file;
        }
        return null;
    }

    public File getHTML() {
        return this.getHTML(null);
    }

    public File getHTML(File file) {
        try {
            if (file == null) {
                file = FileUtil.createTempFile(this.makePrefix(this.getName()), ".html");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        if (this.createHTML(file, false, Env.getLanguage(this.getCtx()))) {
            return file;
        }
        return null;
    }

    public File getCSV() {
        return this.getCSV(null);
    }

    public File getCSV(File file) {
        try {
            if (file == null) {
                file = FileUtil.createTempFile(this.makePrefix(this.getName()), ".csv");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        if (this.createCSV(file, ',', Env.getLanguage(this.getCtx()))) {
            return file;
        }
        return null;
    }

    public File getXLS() {
        return this.getXLS(null);
    }

    public File getXLS(File file) {
        try {
            if (file == null) {
                file = FileUtil.createTempFile(this.makePrefix(this.getName()), ".xls");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        try {
            this.createXLS(file, Env.getLanguage(this.getCtx()));
            return file;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public File getXLSX() {
        return this.getXLSX(null);
    }

    public File getXLSX(File file) {
        try {
            if (file == null) {
                file = FileUtil.createTempFile(this.makePrefix(this.getName()), ".xlsx");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        try {
            this.createXLSX(file, Env.getLanguage(this.getCtx()));
            return file;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public boolean createPDF(File file) {
        String fileName = null;
        URI uri = null;
        try {
            if (file == null) {
                file = FileUtil.createTempFile("ReportEngine", ".pdf");
            }
            fileName = file.getAbsolutePath();
            uri = file.toURI();
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "file", e);
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(uri.toString());
        }
        try {
            if (this.m_printFormat != null && this.m_printFormat.getJasperProcess_ID() > 0) {
                ProcessInfo pi = new ProcessInfo("", this.m_printFormat.getJasperProcess_ID(), this.m_printFormat.getAD_Table_ID(), this.m_info.getRecord_ID());
                if (this.m_printFormat.getLanguage() != null && this.m_printFormat.getLanguage().getAD_Language() != null) {
                    ProcessInfoParameter reportLanguagePip = new ProcessInfoParameter("AD_Language", this.m_printFormat.getLanguage().getAD_Language(), null, null, null);
                    pi.setParameter(new ProcessInfoParameter[]{reportLanguagePip});
                }
                pi.setIsBatch(true);
                pi.setPDFFileName(fileName);
                ServerProcessCtl.process(pi, this.m_trxName == null ? null : Trx.get(this.m_trxName, false));
            } else {
                if (this.m_layout == null) {
                    this.layout();
                }
                Document.getPDFAsFile(fileName, this.m_layout.getPageable(false));
                ArchiveEngine.get().archive(new File(fileName), this.m_info);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "PDF", e);
            throw new AdempiereException(e);
        }
        File file2 = new File(fileName);
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(file2.getAbsolutePath()) + " - " + file2.length());
        }
        return file2.exists();
    }

    private String makePrefix(String name) {
        char[] nameArray;
        StringBuilder prefix = new StringBuilder();
        char[] cArray = nameArray = name.toCharArray();
        int n = nameArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isLetterOrDigit(ch)) {
                prefix.append(ch);
            } else {
                prefix.append("_");
            }
            ++n2;
        }
        return prefix.toString();
    }

    public byte[] createPDFData() {
        try {
            if (this.m_layout == null) {
                this.layout();
            }
            return Document.getPDFAsArray(this.m_layout.getPageable(false));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "PDF", e);
            return null;
        }
    }

    public boolean createPS(File file) {
        try {
            return this.createPS(new FileOutputStream(file));
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
        }
        return false;
    }

    public boolean createPS(OutputStream os) {
        StreamPrintServiceFactory[] spsfactories;
        block5: {
            String outputMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
            DocFlavor.SERVICE_FORMATTED docFlavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
            spsfactories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(docFlavor, outputMimeType);
            if (spsfactories.length != 0) break block5;
            log.log(Level.SEVERE, "(fos) - No StreamPrintService");
            return false;
        }
        try {
            StreamPrintService sps = spsfactories[0].getPrintService(os);
            if (this.m_layout == null) {
                this.layout();
            }
            sps.createPrintJob().print(this.m_layout.getPageable(false), new HashPrintRequestAttributeSet());
            os.flush();
            if (os instanceof FileOutputStream) {
                ((FileOutputStream)os).close();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(fos)", e);
        }
        return false;
    }

    public void createXLS(File outFile, Language language) throws Exception {
        Boolean[] colSuppressRepeats = this.m_layout == null || this.m_layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats(this.m_printFormat) : this.m_layout.colSuppressRepeats;
        Map<MPrintFormatItem, PrintData> childFormats = this.m_layout != null ? this.m_layout.getChildPrintFormatDetails() : null;
        PrintDataExcelExporter exp = new PrintDataExcelExporter(this.getPrintData(), this.getPrintFormat(), childFormats, colSuppressRepeats, this.m_query);
        exp.export(outFile, language);
    }

    public void createXLSX(File outFile, Language language) throws Exception {
        Boolean[] colSuppressRepeats = this.m_layout == null || this.m_layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats(this.m_printFormat) : this.m_layout.colSuppressRepeats;
        Map<MPrintFormatItem, PrintData> childFormats = this.m_layout != null ? this.m_layout.getChildPrintFormatDetails() : null;
        PrintDataXLSXExporter exp = new PrintDataXLSXExporter(this.getPrintData(), this.getPrintFormat(), childFormats, colSuppressRepeats, this.m_query);
        exp.export(outFile, language);
    }

    public static ReportEngine get(Properties ctx, ProcessInfo pi) {
        return ReportEngine.get(ctx, pi, 0);
    }

    public static ReportEngine get(Properties ctx, ProcessInfo pi, int windowNo) {
        ResultSet rs;
        CPreparedStatement pstmt;
        StringBuilder sql;
        MPInstance instance;
        int Client_ID;
        boolean IsForm;
        int AD_PrintFormat_ID;
        String TableName;
        int AD_ReportView_ID;
        int AD_Table_ID;
        int AD_Client_ID;
        block22: {
            AD_Client_ID = pi.getAD_Client_ID();
            AD_Table_ID = 0;
            AD_ReportView_ID = 0;
            TableName = null;
            AD_PrintFormat_ID = 0;
            IsForm = false;
            Client_ID = -1;
            instance = null;
            sql = new StringBuilder("SELECT rv.AD_ReportView_ID,rv.WhereClause,").append(" t.AD_Table_ID,t.TableName, pf.AD_PrintFormat_ID, pf.IsForm, pf.AD_Client_ID ").append("FROM AD_PInstance pi").append(" INNER JOIN AD_Process p ON (pi.AD_Process_ID=p.AD_Process_ID)").append(" INNER JOIN AD_ReportView rv ON (p.AD_ReportView_ID=rv.AD_ReportView_ID)").append(" INNER JOIN AD_Table t ON (rv.AD_Table_ID=t.AD_Table_ID)").append(" LEFT OUTER JOIN AD_PrintFormat pf ON (p.AD_ReportView_ID=pf.AD_ReportView_ID AND pf.AD_Client_ID IN (0,?) AND pf.IsActive='Y') ").append("WHERE pi.AD_PInstance_ID=? ").append("ORDER BY pf.AD_Client_ID DESC, pf.IsDefault DESC");
            pstmt = null;
            rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setInt(2, pi.getAD_PInstance_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        AD_ReportView_ID = rs.getInt(1);
                        AD_Table_ID = rs.getInt(3);
                        TableName = rs.getString(4);
                        AD_PrintFormat_ID = rs.getInt(5);
                        IsForm = "Y".equals(rs.getString(6));
                        Client_ID = rs.getInt(7);
                        instance = new MPInstance(ctx, pi.getAD_PInstance_ID(), null);
                        if (instance.getAD_PrintFormat_ID() <= 0) {
                            instance.setAD_PrintFormat_ID(AD_PrintFormat_ID);
                        } else {
                            AD_PrintFormat_ID = instance.getAD_PrintFormat_ID();
                        }
                        ReportEngine.setDefaultReportTypeToPInstance(ctx, instance, AD_PrintFormat_ID);
                        instance.saveEx();
                    }
                }
                catch (SQLException e1) {
                    log.log(Level.SEVERE, "(1) - " + sql, e1);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block22;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (AD_ReportView_ID == 0) {
            block24: {
                sql = new StringBuilder("SELECT t.AD_Table_ID,t.TableName, pf.AD_PrintFormat_ID, pf.IsForm ").append("FROM AD_PInstance pi").append(" INNER JOIN AD_Process p ON (pi.AD_Process_ID=p.AD_Process_ID)").append(" INNER JOIN AD_PrintFormat pf ON (p.AD_PrintFormat_ID=pf.AD_PrintFormat_ID)").append(" INNER JOIN AD_Table t ON (pf.AD_Table_ID=t.AD_Table_ID) ").append("WHERE pi.AD_PInstance_ID=?");
                try {
                    try {
                        pstmt = DB.prepareStatement(sql.toString(), null);
                        pstmt.setInt(1, pi.getAD_PInstance_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            AD_Table_ID = rs.getInt(1);
                            TableName = rs.getString(2);
                            AD_PrintFormat_ID = rs.getInt(3);
                            IsForm = "Y".equals(rs.getString(4));
                            Client_ID = AD_Client_ID;
                            instance = new MPInstance(ctx, pi.getAD_PInstance_ID(), null);
                        }
                    }
                    catch (SQLException e1) {
                        log.log(Level.SEVERE, "(2) - " + sql, e1);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (AD_PrintFormat_ID == 0) {
                log.log(Level.SEVERE, "Report Info NOT found AD_PInstance_ID=" + pi.getAD_PInstance_ID() + ",AD_Client_ID=" + AD_Client_ID);
                return null;
            }
            if (instance != null) {
                instance.setAD_PrintFormat_ID(AD_PrintFormat_ID);
                ReportEngine.setDefaultReportTypeToPInstance(ctx, instance, AD_PrintFormat_ID);
                instance.saveEx();
            }
        }
        MQuery query = null;
        query = IsForm && pi.getRecord_ID() != 0 && !TableName.startsWith("T_") ? MQuery.getEqualQuery(String.valueOf(TableName) + "_ID", pi.getRecord_ID()) : MQuery.get(ctx, pi.getAD_PInstance_ID(), TableName);
        MPrintFormat format = null;
        Serializable so = pi.getSerializableObject();
        if (so instanceof MPrintFormat) {
            format = (MPrintFormat)so;
        }
        if (format == null && AD_PrintFormat_ID != 0) {
            format = Client_ID == AD_Client_ID ? MPrintFormat.get(ctx, AD_PrintFormat_ID, false) : MPrintFormat.copyToClient(ctx, AD_PrintFormat_ID, AD_Client_ID);
        }
        if (format != null && format.getItemCount() == 0) {
            if (log.isLoggable(Level.INFO)) {
                log.info("No Items - recreating:  " + format);
            }
            format.delete(true);
            format = null;
        }
        if (format == null && AD_ReportView_ID != 0) {
            format = MPrintFormat.createFromReportView(ctx, AD_ReportView_ID, pi.getTitle());
        }
        if (format == null) {
            return null;
        }
        format.setTranslationLanguage(format.getLanguage());
        PrintInfo info = new PrintInfo(pi);
        info.setAD_Table_ID(AD_Table_ID);
        return new ReportEngine(ctx, format, query, info, pi.isSummary(), pi.getTransactionName(), windowNo);
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID) {
        return ReportEngine.get(ctx, type, Record_ID, null, 0);
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID, int windowNo) {
        return ReportEngine.get(ctx, type, Record_ID, null, windowNo);
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID, String trxName) {
        return ReportEngine.get(ctx, type, Record_ID, trxName, 0);
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID, String trxName, int windowNo) {
        Language language;
        int copies;
        String DocumentNo;
        int C_BPartner_ID;
        int AD_PrintFormat_ID;
        block19: {
            int[] what;
            if (Record_ID < 1) {
                log.log(Level.WARNING, "No PrintFormat for Record_ID=" + Record_ID + ", Type=" + type);
                return null;
            }
            if (type == 0 && (what = ReportEngine.getDocumentWhat(Record_ID)) != null) {
                type = what[0];
                Record_ID = what[1];
            }
            AD_PrintFormat_ID = 0;
            C_BPartner_ID = 0;
            DocumentNo = null;
            copies = 1;
            MClient client = MClient.get(ctx);
            language = client.getLanguage();
            StringBuilder sql = null;
            sql = type == 6 ? new StringBuilder("SELECT bad.Check_PrintFormat_ID,").append("\tc.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.DocumentNo ").append("FROM C_PaySelectionCheck d").append(" INNER JOIN C_PaySelection ps ON (d.C_PaySelection_ID=ps.C_PaySelection_ID)").append(" INNER JOIN C_BankAccountDoc bad ON (ps.C_BankAccount_ID=bad.C_BankAccount_ID AND d.PaymentRule=bad.PaymentRule)").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) ").append("WHERE d.C_PaySelectionCheck_ID=?") : (type == 7 ? new StringBuilder("SELECT dl.Dunning_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,dr.DunningDate ").append("FROM C_DunningRunEntry d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID)").append(" INNER JOIN C_DunningRun dr ON (d.C_DunningRun_ID=dr.C_DunningRun_ID)").append(" INNER JOIN C_DunningLevel dl ON (dl.C_DunningLevel_ID=d.C_DunningLevel_ID) ").append("WHERE d.C_DunningRunEntry_ID=?") : (type == 5 ? new StringBuilder("SELECT pf.Remittance_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.DocumentNo ").append("FROM C_PaySelectionCheck d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) ").append("WHERE d.C_PaySelectionCheck_ID=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC") : (type == 3 ? new StringBuilder("SELECT pf.Project_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.Value ").append("FROM C_Project d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" LEFT OUTER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) ").append("WHERE d.C_Project_ID=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC") : (type == 8 ? new StringBuilder("SELECT pf.Manuf_Order_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language, 0 , d.DocumentNo ").append("FROM PP_Order d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" LEFT OUTER JOIN AD_User u ON (u.AD_User_ID=d.Planner_ID)").append(" LEFT OUTER JOIN C_BPartner bp ON (u.C_BPartner_ID=bp.C_BPartner_ID) ").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append("WHERE d.PP_Order_ID=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC") : (type == 9 ? new StringBuilder("SELECT pf.Distrib_Order_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language, bp.C_BPartner_ID , d.DocumentNo ").append("FROM DD_Order d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" LEFT OUTER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) ").append("WHERE d.DD_Order_ID=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC") : (type == 4 ? new StringBuilder("SELECT COALESCE(t.AD_PrintFormat_ID, pf.AD_PrintFormat_ID),").append(" c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,rr.Name ").append("FROM C_RfQResponse rr").append(" INNER JOIN C_RfQ r ON (rr.C_RfQ_ID=r.C_RfQ_ID)").append(" INNER JOIN C_RfQ_Topic t ON (r.C_RfQ_Topic_ID=t.C_RfQ_Topic_ID)").append(" INNER JOIN AD_Client c ON (rr.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (rr.C_BPartner_ID=bp.C_BPartner_ID),").append(" AD_PrintFormat pf ").append("WHERE pf.AD_Client_ID IN (0,rr.AD_Client_ID)").append(" AND pf.AD_Table_ID=725 AND pf.IsTableBased='N'").append(" AND rr.C_RfQResponse_ID=? ").append("ORDER BY t.AD_PrintFormat_ID, pf.AD_Client_ID DESC, pf.AD_Org_ID DESC") : (type == 0 || type == 2 ? new StringBuilder("SELECT pf.Order_PrintFormat_ID,pf.Shipment_PrintFormat_ID,").append(" COALESCE (bp.Invoice_PrintFormat_ID,dt.AD_PrintFormat_ID,pf.Invoice_PrintFormat_ID),").append(" pf.Project_PrintFormat_ID, pf.Remittance_PrintFormat_ID,").append(" c.IsMultiLingualDocument, bp.AD_Language,").append(" COALESCE(dt.DocumentCopies,0)+COALESCE(bp.DocumentCopies,1), ").append(" dt.AD_PrintFormat_ID,bp.C_BPartner_ID,d.DocumentNo ").append("FROM " + DOC_BASETABLES[type] + " d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID)").append(" LEFT OUTER JOIN C_DocType dt ON ((d.C_DocType_ID>0 AND d.C_DocType_ID=dt.C_DocType_ID) OR (d.C_DocType_ID=0 AND d.C_DocTypeTarget_ID=dt.C_DocType_ID)) ").append("WHERE d." + DOC_IDS[type] + "=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ").append("ORDER BY pf.AD_Org_ID DESC") : (type == 10 || type == 11 ? new StringBuilder("SELECT COALESCE (dt.AD_PrintFormat_ID, 0), 0,").append(" NULL, 0 , d.DocumentNo ").append("FROM " + DOC_BASETABLES[type] + " d").append(" LEFT OUTER JOIN C_DocType dt ON (d.C_DocType_ID=dt.C_DocType_ID) ").append("WHERE d." + DOC_IDS[type] + "=?") : new StringBuilder("SELECT pf.Order_PrintFormat_ID,pf.Shipment_PrintFormat_ID,").append(" COALESCE (bp.Invoice_PrintFormat_ID,dt.AD_PrintFormat_ID,pf.Invoice_PrintFormat_ID),").append(" pf.Project_PrintFormat_ID, pf.Remittance_PrintFormat_ID,").append(" c.IsMultiLingualDocument, bp.AD_Language,").append(" COALESCE(dt.DocumentCopies,0)+COALESCE(bp.DocumentCopies,1), ").append(" dt.AD_PrintFormat_ID,bp.C_BPartner_ID,d.DocumentNo, ").append(" pf.Manuf_Order_PrintFormat_ID, pf.Distrib_Order_PrintFormat_ID ").append("FROM " + DOC_BASETABLES[type] + " d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID)").append(" LEFT OUTER JOIN C_DocType dt ON (d.C_DocType_ID=dt.C_DocType_ID) ").append("WHERE d." + DOC_IDS[type] + "=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ").append("ORDER BY pf.AD_Org_ID DESC")))))))));
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), trxName);
                    pstmt.setInt(1, Record_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String AD_Language;
                        if (type == 6 || type == 7 || type == 5 || type == 3 || type == 4 || type == 8 || type == 9 || type == 10 || type == 11) {
                            MProcess process;
                            AD_PrintFormat_ID = rs.getInt(1);
                            copies = 1;
                            AD_Language = rs.getString(3);
                            if (AD_Language != null) {
                                language = Language.getLanguage(AD_Language);
                            }
                            C_BPartner_ID = rs.getInt(4);
                            if (type == 7) {
                                Timestamp ts = rs.getTimestamp(5);
                                DocumentNo = ts.toString();
                            } else {
                                DocumentNo = rs.getString(5);
                            }
                            if (AD_PrintFormat_ID == 0 && type == 10) {
                                process = MProcess.get(ctx, 291);
                                AD_PrintFormat_ID = process.getAD_PrintFormat_ID();
                            }
                            if (AD_PrintFormat_ID == 0 && type == 11) {
                                process = MProcess.get(ctx, 290);
                                AD_PrintFormat_ID = process.getAD_PrintFormat_ID();
                            }
                        } else {
                            AD_PrintFormat_ID = rs.getInt(type + 1);
                            if (type != 2 && rs.getInt(9) != 0) {
                                AD_PrintFormat_ID = rs.getInt(9);
                            }
                            copies = rs.getInt(8);
                            AD_Language = rs.getString(7);
                            if (AD_Language != null) {
                                language = Language.getLanguage(AD_Language);
                            }
                            C_BPartner_ID = rs.getInt(10);
                            DocumentNo = rs.getString(11);
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Record_ID=" + Record_ID + ", SQL=" + sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (AD_PrintFormat_ID == 0) {
            log.log(Level.SEVERE, "No PrintFormat found for Type=" + type + ", Record_ID=" + Record_ID);
            return null;
        }
        MPrintFormat format = MPrintFormat.get(ctx, AD_PrintFormat_ID, false);
        format.setLanguage(language);
        format.setTranslationLanguage(language);
        MQuery query = new MQuery(format.getAD_Table_ID());
        query.addRestriction(DOC_IDS[type], "=", Record_ID);
        if (DocumentNo == null || DocumentNo.length() == 0) {
            DocumentNo = "DocPrint";
        }
        PrintInfo info = new PrintInfo(DocumentNo, DOC_TABLE_ID[type], Record_ID, C_BPartner_ID);
        info.setCopies(copies);
        info.setDocumentCopy(false);
        info.setPrinterName(format.getPrinterName());
        ReportEngine re = new ReportEngine(ctx, format, query, info, trxName, windowNo);
        return re;
    }

    private static int[] getDocumentWhat(int C_Order_ID) {
        int[] what = new int[]{0, C_Order_ID};
        StringBuilder sql = new StringBuilder("SELECT dt.DocSubTypeSO ").append("FROM C_DocType dt, C_Order o ").append("WHERE o.C_DocType_ID=dt.C_DocType_ID").append(" AND o.C_Order_ID=?");
        String DocSubTypeSO = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, C_Order_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DocSubTypeSO = rs.getString(1);
                }
                if (DocSubTypeSO == null || "".equals(DocSubTypeSO)) {
                    sql = new StringBuilder("SELECT dt.DocSubTypeSO ").append("FROM C_DocType dt, C_Order o ").append("WHERE o.C_DocTypeTarget_ID=dt.C_DocType_ID").append(" AND o.C_Order_ID=?");
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, C_Order_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        DocSubTypeSO = rs.getString(1);
                    }
                }
            }
            catch (SQLException e1) {
                log.log(Level.SEVERE, "(1) - " + sql, e1);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (DocSubTypeSO == null) {
            DocSubTypeSO = "";
        }
        if (DocSubTypeSO.equals("WR") || DocSubTypeSO.equals("WI")) {
            what[0] = 2;
        } else if (DocSubTypeSO.equals("WP")) {
            what[0] = 1;
        } else {
            return what;
        }
        sql = what[0] == 2 ? new StringBuilder("SELECT C_Invoice_ID REC FROM C_Invoice WHERE C_Order_ID=?").append(" ORDER BY C_Invoice_ID DESC") : new StringBuilder("SELECT M_InOut_ID REC FROM M_InOut WHERE C_Order_ID=?").append(" ORDER BY M_InOut_ID DESC");
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, C_Order_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    what[1] = rs.getInt(1);
                } else {
                    what[0] = 0;
                }
            }
            catch (SQLException e2) {
                log.log(Level.SEVERE, "(2) - " + sql, e2);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Order => " + what[0] + " ID=" + what[1]);
        }
        return what;
    }

    public static void printConfirm(int type, int Record_ID) {
        int no;
        StringBuilder sql = new StringBuilder();
        if (type == 0 || type == 1 || type == 2) {
            sql.append("UPDATE ").append(DOC_BASETABLES[type]).append(" SET DatePrinted=getDate(), IsPrinted='Y' WHERE ").append(DOC_IDS[type]).append("=").append(Record_ID);
        }
        if (sql.length() > 0 && (no = DB.executeUpdate(sql.toString(), null)) != 1) {
            log.log(Level.SEVERE, "Updated records=" + no + " - should be just one");
        }
    }

    public void setWhereExtended(String whereExtended) {
        this.m_whereExtended = whereExtended;
    }

    public String getWhereExtended() {
        return this.m_whereExtended;
    }

    public void setWindowNo(int windowNo) {
        this.m_windowNo = windowNo;
    }

    public int getWindowNo() {
        return this.m_windowNo;
    }

    public void setSummary(boolean summary) {
        this.m_summary = summary;
    }

    public boolean isSummary() {
        return this.m_summary;
    }

    public void setLanguageID(int languageID) {
        this.m_language_id = languageID;
    }

    public int getLanguageID() {
        return this.m_language_id;
    }

    public void setReportType(String type) {
        this.reportType = type;
    }

    public String getReportType() {
        return this.reportType;
    }

    public boolean isReplaceTabContent() {
        return this.m_isReplaceTabContent;
    }

    public void setIsReplaceTabContent(boolean m_isReplaceTabContent) {
        this.m_isReplaceTabContent = m_isReplaceTabContent;
    }

    public static int getReportEngineType(int tableID) {
        int i2 = 0;
        while (i2 < DOC_TABLE_ID.length) {
            if (DOC_TABLE_ID[i2] == tableID) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public void appendInlineCss(XhtmlDocument doc) {
        StringBuilder buildCssInline = new StringBuilder();
        for (Map.Entry<CSSInfo, List<ColumnInfo>> cssClassInfo : this.mapCssInfo.entrySet()) {
            int i2 = 0;
            while (i2 < cssClassInfo.getValue().size()) {
                if (i2 > 0) {
                    buildCssInline.append(",");
                }
                buildCssInline.append(cssClassInfo.getValue().get(i2).getCssSelector());
                ++i2;
            }
            buildCssInline.append(cssClassInfo.getKey().getCssRule());
            buildCssInline.append("\n");
        }
        this.appendInlineCss(doc, buildCssInline);
    }

    public void appendInlineCss(XhtmlDocument doc, StringBuilder buildCssInline) {
        if (buildCssInline.length() > 0) {
            buildCssInline.insert(0, "<style>");
            buildCssInline.append("</style>");
            doc.appendHead(buildCssInline.toString());
        }
    }

    public void addCssInfo(MPrintFormatItem formatItem, int index) {
        CSSInfo cadidateCss = new CSSInfo(formatItem);
        if (this.mapCssInfo.containsKey(cadidateCss)) {
            this.mapCssInfo.get(cadidateCss).add(new ColumnInfo(index, formatItem));
        } else {
            ArrayList<ColumnInfo> newColumnList = new ArrayList<ColumnInfo>();
            newColumnList.add(new ColumnInfo(index, formatItem));
            this.mapCssInfo.put(cadidateCss, newColumnList);
        }
    }

    private boolean isDisplayPFItem(MPrintFormatItem item) {
        if (Util.isEmpty(item.getDisplayLogic())) {
            return true;
        }
        return Evaluator.evaluateLogic(new PrintDataEvaluatee(null, this.m_printData), item.getDisplayLogic());
    }

    public String compress(String src, boolean minify) {
        if (minify) {
            HtmlCompressor compressor = new HtmlCompressor();
            compressor.setEnabled(true);
            compressor.setCompressCss(true);
            compressor.setCompressJavaScript(true);
            compressor.setRemoveComments(true);
            compressor.setRemoveMultiSpaces(true);
            compressor.setRemoveIntertagSpaces(true);
            return compressor.compress(src);
        }
        return src;
    }

    public static void setDefaultReportTypeToPInstance(Properties ctx, MPInstance instance, int printFormatID) {
        if (Util.isEmpty(instance.getReportType())) {
            MPrintFormat pf = new MPrintFormat(ctx, printFormatID, null);
            String type = pf.isForm() ? MSysConfig.getValue("ZK_REPORT_FORM_OUTPUT_TYPE", "PDF", Env.getAD_Client_ID(ctx), Env.getAD_Org_ID(ctx)) : MSysConfig.getValue("ZK_REPORT_TABLE_OUTPUT_TYPE", "PDF", Env.getAD_Client_ID(ctx), Env.getAD_Org_ID(ctx));
            instance.setReportType(type);
        }
    }

    public class CSSInfo {
        private Font font;
        private Color color;
        private String cssStr;

        public CSSInfo(MPrintFormatItem item) {
            MPrintFont mPrintFont = null;
            if (item.getAD_PrintFont_ID() > 0) {
                mPrintFont = MPrintFont.get(item.getAD_PrintFont_ID());
            } else if (ReportEngine.this.m_printFormat.getAD_PrintFont_ID() > 0) {
                mPrintFont = MPrintFont.get(ReportEngine.this.m_printFormat.getAD_PrintFont_ID());
            }
            if (mPrintFont != null && mPrintFont.getAD_PrintFont_ID() > 0) {
                this.font = mPrintFont.getFont();
            }
            MPrintColor mPrintColor = null;
            if (item.getAD_PrintColor_ID() > 0) {
                mPrintColor = MPrintColor.get(ReportEngine.this.m_ctx, item.getAD_PrintColor_ID());
            } else if (ReportEngine.this.m_printFormat.getAD_PrintColor_ID() > 0) {
                mPrintColor = MPrintColor.get(ReportEngine.this.m_ctx, ReportEngine.this.m_printFormat.getAD_PrintColor_ID());
            }
            if (mPrintColor != null && mPrintColor.getAD_PrintColor_ID() > 0) {
                this.color = mPrintColor.getColor();
            }
        }

        public CSSInfo(Font font, Color color) {
            this.font = font;
            this.color = color;
        }

        public int hashCode() {
            return (this.color == null ? 0 : this.color.hashCode()) + (this.font == null ? 0 : this.font.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CSSInfo) || obj.hashCode() != this.hashCode()) {
                return false;
            }
            CSSInfo compareObj = (CSSInfo)obj;
            return this.compareObj(compareObj.color, this.color) && this.compareObj(compareObj.font, this.font);
        }

        protected boolean compareObj(Object obj1, Object obj2) {
            if (obj1 == null && obj2 != null) {
                return false;
            }
            if (obj1 == null && obj2 == null) {
                return true;
            }
            return obj1.equals(obj2);
        }

        protected void addCssRule(StringBuilder cssBuild, String ruleName, String ruleValue) {
            cssBuild.append(ruleName);
            cssBuild.append(":");
            cssBuild.append(ruleValue);
            cssBuild.append(";");
        }

        public String getCssRule() {
            if (this.cssStr != null) {
                return this.cssStr;
            }
            StringBuilder cssBuild = new StringBuilder();
            cssBuild.append("{");
            if (this.font != null) {
                String fontFamily = this.font.getFamily();
                if ((fontFamily = ReportEngine.this.getCSSFontFamily(fontFamily)) != null) {
                    this.addCssRule(cssBuild, "font-family", fontFamily);
                }
                if (this.font.isBold()) {
                    this.addCssRule(cssBuild, "font-weight", "bold");
                }
                if (this.font.isItalic()) {
                    this.addCssRule(cssBuild, "font-style", "italic");
                }
                int size = this.font.getSize();
                this.addCssRule(cssBuild, "font-size", String.valueOf(size) + "pt");
            }
            if (this.color != null) {
                cssBuild.append("color:rgb(");
                cssBuild.append(this.color.getRed());
                cssBuild.append(",");
                cssBuild.append(this.color.getGreen());
                cssBuild.append(",");
                cssBuild.append(this.color.getBlue());
                cssBuild.append(");");
            }
            cssBuild.append("}");
            this.cssStr = cssBuild.toString();
            return this.cssStr;
        }
    }

    public static class ColumnInfo {
        protected static String CSS_SELECTOR_TEMPLATE = "table > tbody > tr > td:nth-child(%1$s)";
        int index = -1;

        public ColumnInfo(int index, MPrintFormatItem formatItem) {
            this.index = index;
        }

        public String getCssSelector() {
            return String.format(CSS_SELECTOR_TEMPLATE, this.index + 1);
        }
    }
}

