/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import org.compiere.util.Env;

public class PrintDataFunction {
    private BigDecimal m_sum = Env.ZERO;
    private int m_count = 0;
    private int m_totalCount = 0;
    private BigDecimal m_min = null;
    private BigDecimal m_max = null;
    private Timestamp m_minDate = null;
    private Timestamp m_maxDate = null;
    private BigDecimal m_sumSquare = Env.ZERO;
    public static final char F_SUM = 'S';
    public static final char F_MEAN = 'A';
    public static final char F_COUNT = 'C';
    public static final char F_MIN = 'm';
    public static final char F_MAX = 'M';
    public static final char F_VARIANCE = 'V';
    public static final char F_DEVIATION = 'D';
    private static final char[] FUNCTIONS = new char[]{'S', 'A', 'C', 'm', 'M', 'V', 'D'};
    private static final String[] FUNCTION_SYMBOLS = new String[]{" \u03a3", " \u03bc", " \u2116", " \u2193", " \u2191", " \u03c3\u00b2", " \u03c3"};
    private static final String[] FUNCTION_NAMES = new String[]{"Sum", "Mean", "Count", "Min", "Max", "Variance", "Deviation"};

    public void addValue(Serializable s) {
        if (s != null) {
            ++this.m_count;
            if (s instanceof BigDecimal) {
                BigDecimal bdVaue = (BigDecimal)s;
                this.m_sum = this.m_sum.add(bdVaue);
                if (this.m_min == null) {
                    this.m_min = bdVaue;
                }
                this.m_min = this.m_min.min(bdVaue);
                if (this.m_max == null) {
                    this.m_max = bdVaue;
                }
                this.m_max = this.m_max.max(bdVaue);
                this.m_sumSquare = this.m_sumSquare.add(bdVaue.multiply(bdVaue));
            } else if (s instanceof Timestamp) {
                Timestamp t = (Timestamp)s;
                if (this.m_minDate == null || this.m_minDate.after(t)) {
                    this.m_minDate = t;
                }
                if (this.m_maxDate == null || this.m_maxDate.before(t)) {
                    this.m_maxDate = t;
                }
            }
        }
        ++this.m_totalCount;
    }

    public Serializable getValue(char function) {
        if (function == 'S') {
            return this.m_sum;
        }
        if (function == 'm') {
            if (this.m_minDate != null) {
                return this.m_minDate;
            }
            return this.m_min;
        }
        if (function == 'M') {
            if (this.m_maxDate != null) {
                return this.m_maxDate;
            }
            return this.m_max;
        }
        BigDecimal count = new BigDecimal(this.m_count);
        if (function == 'C') {
            return count;
        }
        if (this.m_count == 0) {
            return Env.ZERO;
        }
        if (function == 'A') {
            BigDecimal mean = this.m_sum.divide(count, 4, RoundingMode.HALF_UP);
            if (mean.scale() > 4) {
                mean = mean.setScale(4, RoundingMode.HALF_UP);
            }
            return mean;
        }
        BigDecimal ss = this.m_sum.multiply(this.m_sum);
        ss = ss.divide(count, 10, RoundingMode.HALF_UP);
        BigDecimal variance = this.m_sumSquare.subtract(ss).divide(count, 10, RoundingMode.HALF_UP);
        if (function == 'V') {
            if (variance.scale() > 4) {
                variance = variance.setScale(4, RoundingMode.HALF_UP);
            }
            return variance;
        }
        BigDecimal deviation = BigDecimal.valueOf(Math.sqrt(variance.doubleValue()));
        if (deviation.scale() > 4) {
            deviation = deviation.setScale(4, RoundingMode.HALF_UP);
        }
        return deviation;
    }

    public void reset() {
        this.m_count = 0;
        this.m_totalCount = 0;
        this.m_sum = Env.ZERO;
        this.m_sumSquare = Env.ZERO;
        this.m_min = null;
        this.m_max = null;
        this.m_minDate = null;
        this.m_maxDate = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[").append("Count=").append(this.m_count).append(",").append(this.m_totalCount).append(",Sum=").append(this.m_sum).append(",SumSquare=").append(this.m_sumSquare).append(",Min=").append(this.m_min).append(",Max=").append(this.m_max);
        sb.append("]");
        return sb.toString();
    }

    public static String getFunctionSymbol(char function) {
        int i2 = 0;
        while (i2 < FUNCTIONS.length) {
            if (FUNCTIONS[i2] == function) {
                return FUNCTION_SYMBOLS[i2];
            }
            ++i2;
        }
        return "UnknownFunction=" + function;
    }

    public static String getFunctionName(char function) {
        int i2 = 0;
        while (i2 < FUNCTIONS.length) {
            if (FUNCTIONS[i2] == function) {
                return FUNCTION_NAMES[i2];
            }
            ++i2;
        }
        return "UnknownFunction=" + function;
    }

    public static int getFunctionDisplayType(char function, int displayType) {
        if (function == 'S' || function == 'm' || function == 'M') {
            return displayType;
        }
        if (function == 'C') {
            return 11;
        }
        return 22;
    }
}

