/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MReportView;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.print.MPrintFormat;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataColumn;
import org.compiere.print.PrintDataElement;
import org.compiere.print.PrintDataFunction;
import org.compiere.print.PrintDataGroup;
import org.compiere.print.TableReference;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class DataEngine {
    private static CLogger log = CLogger.getCLogger(DataEngine.class);
    private String m_synonym = "A";
    private Language m_language = Language.getLoginLanguage();
    private PrintDataGroup m_group = new PrintDataGroup();
    private long m_startTime = System.currentTimeMillis();
    private int m_runningTotalLines = -1;
    private String m_runningTotalString = null;
    private String m_trxName = null;
    private boolean m_summary = false;
    public static final String KEY = "*";
    private int m_windowNo = 0;
    private Map<Object, Object> m_summarized = new HashMap<Object, Object>();

    public DataEngine(Language language) {
        this(language, null, 0);
    }

    public DataEngine(Language language, String trxName) {
        this(language, trxName, 0);
    }

    public DataEngine(Language language, String trxName, int windowNo) {
        if (language != null) {
            this.m_language = language;
        }
        this.m_trxName = trxName;
        this.m_windowNo = windowNo;
    }

    public PrintData getPrintData(Properties ctx, MPrintFormat format, MQuery query) {
        return this.getPrintData(ctx, format, query, false);
    }

    public PrintData getPrintData(Properties ctx, MPrintFormat format, MQuery query, boolean summary) {
        PrintData pd;
        boolean hasVT;
        MQuery queryCopy = query.deepCopy();
        this.m_summary = summary;
        if (format == null) {
            throw new IllegalStateException("No print format");
        }
        if (format.getJasperProcess_ID() > 0) {
            return null;
        }
        String tableName = null;
        String reportName = format.getName();
        if (format.getAD_ReportView_ID() != 0) {
            StringBuilder sql = new StringBuilder("SELECT t.AD_Table_ID, t.TableName, rv.Name, rv.WhereClause ").append("FROM AD_Table t").append(" INNER JOIN AD_ReportView rv ON (t.AD_Table_ID=rv.AD_Table_ID) ").append("WHERE rv.AD_ReportView_ID=?");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.m_trxName);
                    pstmt.setInt(1, format.getAD_ReportView_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        tableName = rs.getString(2);
                        reportName = rs.getString(3);
                        String whereClause = rs.getString(4);
                        if (!Util.isEmpty(whereClause)) {
                            if ((whereClause = "(" + whereClause + ")").indexOf("@") == -1) {
                                queryCopy.addRestriction(whereClause);
                            } else {
                                queryCopy.addRestriction(Env.parseContext(ctx, this.m_windowNo, whereClause.toString(), false, true));
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return null;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        } else {
            tableName = MTable.getTableName(ctx, format.getAD_Table_ID());
        }
        if (tableName == null) {
            log.log(Level.SEVERE, "Not found Format=" + format);
            return null;
        }
        if (format.isTranslationView() && tableName.toLowerCase().endsWith("_v") && (hasVT = DB.isTableOrViewExists(String.valueOf(tableName) + "t"))) {
            tableName = String.valueOf(tableName) + "t";
            format.setTranslationViewQuery(queryCopy);
        }
        if ((pd = this.getPrintDataInfo(ctx, format, queryCopy, reportName, tableName)) == null) {
            return null;
        }
        this.loadPrintData(pd, format);
        return pd;
    }

    private PrintData getPrintDataInfo(Properties ctx, MPrintFormat format, MQuery query, String reportName, String tableName) {
        MReportView reportView;
        StringBuilder sql;
        boolean IsGroupedBy;
        ArrayList<String> groupByColumns;
        StringBuilder sqlFROM;
        StringBuilder sqlSELECT;
        ArrayList<String> orderColumns;
        ArrayList<PrintDataColumn> columns;
        block97: {
            this.m_startTime = System.currentTimeMillis();
            if (log.isLoggable(Level.INFO)) {
                log.info(String.valueOf(reportName) + " - " + this.m_language.getAD_Language());
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("TableName=" + tableName + ", Query=" + query);
                log.fine("Format=" + format);
            }
            columns = new ArrayList<PrintDataColumn>();
            this.m_group = new PrintDataGroup();
            int[] orderAD_Column_IDs = format.getOrderAD_Column_IDs();
            orderColumns = new ArrayList<String>(orderAD_Column_IDs.length);
            int i2 = 0;
            while (i2 < orderAD_Column_IDs.length) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Order AD_Column_ID=" + orderAD_Column_IDs[i2]);
                }
                orderColumns.add("");
                ++i2;
            }
            sqlSELECT = new StringBuilder("SELECT ");
            sqlFROM = new StringBuilder(" FROM ").append(tableName);
            groupByColumns = new ArrayList<String>();
            IsGroupedBy = false;
            sql = new StringBuilder("SELECT c.AD_Column_ID,c.ColumnName,").append("c.AD_Reference_ID,c.AD_Reference_Value_ID,").append("c.FieldLength,c.IsMandatory,c.IsKey,c.IsParent,").append("COALESCE(rvc.IsGroupFunction,'N'),rvc.FunctionColumn,").append("pfi.IsGroupBy,pfi.IsSummarized,pfi.IsAveraged,pfi.IsCounted, ").append("pfi.IsPrinted,pfi.SortNo,pfi.IsPageBreak, ").append("pfi.IsMinCalc,pfi.IsMaxCalc, ").append("pfi.isRunningTotal,pfi.RunningTotalLines, ").append("pfi.IsVarianceCalc, pfi.IsDeviationCalc, ").append("c.ColumnSQL, COALESCE(pfi.FormatPattern, c.FormatPattern) ").append(" , pfi.isDesc, pfi.Script, pfi.Name, pfi.AD_PrintFormatItem_ID, pfi.PrintFormatType ").append("FROM AD_PrintFormat pf").append(" INNER JOIN AD_PrintFormatItem pfi ON (pf.AD_PrintFormat_ID=pfi.AD_PrintFormat_ID)").append(" LEFT JOIN AD_Column c ON (pfi.AD_Column_ID=c.AD_Column_ID)").append(" LEFT OUTER JOIN AD_ReportView_Col rvc ON (pf.AD_ReportView_ID=rvc.AD_ReportView_ID AND c.AD_Column_ID=rvc.AD_Column_ID) ").append("WHERE pf.AD_PrintFormat_ID=?").append(" AND pfi.IsActive='Y' AND (pfi.IsPrinted='Y' OR c.IsKey='Y' OR pfi.SortNo > 0 ").append(" OR EXISTS(select 1 from AD_PrintFormatItem x where x.AD_PrintFormat_ID=pf.AD_PrintFormat_ID and x.DisplayLogic is not null and ").append("(x.DisplayLogic Like '%@'||c.ColumnName||'@%' OR x.DisplayLogic Like '%@'||c.ColumnName||':%@%' OR x.DisplayLogic Like '%@'||c.ColumnName||'.%@%'))) ").append(" AND pfi.PrintFormatType IN ('F','I','P','S') ").append(" ORDER BY pfi.IsPrinted DESC, pfi.SeqNo");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.m_trxName);
                    pstmt.setInt(1, format.get_ID());
                    rs = pstmt.executeQuery();
                    this.m_synonym = "A";
                    String orgTable = null;
                    Pattern regTranslateTable = null;
                    if (tableName.toLowerCase().endsWith("_vt")) {
                        orgTable = MTable.getTableName(ctx, format.getAD_Table_ID());
                        regTranslateTable = Pattern.compile("\\b" + orgTable + "\\b", 2);
                    }
                    while (rs.next()) {
                        String display;
                        String orderName;
                        String FunctionColumn;
                        int AD_Column_ID = rs.getInt(1);
                        int AD_PrintFormatItem_ID = rs.getInt("AD_PrintFormatItem_ID");
                        String ColumnName = rs.getString(2);
                        String ColumnSQL = rs.getString(24);
                        if (ColumnSQL != null && ColumnSQL.length() > 0 && ColumnSQL.startsWith("@SQLFIND=")) {
                            ColumnSQL = ColumnSQL.substring(9);
                        }
                        if (ColumnSQL != null && ColumnSQL.length() > 0 && ColumnSQL.startsWith("@SQL=")) {
                            ColumnSQL = "NULL";
                        }
                        if (ColumnSQL != null && ColumnSQL.contains("@")) {
                            ColumnSQL = Env.parseContext(Env.getCtx(), this.m_windowNo, ColumnSQL, false, true);
                        }
                        if (ColumnSQL == null) {
                            ColumnSQL = "";
                        } else if (tableName.toLowerCase().endsWith("_vt")) {
                            ColumnSQL = regTranslateTable.matcher(ColumnSQL).replaceAll(tableName);
                        }
                        int AD_Reference_ID = rs.getInt(3);
                        int AD_Reference_Value_ID = rs.getInt(4);
                        int FieldLength = rs.getInt(5);
                        boolean IsMandatory = "Y".equals(rs.getString(6));
                        boolean IsKey = "Y".equals(rs.getString(7));
                        boolean IsGroupFunction = "Y".equals(rs.getString(9));
                        if (IsGroupFunction) {
                            IsGroupedBy = true;
                        }
                        if ((FunctionColumn = rs.getString(10)) == null) {
                            FunctionColumn = "";
                        }
                        if ("Y".equals(rs.getString(11))) {
                            this.m_group.addGroupColumn(AD_PrintFormatItem_ID);
                        }
                        if ("Y".equals(rs.getString(12))) {
                            this.m_group.addFunction(AD_PrintFormatItem_ID, 'S');
                        }
                        if ("Y".equals(rs.getString(13))) {
                            this.m_group.addFunction(AD_PrintFormatItem_ID, 'A');
                        }
                        if ("Y".equals(rs.getString(14))) {
                            this.m_group.addFunction(AD_PrintFormatItem_ID, 'C');
                        }
                        if ("Y".equals(rs.getString(18))) {
                            this.m_group.addFunction(AD_PrintFormatItem_ID, 'm');
                        }
                        if ("Y".equals(rs.getString(19))) {
                            this.m_group.addFunction(AD_PrintFormatItem_ID, 'M');
                        }
                        if ("Y".equals(rs.getString(22))) {
                            this.m_group.addFunction(AD_PrintFormatItem_ID, 'V');
                        }
                        if ("Y".equals(rs.getString(23))) {
                            this.m_group.addFunction(AD_PrintFormatItem_ID, 'D');
                        }
                        if ("Y".equals(rs.getString(20))) {
                            this.m_runningTotalLines = Math.max(this.m_runningTotalLines, rs.getInt(21));
                        }
                        boolean IsPrinted = "Y".equals(rs.getString(15));
                        boolean isPageBreak = "Y".equals(rs.getString(17));
                        String formatPattern = rs.getString(25);
                        String printFormatType = rs.getString(30);
                        boolean isDesc = "Y".equals(rs.getString(26));
                        String script2 = rs.getString(27);
                        String pfiName = rs.getString(28);
                        String lookupSQL = orderName = String.valueOf(tableName) + "." + ColumnName;
                        PrintDataColumn pdc = null;
                        if (IsKey) {
                            sqlSELECT.append(tableName).append(".").append(ColumnName).append(",");
                            groupByColumns.add(String.valueOf(tableName) + "." + ColumnName);
                            pdc = new PrintDataColumn(AD_PrintFormatItem_ID, AD_Column_ID, ColumnName, AD_Reference_ID, FieldLength, KEY, isPageBreak);
                        } else if (ColumnName == null || script2 != null && !script2.isEmpty()) {
                            if (script2 != null && !script2.isEmpty()) {
                                if (script2.startsWith("@SQL=")) {
                                    script2 = "(" + script2.replace("@SQL=", "").trim() + ")";
                                    script2 = Env.parseContext(Env.getCtx(), this.m_windowNo, script2, false);
                                } else {
                                    script2 = "'@SCRIPT" + script2 + "'";
                                }
                            } else {
                                script2 = "";
                            }
                            if (ColumnName == null && script2.isEmpty()) continue;
                            sqlSELECT.append(script2).append(" AS \"").append(this.m_synonym).append(pfiName).append("\",").append("' '").append(" AS \"").append(pfiName).append("\",");
                            pdc = new PrintDataColumn(AD_PrintFormatItem_ID, -1, pfiName, 14, FieldLength, orderName, isPageBreak);
                            this.synonymNext();
                        } else if (AD_Reference_ID == 19 || AD_Reference_ID == 30 && AD_Reference_Value_ID == 0) {
                            String eSql;
                            if (ColumnSQL.length() > 0) {
                                eSql = MLookupFactory.getLookup_TableDirEmbed(this.m_language, ColumnName, tableName, "(" + ColumnSQL + ")");
                                lookupSQL = ColumnSQL;
                            } else {
                                eSql = MLookupFactory.getLookup_TableDirEmbed(this.m_language, ColumnName, tableName);
                            }
                            if (Util.isEmpty(eSql)) {
                                eSql = lookupSQL;
                            }
                            display = ColumnName;
                            sqlSELECT.append("(").append(eSql).append(") AS ").append(this.m_synonym).append(display).append(",").append(lookupSQL).append(" AS ").append(ColumnName).append(",");
                            groupByColumns.add(lookupSQL);
                            orderName = String.valueOf(this.m_synonym) + display;
                            pdc = new PrintDataColumn(AD_PrintFormatItem_ID, AD_Column_ID, ColumnName, AD_Reference_ID, FieldLength, orderName, isPageBreak);
                            this.synonymNext();
                        } else if (AD_Reference_ID == 18 || AD_Reference_ID == 30 && AD_Reference_Value_ID != 0) {
                            String eSql = MLookupFactory.getLookup_TableEmbed(this.m_language, ColumnName, tableName, AD_Reference_Value_ID);
                            if (ColumnSQL.length() > 0) {
                                lookupSQL = ColumnSQL;
                            }
                            display = ColumnName;
                            sqlSELECT.append("(").append(eSql).append(") AS ").append(this.m_synonym).append(display).append(",").append(lookupSQL).append(" AS ").append(ColumnName).append(",");
                            groupByColumns.add(String.valueOf(this.m_synonym) + display);
                            groupByColumns.add(lookupSQL);
                            orderName = String.valueOf(this.m_synonym) + display;
                            TableReference tr2 = DataEngine.getTableReference(AD_Reference_Value_ID);
                            String foreignColumnName = tr2.KeyColumn;
                            pdc = new PrintDataColumn(AD_PrintFormatItem_ID, AD_Column_ID, ColumnName, AD_Reference_ID, FieldLength, orderName, isPageBreak, foreignColumnName);
                            this.synonymNext();
                        } else if (DisplayType.isList(AD_Reference_ID) || AD_Reference_ID == 28 && AD_Reference_Value_ID != 0) {
                            if (ColumnSQL.length() > 0) {
                                lookupSQL = ColumnSQL;
                            }
                            if (Env.isBaseLanguage(this.m_language, "AD_Ref_List")) {
                                sqlSELECT.append(this.m_synonym).append(".Name AS ").append(this.m_synonym).append("Name,");
                                groupByColumns.add(String.valueOf(this.m_synonym) + ".Name");
                                orderName = String.valueOf(this.m_synonym) + "Name";
                                sqlFROM.append(" LEFT OUTER JOIN ");
                                sqlFROM.append("AD_Ref_List ").append(this.m_synonym).append(" ON (").append(lookupSQL).append("=").append(this.m_synonym).append(".Value").append(" AND ").append(this.m_synonym).append(".AD_Reference_ID=").append(AD_Reference_Value_ID).append(")");
                            } else {
                                sqlSELECT.append(this.m_synonym).append(".Name AS ").append(this.m_synonym).append("Name,");
                                groupByColumns.add(String.valueOf(this.m_synonym) + ".Name");
                                orderName = String.valueOf(this.m_synonym) + "Name";
                                sqlFROM.append(" LEFT OUTER JOIN ");
                                sqlFROM.append(" AD_Ref_List X").append(this.m_synonym).append(" ON (").append(lookupSQL).append("=X").append(this.m_synonym).append(".Value AND X").append(this.m_synonym).append(".AD_Reference_ID=").append(AD_Reference_Value_ID).append(")");
                                sqlFROM.append(" LEFT OUTER JOIN ");
                                sqlFROM.append(" AD_Ref_List_Trl ").append(this.m_synonym).append(" ON (X").append(this.m_synonym).append(".AD_Ref_List_ID=").append(this.m_synonym).append(".AD_Ref_List_ID").append(" AND ").append(this.m_synonym).append(".AD_Language='").append(this.m_language.getAD_Language()).append("')");
                            }
                            sqlSELECT.append(lookupSQL).append(" AS ").append(ColumnName).append(",");
                            groupByColumns.add(lookupSQL);
                            pdc = new PrintDataColumn(AD_PrintFormatItem_ID, AD_Column_ID, ColumnName, AD_Reference_ID, FieldLength, orderName, isPageBreak);
                            this.synonymNext();
                        } else if (AD_Reference_ID == 21 || AD_Reference_ID == 25 || AD_Reference_ID == 31 || AD_Reference_ID == 35) {
                            if (ColumnSQL.length() > 0) {
                                lookupSQL = ColumnSQL;
                            }
                            String table2 = "";
                            String key = "";
                            String display2 = "";
                            String synonym = null;
                            if (AD_Reference_ID == 21) {
                                table2 = "C_Location";
                                key = "C_Location_ID";
                                display2 = "City||'.'";
                                synonym = "Address";
                            } else if (AD_Reference_ID == 25) {
                                table2 = "C_ValidCombination";
                                key = "C_ValidCombination_ID";
                                display2 = "Combination";
                            } else if (AD_Reference_ID == 31) {
                                table2 = "M_Locator";
                                key = "M_Locator_ID";
                                display2 = "Value";
                            } else if (AD_Reference_ID == 35) {
                                table2 = "M_AttributeSetInstance";
                                key = "M_AttributeSetInstance_ID";
                                display2 = "Description";
                                if (CLogMgt.isLevelFine()) {
                                    display2 = String.valueOf(display2) + "||'{'||" + this.m_synonym + ".M_AttributeSetInstance_ID||'}'";
                                }
                                synonym = "Description";
                            }
                            if (synonym == null) {
                                synonym = display2;
                            }
                            sqlSELECT.append(this.m_synonym).append(".").append(display2).append(" AS ").append(this.m_synonym).append(synonym).append(",").append(lookupSQL).append(" AS ").append(ColumnName).append(",");
                            groupByColumns.add(String.valueOf(this.m_synonym) + "." + synonym);
                            groupByColumns.add(lookupSQL);
                            orderName = String.valueOf(this.m_synonym) + synonym;
                            if (IsMandatory) {
                                sqlFROM.append(" INNER JOIN ");
                            } else {
                                sqlFROM.append(" LEFT OUTER JOIN ");
                            }
                            sqlFROM.append(table2).append(" ").append(this.m_synonym).append(" ON (").append(lookupSQL).append("=").append(this.m_synonym).append(".").append(key).append(")");
                            pdc = new PrintDataColumn(AD_PrintFormatItem_ID, AD_Column_ID, ColumnName, AD_Reference_ID, FieldLength, orderName, isPageBreak);
                            this.synonymNext();
                        } else {
                            StringBuilder sb;
                            int index = FunctionColumn.indexOf(64);
                            if (ColumnSQL != null && ColumnSQL.length() > 0) {
                                sqlSELECT.append(ColumnSQL).append(" AS ").append(ColumnName).append(",");
                                if (!IsGroupFunction) {
                                    groupByColumns.add(ColumnSQL);
                                }
                                orderName = ColumnName;
                            } else if (index == -1) {
                                sb = new StringBuilder();
                                sb.append(tableName).append(".").append(ColumnName);
                                sqlSELECT.append((CharSequence)sb).append(",");
                                if (!IsGroupFunction) {
                                    groupByColumns.add(sb.toString());
                                }
                            } else {
                                sb = new StringBuilder();
                                sb.append(FunctionColumn.substring(0, index)).append(tableName).append(".").append(ColumnName).append(FunctionColumn.substring(index + 1));
                                sqlSELECT.append((CharSequence)sb).append(" AS ").append(ColumnName).append(",");
                                if (!IsGroupFunction) {
                                    groupByColumns.add(sb.toString());
                                }
                                orderName = ColumnName;
                            }
                            pdc = new PrintDataColumn(AD_PrintFormatItem_ID, AD_Column_ID, ColumnName, AD_Reference_ID, FieldLength, ColumnName, isPageBreak);
                        }
                        int i3 = 0;
                        while (i3 < orderAD_Column_IDs.length) {
                            if (AD_Column_ID == orderAD_Column_IDs[i3]) {
                                if (isDesc) {
                                    orderName = String.valueOf(orderName) + " DESC";
                                }
                                orderColumns.set(i3, orderName);
                                if (IsPrinted || IsGroupFunction) break;
                                groupByColumns.add(String.valueOf(tableName) + "." + ColumnName);
                                break;
                            }
                            ++i3;
                        }
                        pdc.setFormatPattern(formatPattern);
                        pdc.setPrintFormatType(printFormatType);
                        columns.add(pdc);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, "SQL=" + sql + " - ID=" + format.get_ID(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block97;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (columns.size() == 0) {
            log.log(Level.SEVERE, "No Colums - Delete Report Format " + reportName + " and start again");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("No Colums - SQL=" + sql + " - ID=" + format.get_ID());
            }
            return null;
        }
        boolean hasLevelNo = false;
        if (tableName.startsWith("T_Report")) {
            hasLevelNo = true;
            if (sqlSELECT.indexOf("LevelNo") == -1) {
                sqlSELECT.append("LevelNo,");
            }
            if (tableName.equals("T_Report") && sqlSELECT.indexOf("PA_ReportLine_ID") == -1) {
                sqlSELECT.append("PA_ReportLine_ID,");
            }
        }
        StringBuilder finalSQL = new StringBuilder();
        finalSQL.append(sqlSELECT.substring(0, sqlSELECT.length() - 1)).append((CharSequence)sqlFROM);
        if (tableName.startsWith("T_Report")) {
            finalSQL.append(" WHERE ");
            int i4 = 0;
            while (i4 < query.getRestrictionCount()) {
                String q = query.getWhereClause(i4);
                if (q.indexOf("AD_PInstance_ID") != -1) {
                    finalSQL.append(q);
                }
                ++i4;
            }
        } else {
            MRole role;
            if (query != null && query.isActive()) {
                finalSQL.append(" WHERE ");
                if (!query.getTableName().equals(tableName)) {
                    query.setTableName(tableName);
                }
                finalSQL.append(query.getWhereClause(true));
            }
            if ((role = MRole.getDefault(ctx, false)).getAD_Role_ID() != 0 || Ini.isClient()) {
                finalSQL = new StringBuilder(role.addAccessSQL(finalSQL.toString(), tableName, true, false));
            }
        }
        if (IsGroupedBy) {
            int i5 = 0;
            while (i5 < groupByColumns.size()) {
                if (i5 == 0) {
                    finalSQL.append(" GROUP BY ");
                } else {
                    finalSQL.append(",");
                }
                finalSQL.append((String)groupByColumns.get(i5));
                ++i5;
            }
        }
        if (orderColumns != null && orderColumns.size() > 0) {
            int i6 = 0;
            while (i6 < orderColumns.size()) {
                if (i6 == 0) {
                    finalSQL.append(" ORDER BY ");
                } else {
                    finalSQL.append(",");
                }
                String by = (String)orderColumns.get(i6);
                if (by == null || by.length() == 0) {
                    by = String.valueOf(i6 + 1);
                }
                finalSQL.append(by);
                ++i6;
            }
        } else if (format.getAD_ReportView_ID() > 0 && (reportView = MReportView.get(Env.getCtx(), format.getAD_ReportView_ID())) != null && !Util.isEmpty(reportView.getOrderByClause(), true)) {
            finalSQL.append(" ORDER BY ").append(reportView.getOrderByClause());
        }
        PrintData pd = new PrintData(ctx, reportName);
        PrintDataColumn[] info = new PrintDataColumn[columns.size()];
        columns.toArray(info);
        pd.setColumnInfo(info);
        pd.setTableName(tableName);
        pd.setSQL(finalSQL.toString());
        pd.setHasLevelNo(hasLevelNo);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(finalSQL.toString());
            log.finest("Group=" + this.m_group);
        }
        return pd;
    }

    private void synonymNext() {
        int length = this.m_synonym.length();
        char cc = this.m_synonym.charAt(0);
        if (cc == 'Z') {
            cc = 'A';
            ++length;
        } else if ((cc = (char)((char)(cc + 1))) == 'X') {
            cc = (char)(cc + '\u0001');
        }
        this.m_synonym = String.valueOf(cc);
        int i2 = 1;
        while (i2 < length) {
            this.m_synonym = String.valueOf(this.m_synonym) + String.valueOf(cc);
            ++i2;
        }
    }

    public static TableReference getTableReference(int AD_Reference_Value_ID) {
        TableReference tr2;
        block7: {
            if (AD_Reference_Value_ID <= 0) {
                throw new IllegalArgumentException("AD_Reference_Value_ID <= 0");
            }
            tr2 = new TableReference();
            StringBuilder SQL = new StringBuilder("SELECT t.TableName, ck.ColumnName AS KeyColumn,").append(" cd.ColumnName AS DisplayColumn, rt.IsValueDisplayed, cd.IsTranslated ").append("FROM AD_Ref_Table rt").append(" INNER JOIN AD_Table t ON (rt.AD_Table_ID = t.AD_Table_ID)").append(" INNER JOIN AD_Column ck ON (rt.AD_Key = ck.AD_Column_ID)").append(" INNER JOIN AD_Column cd ON (rt.AD_Display = cd.AD_Column_ID) ").append("WHERE rt.AD_Reference_ID=?").append(" AND rt.IsActive = 'Y' AND t.IsActive = 'Y'");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(SQL.toString(), null);
                    pstmt.setInt(1, AD_Reference_Value_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        tr2.TableName = rs.getString(1);
                        tr2.KeyColumn = rs.getString(2);
                        tr2.DisplayColumn = rs.getString(3);
                        tr2.IsValueDisplayed = "Y".equals(rs.getString(4));
                        tr2.IsTranslated = "Y".equals(rs.getString(5));
                    }
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, SQL.toString(), ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return tr2;
    }

    private void loadPrintData(PrintData pd, MPrintFormat format) {
        int i2;
        boolean translateSpool = pd.getTableName().equals("T_Spool");
        this.m_runningTotalString = Msg.getMsg(format.getLanguage(), "RunningTotal");
        int rowNo = 0;
        PrintDataColumn pdc = null;
        boolean hasLevelNo = pd.hasLevelNo();
        int levelNo = 0;
        int reportLineID = 0;
        ArrayList<PrintDataColumn> scriptColumns = new ArrayList<PrintDataColumn>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                int i3;
                pstmt = DB.prepareNormalReadReplicaStatement(pd.getSQL(), this.m_trxName);
                rs = pstmt.executeQuery();
                boolean isExistsT_Report_PA_ReportLine_ID = false;
                if (pd.getTableName().equals("T_Report")) {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    i3 = 1;
                    while (i3 <= rsmd.getColumnCount()) {
                        if (rsmd.getColumnLabel(i3).equalsIgnoreCase("PA_ReportLine_ID")) {
                            isExistsT_Report_PA_ReportLine_ID = true;
                            break;
                        }
                        ++i3;
                    }
                }
                while (rs.next()) {
                    if (hasLevelNo) {
                        levelNo = rs.getInt("LevelNo");
                        if (isExistsT_Report_PA_ReportLine_ID) {
                            reportLineID = rs.getInt("PA_ReportLine_ID");
                        }
                    } else {
                        levelNo = 0;
                    }
                    if (this.m_group.getGroupColumnCount() > 1) {
                        Object value;
                        PrintDataColumn group_pdc;
                        ArrayList<PrintDataColumn> changedGroups = new ArrayList<PrintDataColumn>();
                        ArrayList<Object> changedValues = new ArrayList<Object>();
                        boolean force = false;
                        int i4 = 0;
                        while (i4 < pd.getColumnInfo().length) {
                            group_pdc = pd.getColumnInfo()[i4];
                            if (this.m_group.isGroupColumn(group_pdc.getAD_PrintFormatItem_ID()) && (value = this.m_group.groupChange(group_pdc.getAD_PrintFormatItem_ID(), rs.getObject(group_pdc.getAlias()), force)) != null) {
                                changedGroups.add(group_pdc);
                                changedValues.add(value);
                                force = true;
                            }
                            ++i4;
                        }
                        int j = changedGroups.size() - 1;
                        while (j >= 0) {
                            group_pdc = (PrintDataColumn)changedGroups.get(j);
                            value = changedValues.get(j);
                            char[] functions = this.m_group.getFunctions(group_pdc.getAD_PrintFormatItem_ID());
                            int f = 0;
                            while (f < functions.length) {
                                this.printRunningTotal(pd, levelNo, rowNo++);
                                pd.addRow(true, levelNo);
                                int c = 0;
                                while (c < pd.getColumnInfo().length) {
                                    pdc = pd.getColumnInfo()[c];
                                    if (group_pdc.getAD_PrintFormatItem_ID() == pdc.getAD_PrintFormatItem_ID()) {
                                        String valueString = value.toString();
                                        if (value instanceof Timestamp) {
                                            valueString = DisplayType.getDateFormat(pdc.getDisplayType(), this.m_language, pdc.getFormatPattern()).format(value);
                                        }
                                        if (format.getTableFormat().isPrintFunctionSymbols()) {
                                            valueString = String.valueOf(valueString) + PrintDataFunction.getFunctionSymbol(functions[f]);
                                        }
                                        pd.addNode(new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), (Serializable)((Object)valueString), 10, false, pdc.isPageBreak(), pdc.getFormatPattern()));
                                    } else if (this.m_group.isFunctionColumn(pdc.getAD_PrintFormatItem_ID(), functions[f])) {
                                        pd.addNode(new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), this.m_group.getValue(group_pdc.getAD_PrintFormatItem_ID(), pdc.getAD_PrintFormatItem_ID(), functions[f]), PrintDataFunction.getFunctionDisplayType(functions[f], pdc.getDisplayType()), false, pdc.isPageBreak(), pdc.getFormatPattern()));
                                    }
                                    ++c;
                                }
                                ++f;
                            }
                            int c = 0;
                            while (c < pd.getColumnInfo().length) {
                                pdc = pd.getColumnInfo()[c];
                                this.m_group.reset(group_pdc.getAD_PrintFormatItem_ID(), pdc.getAD_PrintFormatItem_ID());
                                ++c;
                            }
                            --j;
                        }
                    }
                    this.printRunningTotal(pd, levelNo, rowNo++);
                    if (!this.m_summary) {
                        pd.addRow(false, levelNo, reportLineID);
                    }
                    int counter = 1;
                    i3 = 0;
                    while (i3 < pd.getColumnInfo().length) {
                        pdc = pd.getColumnInfo()[i3];
                        PrintDataElement pde = null;
                        if (pdc.getAlias().equals(KEY)) {
                            if (pdc.getColumnName().endsWith("_ID")) {
                                int id = rs.getInt(counter++);
                                if (!rs.wasNull()) {
                                    KeyNamePair pp = new KeyNamePair(id, KEY);
                                    pde = new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), pp, pdc.getDisplayType(), true, pdc.isPageBreak(), pdc.getFormatPattern());
                                }
                            } else {
                                String id = rs.getString(counter++);
                                if (!rs.wasNull()) {
                                    ValueNamePair pp = new ValueNamePair(id, KEY);
                                    pde = new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), pp, pdc.getDisplayType(), true, pdc.isPageBreak(), pdc.getFormatPattern());
                                }
                            }
                        } else if (pdc.hasAlias()) {
                            int displayIndex = counter++;
                            String display = rs.getString(displayIndex);
                            if (pdc.getColumnName().endsWith("_ID")) {
                                int id = rs.getInt(counter++);
                                if (display != null && !rs.wasNull()) {
                                    KeyNamePair pp = new KeyNamePair(id, display);
                                    pde = new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), pp, pdc.getDisplayType(), pdc.getFormatPattern(), pdc.getForeignColumnName());
                                }
                            } else {
                                String id = rs.getString(counter++);
                                if (display != null && !rs.wasNull()) {
                                    int displayType = pdc.getDisplayType();
                                    if ("S".equalsIgnoreCase(pdc.getPrintFormatType())) {
                                        Object value = rs.getObject(displayIndex);
                                        if (display.startsWith("@SCRIPT")) {
                                            if (!scriptColumns.contains(pdc)) {
                                                scriptColumns.add(pdc);
                                            }
                                            displayType = 14;
                                        } else {
                                            displayType = this.getDisplayType(value);
                                        }
                                        pde = new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), (Serializable)value, displayType, pdc.getFormatPattern());
                                    } else {
                                        ValueNamePair pp = new ValueNamePair(id, display);
                                        pde = new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), pp, displayType, pdc.getFormatPattern());
                                    }
                                }
                            }
                        } else if (pdc.getDisplayType() == 20) {
                            String s = rs.getString(counter++);
                            if (!rs.wasNull()) {
                                boolean b2 = s.equals("Y");
                                pde = new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), Boolean.valueOf(b2), pdc.getDisplayType(), pdc.getFormatPattern());
                            }
                        } else if (pdc.getDisplayType() == 36) {
                            Clob clob;
                            String value = "";
                            if ("java.lang.String".equals(rs.getMetaData().getColumnClassName(counter))) {
                                value = rs.getString(counter++);
                            } else if ((clob = rs.getClob(counter++)) != null) {
                                long length = clob.length();
                                value = clob.getSubString(1L, (int)length);
                            }
                            pde = new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), (Serializable)((Object)value), pdc.getDisplayType(), pdc.getFormatPattern());
                        } else if (pdc.getDisplayType() == 16) {
                            Timestamp datetime = rs.getTimestamp(counter++);
                            pde = new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), datetime, pdc.getDisplayType(), pdc.getFormatPattern());
                        } else {
                            Object obj;
                            if ((obj = rs.getObject(counter++)) != null && obj instanceof String && ((String)(obj = ((String)obj).trim())).length() == 0) {
                                obj = null;
                            }
                            if (obj != null) {
                                if (translateSpool && obj instanceof String) {
                                    String s = (String)obj;
                                    s = Msg.parseTranslation(pd.getCtx(), s);
                                    pde = new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), (Serializable)((Object)s), pdc.getDisplayType(), pdc.getFormatPattern());
                                } else {
                                    pde = new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), (Serializable)obj, pdc.getDisplayType(), pdc.getFormatPattern());
                                }
                            }
                        }
                        if (pde != null) {
                            if (!this.m_summary) {
                                pd.addNode(pde);
                            }
                            this.m_group.addValue(pde.getAD_PrintFormatItem_ID(), pde.getFunctionValue());
                        }
                        ++i3;
                    }
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, pdc + " - " + e.getMessage() + "\nSQL=" + pd.getSQL());
                throw new AdempiereException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (scriptColumns.size() > 0) {
            i2 = 0;
            while (i2 < pd.getRowCount()) {
                for (PrintDataColumn c : scriptColumns) {
                    pd.setRowIndex(i2);
                    PrintDataElement e = (PrintDataElement)pd.getNodeByPrintFormatItemId(c.getAD_PrintFormatItem_ID());
                    Object value = this.parseVariable(e.getValueAsString().replace("@SCRIPT", ""), c, pd);
                    Interpreter bsh = new Interpreter();
                    try {
                        value = bsh.eval(value.toString());
                    }
                    catch (EvalError err) {
                        log.severe(err.getMessage());
                    }
                    e.setDisplayType(this.getDisplayType(value));
                    if (value instanceof Serializable) {
                        e.setValue((Serializable)value);
                        continue;
                    }
                    e.setValue((Serializable)((Object)Objects.toString(value, "")));
                }
                ++i2;
            }
        }
        if (this.m_group.getGroupColumnCount() > 1) {
            i2 = pd.getColumnInfo().length - 1;
            while (i2 >= 0) {
                Object value;
                PrintDataColumn group_pdc = pd.getColumnInfo()[i2];
                if (this.m_group.isGroupColumn(group_pdc.getAD_PrintFormatItem_ID()) && (value = this.m_group.groupChange(group_pdc.getAD_PrintFormatItem_ID(), new Object(), false)) != null) {
                    char[] functions = this.m_group.getFunctions(group_pdc.getAD_PrintFormatItem_ID());
                    int f = 0;
                    while (f < functions.length) {
                        this.printRunningTotal(pd, levelNo, rowNo++);
                        pd.addRow(true, levelNo);
                        int c = 0;
                        while (c < pd.getColumnInfo().length) {
                            pdc = pd.getColumnInfo()[c];
                            if (group_pdc.getColumnName().equals(pdc.getColumnName())) {
                                String valueString = value.toString();
                                if (value instanceof Timestamp) {
                                    valueString = DisplayType.getDateFormat(pdc.getDisplayType(), this.m_language, pdc.getFormatPattern()).format(value);
                                }
                                if (format.getTableFormat().isPrintFunctionSymbols()) {
                                    valueString = String.valueOf(valueString) + PrintDataFunction.getFunctionSymbol(functions[f]);
                                }
                                pd.addNode(new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), (Serializable)((Object)valueString), 10, pdc.getFormatPattern()));
                            } else if (this.m_group.isFunctionColumn(pdc.getAD_PrintFormatItem_ID(), functions[f])) {
                                pd.addNode(new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), this.m_group.getValue(group_pdc.getAD_PrintFormatItem_ID(), pdc.getAD_PrintFormatItem_ID(), functions[f]), PrintDataFunction.getFunctionDisplayType(functions[f], pdc.getDisplayType()), pdc.getFormatPattern()));
                            }
                            ++c;
                        }
                        ++f;
                    }
                }
                --i2;
            }
        }
        if (this.m_group.isGroupColumn(-1)) {
            char[] functions = this.m_group.getFunctions(-1);
            int f = 0;
            while (f < functions.length) {
                this.printRunningTotal(pd, levelNo, rowNo++);
                pd.addRow(true, levelNo);
                int c = 0;
                while (c < pd.getColumnInfo().length) {
                    pdc = pd.getColumnInfo()[c];
                    if (c == 0) {
                        String name = !format.getTableFormat().isPrintFunctionSymbols() ? Msg.getMsg(format.getLanguage(), PrintDataFunction.getFunctionName(functions[f])) : PrintDataFunction.getFunctionSymbol(functions[f]);
                        if (this.m_group.isFunctionColumn(pdc.getAD_PrintFormatItem_ID(), functions[f])) {
                            name = String.valueOf(name) + " " + this.m_group.getValue(-1, pdc.getAD_PrintFormatItem_ID(), functions[f]);
                        }
                        pd.addNode(new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), (Serializable)((Object)name.trim()), 10, pdc.getFormatPattern()));
                    } else if (this.m_group.isFunctionColumn(pdc.getAD_PrintFormatItem_ID(), functions[f])) {
                        pd.addNode(new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), this.m_group.getValue(-1, pdc.getAD_PrintFormatItem_ID(), functions[f]), PrintDataFunction.getFunctionDisplayType(functions[f], pdc.getDisplayType()), pdc.getFormatPattern()));
                    }
                    ++c;
                }
                ++f;
            }
        }
        if (pd.getRowCount() == 0) {
            if (CLogMgt.isLevelFiner()) {
                log.warning("NO Rows - ms=" + (System.currentTimeMillis() - this.m_startTime) + " - " + pd.getSQL());
            } else {
                log.warning("NO Rows - ms=" + (System.currentTimeMillis() - this.m_startTime));
            }
        } else if (log.isLoggable(Level.INFO)) {
            log.info("Rows=" + pd.getRowCount() + " - ms=" + (System.currentTimeMillis() - this.m_startTime));
        }
    }

    private void printRunningTotal(PrintData pd, int levelNo, int rowNo) {
        if (this.m_runningTotalLines < 1) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("(" + this.m_runningTotalLines + ") - Row=" + rowNo + ", mod=" + rowNo % this.m_runningTotalLines);
        }
        if (rowNo % this.m_runningTotalLines != 0) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Row=" + rowNo);
        }
        PrintDataColumn pdc = null;
        int start = 0;
        if (rowNo == 0) {
            start = 1;
        }
        int rt = start;
        while (rt < 2) {
            pd.addRow(true, levelNo);
            int c = 0;
            while (c < pd.getColumnInfo().length) {
                pdc = pd.getColumnInfo()[c];
                if (c == 0) {
                    String title = "RunningTotal";
                    pd.addNode(new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), (Serializable)((Object)title), 10, false, rt == 0, pdc.getFormatPattern()));
                } else if (this.m_group.isFunctionColumn(pdc.getAD_PrintFormatItem_ID(), 'S')) {
                    pd.addNode(new PrintDataElement(pdc.getAD_PrintFormatItem_ID(), pdc.getColumnName(), this.m_group.getValue(-1, pdc.getAD_PrintFormatItem_ID(), 'S'), PrintDataFunction.getFunctionDisplayType('S', pdc.getDisplayType()), false, false, pdc.getFormatPattern()));
                }
                ++c;
            }
            ++rt;
        }
    }

    private int getDisplayType(Object value) {
        if (value instanceof Number) {
            return 22;
        }
        if (value instanceof Boolean) {
            return 20;
        }
        if (value instanceof Date) {
            return 15;
        }
        return 14;
    }

    public String parseVariable(String expression, PrintDataColumn pdc, PrintData pd) {
        if (expression == null || expression.length() == 0) {
            return "";
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Analyzing Expression " + expression);
        }
        String inStr = new String(expression);
        StringBuffer outStr = new StringBuffer();
        int i2 = inStr.indexOf(64);
        while (i2 != -1) {
            Object value;
            Object tokenPDE;
            outStr.append(inStr.substring(0, i2));
            inStr = inStr.substring(i2 + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                return "";
            }
            String token = inStr.substring(0, j);
            if (token.startsWith("ACCUMULATE/")) {
                tokenPDE = pd.getNode(token = token.replace("ACCUMULATE/", ""));
                if (tokenPDE == null) {
                    return "\"Item not found: " + token + "\"";
                }
                value = (BigDecimal)((PrintDataElement)tokenPDE).getValue();
                if (this.m_summarized.containsKey(pdc)) {
                    value = ((BigDecimal)this.m_summarized.get(pdc)).add((BigDecimal)value);
                    this.m_summarized.remove(pdc);
                }
                this.m_summarized.put(pdc, value);
                outStr.append(value);
            } else if (token.startsWith("COL/")) {
                tokenPDE = pd.getNode(token = token.replace("COL/", ""));
                if (tokenPDE == null) {
                    return "\"Item not found: " + token + "\"";
                }
                value = ((PrintDataElement)tokenPDE).getValue();
                outStr.append(value);
            } else if (token.equals("LINE")) {
                BigDecimal value2 = Env.ONE;
                if (this.m_summarized.containsKey(pdc)) {
                    value2 = ((BigDecimal)this.m_summarized.get(pdc)).add(value2);
                    this.m_summarized.remove(pdc);
                }
                this.m_summarized.put(pdc, value2);
                outStr.append(value2);
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i2 = inStr.indexOf(64);
        }
        outStr.append(inStr);
        return outStr.toString();
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        DataEngine de = new DataEngine(Language.getLanguage("de_DE"));
        MQuery query = new MQuery();
        query.addRestriction("AD_Table_ID", "<", 105);
    }

    public int getWindowNo() {
        return this.m_windowNo;
    }

    public void setWindowNo(int windowNo) {
        this.m_windowNo = windowNo;
    }
}

