/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.adempiere.model.ITaxProvider;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MRMATax;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class StandardTaxProvider
implements ITaxProvider {
    protected transient CLogger log = CLogger.getCLogger(this.getClass());

    @Override
    public boolean calculateOrderTaxTotal(MTaxProvider provider, MOrder order) {
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MOrderLine[] lines = order.getLines();
        int i2 = 0;
        while (i2 < lines.length) {
            MTax tax;
            MOrderLine line = lines[i2];
            totalLines = totalLines.add(line.getLineNetAmt());
            Integer taxID = line.getC_Tax_ID();
            if (!taxList.contains(taxID) && (tax = new MTax(order.getCtx(), taxID, order.get_TrxName())).getC_TaxProvider_ID() == 0) {
                MOrderTax oTax = MOrderTax.get(line, order.getPrecision(), false, order.get_TrxName());
                oTax.setIsTaxIncluded(order.isTaxIncluded());
                if (!oTax.calculateTaxFromLines()) {
                    return false;
                }
                if (!oTax.save(order.get_TrxName())) {
                    return false;
                }
                taxList.add(taxID);
            }
            ++i2;
        }
        BigDecimal grandTotal = totalLines;
        MOrderTax[] taxes = order.getTaxes(true);
        int i3 = 0;
        while (i3 < taxes.length) {
            MOrderTax oTax = taxes[i3];
            if (oTax.getC_TaxProvider_ID() != 0) {
                if (!order.isTaxIncluded()) {
                    grandTotal = grandTotal.add(oTax.getTaxAmt());
                }
            } else {
                MTax tax = oTax.getTax();
                if (tax.isSummary()) {
                    MTax[] cTaxes = tax.getChildTaxes(false);
                    int j = 0;
                    while (j < cTaxes.length) {
                        MTax cTax = cTaxes[j];
                        BigDecimal taxAmt = cTax.calculateTax(oTax.getTaxBaseAmt(), false, order.getPrecision());
                        MOrderTax newOTax = new MOrderTax(order.getCtx(), 0, order.get_TrxName());
                        newOTax.setClientOrg(order);
                        newOTax.setC_Order_ID(order.getC_Order_ID());
                        newOTax.setC_Tax_ID(cTax.getC_Tax_ID());
                        newOTax.setPrecision(order.getPrecision());
                        newOTax.setIsTaxIncluded(order.isTaxIncluded());
                        newOTax.setTaxBaseAmt(oTax.getTaxBaseAmt());
                        newOTax.setTaxAmt(taxAmt);
                        if (!newOTax.save(order.get_TrxName())) {
                            return false;
                        }
                        if (!order.isTaxIncluded()) {
                            grandTotal = grandTotal.add(taxAmt);
                        }
                        ++j;
                    }
                    if (!oTax.delete(true, order.get_TrxName())) {
                        return false;
                    }
                } else if (!order.isTaxIncluded()) {
                    grandTotal = grandTotal.add(oTax.getTaxAmt());
                }
            }
            ++i3;
        }
        order.setTotalLines(totalLines);
        order.setGrandTotal(grandTotal);
        return true;
    }

    @Override
    public boolean updateOrderTax(MTaxProvider provider, MOrderLine line) {
        MTax mtax = new MTax(line.getCtx(), line.getC_Tax_ID(), line.get_TrxName());
        if (mtax.getC_TaxProvider_ID() == 0) {
            return line.updateOrderTax(false);
        }
        return true;
    }

    @Override
    public boolean recalculateTax(MTaxProvider provider, MOrderLine line, boolean newRecord) {
        MTax mtax;
        if (!newRecord && line.is_ValueChanged("C_Tax_ID") && !line.getParent().isProcessed() && (mtax = new MTax(line.getCtx(), line.getC_Tax_ID(), line.get_TrxName())).getC_TaxProvider_ID() == 0 && !line.updateOrderTax(true)) {
            return false;
        }
        return line.updateHeaderTax();
    }

    @Override
    public boolean updateHeaderTax(MTaxProvider provider, MOrderLine line) {
        String sql = "UPDATE C_Order i SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM C_OrderLine il WHERE i.C_Order_ID=il.C_Order_ID) WHERE C_Order_ID=" + line.getC_Order_ID();
        int no = DB.executeUpdate(sql, line.get_TrxName());
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        if ((no = DB.executeUpdate(sql = line.isTaxIncluded() ? "UPDATE C_Order i  SET GrandTotal=TotalLines WHERE C_Order_ID=" + line.getC_Order_ID() : "UPDATE C_Order i  SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM C_OrderTax it WHERE i.C_Order_ID=it.C_Order_ID) WHERE C_Order_ID=" + line.getC_Order_ID(), line.get_TrxName())) != 1) {
            this.log.warning("(2) #" + no);
        }
        line.clearParent();
        return no == 1;
    }

    @Override
    public boolean calculateInvoiceTaxTotal(MTaxProvider provider, MInvoice invoice) {
        MInvoiceTax iTax;
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MInvoiceLine[] lines = invoice.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MTax tax;
            MInvoiceLine line = lines[i2];
            totalLines = totalLines.add(line.getLineNetAmt());
            if (!taxList.contains(line.getC_Tax_ID()) && (tax = new MTax(invoice.getCtx(), line.getC_Tax_ID(), invoice.get_TrxName())).getC_TaxProvider_ID() == 0 && (iTax = MInvoiceTax.get(line, invoice.getPrecision(), false, invoice.get_TrxName())) != null) {
                iTax.setIsTaxIncluded(invoice.isTaxIncluded());
                if (!iTax.calculateTaxFromLines()) {
                    return false;
                }
                iTax.saveEx();
                taxList.add(line.getC_Tax_ID());
            }
            ++i2;
        }
        BigDecimal grandTotal = totalLines;
        MInvoiceTax[] taxes = invoice.getTaxes(true);
        int i3 = 0;
        while (i3 < taxes.length) {
            iTax = taxes[i3];
            if (iTax.getC_TaxProvider_ID() != 0) {
                if (!invoice.isTaxIncluded()) {
                    grandTotal = grandTotal.add(iTax.getTaxAmt());
                }
            } else {
                MTax tax = iTax.getTax();
                if (tax.isSummary()) {
                    MTax[] cTaxes = tax.getChildTaxes(false);
                    int j = 0;
                    while (j < cTaxes.length) {
                        MTax cTax = cTaxes[j];
                        BigDecimal taxAmt = cTax.calculateTax(iTax.getTaxBaseAmt(), false, invoice.getPrecision());
                        MInvoiceTax newITax = new MInvoiceTax(invoice.getCtx(), 0, invoice.get_TrxName());
                        newITax.setClientOrg(invoice);
                        newITax.setAD_Org_ID(invoice.getAD_Org_ID());
                        newITax.setC_Invoice_ID(invoice.getC_Invoice_ID());
                        newITax.setC_Tax_ID(cTax.getC_Tax_ID());
                        newITax.setPrecision(invoice.getPrecision());
                        newITax.setIsTaxIncluded(invoice.isTaxIncluded());
                        newITax.setTaxBaseAmt(iTax.getTaxBaseAmt());
                        newITax.setTaxAmt(taxAmt);
                        newITax.saveEx(invoice.get_TrxName());
                        if (!invoice.isTaxIncluded()) {
                            grandTotal = grandTotal.add(taxAmt);
                        }
                        ++j;
                    }
                    iTax.deleteEx(true, invoice.get_TrxName());
                } else if (!invoice.isTaxIncluded()) {
                    grandTotal = grandTotal.add(iTax.getTaxAmt());
                }
            }
            ++i3;
        }
        invoice.setTotalLines(totalLines);
        invoice.setGrandTotal(grandTotal);
        return true;
    }

    @Override
    public boolean updateInvoiceTax(MTaxProvider provider, MInvoiceLine line) {
        MTax mtax = new MTax(line.getCtx(), line.getC_Tax_ID(), line.get_TrxName());
        if (mtax.getC_TaxProvider_ID() == 0) {
            return line.updateInvoiceTax(false);
        }
        return true;
    }

    @Override
    public boolean recalculateTax(MTaxProvider provider, MInvoiceLine line, boolean newRecord) {
        MTax mtax;
        if (!newRecord && line.is_ValueChanged("C_Tax_ID") && (mtax = new MTax(line.getCtx(), line.getC_Tax_ID(), line.get_TrxName())).getC_TaxProvider_ID() == 0 && !line.updateInvoiceTax(true)) {
            return false;
        }
        return line.updateHeaderTax();
    }

    @Override
    public boolean updateHeaderTax(MTaxProvider provider, MInvoiceLine line) {
        String sql = "UPDATE C_Invoice i SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_Invoice_ID=?";
        int no = DB.executeUpdateEx(sql, new Object[]{line.getC_Invoice_ID()}, line.get_TrxName());
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        if ((no = DB.executeUpdateEx(sql = line.isTaxIncluded() ? "UPDATE C_Invoice i  SET GrandTotal=TotalLines WHERE C_Invoice_ID=?" : "UPDATE C_Invoice i  SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM C_InvoiceTax it WHERE i.C_Invoice_ID=it.C_Invoice_ID) WHERE C_Invoice_ID=?", new Object[]{line.getC_Invoice_ID()}, line.get_TrxName())) != 1) {
            this.log.warning("(2) #" + no);
        }
        line.clearParent();
        return no == 1;
    }

    @Override
    public boolean calculateRMATaxTotal(MTaxProvider provider, MRMA rma) {
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MRMALine[] lines = rma.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MTax tax;
            MRMALine line = lines[i2];
            totalLines = totalLines.add(line.getLineNetAmt());
            Integer taxID = line.getC_Tax_ID();
            if (!taxList.contains(taxID) && (tax = new MTax(rma.getCtx(), taxID, rma.get_TrxName())).getC_TaxProvider_ID() == 0) {
                MRMATax oTax = MRMATax.get(line, rma.getPrecision(), false, rma.get_TrxName());
                oTax.setIsTaxIncluded(rma.isTaxIncluded());
                if (!oTax.calculateTaxFromLines()) {
                    return false;
                }
                if (!oTax.save(rma.get_TrxName())) {
                    return false;
                }
                taxList.add(taxID);
            }
            ++i2;
        }
        BigDecimal grandTotal = totalLines;
        MRMATax[] taxes = rma.getTaxes(true);
        int i3 = 0;
        while (i3 < taxes.length) {
            MRMATax oTax = taxes[i3];
            if (oTax.getC_TaxProvider_ID() != 0) {
                if (!rma.isTaxIncluded()) {
                    grandTotal = grandTotal.add(oTax.getTaxAmt());
                }
            } else {
                MTax tax = oTax.getTax();
                if (tax.isSummary()) {
                    MTax[] cTaxes = tax.getChildTaxes(false);
                    int j = 0;
                    while (j < cTaxes.length) {
                        MTax cTax = cTaxes[j];
                        BigDecimal taxAmt = cTax.calculateTax(oTax.getTaxBaseAmt(), false, rma.getPrecision());
                        MRMATax newOTax = new MRMATax(rma.getCtx(), 0, rma.get_TrxName());
                        newOTax.setClientOrg(rma);
                        newOTax.setM_RMA_ID(rma.getM_RMA_ID());
                        newOTax.setC_Tax_ID(cTax.getC_Tax_ID());
                        newOTax.setPrecision(rma.getPrecision());
                        newOTax.setIsTaxIncluded(rma.isTaxIncluded());
                        newOTax.setTaxBaseAmt(oTax.getTaxBaseAmt());
                        newOTax.setTaxAmt(taxAmt);
                        if (!newOTax.save(rma.get_TrxName())) {
                            return false;
                        }
                        if (!rma.isTaxIncluded()) {
                            grandTotal = grandTotal.add(taxAmt);
                        }
                        ++j;
                    }
                    if (!oTax.delete(true, rma.get_TrxName())) {
                        return false;
                    }
                } else if (!rma.isTaxIncluded()) {
                    grandTotal = grandTotal.add(oTax.getTaxAmt());
                }
            }
            ++i3;
        }
        rma.setAmt(grandTotal);
        return true;
    }

    @Override
    public boolean updateRMATax(MTaxProvider provider, MRMALine line) {
        MTax mtax = new MTax(line.getCtx(), line.getC_Tax_ID(), line.get_TrxName());
        if (mtax.getC_TaxProvider_ID() == 0) {
            return line.updateOrderTax(false);
        }
        return true;
    }

    @Override
    public boolean recalculateTax(MTaxProvider provider, MRMALine line, boolean newRecord) {
        MTax mtax;
        if (!newRecord && line.is_ValueChanged("C_Tax_ID") && !line.getParent().isProcessed() && (mtax = new MTax(line.getCtx(), line.getC_Tax_ID(), line.get_TrxName())).getC_TaxProvider_ID() == 0 && !line.updateOrderTax(true)) {
            return false;
        }
        return line.updateHeaderAmt();
    }

    @Override
    public boolean updateHeaderTax(MTaxProvider provider, MRMALine line) {
        String sql = "UPDATE M_RMA  SET Amt=(SELECT COALESCE(SUM(LineNetAmt),0) FROM M_RMALine WHERE M_RMA.M_RMA_ID=M_RMALine.M_RMA_ID) WHERE M_RMA_ID=?";
        int no = DB.executeUpdateEx(sql, new Object[]{line.getM_RMA_ID()}, line.get_TrxName());
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        line.clearParent();
        return no == 1;
    }

    @Override
    public String validateConnection(MTaxProvider provider, ProcessInfo pi) throws Exception {
        throw new IllegalStateException(Msg.getMsg(provider.getCtx(), "ActionNotSupported"));
    }
}

