/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.model.X_AD_User_Roles;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MUserRoles
extends X_AD_User_Roles {
    private static final long serialVersionUID = 5850010835736994376L;
    private static CLogger s_log = CLogger.getCLogger(MUserRoles.class);

    public static MUserRoles[] getOfRole(Properties ctx, int AD_Role_ID) {
        String whereClause = "AD_Role_ID=?";
        List<MUserRoles> list = new Query(ctx, "AD_User_Roles", "AD_Role_ID=?", null).setParameters(AD_Role_ID).list();
        MUserRoles[] retValue = new MUserRoles[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MUserRoles[] getOfUser(Properties ctx, int AD_User_ID) {
        String whereClause = "AD_User_ID=? AND AD_Client_ID IN (0, ?)";
        List<MUserRoles> list = new Query(ctx, "AD_User_Roles", "AD_User_ID=? AND AD_Client_ID IN (0, ?)", null).setParameters(AD_User_ID, Env.getAD_Client_ID(ctx)).list();
        MUserRoles[] retValue = new MUserRoles[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MUserRoles(Properties ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MUserRoles(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MUserRoles(Properties ctx, int AD_User_ID, int AD_Role_ID, String trxName) {
        this(ctx, 0, trxName);
        this.setAD_User_ID(AD_User_ID);
        this.setAD_Role_ID(AD_Role_ID);
    }

    @Override
    public void setAD_User_ID(int AD_User_ID) {
        if (AD_User_ID == 0) {
            this.set_ValueNoCheck("AD_User_ID", AD_User_ID);
        } else {
            super.setAD_User_ID(AD_User_ID);
        }
    }

    @Override
    public void setAD_Role_ID(int AD_Role_ID) {
        this.set_ValueNoCheck("AD_Role_ID", AD_Role_ID);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!MRole.getDefault().isAccessAdvanced()) {
            MRole oldrole;
            MRole role = new MRole(this.getCtx(), this.getAD_Role_ID(), this.get_TrxName());
            if (role.isAccessAdvanced()) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "ActionNotAllowedHere"));
                return false;
            }
            if (!newRecord && this.is_ValueChanged("AD_Role_ID") && (oldrole = new MRole(this.getCtx(), this.get_ValueOldAsInt("AD_Role_ID"), this.get_TrxName())).isAccessAdvanced()) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "ActionNotAllowedHere"));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        MRole role;
        if (!MRole.getDefault().isAccessAdvanced() && (role = new MRole(this.getCtx(), this.getAD_Role_ID(), this.get_TrxName())).isAccessAdvanced()) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "ActionNotAllowedHere"));
            return false;
        }
        return true;
    }
}

