/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.Query;
import org.compiere.model.X_AD_UserQuery;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MUserQuery
extends X_AD_UserQuery {
    private static final long serialVersionUID = 488522350853249825L;
    private static CLogger s_log = CLogger.getCLogger(MUserQuery.class);

    public static MUserQuery[] get(Properties ctx, int AD_Tab_ID) {
        ArrayList<MUserQuery> list = MUserQuery.getUserOnlyQueries(ctx, AD_Tab_ID);
        list.addAll(MUserQuery.getAllUsersQueries(ctx, AD_Tab_ID));
        list.addAll(MUserQuery.getClientQueries(ctx, AD_Tab_ID));
        list.addAll(MUserQuery.getRoleQueries(ctx, AD_Tab_ID));
        Collections.sort(list, new Comparator<MUserQuery>(){

            @Override
            public int compare(MUserQuery uq1, MUserQuery uq2) {
                return uq1.getName().compareTo(uq2.getName());
            }
        });
        MUserQuery[] retValue = new MUserQuery[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static ArrayList<MUserQuery> getUserOnlyQueries(Properties ctx, int AD_Tab_ID) {
        ArrayList<MUserQuery> list;
        block6: {
            int AD_User_ID = Env.getAD_User_ID(ctx);
            String sql = "SELECT * FROM AD_UserQuery WHERE AD_Client_ID=? AND AD_Tab_ID=? AND IsActive='Y' AND AD_User_ID in (0, ?) ORDER BY Name";
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            list = new ArrayList<MUserQuery>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setInt(2, AD_Tab_ID);
                    pstmt.setInt(3, AD_User_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MUserQuery(ctx, rs, null));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    public static ArrayList<MUserQuery> getAllUsersQueries(Properties ctx, int AD_Tab_ID) {
        ArrayList<MUserQuery> list;
        block6: {
            String sql = "SELECT * FROM AD_UserQuery WHERE AD_Client_ID=0 AND AD_Tab_ID=? AND IsActive='Y' AND AD_User_ID IS NULL AND AD_Role_ID IS NULL ORDER BY Name";
            list = new ArrayList<MUserQuery>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Tab_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MUserQuery(ctx, rs, null));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    public static ArrayList<MUserQuery> getClientQueries(Properties ctx, int AD_Tab_ID) {
        ArrayList<MUserQuery> list;
        block6: {
            String sql = "SELECT * FROM AD_UserQuery WHERE AD_Client_ID=? AND AD_Tab_ID=? AND IsActive='Y' AND AD_User_ID IS NULL AND AD_Role_ID IS NULL ORDER BY Name";
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            list = new ArrayList<MUserQuery>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setInt(2, AD_Tab_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MUserQuery(ctx, rs, null));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    public static ArrayList<MUserQuery> getRoleQueries(Properties ctx, int AD_Tab_ID) {
        ArrayList<MUserQuery> list;
        block6: {
            String sql = "SELECT * FROM AD_UserQuery WHERE AD_Client_ID IN (0,?) AND AD_Tab_ID=? AND IsActive='Y' AND AD_User_ID IS NULL AND (AD_Role_ID = ? OR AD_Role_ID IN (SELECT Included_Role_ID FROM   AD_Role_Included WHERE  AD_Role_id = ? AND IsActive = 'Y')) ORDER BY Name";
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            int AD_Role_ID = Env.getAD_Role_ID(ctx);
            list = new ArrayList<MUserQuery>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setInt(2, AD_Tab_ID);
                    pstmt.setInt(3, AD_Role_ID);
                    pstmt.setInt(4, AD_Role_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MUserQuery(ctx, rs, null));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    public static MUserQuery get(Properties ctx, int AD_Tab_ID, String name) {
        MUserQuery retValue;
        block7: {
            int AD_User_ID = Env.getAD_User_ID(ctx);
            String sql = "SELECT * FROM AD_UserQuery WHERE AD_Client_ID=? AND AD_Tab_ID=? AND UPPER(Name) LIKE ? AND IsActive='Y' AND AD_User_ID in (0, " + AD_User_ID + ") " + "ORDER BY Name";
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            if (name == null) {
                name = "%";
            }
            retValue = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setInt(2, AD_Tab_ID);
                    pstmt.setString(3, name.toUpperCase());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MUserQuery(ctx, rs, null);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public static MUserQuery getUserQueryByName(Properties ctx, int AD_Tab_ID, String name) {
        String sqlWhere = " AD_Client_ID=? AND AD_Tab_ID=? AND UPPER(Name) LIKE ? AND (AD_User_ID = ? OR AD_User_ID IS NULL) ";
        return (MUserQuery)new Query(ctx, "AD_UserQuery", sqlWhere, null).setParameters(Env.getAD_Client_ID(ctx), AD_Tab_ID, name.toUpperCase(), Env.getAD_User_ID(ctx)).setOnlyActiveRecords(true).setOrderBy("Name").first();
    }

    public MUserQuery(Properties ctx, int AD_UserQuery_ID, String trxName) {
        super(ctx, AD_UserQuery_ID, trxName);
    }

    public MUserQuery(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Tab_ID() > 0) {
            if (newRecord || this.is_ValueChanged("AD_Tab_ID")) {
                MTab tab = new MTab(this.getCtx(), this.getAD_Tab_ID(), this.get_TrxName());
                this.setAD_Window_ID(tab.getAD_Window_ID());
                this.setAD_Table_ID(tab.getAD_Table_ID());
            }
        } else {
            this.setAD_Window_ID(0);
        }
        return true;
    }

    public boolean userCanSave() {
        return this.getAD_Client_ID() == Env.getAD_Client_ID(Env.getCtx()) && this.getAD_User_ID() == Env.getAD_User_ID(Env.getCtx()) && this.get_Value("AD_User_ID") != null;
    }

    public boolean userCanShare() {
        return "C".equals(MRole.getDefault().getPreferenceType()) && this.getAD_Client_ID() == Env.getAD_Client_ID(Env.getCtx());
    }

    @Override
    public void setAD_User_ID(int AD_User_ID) {
        if (AD_User_ID == 0) {
            this.set_ValueNoCheck("AD_User_ID", AD_User_ID);
        } else {
            super.setAD_User_ID(AD_User_ID);
        }
    }
}

