/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.model.X_AD_UserDef_Win;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MUserDefWin
extends X_AD_UserDef_Win
implements ImmutablePOSupport {
    private static final long serialVersionUID = -7542708120229671875L;
    private static final Map<Integer, List<MUserDefWin>> m_fullMap = new HashMap<Integer, List<MUserDefWin>>();
    private static ImmutablePOCache<String, MUserDefWin> s_cache = new ImmutablePOCache("AD_UserDef_Win", 3);

    public MUserDefWin(Properties ctx, int ID, String trxName) {
        super(ctx, ID, trxName);
    }

    public MUserDefWin(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MUserDefWin(MUserDefWin copy) {
        this(Env.getCtx(), copy);
    }

    public MUserDefWin(Properties ctx, MUserDefWin copy) {
        this(ctx, copy, null);
    }

    public MUserDefWin(Properties ctx, MUserDefWin copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MUserDefWin[] getAll(Properties ctx, int window_ID) {
        List<MUserDefWin> fullList = null;
        Map<Integer, List<MUserDefWin>> map = m_fullMap;
        synchronized (map) {
            fullList = m_fullMap.get(Env.getAD_Client_ID(ctx));
            if (fullList == null) {
                fullList = new Query(ctx, "AD_UserDef_Win", null, null).setOnlyActiveRecords(true).setClient_ID().list();
                m_fullMap.put(Env.getAD_Client_ID(ctx), fullList);
            }
        }
        if (fullList.size() == 0) {
            return null;
        }
        ArrayList<MUserDefWin> list = new ArrayList<MUserDefWin>();
        for (MUserDefWin udw : fullList) {
            if (udw.getAD_Window_ID() != window_ID || udw.getAD_Client_ID() != Env.getAD_Client_ID(ctx) || udw.getAD_Language() != null && !udw.getAD_Language().equals(Env.getAD_Language(ctx))) continue;
            list.add(udw);
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new MUserDefWin[list.size()]);
    }

    public static MUserDefWin getBestMatch(Properties ctx, int window_ID) {
        int AD_Org_ID = Env.getAD_Org_ID(ctx);
        int AD_Role_ID = Env.getAD_Role_ID(ctx);
        int AD_User_ID = Env.getAD_User_ID(ctx);
        String key = window_ID + "_" + Env.getAD_Client_ID(ctx) + "_" + Env.getAD_Language(ctx) + "_" + AD_Org_ID + "_" + AD_Role_ID + "_" + AD_User_ID;
        if (s_cache.containsKey(key)) {
            return s_cache.get(ctx, key, e -> new MUserDefWin(ctx, (MUserDefWin)e));
        }
        MUserDefWin[] candidates = MUserDefWin.getAll(ctx, window_ID);
        if (candidates == null) {
            s_cache.put(key, null);
            return null;
        }
        int size = candidates.length;
        int[] weight = new int[size];
        int i2 = 0;
        while (i2 < size) {
            weight[i2] = 0;
            if (candidates[i2].getAD_User_ID() > 0) {
                weight[i2] = candidates[i2].getAD_User_ID() == AD_User_ID ? weight[i2] + 4 : -1;
            }
            if (weight[i2] > -1 && candidates[i2].getAD_Role_ID() > 0) {
                weight[i2] = candidates[i2].getAD_Role_ID() == AD_Role_ID ? weight[i2] + 2 : -1;
            }
            if (weight[i2] > -1 && candidates[i2].getAD_Org_ID() > 0) {
                weight[i2] = candidates[i2].getAD_Org_ID() == AD_Org_ID ? weight[i2] + 1 : -1;
            }
            if (weight[i2] > -1 && Env.getAD_Language(ctx).equalsIgnoreCase(candidates[i2].getAD_Language())) {
                weight[i2] = weight[i2] + 8;
            }
            ++i2;
        }
        int maximum = weight[0];
        int maxindex = 0;
        int j = 0;
        while (j < weight.length) {
            if (weight[j] > maximum) {
                maximum = weight[j];
                maxindex = j;
            }
            ++j;
        }
        if (weight[maxindex] > -1) {
            MUserDefWin retValue = null;
            retValue = candidates[maxindex];
            s_cache.put(key, retValue, e -> new MUserDefWin(Env.getCtx(), (MUserDefWin)e));
            return retValue;
        }
        s_cache.put(key, null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean beforeSave(boolean newRecord) {
        Map<Integer, List<MUserDefWin>> map = m_fullMap;
        synchronized (map) {
            m_fullMap.remove(this.getAD_Client_ID());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean beforeDelete() {
        Map<Integer, List<MUserDefWin>> map = m_fullMap;
        synchronized (map) {
            m_fullMap.remove(this.getAD_Client_ID());
        }
        return true;
    }

    @Override
    public MUserDefWin markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

