/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Point;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MProduct;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOM;
import org.compiere.model.Query;
import org.compiere.model.X_C_UOM_Conversion;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.idempiere.cache.ImmutablePOSupport;

public class MUOMConversion
extends X_C_UOM_Conversion
implements ImmutablePOSupport {
    private static final long serialVersionUID = 1772365359514185604L;
    private static final CLogger s_log = CLogger.getCLogger(MUOMConversion.class);
    protected static final BigDecimal GETRATE = BigDecimal.valueOf(123.456);
    protected static CCache<Point, BigDecimal> s_conversions = null;
    protected static final CCache<Integer, MUOMConversion[]> s_conversionProduct = new CCache("C_UOM_Conversion", "C_UOM_Conversion_Of_Product", 20);

    public static BigDecimal convert(Properties ctx, int C_UOM_ID, int C_UOM_To_ID, BigDecimal qty) {
        if (qty == null || qty.compareTo(Env.ZERO) == 0 || C_UOM_ID == C_UOM_To_ID) {
            return qty;
        }
        BigDecimal retValue = MUOMConversion.getRate(ctx, C_UOM_ID, C_UOM_To_ID);
        if (retValue != null) {
            MUOM uom = MUOM.get(ctx, C_UOM_To_ID);
            if (uom != null) {
                return uom.round(retValue.multiply(qty), true);
            }
            return retValue.multiply(qty);
        }
        return null;
    }

    public static BigDecimal getRate(Properties ctx, int C_UOM_ID, int C_UOM_To_ID) {
        if (C_UOM_ID == C_UOM_To_ID) {
            return Env.ONE;
        }
        Point p2 = new Point(C_UOM_ID, C_UOM_To_ID);
        BigDecimal retValue = MUOMConversion.getRate(ctx, p2);
        return retValue;
    }

    public static int convertToMinutes(Properties ctx, int C_UOM_ID, BigDecimal qty) {
        if (qty == null) {
            return 0;
        }
        int C_UOM_To_ID = MUOM.getMinute_UOM_ID(ctx);
        if (C_UOM_ID == C_UOM_To_ID) {
            return qty.intValue();
        }
        BigDecimal result = MUOMConversion.convert(ctx, C_UOM_ID, C_UOM_To_ID, qty);
        if (result == null) {
            return 0;
        }
        return result.intValue();
    }

    public static Timestamp getEndDate(Properties ctx, Timestamp startDate, int C_UOM_ID, BigDecimal qty) {
        GregorianCalendar endDate = new GregorianCalendar();
        endDate.setTime(startDate);
        int minutes = MUOMConversion.convertToMinutes(ctx, C_UOM_ID, qty);
        endDate.add(12, minutes);
        Timestamp retValue = new Timestamp(endDate.getTimeInMillis());
        return retValue;
    }

    protected static BigDecimal getRate(Properties ctx, Point p2) {
        BigDecimal retValue = null;
        if (Ini.isClient()) {
            if (s_conversions == null) {
                MUOMConversion.createRates(ctx);
            }
            retValue = s_conversions.get(p2);
        } else {
            retValue = MUOMConversion.getRate(p2.x, p2.y);
        }
        if (retValue != null) {
            return retValue;
        }
        return MUOMConversion.deriveRate(ctx, p2.x, p2.y);
    }

    protected static void createRates(Properties ctx) {
        block8: {
            s_conversions = new CCache("C_UOM_Conversion", 20);
            String sql = MRole.getDefault(ctx, false).addAccessSQL("SELECT C_UOM_ID, C_UOM_To_ID, MultiplyRate, DivideRate FROM C_UOM_Conversion WHERE IsActive='Y' AND M_Product_ID IS NULL", "C_UOM_Conversion", false, false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Point p2 = new Point(rs.getInt(1), rs.getInt(2));
                        BigDecimal mr = rs.getBigDecimal(3);
                        BigDecimal dr = rs.getBigDecimal(4);
                        if (mr != null) {
                            s_conversions.put(p2, mr);
                        }
                        if (dr == null && mr != null) {
                            dr = Env.ONE.divide(mr, RoundingMode.HALF_UP);
                        }
                        if (dr == null) continue;
                        s_conversions.put(new Point(p2.y, p2.x), dr);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public static BigDecimal deriveRate(Properties ctx, int C_UOM_ID, int C_UOM_To_ID) {
        if (C_UOM_ID == C_UOM_To_ID) {
            return Env.ONE;
        }
        MUOM from = MUOM.get(ctx, C_UOM_ID);
        MUOM to = MUOM.get(ctx, C_UOM_To_ID);
        if (from == null || to == null) {
            return null;
        }
        if (from.isMinute()) {
            if (to.isHour()) {
                return BigDecimal.valueOf(0.016666666666666666);
            }
            if (to.isDay()) {
                return BigDecimal.valueOf(6.944444444444445E-4);
            }
            if (to.isWorkDay()) {
                return BigDecimal.valueOf(0.0020833333333333333);
            }
            if (to.isWeek()) {
                return BigDecimal.valueOf(9.92063492063492E-5);
            }
            if (to.isMonth()) {
                return BigDecimal.valueOf(2.3148148148148147E-5);
            }
            if (to.isWorkMonth()) {
                return BigDecimal.valueOf(1.0416666666666667E-4);
            }
            if (to.isYear()) {
                return BigDecimal.valueOf(1.902587519025875E-6);
            }
        }
        if (from.isHour()) {
            if (to.isMinute()) {
                return BigDecimal.valueOf(60.0);
            }
            if (to.isDay()) {
                return BigDecimal.valueOf(0.041666666666666664);
            }
            if (to.isWorkDay()) {
                return BigDecimal.valueOf(0.125);
            }
            if (to.isWeek()) {
                return BigDecimal.valueOf(0.005952380952380952);
            }
            if (to.isMonth()) {
                return BigDecimal.valueOf(0.001388888888888889);
            }
            if (to.isWorkMonth()) {
                return BigDecimal.valueOf(0.00625);
            }
            if (to.isYear()) {
                return BigDecimal.valueOf(1.1415525114155251E-4);
            }
        }
        if (from.isDay()) {
            if (to.isMinute()) {
                return BigDecimal.valueOf(1440.0);
            }
            if (to.isHour()) {
                return BigDecimal.valueOf(24.0);
            }
            if (to.isWorkDay()) {
                return BigDecimal.valueOf(3.0);
            }
            if (to.isWeek()) {
                return BigDecimal.valueOf(0.14285714285714285);
            }
            if (to.isMonth()) {
                return BigDecimal.valueOf(0.03333333333333333);
            }
            if (to.isWorkMonth()) {
                return BigDecimal.valueOf(0.05);
            }
            if (to.isYear()) {
                return BigDecimal.valueOf(0.0027397260273972603);
            }
        }
        if (from.isWorkDay()) {
            if (to.isMinute()) {
                return BigDecimal.valueOf(480.0);
            }
            if (to.isHour()) {
                return BigDecimal.valueOf(8.0);
            }
            if (to.isDay()) {
                return BigDecimal.valueOf(0.3333333333333333);
            }
            if (to.isWeek()) {
                return BigDecimal.valueOf(0.2);
            }
            if (to.isMonth()) {
                return BigDecimal.valueOf(0.05);
            }
            if (to.isWorkMonth()) {
                return BigDecimal.valueOf(0.05);
            }
            if (to.isYear()) {
                return BigDecimal.valueOf(0.004166666666666667);
            }
        }
        if (from.isWeek()) {
            if (to.isMinute()) {
                return BigDecimal.valueOf(10080.0);
            }
            if (to.isHour()) {
                return BigDecimal.valueOf(168.0);
            }
            if (to.isDay()) {
                return BigDecimal.valueOf(7.0);
            }
            if (to.isWorkDay()) {
                return BigDecimal.valueOf(5.0);
            }
            if (to.isMonth()) {
                return BigDecimal.valueOf(0.25);
            }
            if (to.isWorkMonth()) {
                return BigDecimal.valueOf(0.25);
            }
            if (to.isYear()) {
                return BigDecimal.valueOf(0.02);
            }
        }
        if (from.isMonth()) {
            if (to.isMinute()) {
                return BigDecimal.valueOf(43200.0);
            }
            if (to.isHour()) {
                return BigDecimal.valueOf(720.0);
            }
            if (to.isDay()) {
                return BigDecimal.valueOf(30.0);
            }
            if (to.isWorkDay()) {
                return BigDecimal.valueOf(20.0);
            }
            if (to.isWeek()) {
                return BigDecimal.valueOf(4.0);
            }
            if (to.isWorkMonth()) {
                return BigDecimal.valueOf(1.5);
            }
            if (to.isYear()) {
                return BigDecimal.valueOf(0.08333333333333333);
            }
        }
        if (from.isWorkMonth()) {
            if (to.isMinute()) {
                return BigDecimal.valueOf(9600.0);
            }
            if (to.isHour()) {
                return BigDecimal.valueOf(160.0);
            }
            if (to.isDay()) {
                return BigDecimal.valueOf(20.0);
            }
            if (to.isWorkDay()) {
                return BigDecimal.valueOf(20.0);
            }
            if (to.isWeek()) {
                return BigDecimal.valueOf(4.0);
            }
            if (to.isMonth()) {
                return BigDecimal.valueOf(0.6666666666666666);
            }
            if (to.isYear()) {
                return BigDecimal.valueOf(0.08333333333333333);
            }
        }
        if (from.isYear()) {
            if (to.isMinute()) {
                return BigDecimal.valueOf(518400.0);
            }
            if (to.isHour()) {
                return BigDecimal.valueOf(8640.0);
            }
            if (to.isDay()) {
                return BigDecimal.valueOf(365.0);
            }
            if (to.isWorkDay()) {
                return BigDecimal.valueOf(240.0);
            }
            if (to.isWeek()) {
                return BigDecimal.valueOf(50.0);
            }
            if (to.isMonth()) {
                return BigDecimal.valueOf(12.0);
            }
            if (to.isWorkMonth()) {
                return BigDecimal.valueOf(12.0);
            }
        }
        return null;
    }

    public static BigDecimal getRate(int C_UOM_ID, int C_UOM_To_ID) {
        return MUOMConversion.convert(C_UOM_ID, C_UOM_To_ID, GETRATE, false);
    }

    public static BigDecimal convert(int C_UOM_From_ID, int C_UOM_To_ID, BigDecimal qty, boolean StdPrecision) {
        if (qty == null || qty.compareTo(Env.ZERO) == 0 || C_UOM_From_ID == C_UOM_To_ID) {
            return qty;
        }
        BigDecimal retValue = null;
        int precision = 2;
        String sql = "SELECT c.MultiplyRate, uomTo.StdPrecision, uomTo.CostingPrecision FROM\tC_UOM_Conversion c INNER JOIN C_UOM uomTo ON (c.C_UOM_TO_ID=uomTo.C_UOM_ID) WHERE c.IsActive='Y' AND c.C_UOM_ID=? AND c.C_UOM_TO_ID=?  AND c.M_Product_ID IS NULL ORDER BY c.AD_Client_ID DESC, c.AD_Org_ID DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_UOM_From_ID);
                pstmt.setInt(2, C_UOM_To_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getBigDecimal(1);
                    precision = rs.getInt(StdPrecision ? 2 : 3);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (retValue == null) {
            if (s_log.isLoggable(Level.INFO)) {
                s_log.info("NOT found - FromUOM=" + C_UOM_From_ID + ", ToUOM=" + C_UOM_To_ID);
            }
            return null;
        }
        if (GETRATE.equals(qty)) {
            return retValue;
        }
        if ((retValue = retValue.multiply(qty)).scale() > precision) {
            retValue = retValue.setScale(precision, RoundingMode.HALF_UP);
        }
        return retValue;
    }

    public static BigDecimal convertProductTo(Properties ctx, int M_Product_ID, int C_UOM_To_ID, BigDecimal qtyPrice) {
        return MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, qtyPrice, -1);
    }

    public static BigDecimal convertProductTo(Properties ctx, int M_Product_ID, int C_UOM_To_ID, BigDecimal qtyPrice, int precision) {
        if (qtyPrice == null || qtyPrice.signum() == 0 || M_Product_ID == 0 || C_UOM_To_ID == 0) {
            return qtyPrice;
        }
        BigDecimal retValue = MUOMConversion.getProductRateTo(ctx, M_Product_ID, C_UOM_To_ID);
        if (retValue != null) {
            if (Env.ONE.compareTo(retValue) == 0) {
                return qtyPrice;
            }
            if (precision >= 0) {
                return retValue.multiply(qtyPrice).setScale(precision, RoundingMode.HALF_UP);
            }
            MUOM uom = MUOM.get(ctx, C_UOM_To_ID);
            if (uom != null) {
                return uom.round(retValue.multiply(qtyPrice), true);
            }
            return retValue.multiply(qtyPrice);
        }
        return null;
    }

    public static BigDecimal getProductRateTo(Properties ctx, int M_Product_ID, int C_UOM_To_ID) {
        if (M_Product_ID == 0) {
            return null;
        }
        MUOMConversion[] rates = MUOMConversion.getProductConversions(ctx, M_Product_ID);
        int i2 = 0;
        while (i2 < rates.length) {
            MUOMConversion rate = rates[i2];
            if (rate.getC_UOM_To_ID() == C_UOM_To_ID) {
                return rate.getMultiplyRate();
            }
            ++i2;
        }
        List conversions = new Query(ctx, "C_UOM_Conversion", "C_UOM_ID=? AND C_UOM_TO_ID=? AND M_Product_ID IS NULL AND AD_Client_ID IN (0, ?)", null).setParameters(MProduct.get(ctx, M_Product_ID).getC_UOM_ID(), C_UOM_To_ID, Env.getAD_Client_ID(ctx)).setOrderBy("AD_Client_ID Desc").setOnlyActiveRecords(true).list();
        int i3 = 0;
        while (i3 < conversions.size()) {
            MUOMConversion rate = (MUOMConversion)conversions.get(i3);
            if (rate.getC_UOM_To_ID() == C_UOM_To_ID) {
                return rate.getMultiplyRate();
            }
            ++i3;
        }
        return null;
    }

    public static BigDecimal convertProductFrom(Properties ctx, int M_Product_ID, int C_UOM_To_ID, BigDecimal qtyPrice) {
        return MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, qtyPrice, -1);
    }

    public static BigDecimal convertProductFrom(Properties ctx, int M_Product_ID, int C_UOM_To_ID, BigDecimal qtyPrice, int precision) {
        if (qtyPrice == null || qtyPrice.compareTo(Env.ZERO) == 0 || C_UOM_To_ID == 0 || M_Product_ID == 0) {
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("No Conversion - QtyPrice=" + qtyPrice);
            }
            return qtyPrice;
        }
        BigDecimal retValue = MUOMConversion.getProductRateFrom(ctx, M_Product_ID, C_UOM_To_ID);
        if (retValue != null) {
            if (Env.ONE.compareTo(retValue) == 0) {
                return qtyPrice;
            }
            if (precision >= 0) {
                return retValue.multiply(qtyPrice).setScale(precision, RoundingMode.HALF_UP);
            }
            MUOM uom = MUOM.get(ctx, C_UOM_To_ID);
            if (uom != null) {
                return uom.round(retValue.multiply(qtyPrice), true);
            }
            return retValue.multiply(qtyPrice);
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("No Rate M_Product_ID=" + M_Product_ID);
        }
        return null;
    }

    public static BigDecimal getProductRateFrom(Properties ctx, int M_Product_ID, int C_UOM_To_ID) {
        if (M_Product_ID == 0) {
            return null;
        }
        MUOMConversion[] rates = MUOMConversion.getProductConversions(ctx, M_Product_ID);
        int i2 = 0;
        while (i2 < rates.length) {
            MUOMConversion rate = rates[i2];
            if (rate.getC_UOM_To_ID() == C_UOM_To_ID) {
                return rate.getDivideRate();
            }
            ++i2;
        }
        List conversions = new Query(ctx, "C_UOM_Conversion", "C_UOM_ID=? AND C_UOM_TO_ID=? AND M_Product_ID IS NULL AND AD_Client_ID IN (0, ?)", null).setParameters(MProduct.get(ctx, M_Product_ID).getC_UOM_ID(), C_UOM_To_ID, Env.getAD_Client_ID(ctx)).setOrderBy("AD_Client_ID Desc").setOnlyActiveRecords(true).list();
        int i3 = 0;
        while (i3 < conversions.size()) {
            MUOMConversion rate = (MUOMConversion)conversions.get(i3);
            if (rate.getC_UOM_To_ID() == C_UOM_To_ID) {
                return rate.getDivideRate();
            }
            ++i3;
        }
        return null;
    }

    public static MUOMConversion[] getProductConversions(Properties ctx, int M_Product_ID) {
        if (M_Product_ID == 0) {
            return new MUOMConversion[0];
        }
        Integer key = M_Product_ID;
        MUOMConversion[] result = s_conversionProduct.get(key);
        if (result != null) {
            if (ctx == Env.getCtx()) {
                return result;
            }
            return (MUOMConversion[])Arrays.stream(result).map(e -> new MUOMConversion(ctx, (MUOMConversion)e).markImmutable()).toArray(MUOMConversion[]::new);
        }
        ArrayList<MUOMConversion> list = new ArrayList<MUOMConversion>();
        MUOMConversion defRate = new MUOMConversion(MProduct.get(ctx, M_Product_ID));
        list.add(defRate);
        String whereClause = "M_Product_ID=? AND EXISTS (SELECT 1 FROM M_Product p WHERE C_UOM_Conversion.M_Product_ID=p.M_Product_ID AND C_UOM_Conversion.C_UOM_ID=p.C_UOM_ID)";
        List conversions = new Query(ctx, "C_UOM_Conversion", "M_Product_ID=? AND EXISTS (SELECT 1 FROM M_Product p WHERE C_UOM_Conversion.M_Product_ID=p.M_Product_ID AND C_UOM_Conversion.C_UOM_ID=p.C_UOM_ID)", null).setParameters(M_Product_ID).setOnlyActiveRecords(true).list();
        list.addAll(conversions);
        list.stream().forEach(e -> {
            MUOMConversion mUOMConversion = e.markImmutable();
        });
        result = new MUOMConversion[list.size()];
        list.toArray(result);
        if (ctx == Env.getCtx()) {
            s_conversionProduct.put(key, result);
        } else {
            s_conversionProduct.put(key, (MUOMConversion[])Arrays.stream(result).map(e -> new MUOMConversion(Env.getCtx(), (MUOMConversion)e)).toArray(MUOMConversion[]::new));
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("getProductConversions - M_Product_ID=" + M_Product_ID + " #" + result.length);
        }
        return result;
    }

    public MUOMConversion(Properties ctx, int C_UOM_Conversion_ID, String trxName) {
        super(ctx, C_UOM_Conversion_ID, trxName);
    }

    public MUOMConversion(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MUOMConversion(MUOM parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setC_UOM_ID(parent.getC_UOM_ID());
        this.setM_Product_ID(0);
        this.setC_UOM_To_ID(parent.getC_UOM_ID());
        this.setMultiplyRate(Env.ONE);
        this.setDivideRate(Env.ONE);
    }

    public MUOMConversion(MProduct parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setC_UOM_ID(parent.getC_UOM_ID());
        this.setM_Product_ID(parent.getM_Product_ID());
        this.setC_UOM_To_ID(parent.getC_UOM_ID());
        this.setMultiplyRate(Env.ONE);
        this.setDivideRate(Env.ONE);
    }

    public MUOMConversion(MUOMConversion copy) {
        this(Env.getCtx(), copy);
    }

    public MUOMConversion(Properties ctx, MUOMConversion copy) {
        this(ctx, copy, null);
    }

    public MUOMConversion(Properties ctx, MUOMConversion copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MProduct product;
        if (this.getC_UOM_ID() == this.getC_UOM_To_ID()) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@C_UOM_ID@ = @C_UOM_To_ID@"));
            return false;
        }
        if (this.getMultiplyRate() != null && this.getMultiplyRate().signum() != 0) {
            if (this.getDivideRate() == null || this.getDivideRate().signum() == 0) {
                this.setDivideRate(MUOMConversion.getOppositeRate(this.getMultiplyRate()));
            }
        } else if (this.getDivideRate() != null && this.getDivideRate().signum() != 0 && (this.getMultiplyRate() == null || this.getMultiplyRate().signum() == 0)) {
            this.setMultiplyRate(MUOMConversion.getOppositeRate(this.getDivideRate()));
        }
        if (this.getMultiplyRate().compareTo(Env.ZERO) <= 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@MultiplyRate@ <= 0"));
            return false;
        }
        if (MSysConfig.getBooleanValue("ProductUOMConversionUOMValidate", true, this.getAD_Client_ID()) && this.getM_Product_ID() != 0 && (newRecord || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("C_UOM_ID")) && (product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName())).getC_UOM_ID() != this.getC_UOM_ID()) {
            MUOM uom = MUOM.get(this.getCtx(), product.getC_UOM_ID());
            this.log.saveError("ProductUOMConversionUOMError", uom.getName());
            return false;
        }
        if (MSysConfig.getBooleanValue("ProductUOMConversionRateValidate", true, this.getAD_Client_ID()) && this.getM_Product_ID() != 0 && this.getDivideRate().compareTo(Env.ONE) < 0) {
            this.log.saveError("ProductUOMConversionRateError", "");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MUOMConversion[");
        sb.append(this.get_ID()).append("-C_UOM_ID=").append(this.getC_UOM_ID()).append(",C_UOM_To_ID=").append(this.getC_UOM_To_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append("-Multiply=").append(this.getMultiplyRate()).append("/Divide=").append(this.getDivideRate()).append("]");
        return sb.toString();
    }

    @Override
    public MUOMConversion markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    public static BigDecimal getOppositeRate(BigDecimal rate) {
        return Env.ONE.divide(rate, 12, RoundingMode.HALF_UP);
    }
}

