/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.X_Test;
import org.compiere.util.Env;

public class MTest
extends X_Test {
    private static final long serialVersionUID = 5750690186875693958L;

    public MTest(Properties ctx, int Test_ID, String trxName) {
        super(ctx, Test_ID, trxName);
    }

    public MTest(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTest(Properties ctx, String testString, int testNo) {
        super(ctx, 0, null);
        testString = String.valueOf(testString) + "_" + testNo;
        this.setName(testString);
        this.setDescription(String.valueOf(testString) + " " + testString + " " + testString);
        this.setHelp(String.valueOf(this.getDescription()) + " - " + this.getDescription());
        this.setT_Date(new Timestamp(System.currentTimeMillis()));
        this.setT_DateTime(new Timestamp(System.currentTimeMillis()));
        this.setT_Integer(testNo);
        this.setT_Amount(new BigDecimal(testNo));
        this.setT_Number(Env.ONE.divide(new BigDecimal(testNo), RoundingMode.HALF_UP));
        this.setC_Currency_ID(100);
        this.setC_Location_ID(109);
        this.setC_UOM_ID(100);
    }

    public MTest(Properties ctx, int Test_ID, String trxName, String ... virtualColumns) {
        super(ctx, Test_ID, trxName, virtualColumns);
    }

    @Override
    protected boolean beforeDelete() {
        this.log.info("***");
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("*** Success=" + success);
        }
        return success;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("New=" + newRecord + " ***");
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("New=" + newRecord + ", Success=" + success + " ***");
        }
        return success;
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        Properties ctx = Env.getCtx();
        MTest t1 = new MTest(ctx, 0, null);
        t1.setName("Test1");
        System.out.println("->" + t1.getCharacterData() + "<-");
        t1.saveEx();
        t1.setCharacterData("Long Text JJ");
        t1.saveEx();
        int Test_ID = t1.getTest_ID();
        MTest t2 = new MTest(Env.getCtx(), Test_ID, null);
        System.out.println("->" + t2.getCharacterData() + "<-");
        t2.delete(true);
    }
}

