/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MMenu;
import org.compiere.model.X_AD_Task;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Task;

public class MTask
extends X_AD_Task {
    private static final long serialVersionUID = 5286481246615520755L;
    private Task m_task = null;

    public MTask(Properties ctx, int AD_Task_ID, String trxName) {
        super(ctx, AD_Task_ID, trxName);
    }

    public MTask(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String execute() {
        String cmd = Msg.parseTranslation(Env.getCtx(), this.getOS_Command()).trim();
        if (cmd == null || cmd.equals("")) {
            return "Cannot execute '" + this.getOS_Command() + "'";
        }
        return this.executeLocal(cmd);
    }

    public String executeLocal(String cmd) {
        this.log.config(cmd);
        if (this.m_task != null && this.m_task.isAlive()) {
            this.m_task.interrupt();
        }
        this.m_task = new Task(cmd);
        this.m_task.start();
        StringBuilder sb = new StringBuilder();
        do {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ioe) {
                this.log.log(Level.SEVERE, cmd, ioe);
            }
            sb.append(this.m_task.getOut()).append("\n-----------\n").append(this.m_task.getErr()).append("\n-----------");
        } while (this.m_task.isAlive());
        this.log.config("done");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MTask[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(";").append(this.getOS_Command()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Success=" + success);
        }
        if (!success) {
            return success;
        }
        if (!newRecord && (this.is_ValueChanged("IsActive") || this.is_ValueChanged("Name") || this.is_ValueChanged("Description"))) {
            MMenu[] menues = MMenu.get(this.getCtx(), "AD_Task_ID=" + this.getAD_Task_ID(), this.get_TrxName());
            int i2 = 0;
            while (i2 < menues.length) {
                menues[i2].setIsActive(this.isActive());
                menues[i2].setName(this.getName());
                menues[i2].setDescription(this.getDescription());
                menues[i2].saveEx();
                ++i2;
            }
        }
        return success;
    }
}

