/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Table_ScriptValidator;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MTableScriptValidator
extends X_AD_Table_ScriptValidator
implements ImmutablePOSupport {
    private static final long serialVersionUID = 6776991549481106111L;
    private static ImmutableIntPOCache<Integer, MTableScriptValidator> s_cache = new ImmutableIntPOCache("AD_Table_ScriptValidator", 20);
    private static CCache<MultiKey, List<MTableScriptValidator>> s_cacheTableEvent = new CCache(null, "AD_Table_ScriptValidator_TableEvent", 20, false);

    public static MTableScriptValidator get(int AD_Table_ScriptValidator_ID) {
        return MTableScriptValidator.get(Env.getCtx(), AD_Table_ScriptValidator_ID);
    }

    public static MTableScriptValidator get(Properties ctx, int AD_Table_ScriptValidator_ID) {
        Integer key = AD_Table_ScriptValidator_ID;
        MTableScriptValidator retValue = s_cache.get(ctx, key, e -> new MTableScriptValidator(ctx, (MTableScriptValidator)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTableScriptValidator(ctx, AD_Table_ScriptValidator_ID, null);
        if (retValue.get_ID() == AD_Table_ScriptValidator_ID) {
            s_cache.put(key, retValue, e -> new MTableScriptValidator(Env.getCtx(), (MTableScriptValidator)e));
            return retValue;
        }
        return null;
    }

    public static List<MTableScriptValidator> getModelValidatorRules(Properties ctx, int ad_table_id, String event) {
        MultiKey key = new MultiKey((Object)ad_table_id, (Object)event);
        List<MTableScriptValidator> mvrs = s_cacheTableEvent.get(key);
        if (mvrs != null) {
            return mvrs;
        }
        String whereClause = "AD_Table_ID=? AND EventModelValidator=?";
        mvrs = new Query(ctx, "AD_Table_ScriptValidator", "AD_Table_ID=? AND EventModelValidator=?", null).setParameters(ad_table_id, event).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        for (MTableScriptValidator rule : mvrs) {
            s_cache.put(rule.get_ID(), rule, e -> new MTableScriptValidator(Env.getCtx(), (MTableScriptValidator)e));
        }
        if (mvrs != null) {
            if (ctx == Env.getCtx()) {
                s_cacheTableEvent.put(key, mvrs.stream().collect(Collectors.toCollection(ArrayList::new)));
            } else {
                s_cacheTableEvent.put(key, mvrs.stream().map(e -> new MTableScriptValidator(Env.getCtx(), (MTableScriptValidator)e).markImmutable()).collect(Collectors.toCollection(ArrayList::new)));
            }
        }
        if (mvrs != null && mvrs.size() > 0) {
            return mvrs;
        }
        return null;
    }

    public MTableScriptValidator(Properties ctx, int AD_Table_ScriptValidator_ID, String trxName) {
        super(ctx, AD_Table_ScriptValidator_ID, trxName);
    }

    public MTableScriptValidator(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTableScriptValidator(MTableScriptValidator copy) {
        this(Env.getCtx(), copy);
    }

    public MTableScriptValidator(Properties ctx, MTableScriptValidator copy) {
        this(ctx, copy, null);
    }

    public MTableScriptValidator(Properties ctx, MTableScriptValidator copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getSeqNo() == 0) {
            String sql = "SELECT COALESCE(MAX(SeqNo),0) + 10 FROM AD_Table_ScriptValidator WHERE AD_Table_ID=? AND EventModelValidator=?";
            int seqNo = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(MAX(SeqNo),0) + 10 FROM AD_Table_ScriptValidator WHERE AD_Table_ID=? AND EventModelValidator=?", this.getAD_Table_ID(), this.getEventModelValidator());
            this.setSeqNo(seqNo);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MTableScriptValidator[");
        sb.append(this.get_ID()).append("-").append(this.getAD_Table_ID()).append("-").append(this.getEventModelValidator()).append("]");
        return sb.toString();
    }

    @Override
    public MTableScriptValidator markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

