/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.base.ServiceQuery;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.IArchiveStore;
import org.compiere.model.IAttachmentStore;
import org.compiere.model.IImageStore;
import org.compiere.model.X_AD_StorageProvider;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MStorageProvider
extends X_AD_StorageProvider
implements ImmutablePOSupport {
    private static final long serialVersionUID = -7444967391781941193L;
    private static ImmutableIntPOCache<Integer, MStorageProvider> s_cache = new ImmutableIntPOCache("AD_StorageProvider", 10);
    private static CCache<ServiceQuery, IServiceReferenceHolder<IAttachmentStore>> s_attachmentStoreReference = new CCache(null, "IAttachmentStore", 3, false);
    private static CCache<ServiceQuery, IServiceReferenceHolder<IArchiveStore>> s_archiveStoreReference = new CCache(null, "IArchiveStore", 3, false);
    private static CCache<ServiceQuery, IServiceReferenceHolder<IImageStore>> s_imageStoreReference = new CCache(null, "IImageStore", 3, false);

    public static MStorageProvider get(int AD_StorageProvider_ID) {
        return MStorageProvider.get(Env.getCtx(), AD_StorageProvider_ID);
    }

    public static MStorageProvider get(Properties ctx, int AD_StorageProvider_ID) {
        Integer key = AD_StorageProvider_ID;
        MStorageProvider retValue = s_cache.get(ctx, key, e -> new MStorageProvider(ctx, (MStorageProvider)e));
        if (retValue == null) {
            retValue = new MStorageProvider(ctx, AD_StorageProvider_ID, null);
            if (retValue.get_ID() == AD_StorageProvider_ID) {
                s_cache.put(key, retValue, e -> new MStorageProvider(Env.getCtx(), (MStorageProvider)e));
                return retValue;
            }
            return null;
        }
        return retValue;
    }

    public static MStorageProvider getCopy(Properties ctx, int AD_StorageProvider_ID, String trxName) {
        MStorageProvider rt = MStorageProvider.get(AD_StorageProvider_ID);
        if (rt != null) {
            rt = new MStorageProvider(ctx, rt, trxName);
        }
        return rt;
    }

    public MStorageProvider(Properties ctx, int AD_StorageProvider_ID, String trxName) {
        super(ctx, AD_StorageProvider_ID, trxName);
    }

    public MStorageProvider(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MStorageProvider(MStorageProvider copy) {
        this(Env.getCtx(), copy);
    }

    public MStorageProvider(Properties ctx, MStorageProvider copy) {
        this(ctx, copy, null);
    }

    public MStorageProvider(Properties ctx, MStorageProvider copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public IAttachmentStore getAttachmentStore() {
        ServiceQuery query = new ServiceQuery();
        String method = this.getMethod();
        if (method == null) {
            method = "DB";
        }
        query.put("method", method);
        IAttachmentStore store = MStorageProvider.getAttachmentStoreService(query);
        if (store == null) {
            throw new AdempiereException("No attachment storage provider found");
        }
        return store;
    }

    public static IAttachmentStore getAttachmentStoreService(ServiceQuery query) {
        IServiceReferenceHolder<IAttachmentStore> serviceReference;
        IAttachmentStore store = null;
        IServiceReferenceHolder<IAttachmentStore> cache = s_attachmentStoreReference.get(query);
        if (cache != null) {
            store = cache.getService();
            if (store != null) {
                return store;
            }
            s_attachmentStoreReference.remove(query);
        }
        if ((serviceReference = Service.locator().locate(IAttachmentStore.class, query).getServiceReference()) != null && (store = serviceReference.getService()) != null) {
            s_attachmentStoreReference.put(query, serviceReference);
        }
        return store;
    }

    public IArchiveStore getArchiveStore() {
        ServiceQuery query = new ServiceQuery();
        String method = this.getMethod();
        if (method == null) {
            method = "DB";
        }
        query.put("method", method);
        IArchiveStore store = MStorageProvider.getArchiveStoreService(query);
        if (store == null) {
            throw new AdempiereException("No archive storage provider found");
        }
        return store;
    }

    public static IArchiveStore getArchiveStoreService(ServiceQuery query) {
        IServiceReferenceHolder<IArchiveStore> serviceReference;
        IArchiveStore store = null;
        IServiceReferenceHolder<IArchiveStore> cache = s_archiveStoreReference.get(query);
        if (cache != null) {
            store = cache.getService();
            if (store != null) {
                return store;
            }
            s_archiveStoreReference.remove(query);
        }
        if ((serviceReference = Service.locator().locate(IArchiveStore.class, query).getServiceReference()) != null && (store = serviceReference.getService()) != null) {
            s_archiveStoreReference.put(query, serviceReference);
        }
        return store;
    }

    public IImageStore getImageStore() {
        ServiceQuery query = new ServiceQuery();
        String method = this.getMethod();
        if (method == null) {
            method = "DB";
        }
        query.put("method", method);
        IImageStore store = MStorageProvider.getImageStoreService(query);
        if (store == null) {
            throw new AdempiereException("No image storage provider found");
        }
        return store;
    }

    public static IImageStore getImageStoreService(ServiceQuery query) {
        IServiceReferenceHolder<IImageStore> serviceReference;
        IImageStore store = null;
        IServiceReferenceHolder<IImageStore> cache = s_imageStoreReference.get(query);
        if (cache != null) {
            store = cache.getService();
            if (store != null) {
                return store;
            }
            s_imageStoreReference.remove(query);
        }
        if ((serviceReference = Service.locator().locate(IImageStore.class, query).getServiceReference()) != null) {
            store = serviceReference.getService();
            s_imageStoreReference.put(query, serviceReference);
        }
        return store;
    }

    public static int getDefaultStorageProviderID() {
        String sql = "SELECT AD_StorageProvider_ID FROM AD_StorageProvider WHERE IsDefault='Y' AND IsActive='Y' ORDER BY AD_StorageProvider_ID";
        return DB.getSQLValueEx(null, "SELECT AD_StorageProvider_ID FROM AD_StorageProvider WHERE IsDefault='Y' AND IsActive='Y' ORDER BY AD_StorageProvider_ID", new Object[0]);
    }

    @Override
    public MStorageProvider markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

