/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_R_Status;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MStatus
extends X_R_Status
implements ImmutablePOSupport {
    private static final long serialVersionUID = 446327334122691551L;
    private static CLogger s_log = CLogger.getCLogger(MStatus.class);
    private static ImmutableIntPOCache<Integer, MStatus> s_cache = new ImmutableIntPOCache("R_Status", 10);
    private static ImmutableIntPOCache<Integer, MStatus> s_cacheDefault = new ImmutableIntPOCache("R_Status", "R_Status_Default", 10);

    public static MStatus get(int R_Status_ID) {
        return MStatus.get(Env.getCtx(), R_Status_ID);
    }

    public static MStatus get(Properties ctx, int R_Status_ID) {
        if (R_Status_ID == 0) {
            return null;
        }
        Integer key = R_Status_ID;
        MStatus retValue = s_cache.get(ctx, key, e -> new MStatus(ctx, (MStatus)e));
        if (retValue == null) {
            retValue = new MStatus(ctx, R_Status_ID, null);
            if (retValue.get_ID() == R_Status_ID) {
                s_cache.put(key, retValue, e -> new MStatus(Env.getCtx(), (MStatus)e));
                return retValue;
            }
            return null;
        }
        return retValue;
    }

    public static MStatus getCopy(Properties ctx, int R_Status_ID, String trxName) {
        MStatus status = MStatus.get(R_Status_ID);
        if (status != null) {
            status = new MStatus(ctx, status, trxName);
        }
        return status;
    }

    public static MStatus getDefault(Properties ctx, int R_RequestType_ID) {
        MStatus retValue;
        Integer key;
        block8: {
            key = R_RequestType_ID;
            retValue = s_cacheDefault.get(ctx, key, e -> new MStatus(ctx, (MStatus)e));
            if (retValue != null) {
                return retValue;
            }
            String sql = "SELECT * FROM R_Status s WHERE EXISTS (SELECT * FROM R_RequestType rt WHERE rt.R_StatusCategory_ID=s.R_StatusCategory_ID AND rt.R_RequestType_ID=?) AND IsDefault='Y' ORDER BY SeqNo";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, R_RequestType_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MStatus(ctx, rs, null);
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, sql, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            s_cacheDefault.put(key, retValue, e -> new MStatus(Env.getCtx(), (MStatus)e));
        }
        return retValue;
    }

    public static MStatus[] getClosed(Properties ctx) {
        ArrayList<MStatus> list;
        block6: {
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            String sql = "SELECT * FROM R_Status WHERE AD_Client_ID=? AND IsActive='Y' AND IsClosed='Y' ORDER BY Value";
            list = new ArrayList<MStatus>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MStatus(ctx, rs, null));
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, sql, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MStatus[] retValue = new MStatus[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MStatus(Properties ctx, int R_Status_ID, String trxName) {
        super(ctx, R_Status_ID, trxName);
        if (R_Status_ID == 0) {
            this.setIsClosed(false);
            this.setIsDefault(false);
            this.setIsFinalClose(false);
            this.setIsOpen(false);
            this.setIsWebCanUpdate(true);
        }
    }

    public MStatus(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MStatus(MStatus copy) {
        this(Env.getCtx(), copy);
    }

    public MStatus(Properties ctx, MStatus copy) {
        this(ctx, copy, null);
    }

    public MStatus(Properties ctx, MStatus copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isOpen() && this.isClosed()) {
            this.setIsClosed(false);
        }
        if (this.isFinalClose() && !this.isClosed()) {
            this.setIsFinalClose(false);
        }
        if (!this.isWebCanUpdate() && this.getUpdate_Status_ID() != 0) {
            this.setUpdate_Status_ID(0);
        }
        if (this.getTimeoutDays() == 0 && this.getNext_Status_ID() != 0) {
            this.setNext_Status_ID(0);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MStatus[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    public MStatus markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

