/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.GridTab;
import org.compiere.model.MDocType;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Sequence;
import org.compiere.model.X_AD_Sequence_No;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class MSequence
extends X_AD_Sequence {
    private static final long serialVersionUID = -750059366190164777L;
    private static final int QUERY_TIME_OUT = 30;
    private static final String NoYearNorMonth = "-";
    private static final String PREFIX_DOCSEQ = "DocumentNo_";
    public static final int INIT_NO = 1000000;
    public static final int INIT_SYS_NO = 200000;
    private static CLogger s_log = CLogger.getCLogger(MSequence.class);
    private static Vector<Integer> s_list = null;
    private static String[] dontUseCentralized = new String[]{"AD_ACCESSLOG", "AD_ALERTPROCESSORLOG", "AD_CHANGELOG", "AD_ISSUE", "AD_LDAPPROCESSORLOG", "AD_PACKAGE_IMP", "AD_PACKAGE_IMP_BACKUP", "AD_PACKAGE_IMP_DETAIL", "AD_PACKAGE_IMP_INST", "AD_PACKAGE_IMP_PROC", "AD_PINSTANCE", "AD_PINSTANCE_LOG", "AD_PINSTANCE_PARA", "AD_PREFERENCE", "AD_RECENTITEM", "AD_REPLICATION_LOG", "AD_SCHEDULERLOG", "AD_SESSION", "AD_USERPREFERENCE", "AD_WLISTBOX_CUSTOMIZATION", "AD_WORKFLOWPROCESSORLOG", "CM_WEBACCESSLOG", "C_ACCTPROCESSORLOG", "K_INDEXLOG", "R_REQUESTPROCESSORLOG", "T_AGING", "T_ALTER_COLUMN", "T_DISTRIBUTIONRUNDETAIL", "T_INVENTORYVALUE", "T_INVOICEGL", "T_REPLENISH", "T_REPORT", "T_REPORTSTATEMENT", "T_SELECTION", "T_SELECTION2", "T_SPOOL", "T_TRANSACTION", "T_TRIALBALANCE"};
    private static CCache<String, String> tablesWithEntityType = new CCache("AD_Sequence", "TablesWithEntityType", 60, 0, false, 0);

    public static int getNextID(int AD_Client_ID, String TableName) {
        return MSequence.getNextID(AD_Client_ID, TableName, null);
    }

    /*
     * Loose catch block
     */
    public static int getNextID(int AD_Client_ID, String TableName, String trxName) {
        boolean isUseProjectCentralizedID;
        boolean isSystemNativeSequence = MSysConfig.getBooleanValue("SYSTEM_NATIVE_SEQUENCE", false);
        boolean adempiereSys = false;
        if (Ini.isClient()) {
            adempiereSys = Ini.isPropertyBool("AdempiereSys");
        } else {
            String sysProperty = Env.getCtx().getProperty("AdempiereSys", "N");
            boolean bl = adempiereSys = "y".equalsIgnoreCase(sysProperty) || "true".equalsIgnoreCase(sysProperty);
        }
        if (adempiereSys && AD_Client_ID > 11) {
            adempiereSys = false;
        }
        if (CLogMgt.isLevel(Level.FINER)) {
            s_log.log(Level.FINER, String.valueOf(TableName) + " - AdempiereSys=" + adempiereSys + " [" + trxName + "]");
        }
        if (TableName == null || TableName.length() == 0) {
            throw new IllegalArgumentException("TableName missing");
        }
        int retValue = -1;
        if (adempiereSys) {
            boolean isUseCentralizedID = MSysConfig.getBooleanValue("DICTIONARY_ID_USE_CENTRALIZED_ID", true);
            if (isUseCentralizedID) {
                if (!MSequence.isExceptionCentralized(TableName)) {
                    retValue = MSequence.getNextOfficialID_HTTP(TableName);
                    if (retValue > 0) {
                        DB.executeUpdateEx("UPDATE AD_Sequence SET CurrentNextSys = ? + 1 WHERE Name=? AND IsTableID='Y' AND IsAutoSequence='Y'", new Object[]{retValue, TableName}, trxName);
                    }
                    return retValue;
                }
            } else {
                throw new AdempiereException("System IDs must be always obtained from Centralized ID server");
            }
        }
        boolean queryProjectServer = false;
        if (MSequence.isTableWithEntityType(TableName)) {
            queryProjectServer = true;
        }
        if (!queryProjectServer && "AD_Sequence".equalsIgnoreCase(TableName)) {
            queryProjectServer = true;
        }
        if (queryProjectServer && !adempiereSys && !MSequence.isExceptionCentralized(TableName) && (isUseProjectCentralizedID = MSysConfig.getBooleanValue("PROJECT_ID_USE_CENTRALIZED_ID", false))) {
            retValue = MSequence.getNextProjectID_HTTP(TableName);
            if (retValue > 0) {
                DB.executeUpdateEx("UPDATE AD_Sequence SET CurrentNext = GREATEST(CurrentNext, ? + 1) WHERE Name=? AND IsTableID='Y' AND IsAutoSequence='Y'", new Object[]{retValue, TableName}, trxName);
            }
            return retValue;
        }
        if (isSystemNativeSequence) {
            retValue = CConnection.get().getDatabase().getNextID(String.valueOf(TableName) + "_SQ", trxName);
            if (retValue == -1) {
                MSequence.createTableSequence(Env.getCtx(), TableName, trxName, true);
                retValue = CConnection.get().getDatabase().getNextID(String.valueOf(TableName) + "_SQ", trxName);
            }
            return retValue;
        }
        String selectSQL = null;
        if (!DB.isOracle()) {
            selectSQL = "SELECT CurrentNext, CurrentNextSys, IncrementNo, AD_Sequence_ID FROM AD_Sequence WHERE Name=? AND IsActive='Y' AND IsTableID='Y' AND IsAutoSequence='Y'  FOR UPDATE OF AD_Sequence ";
        } else {
            selectSQL = "SELECT CurrentNext, CurrentNextSys, IncrementNo, AD_Sequence_ID FROM AD_Sequence WHERE Name=? AND IsActive='Y' AND IsTableID='Y' AND IsAutoSequence='Y' ";
            selectSQL = adempiereSys ? String.valueOf(selectSQL) + " FOR UPDATE OF CurrentNextSys" : String.valueOf(selectSQL) + " FOR UPDATE OF CurrentNext";
        }
        if (!DB.isOracle() && !DB.isPostgreSQL()) {
            selectSQL = DB.getDatabase().convertStatement(selectSQL);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int i2 = 0;
        while (i2 < 3) {
            block49: {
                block48: {
                    block47: {
                        conn = DB.getConnection(false);
                        if (conn != null) break block47;
                        DB.close(rs, pstmt);
                        pstmt = null;
                        rs = null;
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            conn = null;
                        }
                        return -1;
                    }
                    pstmt = conn.prepareStatement(selectSQL, 1003, 1008);
                    pstmt.setString(1, TableName);
                    if (DB.getDatabase().isQueryTimeoutSupported()) {
                        int timeout = MSysConfig.getIntValue("MSEQUENCE_GETNEXT_TIMEOUT", 30, Env.getAD_Client_ID(Env.getCtx()));
                        pstmt.setQueryTimeout(timeout);
                    }
                    rs = pstmt.executeQuery();
                    if (s_log.isLoggable(Level.FINEST)) {
                        s_log.finest("AC=" + conn.getAutoCommit() + ", RO=" + conn.isReadOnly() + " - Isolation=" + conn.getTransactionIsolation() + "(" + 2 + ") - RSType=" + pstmt.getResultSetType() + "(" + 1005 + "), RSConcur=" + pstmt.getResultSetConcurrency() + "(" + 1008 + ")");
                    }
                    if (rs.next()) {
                        int AD_Sequence_ID = rs.getInt(4);
                        PreparedStatement updateSQL = null;
                        try {
                            int incrementNo = rs.getInt(3);
                            if (adempiereSys) {
                                String updateCmd = "UPDATE AD_Sequence SET CurrentNextSys=CurrentNextSys+? WHERE AD_Sequence_ID=?";
                                if (!DB.isOracle() && !DB.isPostgreSQL()) {
                                    updateCmd = DB.getDatabase().convertStatement(updateCmd);
                                }
                                updateSQL = conn.prepareStatement(updateCmd);
                                retValue = rs.getInt(2);
                            } else {
                                String updateCmd = "UPDATE AD_Sequence SET CurrentNext=CurrentNext+? WHERE AD_Sequence_ID=?";
                                if (!DB.isOracle() && !DB.isPostgreSQL()) {
                                    updateCmd = DB.getDatabase().convertStatement(updateCmd);
                                }
                                updateSQL = conn.prepareStatement(updateCmd);
                                retValue = rs.getInt(1);
                            }
                            updateSQL.setInt(1, incrementNo);
                            updateSQL.setInt(2, AD_Sequence_ID);
                            updateSQL.executeUpdate();
                        }
                        catch (Throwable throwable) {
                            DB.close(updateSQL);
                            updateSQL = null;
                            throw throwable;
                        }
                        DB.close(updateSQL);
                        updateSQL = null;
                        conn.commit();
                        break block48;
                    }
                    s_log.severe("No record found - " + TableName);
                }
                DB.close(rs, pstmt);
                pstmt = null;
                rs = null;
                if (conn == null) break;
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                conn = null;
                break;
                catch (Exception e) {
                    try {
                        s_log.log(Level.SEVERE, String.valueOf(TableName) + " - " + e.getMessage(), e);
                        try {
                            if (conn != null) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        pstmt = null;
                        rs = null;
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            conn = null;
                        }
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    pstmt = null;
                    rs = null;
                    if (conn == null) break block49;
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    conn = null;
                }
            }
            Thread.yield();
            ++i2;
        }
        return retValue;
    }

    public static String getDocumentNo(int AD_Client_ID, String TableName, String trxName) {
        return MSequence.getDocumentNo(AD_Client_ID, TableName, trxName, null);
    }

    public static String getDocumentNo(int AD_Client_ID, String TableName, String trxName, PO po) {
        if (TableName == null || TableName.length() == 0) {
            throw new IllegalArgumentException("TableName missing");
        }
        MSequence seq = MSequence.get(Env.getCtx(), TableName, trxName, false);
        if (seq == null || seq.get_ID() == 0) {
            if (!MSequence.createTableSequence(Env.getCtx(), TableName, trxName, false)) {
                throw new AdempiereException("Could not create table sequence");
            }
            seq = MSequence.get(Env.getCtx(), TableName, trxName, false);
            if (seq == null || seq.get_ID() == 0) {
                throw new AdempiereException("Could not find table sequence");
            }
        }
        return MSequence.getDocumentNoFromSeq(seq, trxName, po);
    }

    public static String getDocumentNoFromSeq(MSequence seq, String trxName, PO po) {
        String suffixValue;
        String prefixValue;
        ResultSet rs;
        PreparedStatement pstmt;
        int next;
        int docOrg_ID;
        String calendarYearMonth;
        Trx trx;
        Connection conn;
        String selectSQL;
        String decimalPattern;
        String suffix;
        String prefix;
        int incrementNo;
        int startNo;
        String orgColumn;
        boolean isUseOrgLevel;
        String dateColumn;
        boolean isStartNewMonth;
        boolean isStartNewYear;
        int AD_Sequence_ID;
        boolean adempiereSys;
        block46: {
            adempiereSys = false;
            if (Ini.isClient()) {
                adempiereSys = Ini.isPropertyBool("AdempiereSys");
            } else {
                String sysProperty = Env.getCtx().getProperty("AdempiereSys", "N");
                boolean bl = adempiereSys = "y".equalsIgnoreCase(sysProperty) || "true".equalsIgnoreCase(sysProperty);
            }
            if (adempiereSys && Env.getAD_Client_ID(Env.getCtx()) > 11) {
                adempiereSys = false;
            }
            AD_Sequence_ID = seq.getAD_Sequence_ID();
            isStartNewYear = seq.isStartNewYear();
            isStartNewMonth = seq.isStartNewMonth();
            dateColumn = seq.getDateColumn();
            isUseOrgLevel = seq.isOrgLevelSequence();
            orgColumn = seq.getOrgColumn();
            startNo = seq.getStartNo();
            incrementNo = seq.getIncrementNo();
            prefix = seq.getPrefix();
            suffix = seq.getSuffix();
            decimalPattern = seq.getDecimalPattern();
            selectSQL = null;
            selectSQL = isStartNewYear || isUseOrgLevel ? "SELECT y.CurrentNext, s.CurrentNextSys FROM AD_Sequence_No y, AD_Sequence s WHERE y.AD_Sequence_ID = s.AD_Sequence_ID AND s.AD_Sequence_ID = ? AND y.CalendarYearMonth = ? AND y.AD_Org_ID = ? AND s.IsActive='Y' AND s.IsTableID='N' AND s.IsAutoSequence='Y' ORDER BY s.AD_Client_ID DESC" : "SELECT s.CurrentNext, s.CurrentNextSys FROM AD_Sequence s WHERE s.AD_Sequence_ID = ? AND s.IsActive='Y' AND s.IsTableID='N' AND s.IsAutoSequence='Y' ORDER BY s.AD_Client_ID DESC";
            if (!DB.isOracle()) {
                selectSQL = isStartNewYear || isUseOrgLevel ? String.valueOf(selectSQL) + " FOR UPDATE OF y" : String.valueOf(selectSQL) + " FOR UPDATE OF s";
            } else {
                selectSQL = isStartNewYear || isUseOrgLevel ? String.valueOf(selectSQL) + " FOR UPDATE OF y." : String.valueOf(selectSQL) + " FOR UPDATE OF s.";
                selectSQL = adempiereSys ? String.valueOf(selectSQL) + "CurrentNextSys" : String.valueOf(selectSQL) + "CurrentNext";
            }
            if (!DB.isOracle() && !DB.isPostgreSQL()) {
                selectSQL = DB.getDatabase().convertStatement(selectSQL);
            }
            conn = null;
            trx = trxName == null ? null : Trx.get(trxName, true);
            calendarYearMonth = NoYearNorMonth;
            docOrg_ID = 0;
            next = -1;
            pstmt = null;
            rs = null;
            conn = trx != null ? trx.getConnection() : DB.getConnection(false);
            if (conn != null) break block46;
            DB.close(rs, pstmt);
            pstmt = null;
            rs = null;
            try {
                if (trx == null && conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, "(DocType) - finish", e);
            }
            return null;
        }
        try {
            try {
                if (isStartNewYear) {
                    SimpleDateFormat sdf = null;
                    sdf = isStartNewMonth ? new SimpleDateFormat("yyyyMM") : new SimpleDateFormat("yyyy");
                    if (po != null && dateColumn != null && dateColumn.length() > 0) {
                        Date docDate = (Date)po.get_Value(dateColumn);
                        calendarYearMonth = sdf.format(docDate);
                    } else {
                        calendarYearMonth = sdf.format(new Date());
                    }
                }
                if (isUseOrgLevel && po != null && orgColumn != null && orgColumn.length() > 0) {
                    docOrg_ID = po.get_ValueAsInt(orgColumn);
                }
                pstmt = conn.prepareStatement(selectSQL, 1003, 1008);
                int index = 1;
                pstmt.setInt(index++, AD_Sequence_ID);
                if (isUseOrgLevel || isStartNewYear) {
                    pstmt.setString(index++, calendarYearMonth);
                    pstmt.setInt(index++, docOrg_ID);
                }
                if (DB.getDatabase().isQueryTimeoutSupported()) {
                    int timeout = MSysConfig.getIntValue("MSEQUENCE_GETNEXT_TIMEOUT", 30, Env.getAD_Client_ID(Env.getCtx()));
                    pstmt.setQueryTimeout(timeout);
                }
                if ((rs = pstmt.executeQuery()).next()) {
                    if (s_log.isLoggable(Level.FINE)) {
                        s_log.fine("AD_Sequence_ID=" + AD_Sequence_ID);
                    }
                    PreparedStatement updateSQL = null;
                    try {
                        if (adempiereSys) {
                            String updateCmd = "UPDATE AD_Sequence SET CurrentNextSys = CurrentNextSys + ? WHERE AD_Sequence_ID = ?";
                            if (!DB.isOracle() && !DB.isPostgreSQL()) {
                                updateCmd = DB.getDatabase().convertStatement(updateCmd);
                            }
                            updateSQL = conn.prepareStatement(updateCmd);
                            next = rs.getInt(2);
                        } else {
                            String sql = isStartNewYear || isUseOrgLevel ? "UPDATE AD_Sequence_No SET CurrentNext = CurrentNext + ? WHERE AD_Sequence_ID=? AND CalendarYearMonth=? AND AD_Org_ID=?" : "UPDATE AD_Sequence SET CurrentNext = CurrentNext + ? WHERE AD_Sequence_ID=?";
                            if (!DB.isOracle() && !DB.isPostgreSQL()) {
                                sql = DB.getDatabase().convertStatement(sql);
                            }
                            updateSQL = conn.prepareStatement(sql);
                            next = rs.getInt(1);
                        }
                        updateSQL.setInt(1, incrementNo);
                        updateSQL.setInt(2, AD_Sequence_ID);
                        if (isStartNewYear || isUseOrgLevel) {
                            updateSQL.setString(3, calendarYearMonth);
                            updateSQL.setInt(4, docOrg_ID);
                        }
                        updateSQL.executeUpdate();
                    }
                    catch (Throwable throwable) {
                        DB.close(updateSQL);
                        updateSQL = null;
                        throw throwable;
                    }
                    DB.close(updateSQL);
                    updateSQL = null;
                } else if (isUseOrgLevel || isStartNewYear) {
                    next = startNo;
                    X_AD_Sequence_No seqno = new X_AD_Sequence_No(Env.getCtx(), 0, trxName);
                    seqno.setAD_Sequence_ID(AD_Sequence_ID);
                    seqno.setAD_Org_ID(docOrg_ID);
                    seqno.setCalendarYearMonth(calendarYearMonth);
                    seqno.setCurrentNext(startNo + incrementNo);
                    seqno.saveEx();
                } else {
                    s_log.warning("(Sequence)- no record found - " + seq);
                    next = -2;
                }
                if (trx == null) {
                    conn.commit();
                }
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, "(DocType) [" + trxName + "]", e);
                if (DBException.isTimeout(e)) {
                    throw new AdempiereException("GenerateDocumentNoTimeOut", e);
                }
                throw new AdempiereException("GenerateDocumentNoError", e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            pstmt = null;
            rs = null;
            try {
                if (trx == null && conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, "(DocType) - finish", e);
            }
            throw throwable;
        }
        DB.close(rs, pstmt);
        pstmt = null;
        rs = null;
        try {
            if (trx == null && conn != null) {
                conn.close();
                conn = null;
            }
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "(DocType) - finish", e);
        }
        if (next < 0) {
            return null;
        }
        StringBuilder doc = new StringBuilder();
        if (prefix != null && prefix.length() > 0 && !Util.isEmpty(prefixValue = Env.parseVariable(prefix, po, trxName, false))) {
            doc.append(prefixValue);
        }
        if (decimalPattern != null && decimalPattern.length() > 0) {
            doc.append(new DecimalFormat(decimalPattern).format(next));
        } else {
            doc.append(next);
        }
        if (suffix != null && suffix.length() > 0 && !Util.isEmpty(suffixValue = Env.parseVariable(suffix, po, trxName, false))) {
            doc.append(suffixValue);
        }
        String documentNo = doc.toString();
        if (s_log.isLoggable(Level.FINER)) {
            s_log.finer(String.valueOf(documentNo) + " (" + incrementNo + ")" + " - Sequence=" + AD_Sequence_ID + " [" + trx + "]");
        }
        return documentNo;
    }

    public static String getDocumentNo(int C_DocType_ID, String trxName) {
        return MSequence.getDocumentNo(C_DocType_ID, trxName, false);
    }

    public static String getDocumentNo(int C_DocType_ID, String trxName, boolean definite) {
        return MSequence.getDocumentNo(C_DocType_ID, trxName, definite, null);
    }

    public static String getDocumentNo(int C_DocType_ID, String trxName, boolean definite, PO po) {
        if (C_DocType_ID == 0) {
            s_log.severe("C_DocType_ID=0");
            return null;
        }
        MDocType dt = MDocType.get(Env.getCtx(), C_DocType_ID);
        if (dt != null && !dt.isDocNoControlled()) {
            if (s_log.isLoggable(Level.FINER)) {
                s_log.finer("DocType_ID=" + C_DocType_ID + " Not DocNo controlled");
            }
            return null;
        }
        if (definite && !dt.isOverwriteSeqOnComplete()) {
            s_log.warning("DocType_ID=" + C_DocType_ID + " Not Sequence Overwrite on Complete");
            return null;
        }
        if (dt == null || dt.getDocNoSequence_ID() == 0) {
            s_log.warning("No Sequence for DocType - " + dt);
            return null;
        }
        if (definite && dt.getDefiniteSequence_ID() == 0) {
            s_log.warning("No Definite Sequence for DocType - " + dt);
            return null;
        }
        int seqID = definite ? dt.getDefiniteSequence_ID() : dt.getDocNoSequence_ID();
        MSequence seq = new MSequence(Env.getCtx(), seqID, trxName);
        if (CLogMgt.isLevel(Level.FINER)) {
            s_log.log(Level.FINER, "DocType_ID=" + C_DocType_ID + " [" + trxName + "]");
        }
        return MSequence.getDocumentNoFromSeq(seq, trxName, po);
    }

    public static boolean checkClientSequences(Properties ctx, int AD_Client_ID, String trxName) {
        boolean success;
        int counter;
        block9: {
            String sql = "SELECT TableName FROM AD_Table t WHERE IsActive='Y' AND IsView='N' AND AD_Table_ID IN (SELECT AD_Table_ID FROM AD_Column WHERE ColumnName = 'DocumentNo' OR ColumnName = 'Value') AND 'DocumentNo_' || TableName NOT IN (SELECT Name FROM AD_Sequence s WHERE s.AD_Client_ID=?)";
            counter = 0;
            success = true;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MSequence seq;
                        String tableName = rs.getString(1);
                        if (s_log.isLoggable(Level.FINE)) {
                            s_log.fine("Add: " + tableName);
                        }
                        if ((seq = new MSequence(ctx, AD_Client_ID, tableName, trxName)).save()) {
                            ++counter;
                            continue;
                        }
                        s_log.severe("Not created - AD_Client_ID=" + AD_Client_ID + " - " + tableName);
                        success = false;
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("AD_Client_ID=" + AD_Client_ID + " - created #" + counter + " - success=" + success);
        }
        return success;
    }

    public static boolean createTableSequence(Properties ctx, String TableName, String trxName) {
        return MSequence.createTableSequence(ctx, TableName, trxName, true);
    }

    public static boolean createTableSequence(Properties ctx, String TableName, String trxName, boolean tableID) {
        boolean SYSTEM_NATIVE_SEQUENCE = MSysConfig.getBooleanValue("SYSTEM_NATIVE_SEQUENCE", false);
        if (tableID && SYSTEM_NATIVE_SEQUENCE) {
            int next_id = DB.getSQLValueEx(trxName, "SELECT CurrentNext FROM AD_Sequence WHERE Name=? AND IsActive='Y' AND IsTableID='Y' AND IsAutoSequence='Y'", TableName);
            if (next_id == -1) {
                MSequence seq = new MSequence(ctx, 0, trxName);
                seq.setClientOrg(0, 0);
                seq.setName(TableName);
                seq.setDescription("Table " + TableName);
                seq.setIsTableID(tableID);
                seq.saveEx();
                next_id = 1000000;
            }
            return CConnection.get().getDatabase().createSequence(String.valueOf(TableName) + "_SQ", 1, 1000000, Integer.MAX_VALUE, next_id, trxName);
        }
        MSequence seq = new MSequence(ctx, 0, trxName);
        if (tableID) {
            seq.setClientOrg(0, 0);
        } else {
            seq.setClientOrg(Env.getAD_Client_ID(Env.getCtx()), 0);
        }
        if (tableID) {
            seq.setName(TableName);
            seq.setDescription("Table " + TableName);
        } else {
            seq.setName(PREFIX_DOCSEQ + TableName);
            seq.setDescription("DocumentNo/Value for Table " + TableName);
        }
        seq.setIsTableID(tableID);
        seq.saveEx();
        return true;
    }

    public static MSequence get(Properties ctx, String tableName) {
        return MSequence.get(ctx, tableName, null);
    }

    public static MSequence get(Properties ctx, String tableName, String trxName) {
        return MSequence.get(ctx, tableName, trxName, true);
    }

    public static MSequence get(Properties ctx, String tableName, String trxName, boolean tableID) {
        if (!tableID) {
            tableName = PREFIX_DOCSEQ + tableName;
        }
        String sql = "SELECT * FROM AD_Sequence WHERE UPPER(Name)=? AND IsTableID=?";
        if (!tableID) {
            sql = String.valueOf(sql) + " AND AD_Client_ID=?";
        }
        MSequence retValue = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                pstmt.setString(1, tableName.toUpperCase());
                pstmt.setString(2, tableID ? "Y" : "N");
                if (!tableID) {
                    pstmt.setInt(3, Env.getAD_Client_ID(Env.getCtx()));
                }
                if ((rs = pstmt.executeQuery()).next()) {
                    retValue = new MSequence(ctx, rs, trxName);
                }
                if (rs.next()) {
                    s_log.log(Level.SEVERE, "More then one sequence for " + tableName);
                }
            }
            catch (Exception e) {
                throw new DBException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public MSequence(Properties ctx, int AD_Sequence_ID, String trxName) {
        super(ctx, AD_Sequence_ID, trxName);
        if (AD_Sequence_ID == 0) {
            this.setIsTableID(false);
            this.setStartNo(1000000);
            this.setCurrentNext(1000000);
            this.setCurrentNextSys(200000);
            this.setIncrementNo(1);
            this.setIsAutoSequence(true);
            this.setIsAudited(false);
            this.setStartNewYear(false);
        }
    }

    public MSequence(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MSequence(Properties ctx, int AD_Client_ID, String tableName, String trxName) {
        this(ctx, 0, trxName);
        this.setClientOrg(AD_Client_ID, 0);
        this.setName(PREFIX_DOCSEQ + tableName);
        this.setDescription("DocumentNo/Value for Table " + tableName);
    }

    public MSequence(Properties ctx, int AD_Client_ID, String sequenceName, int StartNo, String trxName) {
        this(ctx, 0, trxName);
        this.setClientOrg(AD_Client_ID, 0);
        this.setName(sequenceName);
        this.setDescription(sequenceName);
        this.setStartNo(StartNo);
        this.setCurrentNext(StartNo);
        this.setCurrentNextSys(StartNo / 10);
    }

    public int getNextID() {
        int retValue = this.getCurrentNext();
        if (!MSysConfig.getBooleanValue("SYSTEM_NATIVE_SEQUENCE", false) || !this.isTableID()) {
            this.setCurrentNext(retValue + this.getIncrementNo());
        }
        return retValue;
    }

    public String validateTableIDValue() {
        return this.validateTableIDValue(null);
    }

    public String validateTableIDValue(String trxName) {
        int currentNextSysValue;
        int maxTableSysID;
        int currentNextValue;
        int maxTableID;
        if (!this.isTableID()) {
            return null;
        }
        String tableName = this.getName();
        int AD_Column_ID = DB.getSQLValue(trxName, "SELECT MAX(c.AD_Column_ID) FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE t.TableName='" + tableName + "'" + " AND t.IsView='N'" + " AND c.ColumnName='" + tableName + "_ID'");
        if (AD_Column_ID <= 0) {
            return null;
        }
        MSystem system = MSystem.get(this.getCtx());
        int IDRangeEnd = 0;
        if (system.getIDRangeEnd() != null) {
            IDRangeEnd = system.getIDRangeEnd().intValue();
        }
        String changeMsg = null;
        String info = null;
        String sql = "SELECT MAX(" + tableName + "_ID) FROM " + tableName;
        if (IDRangeEnd > 0) {
            sql = String.valueOf(sql) + " WHERE " + tableName + "_ID < " + IDRangeEnd;
        }
        if ((maxTableID = DB.getSQLValue(trxName, sql)) < 1000000) {
            maxTableID = 999999;
        }
        if ((currentNextValue = this.getCurrentNext()) < ++maxTableID) {
            this.setCurrentNext(maxTableID);
            info = "CurrentNext=" + maxTableID;
            changeMsg = String.valueOf(this.getName()) + " ID  " + currentNextValue + " -> " + maxTableID;
        }
        if ((maxTableSysID = DB.getSQLValue(trxName, sql = "SELECT MAX(" + tableName + "_ID) FROM " + tableName + " WHERE " + tableName + "_ID < " + 1000000)) <= 0) {
            maxTableSysID = 200000;
        }
        if ((currentNextSysValue = this.getCurrentNextSys()) < maxTableSysID) {
            this.setCurrentNextSys(maxTableSysID);
            info = info == null ? "CurrentNextSys=" + maxTableSysID : String.valueOf(info) + " - CurrentNextSys=" + maxTableSysID;
            changeMsg = changeMsg == null ? String.valueOf(this.getName()) + " Sys " + currentNextSysValue + " -> " + maxTableSysID : String.valueOf(changeMsg) + " - " + this.getName() + " Sys " + currentNextSysValue + " -> " + maxTableSysID;
        }
        if (info != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.getName()) + " - " + info);
        }
        return changeMsg;
    }

    @Override
    public int getCurrentNext() {
        if (MSysConfig.getBooleanValue("SYSTEM_NATIVE_SEQUENCE", false) && this.isTableID()) {
            return DB.getNextID(this.getAD_Client_ID(), this.getName(), this.get_TrxName());
        }
        return super.getCurrentNext();
    }

    @Override
    public void setCurrentNext(int CurrentNext) {
        if (MSysConfig.getBooleanValue("SYSTEM_NATIVE_SEQUENCE", false) && this.isTableID()) {
            int id;
            while ((id = DB.getNextID(this.getAD_Client_ID(), this.getName(), this.get_TrxName())) >= 0 && id < CurrentNext - 1) {
            }
        } else {
            super.setCurrentNext(CurrentNext);
        }
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        CLogMgt.setLevel(Level.SEVERE);
        CLogMgt.setLoggerLevel(Level.SEVERE, null);
        s_list = new Vector(1000);
        long time = System.currentTimeMillis();
        Thread[] threads = new Thread[10];
        int i2 = 0;
        while (i2 < 10) {
            GetIDs r = new GetIDs(i2);
            threads[i2] = new Thread(r);
            threads[i2].start();
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            try {
                threads[i2].join();
            }
            catch (InterruptedException r) {
                // empty catch block
            }
            ++i2;
        }
        time = System.currentTimeMillis() - time;
        System.out.println("-------------------------------------------");
        System.out.println("Size=" + s_list.size() + " (should be 1000)");
        Object[] ia = new Integer[s_list.size()];
        s_list.toArray(ia);
        Arrays.sort(ia);
        Object last = null;
        int duplicates = 0;
        int i3 = 0;
        while (i3 < ia.length) {
            if (last != null && ((Integer)last).compareTo((Integer)ia[i3]) == 0) {
                ++duplicates;
            }
            last = ia[i3];
            ++i3;
        }
        System.out.println("-------------------------------------------");
        System.out.println("Size=" + s_list.size() + " (should be 1000)");
        System.out.println("Duplicates=" + duplicates);
        System.out.println("Time (ms)=" + time + " - " + (float)time / (float)s_list.size() + " each");
        System.out.println("-------------------------------------------");
    }

    public static synchronized int getNextOfficialID_HTTP(String TableName) {
        String website = MSysConfig.getValue("DICTIONARY_ID_WEBSITE");
        String prm_USER = MSysConfig.getValue("DICTIONARY_ID_USER");
        String prm_PASSWORD = MSysConfig.getValue("DICTIONARY_ID_PASSWORD");
        String prm_TABLE = TableName;
        String prm_ALTKEY = "";
        String prm_COMMENT = Env.getContext(Env.getCtx(), "MigrationScriptComment");
        String prm_PROJECT = new String("Adempiere");
        return MSequence.getNextID_HTTP(TableName, website, prm_USER, prm_PASSWORD, prm_TABLE, prm_ALTKEY, prm_COMMENT, prm_PROJECT);
    }

    public static synchronized int getNextProjectID_HTTP(String TableName) {
        String website = MSysConfig.getValue("PROJECT_ID_WEBSITE");
        String prm_USER = MSysConfig.getValue("PROJECT_ID_USER");
        String prm_PASSWORD = MSysConfig.getValue("PROJECT_ID_PASSWORD");
        String prm_TABLE = TableName;
        String prm_ALTKEY = "";
        String prm_COMMENT = Env.getContext(Env.getCtx(), "MigrationScriptComment");
        String prm_PROJECT = MSysConfig.getValue("PROJECT_ID_PROJECT");
        return MSequence.getNextID_HTTP(TableName, website, prm_USER, prm_PASSWORD, prm_TABLE, prm_ALTKEY, prm_COMMENT, prm_PROJECT);
    }

    private static int getNextID_HTTP(String TableName, String website, String prm_USER, String prm_PASSWORD, String prm_TABLE, String prm_ALTKEY, String prm_COMMENT, String prm_PROJECT) {
        StringBuilder read = new StringBuilder();
        int retValue = -1;
        try {
            int bytes_read;
            String completeUrl = String.valueOf(website) + "?" + "USER=" + URLEncoder.encode(prm_USER, "UTF-8") + "&PASSWORD=" + URLEncoder.encode(prm_PASSWORD, "UTF-8") + "&PROJECT=" + URLEncoder.encode(prm_PROJECT, "UTF-8") + "&TABLE=" + URLEncoder.encode(prm_TABLE, "UTF-8") + "&ALTKEY=" + URLEncoder.encode(prm_ALTKEY, "UTF-8") + "&COMMENT=" + URLEncoder.encode(prm_COMMENT, "UTF-8");
            URL url = new URL(completeUrl);
            String protocol = url.getProtocol();
            if (!protocol.equals("https") && !protocol.equals("http")) {
                throw new IllegalArgumentException("URL must use 'http:' or 'https:' protocol");
            }
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setAllowUserInteraction(false);
            InputStream is = conn.getInputStream();
            byte[] buffer = new byte[4096];
            while ((bytes_read = is.read(buffer)) != -1) {
                int i2 = 0;
                while (i2 < bytes_read) {
                    if (buffer[i2] != 10) {
                        read.append((char)buffer[i2]);
                    }
                    ++i2;
                }
            }
            conn.disconnect();
            retValue = Integer.parseInt(read.toString());
            if (retValue <= 0) {
                retValue = -1;
            }
        }
        catch (Exception e) {
            System.err.println(e);
            retValue = -1;
        }
        if (s_log.isLoggable(Level.INFO)) {
            s_log.log(Level.INFO, "getNextID_HTTP - " + TableName + "=" + read + "(" + retValue + ")");
        }
        return retValue;
    }

    public static boolean isExceptionCentralized(String tableName) {
        String[] stringArray = dontUseCentralized;
        int n = dontUseCentralized.length;
        int n2 = 0;
        while (n2 < n) {
            String exceptionTable = stringArray[n2];
            if (tableName.equalsIgnoreCase(exceptionTable)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static synchronized boolean isTableWithEntityType(String tableName) {
        if (tablesWithEntityType.size() == 0) {
            String sql = "SELECT TableName FROM AD_Table WHERE AD_Table_ID IN (SELECT AD_Table_ID FROM AD_Column WHERE ColumnName='EntityType') ORDER BY TableName";
            List<List<Object>> list = DB.getSQLArrayObjectsEx(null, "SELECT TableName FROM AD_Table WHERE AD_Table_ID IN (SELECT AD_Table_ID FROM AD_Column WHERE ColumnName='EntityType') ORDER BY TableName", new Object[0]);
            for (List<Object> row : list) {
                tablesWithEntityType.put((String)row.get(0), "");
            }
        }
        return tablesWithEntityType.get(tableName) != null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isStartNewMonth() && !this.isStartNewYear()) {
            this.setStartNewMonth(false);
        }
        return true;
    }

    public static String getPreliminaryNo(GridTab tab, int AD_Sequence_ID) {
        String prelim = null;
        if (AD_Sequence_ID > 0) {
            String decimalPattern;
            MSequence seq = new MSequence(Env.getCtx(), AD_Sequence_ID, null);
            boolean startNewYear = seq.isStartNewYear();
            boolean startNewMonth = seq.isStartNewMonth();
            boolean orgLevelSeq = seq.isOrgLevelSequence();
            int currentNext = seq.getCurrentNext();
            if (startNewYear || orgLevelSeq) {
                String orgColumn;
                Object orgObj;
                String cym = NoYearNorMonth;
                int org = 0;
                if (startNewYear || startNewMonth) {
                    Date d = (Date)tab.getValue(seq.getDateColumn());
                    if (d == null) {
                        d = new Date();
                    }
                    SimpleDateFormat sdf = null;
                    sdf = startNewMonth ? new SimpleDateFormat("yyyyMM") : new SimpleDateFormat("yyyy");
                    cym = sdf.format(d);
                }
                if (orgLevelSeq && (orgObj = tab.getValue(orgColumn = seq.getOrgColumn())) != null) {
                    org = (Integer)orgObj;
                }
                String sql = "SELECT CurrentNext FROM AD_Sequence_No WHERE AD_Sequence_ID=? AND CalendarYearMonth=? AND AD_Org_ID=?";
                currentNext = DB.getSQLValue(null, sql, AD_Sequence_ID, cym, org);
            }
            prelim = (decimalPattern = seq.getDecimalPattern()) != null && decimalPattern.length() > 0 ? new DecimalFormat(decimalPattern).format(currentNext) : String.valueOf(currentNext);
        }
        if (prelim == null) {
            prelim = "?";
        }
        return "<" + prelim + ">";
    }

    @Override
    public String getOrgColumn() {
        if (super.getOrgColumn() == null) {
            return "AD_Org_ID";
        }
        return super.getOrgColumn();
    }

    public static class GetIDs
    implements Runnable {
        private int m_i;

        public GetIDs(int i2) {
            this.m_i = i2;
        }

        @Override
        public void run() {
            int i2 = 0;
            while (i2 < 100) {
                try {
                    int no = DB.getNextID(0, "Test", null);
                    s_list.add(no);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                ++i2;
            }
        }
    }
}

