/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MOrg;
import org.compiere.model.MRole;
import org.compiere.model.X_AD_Role_OrgAccess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MRoleOrgAccess
extends X_AD_Role_OrgAccess {
    private static final long serialVersionUID = 4664267788838719168L;
    private static CLogger s_log = CLogger.getCLogger(MRoleOrgAccess.class);
    private String m_clientName;
    private String m_orgName;

    public static MRoleOrgAccess[] getOfRole(Properties ctx, int AD_Role_ID) {
        return MRoleOrgAccess.get(ctx, "SELECT * FROM AD_Role_OrgAccess WHERE AD_Role_ID=?", AD_Role_ID);
    }

    public static MRoleOrgAccess[] getOfClient(Properties ctx, int AD_Client_ID) {
        return MRoleOrgAccess.get(ctx, "SELECT * FROM AD_Role_OrgAccess WHERE AD_Client_ID=?", AD_Client_ID);
    }

    public static MRoleOrgAccess[] getOfOrg(Properties ctx, int AD_Org_ID) {
        return MRoleOrgAccess.get(ctx, "SELECT * FROM AD_Role_OrgAccess WHERE AD_Org_ID=?", AD_Org_ID);
    }

    private static MRoleOrgAccess[] get(Properties ctx, String sql, int id) {
        ArrayList<MRoleOrgAccess> list;
        block6: {
            list = new ArrayList<MRoleOrgAccess>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, id);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRoleOrgAccess(ctx, rs, null));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, "get", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MRoleOrgAccess[] retValue = new MRoleOrgAccess[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static boolean createForOrg(MOrg org) {
        int counter = 0;
        MRole[] roles = MRole.getOfClient(org.getCtx(), org.get_TrxName());
        int i2 = 0;
        while (i2 < roles.length) {
            MRoleOrgAccess orgAccess;
            if (!roles[i2].isManual() && (orgAccess = new MRoleOrgAccess(org, roles[i2].getAD_Role_ID())).save()) {
                ++counter;
            }
            ++i2;
        }
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info(org + " - created #" + counter);
        }
        return counter != 0;
    }

    public MRoleOrgAccess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRoleOrgAccess(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setIsReadOnly(false);
    }

    public MRoleOrgAccess(MOrg org, int AD_Role_ID) {
        this(org.getCtx(), 0, org.get_TrxName());
        this.setClientOrg(org);
        this.setAD_Role_ID(AD_Role_ID);
    }

    public MRoleOrgAccess(MRole role, int AD_Org_ID) {
        this(role.getCtx(), 0, role.get_TrxName());
        this.setClientOrg(role.getAD_Client_ID(), AD_Org_ID);
        this.setAD_Role_ID(role.getAD_Role_ID());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRoleOrgAccess[");
        sb.append("AD_Role_ID=").append(this.getAD_Role_ID()).append(",AD_Client_ID=").append(this.getAD_Client_ID()).append(",AD_Org_ID=").append(this.getAD_Org_ID()).append(",RO=").append(this.isReadOnly());
        sb.append("]");
        return sb.toString();
    }

    public String toStringX(Properties ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append(Msg.translate(ctx, "AD_Client_ID")).append("=").append(this.getClientName()).append(" - ").append(Msg.translate(ctx, "AD_Org_ID")).append("=").append(this.getOrgName());
        return sb.toString();
    }

    public String getClientName() {
        block7: {
            if (this.m_clientName == null) {
                String sql = "SELECT c.Name, o.Name FROM AD_Client c INNER JOIN AD_Org o ON (c.AD_Client_ID=o.AD_Client_ID) WHERE o.AD_Org_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setInt(1, this.getAD_Org_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_clientName = rs.getString(1);
                            this.m_orgName = rs.getString(2);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "getClientName", e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                Object var2_2 = null;
            }
        }
        return this.m_clientName;
    }

    public String getOrgName() {
        if (this.m_orgName == null) {
            this.getClientName();
        }
        return this.m_orgName;
    }
}

