/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MProduct;
import org.compiere.model.X_S_ResourceType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MResourceType
extends X_S_ResourceType
implements ImmutablePOSupport {
    private static final long serialVersionUID = 1738229111191830237L;
    private static ImmutableIntPOCache<Integer, MResourceType> s_cache = new ImmutableIntPOCache("S_ResourceType", 20);

    public static MResourceType get(int S_ResourceType_ID) {
        return MResourceType.get(Env.getCtx(), S_ResourceType_ID);
    }

    public static MResourceType get(Properties ctx, int S_ResourceType_ID) {
        if (S_ResourceType_ID <= 0) {
            return null;
        }
        MResourceType type = s_cache.get(ctx, S_ResourceType_ID, e -> new MResourceType(ctx, (MResourceType)e));
        if (type == null) {
            type = new MResourceType(ctx, S_ResourceType_ID, null);
            if (type.get_ID() == S_ResourceType_ID) {
                s_cache.put(S_ResourceType_ID, type, e -> new MResourceType(Env.getCtx(), (MResourceType)e));
                return type;
            }
            return null;
        }
        return type;
    }

    public static MResourceType getCopy(Properties ctx, int S_ResourceType_ID, String trxName) {
        MResourceType rt = MResourceType.get(S_ResourceType_ID);
        if (rt != null) {
            rt = new MResourceType(ctx, rt, trxName);
        }
        return rt;
    }

    public MResourceType(Properties ctx, int S_ResourceType_ID, String trxName) {
        super(ctx, S_ResourceType_ID, trxName);
    }

    public MResourceType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MResourceType(MResourceType copy) {
        this(Env.getCtx(), copy);
    }

    public MResourceType(Properties ctx, MResourceType copy) {
        this(ctx, copy, null);
    }

    public MResourceType(Properties ctx, MResourceType copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isTimeSlot()) {
            Timestamp start = this.getTimeSlotStart();
            if (start == null) {
                throw new FillMandatoryException(new String[]{"TimeSlotStart"});
            }
            Timestamp end = this.getTimeSlotEnd();
            if (end == null) {
                throw new FillMandatoryException(new String[]{"TimeSlotEnd"});
            }
            if (start.compareTo(end) >= 0) {
                throw new AdempiereException("@TimeSlotStart@ > @TimeSlotEnd@");
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        if (!newRecord) {
            MProduct[] products = MProduct.get(this.getCtx(), "S_Resource_ID IN (SELECT S_Resource_ID FROM S_Resource WHERE S_ResourceType_ID=" + this.getS_ResourceType_ID() + ")", this.get_TrxName());
            int i2 = 0;
            while (i2 < products.length) {
                MProduct product = products[i2];
                if (product.setResource(this)) {
                    product.saveEx(this.get_TrxName());
                }
                ++i2;
            }
        }
        return success;
    }

    public Timestamp getDayStart(Timestamp date) {
        if (this.isTimeSlot()) {
            return TimeUtil.getDayBorder(date, this.getTimeSlotStart(), false);
        }
        return TimeUtil.getDayBorder(date, null, false);
    }

    public Timestamp getDayEnd(Timestamp date) {
        if (this.isTimeSlot()) {
            return TimeUtil.getDayBorder(date, this.getTimeSlotEnd(), true);
        }
        return TimeUtil.getDayBorder(date, null, true);
    }

    public long getDayDurationMillis() {
        if (this.isTimeSlot()) {
            return this.getTimeSlotEnd().getTime() - this.getTimeSlotStart().getTime();
        }
        return 86400000L;
    }

    public int getTimeSlotHours() {
        long hours = this.isTimeSlot() ? (this.getTimeSlotEnd().getTime() - this.getTimeSlotStart().getTime()) / 3600000L : 24L;
        return (int)hours;
    }

    public int getAvailableDaysWeek() {
        int availableDays = 0;
        if (this.isDateSlot()) {
            if (this.isOnMonday()) {
                ++availableDays;
            }
            if (this.isOnTuesday()) {
                ++availableDays;
            }
            if (this.isOnThursday()) {
                ++availableDays;
            }
            if (this.isOnWednesday()) {
                ++availableDays;
            }
            if (this.isOnFriday()) {
                ++availableDays;
            }
            if (this.isOnSaturday()) {
                ++availableDays;
            }
            if (this.isOnSunday()) {
                ++availableDays;
            }
        } else {
            availableDays = 7;
        }
        return availableDays;
    }

    public boolean isDayAvailable(Timestamp dateTime) {
        if (!this.isActive()) {
            return false;
        }
        if (!this.isDateSlot()) {
            return true;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(dateTime.getTime());
        boolean retValue = false;
        switch (gc.get(7)) {
            case 1: {
                retValue = this.isOnSunday();
                break;
            }
            case 2: {
                retValue = this.isOnMonday();
                break;
            }
            case 3: {
                retValue = this.isOnTuesday();
                break;
            }
            case 4: {
                retValue = this.isOnWednesday();
                break;
            }
            case 5: {
                retValue = this.isOnThursday();
                break;
            }
            case 6: {
                retValue = this.isOnFriday();
                break;
            }
            case 7: {
                retValue = this.isOnSaturday();
            }
        }
        return retValue;
    }

    public boolean isAvailable() {
        if (!this.isActive()) {
            return false;
        }
        return this.getAvailableDaysWeek() > 0 && this.getTimeSlotHours() > 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MResourceType[").append(this.get_ID()).append(",Value=").append(this.getValue()).append(",Name=").append(this.getName());
        if (this.isTimeSlot()) {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
            sb.append(",TimeSlot=");
            Timestamp start = this.getTimeSlotStart();
            Timestamp end = this.getTimeSlotEnd();
            sb.append(start != null ? df.format(start) : " - ");
            sb.append("-");
            sb.append(end != null ? df.format(end) : " - ");
        }
        if (this.isDateSlot()) {
            sb.append(",DaySlot=").append(this.isOnMonday() ? "M" : "-").append(this.isOnTuesday() ? "T" : "-").append(this.isOnWednesday() ? "W" : "-").append(this.isOnThursday() ? "T" : "-").append(this.isOnFriday() ? "F" : "-").append(this.isOnSaturday() ? "S" : "-").append(this.isOnSunday() ? "S" : "-");
        }
        return sb.append("]").toString();
    }

    @Override
    public MResourceType markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

