/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.model.MResourceType;
import org.compiere.model.X_S_Resource;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MResource
extends X_S_Resource
implements ImmutablePOSupport {
    private static final long serialVersionUID = -6893347336885257619L;
    private static ImmutableIntPOCache<Integer, MResource> s_cache = new ImmutableIntPOCache("S_Resource", 20);
    private MResourceType m_resourceType = null;
    private MProduct m_product = null;

    public static MResource get(int S_Resource_ID) {
        return MResource.get(Env.getCtx(), S_Resource_ID);
    }

    public static MResource get(Properties ctx, int S_Resource_ID) {
        if (S_Resource_ID <= 0) {
            return null;
        }
        MResource r = s_cache.get(ctx, S_Resource_ID, e -> new MResource(ctx, (MResource)e));
        if (r == null) {
            r = new MResource(ctx, S_Resource_ID, null);
            if (r.get_ID() == S_Resource_ID) {
                s_cache.put(S_Resource_ID, r, e -> new MResource(Env.getCtx(), (MResource)e));
                return r;
            }
            return null;
        }
        return r;
    }

    public static MResource getCopy(Properties ctx, int S_Resource_ID, String trxName) {
        MResource rs = MResource.get(S_Resource_ID);
        if (rs != null) {
            rs = new MResource(ctx, rs, trxName);
        }
        return rs;
    }

    public MResource(Properties ctx, int S_Resource_ID, String trxName) {
        super(ctx, S_Resource_ID, trxName);
    }

    public MResource(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MResource(MResource copy) {
        this(Env.getCtx(), copy);
    }

    public MResource(Properties ctx, MResource copy) {
        this(ctx, copy, null);
    }

    public MResource(Properties ctx, MResource copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_resourceType = copy.m_resourceType != null ? new MResourceType(ctx, copy.m_resourceType, trxName) : null;
        this.m_product = copy.m_product != null ? new MProduct(ctx, copy.m_product, trxName) : null;
    }

    public MResourceType getResourceType() {
        if (this.m_resourceType == null && this.getS_ResourceType_ID() != 0) {
            this.m_resourceType = this.is_Immutable() ? MResourceType.get(this.getCtx(), this.getS_ResourceType_ID()) : MResourceType.getCopy(this.getCtx(), this.getS_ResourceType_ID(), this.get_TrxName());
        }
        return this.m_resourceType;
    }

    public MProduct getProduct() {
        if (this.m_product == null) {
            this.m_product = MProduct.forS_Resource_ID(this.getCtx(), this.getS_Resource_ID(), this.get_TrxName());
            if (!this.is_Immutable() && this.m_product != null) {
                this.m_product = new MProduct(this.getCtx(), this.m_product, this.get_TrxName());
            }
        } else if (!this.is_Immutable()) {
            this.m_product.set_TrxName(this.get_TrxName());
        }
        return this.m_product;
    }

    public int getC_UOM_ID() {
        return this.getProduct().getC_UOM_ID();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord) {
            if (this.getValue() == null || this.getValue().length() == 0) {
                this.setValue(this.getName());
            }
            this.m_product = new MProduct(this, this.getResourceType());
            this.m_product.saveEx(this.get_TrxName());
        }
        if (this.isManufacturingResource() && "PT".equals(this.getManufacturingResourceType()) && this.getPlanningHorizon() <= 0) {
            throw new AdempiereException("@PlanningHorizon@ <= @0@ !");
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        MProduct prod = this.getProduct();
        if (prod.setResource(this)) {
            prod.saveEx(this.get_TrxName());
        }
        return success;
    }

    @Override
    protected boolean beforeDelete() {
        MProduct product = this.getProduct();
        if (product != null && product.getM_Product_ID() > 0) {
            product.setS_Resource_ID(0);
            product.deleteEx(true);
        }
        return true;
    }

    @Override
    public MResource markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_product != null) {
            this.m_product.markImmutable();
        }
        if (this.m_resourceType != null) {
            this.m_resourceType.markImmutable();
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MResource[").append(this.get_ID()).append(", Value=").append(this.getValue()).append(", Name=").append(this.getName()).append("]");
        return sb.toString();
    }
}

