/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MCountry;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Region;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MRegion
extends X_C_Region
implements Comparator<Object>,
Serializable,
ImmutablePOSupport {
    private static final long serialVersionUID = 6956706379305907673L;
    private static ImmutablePOCache<Integer, MRegion> s_regions = new ImmutablePOCache("C_Region", "C_Region", 100, 0, false, 0);
    private static MRegion s_default = null;
    private static CLogger s_log = CLogger.getCLogger(MRegion.class);

    private static void loadAllRegions() {
        List regions;
        s_regions.clear();
        try {
            PO.setCrossTenantSafe();
            regions = new Query(Env.getCtx(), "C_Region", "", null).setOnlyActiveRecords(true).list();
        }
        finally {
            PO.clearCrossTenantSafe();
        }
        for (MRegion r : regions) {
            r.markImmutable();
            s_regions.put(r.getC_Region_ID(), r);
            if (!r.isDefault()) continue;
            s_default = r;
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine(String.valueOf(s_regions.size()) + " - default=" + s_default);
        }
    }

    public static synchronized MRegion get(int C_Region_ID) {
        return MRegion.get(Env.getCtx(), C_Region_ID);
    }

    public static synchronized MRegion get(Properties ctx, int C_Region_ID) {
        MRegion r;
        if (s_regions.size() == 0) {
            MRegion.loadAllRegions();
        }
        if ((r = s_regions.get(ctx, C_Region_ID, e -> new MRegion(ctx, (MRegion)e))) != null) {
            return r;
        }
        r = new MRegion(ctx, C_Region_ID, null);
        if (r.getC_Region_ID() == C_Region_ID) {
            s_regions.put(C_Region_ID, r, e -> new MRegion(Env.getCtx(), (MRegion)e));
            return r;
        }
        return null;
    }

    public static synchronized MRegion getDefault(Properties ctx) {
        return MRegion.getDefault();
    }

    public static synchronized MRegion getDefault() {
        if (s_regions.size() == 0) {
            MRegion.loadAllRegions();
        }
        return s_default;
    }

    public static synchronized MRegion[] getRegions(Properties ctx) {
        return MRegion.getRegions();
    }

    public static synchronized MRegion[] getRegions() {
        if (s_regions.size() == 0) {
            MRegion.loadAllRegions();
        }
        MRegion[] retValue = (MRegion[])s_regions.values().stream().toArray(MRegion[]::new);
        Arrays.sort(retValue, new MRegion(Env.getCtx(), 0, null));
        return retValue;
    }

    public static synchronized MRegion[] getRegions(Properties ctx, int C_Country_ID) {
        return MRegion.getRegions(C_Country_ID);
    }

    public static synchronized MRegion[] getRegions(int C_Country_ID) {
        if (s_regions.size() == 0) {
            MRegion.loadAllRegions();
        }
        MRegion[] retValue = (MRegion[])s_regions.values().stream().filter(e -> e.getC_Country_ID() == C_Country_ID).toArray(MRegion[]::new);
        Arrays.sort(retValue, new MRegion(Env.getCtx(), 0, null));
        return retValue;
    }

    public MRegion(Properties ctx, int C_Region_ID, String trxName) {
        super(ctx, C_Region_ID, trxName);
    }

    public MRegion(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRegion(MCountry country, String regionName) {
        super(country.getCtx(), 0, country.get_TrxName());
        this.setC_Country_ID(country.getC_Country_ID());
        this.setName(regionName);
    }

    public MRegion(MRegion copy) {
        this(Env.getCtx(), copy);
    }

    public MRegion(Properties ctx, MRegion copy) {
        this(ctx, copy, null);
    }

    public MRegion(Properties ctx, MRegion copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    public String toString() {
        return this.getTrlName();
    }

    public String getTrlName() {
        return this.getTrlName(Env.getAD_Language(Env.getCtx()));
    }

    public String getTrlName(String language) {
        return this.get_Translation("Name", language);
    }

    @Override
    public int compare(Object o1, Object o2) {
        String s2;
        String s1 = o1.toString();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = o2.toString()) == null) {
            s2 = "";
        }
        Collator collator = Collator.getInstance();
        return collator.compare(s1, s2);
    }

    @Override
    public MRegion markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        int C_Country_ID = 216;
        MCountry country = new MCountry(Env.getCtx(), C_Country_ID, null);
        MRegion temp = new MRegion(country, "\u5317\u6d77\u9053");
        temp.setDescription("\u5317\u6d77\u9053(Hokkaido)");
        temp.saveEx();
        temp = new MRegion(country, "\u9752\u68ee\u770c");
        temp.setDescription("\u9752\u68ee\u770c(Aomori)");
        temp.saveEx();
        temp = new MRegion(country, "\u5ca9\u624b\u770c");
        temp.setDescription("\u5ca9\u624b\u770c(Iwate)");
        temp.saveEx();
        temp = new MRegion(country, "\u5bae\u57ce\u770c");
        temp.setDescription("\u5bae\u57ce\u770c(Miyagi)");
        temp.saveEx();
        temp = new MRegion(country, "\u79cb\u7530\u770c");
        temp.setDescription("\u79cb\u7530\u770c(Akita)");
        temp.saveEx();
        temp = new MRegion(country, "\u5c71\u5f62\u770c");
        temp.setDescription("\u5c71\u5f62\u770c(Yamagata)");
        temp.saveEx();
        temp = new MRegion(country, "\u798f\u5cf6\u770c");
        temp.setDescription("\u798f\u5cf6\u770c(Fukushima)");
        temp.saveEx();
        temp = new MRegion(country, "\u8328\u57ce\u770c");
        temp.setDescription("\u8328\u57ce\u770c(Ibaraki)");
        temp.saveEx();
        temp = new MRegion(country, "\u7fa4\u99ac\u770c");
        temp.setDescription("\u7fa4\u99ac\u770c(Gunma)");
        temp.saveEx();
        temp = new MRegion(country, "\u57fc\u7389\u770c");
        temp.setDescription("\u57fc\u7389\u770c(Saitama)");
        temp.saveEx();
        temp = new MRegion(country, "\u5343\u8449\u770c");
        temp.setDescription("\u5343\u8449\u770c(Chiba)");
        temp.saveEx();
        temp = new MRegion(country, "\u6771\u4eac\u90fd");
        temp.setDescription("\u6771\u4eac\u90fd(Tokyo)");
        temp.saveEx();
        temp = new MRegion(country, "\u795e\u5948\u5ddd\u770c");
        temp.setDescription("\u795e\u5948\u5ddd\u770c(Kanagawa)");
        temp.saveEx();
        temp = new MRegion(country, "\u65b0\u6f5f\u770c");
        temp.setDescription("\u65b0\u6f5f\u770c(Niigata)");
        temp.saveEx();
        temp = new MRegion(country, "\u5bcc\u5c71\u770c");
        temp.setDescription("\u5bcc\u5c71\u770c(Toyama)");
        temp.saveEx();
        temp = new MRegion(country, "\u77f3\u5ddd\u770c");
        temp.setDescription("\u77f3\u5ddd\u770c(Ishikawa)");
        temp.saveEx();
        temp = new MRegion(country, "\u798f\u4e95\u770c");
        temp.setDescription("\u798f\u4e95\u770c(Fukui)");
        temp.saveEx();
        temp = new MRegion(country, "\u5c71\u68a8\u770c");
        temp.setDescription("\u5c71\u68a8\u770c(Yamanashi)");
        temp.saveEx();
        temp = new MRegion(country, "\u5c90\u961c\u770c");
        temp.setDescription("\u5c90\u961c\u770c(Gifu)");
        temp.saveEx();
        temp = new MRegion(country, "\u9759\u5ca1\u770c");
        temp.setDescription("\u9759\u5ca1\u770c(Shizuoka)");
        temp.saveEx();
        temp = new MRegion(country, "\u611b\u77e5\u770c");
        temp.setDescription("\u611b\u77e5\u770c(Aichi)");
        temp.saveEx();
        temp = new MRegion(country, "\u4e09\u91cd\u770c");
        temp.setDescription("\u4e09\u91cd\u770c(Mie)");
        temp.saveEx();
        temp = new MRegion(country, "\u6ecb\u8cc0\u770c");
        temp.setDescription("\u6ecb\u8cc0\u770c(Siga)");
        temp.saveEx();
        temp = new MRegion(country, "\u4eac\u90fd\u5e9c");
        temp.setDescription("\u4eac\u90fd\u5e9c(Kyoto)");
        temp.saveEx();
        temp = new MRegion(country, "\u5927\u962a\u5e9c");
        temp.setDescription("\u5927\u962a\u5e9c(Osaka)");
        temp.saveEx();
        temp = new MRegion(country, "\u5175\u5eab\u770c");
        temp.setDescription("\u5175\u5eab\u770c(Hyogo)");
        temp.saveEx();
        temp = new MRegion(country, "\u5948\u826f\u770c");
        temp.setDescription("\u5948\u826f\u770c(Nara)");
        temp.saveEx();
        temp = new MRegion(country, "\u548c\u6b4c\u5c71\u770c");
        temp.setDescription("\u548c\u6b4c\u5c71\u770c(Wakayama)");
        temp.saveEx();
        temp = new MRegion(country, "\u9ce5\u53d6\u770c");
        temp.setDescription("\u9ce5\u53d6\u770c(Tottori)");
        temp.saveEx();
        temp = new MRegion(country, "\u5cf6\u6839\u770c");
        temp.setDescription("\u5cf6\u6839\u770c(Shimane)");
        temp.saveEx();
        temp = new MRegion(country, "\u5ca1\u5c71\u770c");
        temp.setDescription("\u5ca1\u5c71\u770c(Okayama)");
        temp.saveEx();
        temp = new MRegion(country, "\u5e83\u5cf6\u770c");
        temp.setDescription("\u5e83\u5cf6\u770c(Hiroshima)");
        temp.saveEx();
        temp = new MRegion(country, "\u5c71\u53e3\u770c");
        temp.setDescription("\u5c71\u53e3\u770c(Yamaguchi)");
        temp.saveEx();
        temp = new MRegion(country, "\u5fb3\u5cf6\u770c");
        temp.setDescription("\u5fb3\u5cf6\u770c(Tokushima)");
        temp.saveEx();
        temp = new MRegion(country, "\u9999\u5ddd\u770c");
        temp.setDescription("\u9999\u5ddd\u770c(Kagawa)");
        temp.saveEx();
        temp = new MRegion(country, "\u611b\u5a9b\u770c");
        temp.setDescription("\u611b\u5a9b\u770c(Ehime)");
        temp.saveEx();
        temp = new MRegion(country, "\u9ad8\u77e5\u770c");
        temp.setDescription("\u9ad8\u77e5\u770c(Kouchi)");
        temp.saveEx();
        temp = new MRegion(country, "\u798f\u5ca1\u770c");
        temp.setDescription("\u798f\u5ca1\u770c(Fukuoka)");
        temp.saveEx();
        temp = new MRegion(country, "\u4f50\u8cc0\u770c");
        temp.setDescription("\u4f50\u8cc0\u770c(Saga)");
        temp.saveEx();
        temp = new MRegion(country, "\u9577\u5d0e\u770c");
        temp.setDescription("\u9577\u5d0e\u770c(Nagasaki)");
        temp.saveEx();
        temp = new MRegion(country, "\u718a\u672c\u770c");
        temp.setDescription("\u718a\u672c\u770c(Kumamoto)");
        temp.saveEx();
        temp = new MRegion(country, "\u5927\u5206\u770c");
        temp.setDescription("\u5927\u5206\u770c(Ohita)");
        temp.saveEx();
        temp = new MRegion(country, "\u5bae\u5d0e\u770c");
        temp.setDescription("\u5bae\u5d0e\u770c(Miyasaki)");
        temp.saveEx();
        temp = new MRegion(country, "\u9e7f\u5150\u5cf6\u770c");
        temp.setDescription("\u9e7f\u5150\u5cf6\u770c(Kagoshima)");
        temp.saveEx();
        temp = new MRegion(country, "\u6c96\u7e04\u770c");
        temp.setDescription("\u6c96\u7e04\u770c(Okinawa)");
        temp.saveEx();
    }
}

