/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MReference;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Ref_List;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MRefList
extends X_AD_Ref_List
implements ImmutablePOSupport {
    private static final long serialVersionUID = -2704284822855131148L;
    private static ImmutablePOCache<String, MRefList> s_ref_value_cache = new ImmutablePOCache("AD_Ref_List", 40);
    private static CLogger s_log = CLogger.getCLogger(MRefList.class);
    private static CCache<String, String> s_cache = new CCache("AD_Ref_List", 20);

    public static synchronized MRefList get(Properties ctx, int AD_Reference_ID, String Value, String trxName) {
        StringBuilder sb = new StringBuilder(String.valueOf(AD_Reference_ID)).append("|").append(Value);
        String key = sb.toString();
        MRefList rl = s_ref_value_cache.get(ctx, key, e -> new MRefList(ctx, (MRefList)e));
        if (rl == null && (rl = (MRefList)new Query(ctx, "AD_Ref_List", "AD_Reference_ID=? AND Value=?", trxName).setParameters(AD_Reference_ID, Value).first()) != null) {
            s_ref_value_cache.put(key, rl, e -> new MRefList(Env.getCtx(), (MRefList)e));
        }
        return rl;
    }

    public MRefList(Properties ctx, MRefList copy) {
        this(ctx, copy, null);
    }

    public MRefList(Properties ctx, MRefList copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public static String getListName(Properties ctx, int AD_Reference_ID, String Value) {
        String AD_Language = Env.getAD_Language(ctx);
        return MRefList.getListName(AD_Language, AD_Reference_ID, Value);
    }

    public static String getListName(String AD_Language, int AD_Reference_ID, String Value) {
        String retValue;
        String key;
        block9: {
            key = String.valueOf(AD_Language) + "_" + AD_Reference_ID + "_" + Value;
            retValue = s_cache.get(key);
            if (retValue != null) {
                return retValue;
            }
            boolean isBaseLanguage = Env.isBaseLanguage(AD_Language, "AD_Ref_List");
            String sql = isBaseLanguage ? "SELECT Name FROM AD_Ref_List WHERE AD_Reference_ID=? AND Value=?" : "SELECT t.Name FROM AD_Ref_List_Trl t INNER JOIN AD_Ref_List r ON (r.AD_Ref_List_ID=t.AD_Ref_List_ID) WHERE r.AD_Reference_ID=? AND r.Value=? AND t.AD_Language=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Reference_ID);
                    pstmt.setString(2, Value);
                    if (!isBaseLanguage) {
                        pstmt.setString(3, AD_Language);
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        retValue = rs.getString(1);
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, String.valueOf(sql) + " -- " + key, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            retValue = "";
            s_log.warning("Not found " + key);
        }
        s_cache.put(key, retValue);
        return retValue;
    }

    public static String getListDescription(Properties ctx, String ListName, String Value) {
        String AD_Language = Env.getAD_Language(ctx);
        return MRefList.getListDescription(AD_Language, ListName, Value);
    }

    public static String getListDescription(String AD_Language, String ListName, String Value) {
        String retValue;
        String key;
        block10: {
            key = String.valueOf(AD_Language) + "_" + ListName + "_" + Value;
            retValue = s_cache.get(key);
            if (retValue != null) {
                return retValue;
            }
            boolean isBaseLanguage = Env.isBaseLanguage(AD_Language, "AD_Ref_List");
            String sql = isBaseLanguage ? "SELECT a.Description FROM AD_Ref_List a, AD_Reference b WHERE b.Name=? AND a.Value=? AND a.AD_Reference_ID = b.AD_Reference_ID" : "SELECT t.Description FROM AD_Reference r INNER JOIN AD_Ref_List rl ON (r.AD_Reference_ID=rl.AD_Reference_ID) INNER JOIN AD_Ref_List_Trl t ON (t.AD_Ref_List_ID=rl.AD_Ref_List_ID) WHERE r.Name=? AND rl.Value=? AND t.AD_Language=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setString(1, ListName);
                    pstmt.setString(2, Value);
                    if (!isBaseLanguage) {
                        pstmt.setString(3, AD_Language);
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        retValue = rs.getString(1);
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, String.valueOf(sql) + " -- " + key, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            retValue = "";
            if (s_log.isLoggable(Level.INFO)) {
                s_log.info("getListDescription - Not found " + key);
            }
        }
        s_cache.put(key, retValue);
        return retValue;
    }

    public static ValueNamePair[] getList(Properties ctx, int AD_Reference_ID, boolean optional) {
        return MRefList.getList(ctx, AD_Reference_ID, optional, "");
    }

    public static ValueNamePair[] getList(Properties ctx, int AD_Reference_ID, boolean optional, String orderBy) {
        return MRefList.getList(ctx, AD_Reference_ID, optional, "", orderBy);
    }

    public static ValueNamePair[] getList(Properties ctx, int AD_Reference_ID, boolean optional, String additionalWhereClause, String orderBy) {
        String language = Env.getAD_Language(ctx);
        boolean orderByValue = MReference.get(AD_Reference_ID).isOrderByValue();
        if (Util.isEmpty(orderBy) || "N".equals(orderBy)) {
            orderByValue = false;
        } else if ("V".equals(orderBy)) {
            orderByValue = true;
        }
        StringBuilder sql = new StringBuilder("SELECT AD_Ref_List.Value,");
        MClient client = MClient.get(Env.getCtx());
        StringBuilder AspFilter = new StringBuilder();
        if (client.isUseASP()) {
            AspFilter.append(" AND AD_Ref_List.AD_Ref_List_ID NOT IN ( ").append(" SELECT li.AD_Ref_List_ID").append(" FROM ASP_Ref_List li").append(" INNER JOIN ASP_Level l ON ( li.ASP_Level_ID = l.ASP_Level_ID)").append(" INNER JOIN ASP_ClientLevel cl on (l.ASP_Level_ID = cl.ASP_Level_ID)").append(" INNER JOIN AD_Client c on (cl.AD_Client_ID = c.AD_Client_ID)").append(" WHERE li.AD_Reference_ID=").append(AD_Reference_ID).append(" AND li.IsActive='Y'").append(" AND c.AD_Client_ID=").append(client.getAD_Client_ID()).append(" AND li.ASP_Status='H')");
        }
        if (Env.isBaseLanguage(language, "AD_Ref_List")) {
            sql.append("AD_Ref_List.Name,AD_Ref_List.IsActive FROM AD_Ref_List ");
        } else {
            sql.append("trl.Name, AD_Ref_List.IsActive ").append("FROM AD_Ref_List INNER JOIN AD_Ref_List_Trl trl ").append(" ON (AD_Ref_List.AD_Ref_List_ID=trl.AD_Ref_List_ID AND trl.AD_Language='").append(language).append("')");
        }
        sql.append(" WHERE AD_Ref_List.AD_Reference_ID=").append(AD_Reference_ID);
        if (!Util.isEmpty(additionalWhereClause, true)) {
            sql.append(" AND (").append(additionalWhereClause).append(")");
        }
        sql.append(AspFilter.toString());
        if (orderByValue) {
            sql.append(" ORDER BY 1");
        } else {
            sql.append(" ORDER BY 2");
        }
        return DB.getValueNamePairs(sql.toString(), optional, null);
    }

    public MRefList(Properties ctx, int AD_Ref_List_ID, String trxName) {
        super(ctx, AD_Ref_List_ID, trxName);
        if (AD_Ref_List_ID == 0) {
            this.setEntityType("U");
        }
    }

    public MRefList(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public PO markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

