/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.X_M_ProductionPlan;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MProductionPlan
extends X_M_ProductionPlan {
    private static final long serialVersionUID = 1830027775110768396L;

    public MProductionPlan(Properties ctx, int M_ProductionPlan_ID, String trxName) {
        super(ctx, M_ProductionPlan_ID, trxName);
    }

    public MProductionPlan(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProductionLine[] getLines() {
        ArrayList<MProductionLine> list = new ArrayList<MProductionLine>();
        String sql = "SELECT pl.M_ProductionLine_ID FROM M_ProductionLine pl WHERE pl.M_ProductionPlan_ID = ? ORDER BY pl.Line, pl.M_ProductionLine_ID ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.get_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(new MProductionLine(this.getCtx(), rs.getInt(1), this.get_TrxName()));
                }
            }
            catch (SQLException ex) {
                throw new AdempiereException("Unable to load production lines", ex);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MProductionLine[] retValue = new MProductionLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void deleteLines(String trxName) {
        MProductionLine[] mProductionLineArray = this.getLines();
        int n = mProductionLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MProductionLine line = mProductionLineArray[n2];
            line.deleteEx(true);
            ++n2;
        }
    }

    public int createLines(boolean mustBeStocked) {
        int lineno = 100;
        int count = 0;
        MProduct finishedProduct = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        MProductionLine line = new MProductionLine(this);
        line.setLine(lineno);
        line.setM_Product_ID(finishedProduct.get_ID());
        line.setM_Locator_ID(this.getM_Locator_ID());
        line.setMovementQty(this.getProductionQty());
        line.setPlannedQty(this.getProductionQty());
        line.saveEx();
        ++count;
        return count += this.createLines(mustBeStocked, finishedProduct, this.getProductionQty(), lineno);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int createLines(boolean mustBeStocked, MProduct finishedProduct, BigDecimal requiredQty, int lineno) {
        count = 0;
        defaultLocator = 0;
        finishedLocator = MLocator.get(this.getCtx(), this.getM_Locator_ID());
        M_Warehouse_ID = finishedLocator.getM_Warehouse_ID();
        sql = " SELECT bl.M_Product_ID, bl.QtyBOM FROM PP_Product_BOMLine bl JOIN PP_Product_BOM b ON b.PP_Product_BOM_ID = bl.PP_Product_BOM_ID  WHERE b.M_Product_ID=" + finishedProduct.getM_Product_ID() + " AND b.IsActive='Y' AND bl.IsActive='Y' " + " AND b.BOMType='A' AND b.BOMUse='A' " + " ORDER BY bl.Line";
        try {
            var10_10 = null;
            var11_13 = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                try {
                    rs = pstmt.executeQuery();
                    while (true) {
                        lineno += 10;
                        BOMProduct_ID = rs.getInt(1);
                        BOMQty = rs.getBigDecimal(2);
                        BOMMovementQty = BOMQty.multiply(requiredQty);
                        bomproduct = new MProduct(Env.getCtx(), BOMProduct_ID, this.get_TrxName());
                        if (bomproduct.isBOM() && bomproduct.isPhantom()) {
                            count += this.createLines(mustBeStocked, bomproduct, BOMMovementQty, lineno);
                        }
                        defaultLocator = bomproduct.getM_Locator_ID();
                        if (defaultLocator == 0) {
                            defaultLocator = this.getM_Locator_ID();
                        }
                        if (!bomproduct.isStocked()) {
                            BOMLine = null;
                            BOMLine = new MProductionLine(this);
                            BOMLine.setLine(lineno);
                            BOMLine.setM_Product_ID(BOMProduct_ID);
                            BOMLine.setM_Locator_ID(defaultLocator);
                            BOMLine.setQtyUsed(BOMMovementQty);
                            BOMLine.setPlannedQty(BOMMovementQty);
                            BOMLine.saveEx(this.get_TrxName());
                            lineno += 10;
                            ++count;
                        }
                        if (BOMMovementQty.signum() == 0) {
                            BOMLine = null;
                            BOMLine = new MProductionLine(this);
                            BOMLine.setLine(lineno);
                            BOMLine.setM_Product_ID(BOMProduct_ID);
                            BOMLine.setM_Locator_ID(defaultLocator);
                            BOMLine.setQtyUsed(BOMMovementQty);
                            BOMLine.setPlannedQty(BOMMovementQty);
                            BOMLine.saveEx(this.get_TrxName());
                            lineno += 10;
                            ++count;
                        }
                        storages = null;
                        usedProduct = MProduct.get(this.getCtx(), BOMProduct_ID);
                        defaultLocator = usedProduct.getM_Locator_ID();
                        if (defaultLocator == 0) {
                            defaultLocator = this.getM_Locator_ID();
                        }
                        if (usedProduct == null) return 0;
                        if (usedProduct.get_ID() == 0) {
                            return 0;
                        }
                        client = MClient.get(this.getCtx());
                        pc = MProductCategory.get(this.getCtx(), usedProduct.getM_Product_Category_ID());
                        MMPolicy = pc.getMMPolicy();
                        if (MMPolicy == null || MMPolicy.length() == 0) {
                            MMPolicy = client.getMMPolicy();
                        }
                        storages = MStorageOnHand.getWarehouse(this.getCtx(), M_Warehouse_ID, BOMProduct_ID, 0, null, "F".equals(MMPolicy), true, 0, this.get_TrxName());
                        BOMLine = null;
                        prevLoc = -1;
                        sl = 0;
                        while (sl < storages.length) {
                            lineQty = storages[sl].getQtyOnHand();
                            if (lineQty.signum() != 0) {
                                if (lineQty.compareTo(BOMMovementQty) > 0) {
                                    lineQty = BOMMovementQty;
                                }
                                if (prevLoc == (loc = storages[sl].getM_Locator_ID())) {
                                    BOMLine.setQtyUsed(BOMLine.getQtyUsed().add(lineQty));
                                    BOMLine.setPlannedQty(BOMLine.getQtyUsed());
                                    BOMLine.saveEx(this.get_TrxName());
                                } else {
                                    BOMLine = new MProductionLine(this);
                                    BOMLine.setLine(lineno);
                                    BOMLine.setM_Product_ID(BOMProduct_ID);
                                    BOMLine.setM_Locator_ID(loc);
                                    BOMLine.setQtyUsed(lineQty);
                                    BOMLine.setPlannedQty(lineQty);
                                    BOMLine.saveEx(this.get_TrxName());
                                    lineno += 10;
                                    ++count;
                                }
                                prevLoc = loc;
                                BOMMovementQty = BOMMovementQty.subtract(lineQty);
                                if (BOMMovementQty.signum() == 0) break;
                            }
                            ++sl;
                        }
                        if (BOMMovementQty.signum() != 0) {
                            if (mustBeStocked != false) throw new AdempiereUserError("Not enough stock of " + BOMProduct_ID);
                            if (prevLoc == defaultLocator) {
                                BOMLine.setQtyUsed(BOMLine.getQtyUsed().add(BOMMovementQty));
                                BOMLine.setPlannedQty(BOMLine.getQtyUsed());
                                BOMLine.saveEx(this.get_TrxName());
                            }
                            BOMLine = new MProductionLine(this);
                            BOMLine.setLine(lineno);
                            BOMLine.setM_Product_ID(BOMProduct_ID);
                            BOMLine.setM_Locator_ID(defaultLocator);
                            BOMLine.setQtyUsed(BOMMovementQty);
                            BOMLine.setPlannedQty(BOMMovementQty);
                            BOMLine.saveEx(this.get_TrxName());
                            lineno += 10;
                            ++count;
                        }
                        break;
                    }
                }
                finally {
                    if (rs.next()) ** continue;
                    return count;
                }
            }
            catch (Throwable var11_14) {
                if (var10_10 == null) {
                    var10_10 = var11_14;
                    throw var10_10;
                }
                if (var10_10 == var11_14) throw var10_10;
                var10_10.addSuppressed(var11_14);
                throw var10_10;
            }
        }
        catch (Exception e) {
            throw new AdempiereException("Failed to create production lines", e);
        }
    }

    @Override
    protected boolean beforeDelete() {
        this.deleteLines(this.get_TrxName());
        return true;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MProduction parent = new MProduction(this.getCtx(), this.getM_Production_ID(), this.get_TrxName());
        if (newRecord && parent.isProcessed()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_Production_ID"));
            return false;
        }
        return true;
    }
}

