/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.MClient;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductionLine;
import org.compiere.model.MProductionLineMA;
import org.compiere.model.MProductionPlan;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MSysConfig;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Production;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MProduction
extends X_M_Production
implements DocAction {
    private static final long serialVersionUID = 6714776372370644208L;
    protected static CLogger m_log = CLogger.getCLogger(MProduction.class);
    protected int lineno;
    protected int count;
    protected String m_processMsg = null;
    protected boolean m_justPrepared = false;

    public MProduction(Properties ctx, int M_Production_ID, String trxName) {
        this(ctx, M_Production_ID, trxName, null);
    }

    public MProduction(Properties ctx, int M_Production_ID, String trxName, String ... virtualColumns) {
        super(ctx, M_Production_ID, trxName, virtualColumns);
        if (M_Production_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("PR");
        }
    }

    public MProduction(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProduction(MOrderLine line) {
        super(line.getCtx(), 0, line.get_TrxName());
        this.setAD_Client_ID(line.getAD_Client_ID());
        this.setAD_Org_ID(line.getAD_Org_ID());
        this.setMovementDate(line.getDatePromised());
    }

    public MProduction(MProjectLine line) {
        super(line.getCtx(), 0, line.get_TrxName());
        MProject project = new MProject(line.getCtx(), line.getC_Project_ID(), line.get_TrxName());
        MWarehouse wh = new MWarehouse(line.getCtx(), project.getM_Warehouse_ID(), line.get_TrxName());
        MLocator M_Locator = null;
        int M_Locator_ID = 0;
        if (wh != null) {
            M_Locator = wh.getDefaultLocator();
            M_Locator_ID = M_Locator.getM_Locator_ID();
        }
        this.setAD_Client_ID(line.getAD_Client_ID());
        this.setAD_Org_ID(line.getAD_Org_ID());
        this.setM_Product_ID(line.getM_Product_ID());
        this.setProductionQty(line.getPlannedQty());
        this.setM_Locator_ID(M_Locator_ID);
        this.setDescription(String.valueOf(project.getValue()) + "_" + project.getName() + " Line: " + line.getLine() + " (project)");
        this.setC_Project_ID(line.getC_Project_ID());
        this.setC_BPartner_ID(project.getC_BPartner_ID());
        this.setC_Campaign_ID(project.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(project.getAD_OrgTrx_ID());
        this.setC_Activity_ID(project.getC_Activity_ID());
        this.setC_ProjectPhase_ID(line.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(line.getC_ProjectTask_ID());
        this.setMovementDate(Env.getContextAsDate(this.p_ctx, "#Date"));
    }

    @Override
    public String completeIt() {
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        StringBuilder errors = new StringBuilder();
        int processed = 0;
        if (!this.isUseProductionPlan()) {
            MProductionLine[] lines = this.getLines();
            if (!this.isHaveEndProduct(lines)) {
                this.m_processMsg = "Production does not contain End Product";
                return "IN";
            }
            errors.append(this.processLines(lines));
            if (errors.length() > 0) {
                this.m_processMsg = errors.toString();
                return "IN";
            }
            processed += lines.length;
        } else {
            Query planQuery = new Query(Env.getCtx(), "M_ProductionPlan", "M_ProductionPlan.M_Production_ID=?", this.get_TrxName());
            List plans = planQuery.setParameters(this.getM_Production_ID()).list();
            for (MProductionPlan plan : plans) {
                MProductionLine[] lines = plan.getLines();
                if (!this.isHaveEndProduct(lines)) {
                    this.m_processMsg = String.format("Production plan (line %1$d id %2$d) does not contain End Product", plan.getLine(), plan.get_ID());
                    return "IN";
                }
                if (lines.length > 0) {
                    errors.append(this.processLines(lines));
                    if (errors.length() > 0) {
                        this.m_processMsg = errors.toString();
                        return "IN";
                    }
                    processed += lines.length;
                }
                plan.setProcessed(true);
                plan.saveEx();
            }
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private boolean isHaveEndProduct(MProductionLine[] lines) {
        MProductionLine[] mProductionLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MProductionLine line = mProductionLineArray[n2];
            if (line.isEndProduct()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected Object processLines(MProductionLine[] lines) {
        StringBuilder errors = new StringBuilder();
        int i2 = 0;
        while (i2 < lines.length) {
            String error = lines[i2].createTransactions(this.getMovementDate(), false);
            if (!Util.isEmpty(error)) {
                errors.append(error);
            } else {
                lines[i2].setProcessed(true);
                lines[i2].saveEx(this.get_TrxName());
            }
            ++i2;
        }
        return errors.toString();
    }

    public MProductionLine[] getLines() {
        ArrayList<MProductionLine> list = new ArrayList<MProductionLine>();
        String sql = "SELECT pl.M_ProductionLine_ID FROM M_ProductionLine pl WHERE pl.M_Production_ID = ? ORDER BY pl.Line, pl.M_ProductionLine_ID ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.get_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(new MProductionLine(this.getCtx(), rs.getInt(1), this.get_TrxName()));
                }
            }
            catch (SQLException ex) {
                throw new AdempiereException("Unable to load production lines", ex);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MProductionLine[] retValue = new MProductionLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void deleteLines(String trxName) {
        MProductionLine[] mProductionLineArray = this.getLines();
        int n = mProductionLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MProductionLine line = mProductionLineArray[n2];
            line.deleteEx(true);
            ++n2;
        }
    }

    public int createLines(boolean mustBeStocked) {
        return this.createLines(mustBeStocked, 0);
    }

    public int createLines(boolean mustBeStocked, int PP_Product_BOM_ID) {
        this.lineno = 100;
        this.count = 0;
        MProduct finishedProduct = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        MProductionLine line = new MProductionLine(this);
        line.setLine(this.lineno);
        line.setM_Product_ID(finishedProduct.get_ID());
        line.setM_Locator_ID(this.getM_Locator_ID());
        line.setMovementQty(this.getProductionQty());
        line.setPlannedQty(this.getProductionQty());
        line.saveEx();
        ++this.count;
        if (PP_Product_BOM_ID > 0) {
            this.setPP_Product_BOM_ID(PP_Product_BOM_ID);
            this.saveEx();
        }
        this.createLines(mustBeStocked, finishedProduct, this.getProductionQty(), PP_Product_BOM_ID);
        return this.count;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int createLines(boolean mustBeStocked, MProduct finishedProduct, BigDecimal requiredQty, int PP_Product_BOM_ID) {
        defaultLocator = 0;
        finishedLocator = MLocator.get(this.getCtx(), this.getM_Locator_ID());
        M_Warehouse_ID = finishedLocator.getM_Warehouse_ID();
        sql = " SELECT bl.M_Product_ID, bl.QtyBOM FROM PP_Product_BOMLine bl JOIN PP_Product_BOM b ON b.PP_Product_BOM_ID = bl.PP_Product_BOM_ID  WHERE b.M_Product_ID=" + finishedProduct.getM_Product_ID() + " AND b.IsActive='Y' AND bl.IsActive='Y' ";
        sql = PP_Product_BOM_ID > 0 ? String.valueOf(sql) + " AND b.PP_Product_BOM_ID=" + PP_Product_BOM_ID : String.valueOf(sql) + " AND b.BOMType='A' AND b.BOMUse='A' ";
        sql = String.valueOf(sql) + " ORDER BY bl.Line";
        try {
            var9_9 = null;
            var10_12 = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                try {
                    rs = pstmt.executeQuery();
                    while (true) {
                        this.lineno += 10;
                        BOMProduct_ID = rs.getInt(1);
                        BOMQty = rs.getBigDecimal(2);
                        BOMMovementQty = BOMQty.multiply(requiredQty);
                        bomproduct = new MProduct(Env.getCtx(), BOMProduct_ID, this.get_TrxName());
                        if (bomproduct.isBOM() && bomproduct.isPhantom()) {
                            this.createLines(mustBeStocked, bomproduct, BOMMovementQty, 0);
                        }
                        defaultLocator = bomproduct.getM_Locator_ID();
                        if (defaultLocator == 0) {
                            defaultLocator = this.getM_Locator_ID();
                        }
                        if (!bomproduct.isStocked()) {
                            BOMLine = null;
                            BOMLine = new MProductionLine(this);
                            BOMLine.setLine(this.lineno);
                            BOMLine.setM_Product_ID(BOMProduct_ID);
                            BOMLine.setM_Locator_ID(defaultLocator);
                            BOMLine.setQtyUsed(BOMMovementQty);
                            BOMLine.setPlannedQty(BOMMovementQty);
                            BOMLine.saveEx(this.get_TrxName());
                            this.lineno += 10;
                            ++this.count;
                        }
                        if (BOMMovementQty.signum() == 0) {
                            BOMLine = null;
                            BOMLine = new MProductionLine(this);
                            BOMLine.setLine(this.lineno);
                            BOMLine.setM_Product_ID(BOMProduct_ID);
                            BOMLine.setM_Locator_ID(defaultLocator);
                            BOMLine.setQtyUsed(BOMMovementQty);
                            BOMLine.setPlannedQty(BOMMovementQty);
                            BOMLine.saveEx(this.get_TrxName());
                            this.lineno += 10;
                            ++this.count;
                        }
                        storages = null;
                        usedProduct = MProduct.get(this.getCtx(), BOMProduct_ID);
                        defaultLocator = usedProduct.getM_Locator_ID();
                        if (defaultLocator == 0) {
                            defaultLocator = this.getM_Locator_ID();
                        }
                        if (usedProduct == null) return 0;
                        if (usedProduct.get_ID() == 0) {
                            return 0;
                        }
                        client = MClient.get(this.getCtx());
                        pc = MProductCategory.get(this.getCtx(), usedProduct.getM_Product_Category_ID());
                        MMPolicy = pc.getMMPolicy();
                        if (MMPolicy == null || MMPolicy.length() == 0) {
                            MMPolicy = client.getMMPolicy();
                        }
                        storages = MStorageOnHand.getWarehouse(this.getCtx(), M_Warehouse_ID, BOMProduct_ID, 0, null, "F".equals(MMPolicy), true, 0, this.get_TrxName());
                        BOMLine = null;
                        prevLoc = -1;
                        sl = 0;
                        while (sl < storages.length) {
                            lineQty = storages[sl].getQtyOnHand();
                            if (lineQty.signum() != 0) {
                                if (lineQty.compareTo(BOMMovementQty) > 0) {
                                    lineQty = BOMMovementQty;
                                }
                                if (prevLoc == (loc = storages[sl].getM_Locator_ID())) {
                                    BOMLine.setQtyUsed(BOMLine.getQtyUsed().add(lineQty));
                                    BOMLine.setPlannedQty(BOMLine.getQtyUsed());
                                    BOMLine.saveEx(this.get_TrxName());
                                } else {
                                    BOMLine = new MProductionLine(this);
                                    BOMLine.setLine(this.lineno);
                                    BOMLine.setM_Product_ID(BOMProduct_ID);
                                    BOMLine.setM_Locator_ID(loc);
                                    BOMLine.setQtyUsed(lineQty);
                                    BOMLine.setPlannedQty(lineQty);
                                    BOMLine.saveEx(this.get_TrxName());
                                    this.lineno += 10;
                                    ++this.count;
                                }
                                prevLoc = loc;
                                BOMMovementQty = BOMMovementQty.subtract(lineQty);
                                if (BOMMovementQty.signum() == 0) break;
                            }
                            ++sl;
                        }
                        if (BOMMovementQty.signum() != 0) {
                            if (mustBeStocked != false) throw new AdempiereUserError("Not enough stock of " + BOMProduct_ID);
                            if (prevLoc == defaultLocator) {
                                BOMLine.setQtyUsed(BOMLine.getQtyUsed().add(BOMMovementQty));
                                BOMLine.setPlannedQty(BOMLine.getQtyUsed());
                                BOMLine.saveEx(this.get_TrxName());
                            }
                            BOMLine = new MProductionLine(this);
                            BOMLine.setLine(this.lineno);
                            BOMLine.setM_Product_ID(BOMProduct_ID);
                            BOMLine.setM_Locator_ID(defaultLocator);
                            BOMLine.setQtyUsed(BOMMovementQty);
                            BOMLine.setPlannedQty(BOMMovementQty);
                            BOMLine.saveEx(this.get_TrxName());
                            this.lineno += 10;
                            ++this.count;
                        }
                        break;
                    }
                }
                finally {
                    if (rs.next()) ** continue;
                    return this.count;
                }
            }
            catch (Throwable var10_13) {
                if (var9_9 == null) {
                    var9_9 = var10_13;
                    throw var9_9;
                }
                if (var9_9 == var10_13) throw var9_9;
                var9_9.addSuppressed(var10_13);
                throw var9_9;
            }
        }
        catch (Exception e) {
            throw new AdempiereException("Failed to create production lines", e);
        }
    }

    @Override
    protected boolean beforeDelete() {
        this.deleteLines(this.get_TrxName());
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), "MMP", this.getAD_Org_ID());
        if (this.getIsCreated().equals("N")) {
            this.m_processMsg = "Not created";
            return "IN";
        }
        if (!this.isUseProductionPlan()) {
            this.m_processMsg = this.validateEndProduct(this.getM_Product_ID());
            if (!Util.isEmpty(this.m_processMsg)) {
                return "IN";
            }
        } else {
            Query planQuery = new Query(this.getCtx(), "M_ProductionPlan", "M_ProductionPlan.M_Production_ID=?", this.get_TrxName());
            List plans = planQuery.setParameters(this.getM_Production_ID()).list();
            for (MProductionPlan plan : plans) {
                this.m_processMsg = this.validateEndProduct(plan.getM_Product_ID());
                if (Util.isEmpty(this.m_processMsg)) continue;
                return "IN";
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public String validateEndProduct(int M_Product_ID) {
        String msg = this.isBom(M_Product_ID);
        if (!Util.isEmpty(msg)) {
            return msg;
        }
        if (!this.costsOK(M_Product_ID)) {
            msg = "Excessive difference in standard costs";
            if (MSysConfig.getBooleanValue("MFG_ValidateCostsDifferenceOnCreate", false, this.getAD_Client_ID())) {
                return msg;
            }
            this.log.warning(msg);
        }
        return null;
    }

    protected String isBom(int M_Product_ID) {
        String bom = DB.getSQLValueString(this.get_TrxName(), "SELECT isbom FROM M_Product WHERE M_Product_ID = ?", M_Product_ID);
        if ("N".compareTo(bom) == 0) {
            return "Attempt to create product line for Non Bill Of Materials";
        }
        int materials = DB.getSQLValue(this.get_TrxName(), "SELECT count(bl.PP_Product_BOMLine_ID) FROM PP_Product_BOMLine bl JOIN PP_Product_BOM b ON b.PP_Product_BOM_ID = bl.PP_Product_BOM_ID WHERE b.M_Product_ID = ?  AND bl.IsActive='Y' AND b.IsActive='Y' AND b.BOMType='A' AND b.BOMUse='A' ", M_Product_ID);
        if (materials == 0) {
            return "Attempt to create product line for Bill Of Materials with no BOM Components";
        }
        return null;
    }

    protected boolean costsOK(int M_Product_ID) throws AdempiereUserError {
        MProduct product = MProduct.get(this.getCtx(), M_Product_ID, this.get_TrxName());
        String costingMethod = product.getCostingMethod(MClient.get(this.getCtx()).getAcctSchema());
        if ("S".equals(costingMethod)) {
            String sql = "SELECT ABS(((cc.currentcostprice-(SELECT SUM(c.currentcostprice*bom.qtybom) FROM m_cost c INNER JOIN pp_product_bomline bom ON (c.m_product_id=bom.m_product_id AND bom.IsActive='Y') JOIN pp_product_bom b ON (b.pp_product_bom_id = bom.pp_product_bom_id) WHERE b.m_product_id = pp.m_product_id and b.bomuse='A' and b.bomtype='A' AND b.IsActive='Y') )/cc.currentcostprice)) FROM m_product pp INNER JOIN m_cost cc on (cc.m_product_id=pp.m_product_id) INNER JOIN m_costelement ce ON (cc.m_costelement_id=ce.m_costelement_id) WHERE cc.currentcostprice > 0 AND pp.M_Product_ID = ? AND ce.costingmethod='S'";
            BigDecimal costPercentageDiff = DB.getSQLValueBD(this.get_TrxName(), sql, M_Product_ID);
            if (costPercentageDiff == null) {
                costPercentageDiff = Env.ZERO;
                String msg = "Could not retrieve costs";
                if (MSysConfig.getBooleanValue("MFG_ValidateCostsOnCreate", false, this.getAD_Client_ID())) {
                    throw new AdempiereUserError(msg);
                }
                this.log.warning(msg);
            }
            return costPercentageDiff.compareTo(new BigDecimal("0.005")) < 0;
        }
        return true;
    }

    @Override
    public boolean approveIt() {
        return true;
    }

    @Override
    public boolean rejectIt() {
        return true;
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.setIsCreated("N");
            if (!this.isUseProductionPlan()) {
                this.deleteLines(this.get_TrxName());
                this.setProductionQty(BigDecimal.ZERO);
            } else {
                Query planQuery = new Query(Env.getCtx(), "M_ProductionPlan", "M_ProductionPlan.M_Production_ID=?", this.get_TrxName());
                List plans = planQuery.setParameters(this.getM_Production_ID()).list();
                for (MProductionPlan plan : plans) {
                    plan.deleteLines(this.get_TrxName());
                    plan.setProductionQty(BigDecimal.ZERO);
                    plan.setProcessed(true);
                    plan.saveEx();
                }
            }
        } else {
            boolean accrual = false;
            try {
                MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), "MMP", this.getAD_Org_ID());
            }
            catch (PeriodClosedException e) {
                accrual = true;
            }
            if (accrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        if (this.getC_OrderLine_ID() > 0) {
            this.setC_OrderLine_ID(0);
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MProduction reversal = this.reverse(false);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        return true;
    }

    protected MProduction reverse(boolean accrual) {
        Timestamp reversalDate;
        Timestamp timestamp = reversalDate = accrual ? Env.getContextAsDate(this.getCtx(), "#Date") : this.getMovementDate();
        if (reversalDate == null) {
            reversalDate = new Timestamp(System.currentTimeMillis());
        }
        if (this.getC_OrderLine_ID() > 0) {
            this.setC_OrderLine_ID(0);
        }
        MPeriod.testPeriodOpen(this.getCtx(), reversalDate, "MMP", this.getAD_Org_ID());
        MProduction reversal = null;
        reversal = this.copyFrom(reversalDate);
        StringBuilder msgadd = new StringBuilder("{->").append(this.getDocumentNo()).append(")");
        reversal.addDescription(msgadd.toString());
        reversal.setReversal_ID(this.getM_Production_ID());
        reversal.saveEx(this.get_TrxName());
        MProductionLine[] sLines = this.getLines();
        MProductionLine[] tLines = reversal.getLines();
        int i2 = 0;
        while (i2 < sLines.length) {
            if (sLines[i2].getM_AttributeSetInstance_ID() == 0) {
                MProductionLineMA[] mas = MProductionLineMA.get(this.getCtx(), sLines[i2].get_ID(), this.get_TrxName());
                int j = 0;
                while (j < mas.length) {
                    MProductionLineMA ma = new MProductionLineMA(tLines[i2], mas[j].getM_AttributeSetInstance_ID(), mas[j].getMovementQty().negate(), mas[j].getDateMaterialPolicy());
                    ma.saveEx(this.get_TrxName());
                    ++j;
                }
            }
            ++i2;
        }
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return null;
        }
        reversal.closeIt();
        reversal.setProcessing(false);
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx(this.get_TrxName());
        msgadd = new StringBuilder("(").append(reversal.getDocumentNo()).append("<-)");
        this.addDescription(msgadd.toString());
        this.setProcessed(true);
        this.setReversal_ID(reversal.getM_Production_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        return reversal;
    }

    protected MProduction copyFrom(Timestamp reversalDate) {
        MProduction to = new MProduction(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues(this, to, this.getAD_Client_ID(), this.getAD_Org_ID());
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setMovementDate(reversalDate);
        to.setIsComplete(false);
        to.setIsCreated("Y");
        to.setProcessing(false);
        to.setProcessed(false);
        to.setIsUseProductionPlan(this.isUseProductionPlan());
        if (this.isUseProductionPlan()) {
            to.saveEx();
            Query planQuery = new Query(Env.getCtx(), "M_ProductionPlan", "M_ProductionPlan.M_Production_ID=?", this.get_TrxName());
            List fplans = planQuery.setParameters(this.getM_Production_ID()).list();
            for (MProductionPlan fplan : fplans) {
                MProductionLine[] flines;
                MProductionPlan tplan = new MProductionPlan(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues(fplan, tplan, this.getAD_Client_ID(), this.getAD_Org_ID());
                tplan.setM_Production_ID(to.getM_Production_ID());
                tplan.setProductionQty(fplan.getProductionQty().negate());
                tplan.setProcessed(false);
                tplan.saveEx();
                MProductionLine[] mProductionLineArray = flines = fplan.getLines();
                int n = flines.length;
                int n2 = 0;
                while (n2 < n) {
                    MProductionLine fline = mProductionLineArray[n2];
                    MProductionLine tline = new MProductionLine(tplan);
                    PO.copyValues(fline, tline, this.getAD_Client_ID(), this.getAD_Org_ID());
                    tline.setM_ProductionPlan_ID(tplan.getM_ProductionPlan_ID());
                    tline.setMovementQty(fline.getMovementQty().negate());
                    tline.setPlannedQty(fline.getPlannedQty().negate());
                    tline.setQtyUsed(fline.getQtyUsed().negate());
                    tline.saveEx();
                    ++n2;
                }
            }
        } else {
            MProductionLine[] flines;
            to.setProductionQty(this.getProductionQty().negate());
            to.saveEx();
            MProductionLine[] mProductionLineArray = flines = this.getLines();
            int n = flines.length;
            int n3 = 0;
            while (n3 < n) {
                MProductionLine fline = mProductionLineArray[n3];
                MProductionLine tline = new MProductionLine(to);
                PO.copyValues(fline, tline, this.getAD_Client_ID(), this.getAD_Org_ID());
                tline.setM_Production_ID(to.getM_Production_ID());
                tline.setMovementQty(fline.getMovementQty().negate());
                tline.setPlannedQty(fline.getPlannedQty().negate());
                tline.setQtyUsed(fline.getQtyUsed().negate());
                tline.saveEx();
                ++n3;
            }
        }
        return to;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        MProduction reversal = this.reverse(true);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        return true;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reActivateIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        return this.getDocumentNo();
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return MClient.get(this.getCtx()).getC_Currency_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return BigDecimal.ZERO;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getM_Product_ID() > 0) {
            if (this.isUseProductionPlan()) {
                this.setIsUseProductionPlan(false);
            }
        } else if (!this.isUseProductionPlan()) {
            this.setIsUseProductionPlan(true);
        }
        return true;
    }

    public boolean isStatusComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

