/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAssetGroup;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MExpenseType;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MProductDownload;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MStorageReservation;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_I_Product;
import org.compiere.model.X_M_Product;
import org.compiere.model.X_M_StorageReservation;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MProduct
extends X_M_Product
implements ImmutablePOSupport {
    private static final long serialVersionUID = 6847265056758898333L;
    private static ImmutableIntPOCache<Integer, MProduct> s_cache = new ImmutableIntPOCache("M_Product", 40, 5);
    private MProductDownload[] m_downloads = null;
    private Integer m_precision = null;

    public static MProduct get(int M_Product_ID) {
        return MProduct.get(Env.getCtx(), M_Product_ID);
    }

    public static MProduct get(Properties ctx, int M_Product_ID) {
        return MProduct.get(ctx, M_Product_ID, null);
    }

    public static MProduct get(Properties ctx, int M_Product_ID, String trxName) {
        if (M_Product_ID <= 0) {
            return null;
        }
        Integer key = M_Product_ID;
        MProduct retValue = s_cache.get(ctx, key, e -> new MProduct(ctx, (MProduct)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProduct(ctx, M_Product_ID, trxName);
        if (retValue.get_ID() == M_Product_ID) {
            s_cache.put(key, retValue, e -> new MProduct(Env.getCtx(), (MProduct)e));
            return retValue;
        }
        return null;
    }

    public static MProduct getCopy(Properties ctx, int M_Product_ID, String trxName) {
        MProduct product = MProduct.get(M_Product_ID);
        if (product != null) {
            product = new MProduct(ctx, product, trxName);
        }
        return product;
    }

    public static MProduct[] get(Properties ctx, String whereClause, String trxName) {
        List<MProduct> list = new Query(ctx, "M_Product", whereClause, trxName).setClient_ID().list();
        return list.toArray(new MProduct[list.size()]);
    }

    public static List<MProduct> getByUPC(Properties ctx, String upc, String trxName) {
        String whereClause = "UPC=?";
        Query q = new Query(ctx, "M_Product", "UPC=?", trxName);
        q.setParameters(upc).setClient_ID();
        return q.list();
    }

    public static MProduct forS_Resource_ID(Properties ctx, int S_Resource_ID) {
        return MProduct.forS_Resource_ID(ctx, S_Resource_ID, null);
    }

    public static MProduct forS_Resource_ID(Properties ctx, int S_Resource_ID, String trxName) {
        MProduct p2;
        if (S_Resource_ID <= 0) {
            return null;
        }
        if (trxName == null) {
            MProduct[] products;
            MProduct[] mProductArray = products = s_cache.values().toArray(new MProduct[0]);
            int n = products.length;
            int n2 = 0;
            while (n2 < n) {
                MProduct p3 = mProductArray[n2];
                if (p3.getS_Resource_ID() == S_Resource_ID) {
                    return p3;
                }
                ++n2;
            }
        }
        if ((p2 = (MProduct)new Query(ctx, "M_Product", "S_Resource_ID=?", trxName).setParameters(S_Resource_ID).firstOnly()) != null) {
            s_cache.put(p2.getM_Product_ID(), p2, e -> new MProduct(Env.getCtx(), (MProduct)e));
        }
        return p2;
    }

    public static boolean isProductStocked(Properties ctx, int M_Product_ID) {
        MProduct product = MProduct.get(ctx, M_Product_ID);
        return product.isStocked();
    }

    public MProduct(Properties ctx, int M_Product_ID, String trxName) {
        this(ctx, M_Product_ID, trxName, null);
    }

    public MProduct(Properties ctx, int M_Product_ID, String trxName, String ... virtualColumns) {
        super(ctx, M_Product_ID, trxName, virtualColumns);
        if (M_Product_ID == 0) {
            this.setProductType("I");
            this.setIsBOM(false);
            this.setIsInvoicePrintDetails(false);
            this.setIsPickListPrintDetails(false);
            this.setIsPurchased(true);
            this.setIsSold(true);
            this.setIsStocked(true);
            this.setIsSummary(false);
            this.setIsVerified(false);
            this.setIsWebStoreFeatured(false);
            this.setIsSelfService(true);
            this.setIsExcludeAutoDelivery(false);
            this.setProcessing(false);
            this.setLowLevel(0);
        }
    }

    public MProduct(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProduct(MExpenseType et) {
        this(et.getCtx(), 0, et.get_TrxName());
        this.setProductType("E");
        this.setExpenseType(et);
    }

    public MProduct(MResource resource, MResourceType resourceType) {
        this(resource.getCtx(), 0, resource.get_TrxName());
        this.setAD_Org_ID(resource.getAD_Org_ID());
        this.setProductType("R");
        this.setResource(resource);
        this.setResource(resourceType);
    }

    public MProduct(X_I_Product impP) {
        this(impP.getCtx(), 0, impP.get_TrxName());
        this.setClientOrg(impP);
        this.setUpdatedBy(impP.getUpdatedBy());
        this.setValue(impP.getValue());
        this.setName(impP.getName());
        this.setDescription(impP.getDescription());
        this.setDocumentNote(impP.getDocumentNote());
        this.setHelp(impP.getHelp());
        this.setUPC(impP.getUPC());
        this.setSKU(impP.getSKU());
        this.setC_UOM_ID(impP.getC_UOM_ID());
        this.setM_Product_Category_ID(impP.getM_Product_Category_ID());
        this.setProductType(impP.getProductType());
        this.setImageURL(impP.getImageURL());
        this.setDescriptionURL(impP.getDescriptionURL());
        this.setVolume(impP.getVolume());
        this.setWeight(impP.getWeight());
        this.setCustomsTariffNumber(impP.getCustomsTariffNumber());
        this.setGroup1(impP.getGroup1());
        this.setGroup2(impP.getGroup2());
    }

    public MProduct(MProduct copy) {
        this(Env.getCtx(), copy);
    }

    public MProduct(Properties ctx, MProduct copy) {
        this(ctx, copy, null);
    }

    public MProduct(Properties ctx, MProduct copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_downloads = copy.m_downloads != null ? (MProductDownload[])Arrays.stream(copy.m_downloads).map(e -> new MProductDownload(ctx, (MProductDownload)e, trxName)).toArray(MProductDownload[]::new) : null;
        this.m_precision = copy.m_precision;
    }

    public boolean setExpenseType(MExpenseType parent) {
        boolean changed = false;
        if (!"E".equals(this.getProductType())) {
            this.setProductType("E");
            changed = true;
        }
        if (parent.getS_ExpenseType_ID() != this.getS_ExpenseType_ID()) {
            this.setS_ExpenseType_ID(parent.getS_ExpenseType_ID());
            changed = true;
        }
        if (parent.isActive() != this.isActive()) {
            this.setIsActive(parent.isActive());
            changed = true;
        }
        if (!parent.getValue().equals(this.getValue())) {
            this.setValue(parent.getValue());
            changed = true;
        }
        if (!parent.getName().equals(this.getName())) {
            this.setName(parent.getName());
            changed = true;
        }
        if (parent.getDescription() == null && this.getDescription() != null || parent.getDescription() != null && !parent.getDescription().equals(this.getDescription())) {
            this.setDescription(parent.getDescription());
            changed = true;
        }
        if (parent.getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(parent.getC_UOM_ID());
            changed = true;
        }
        if (parent.getM_Product_Category_ID() != this.getM_Product_Category_ID()) {
            this.setM_Product_Category_ID(parent.getM_Product_Category_ID());
            changed = true;
        }
        if (parent.getC_TaxCategory_ID() != this.getC_TaxCategory_ID()) {
            this.setC_TaxCategory_ID(parent.getC_TaxCategory_ID());
            changed = true;
        }
        return changed;
    }

    public boolean setResource(MResource parent) {
        boolean changed = false;
        if (!"R".equals(this.getProductType())) {
            this.setProductType("R");
            changed = true;
        }
        if (parent.getS_Resource_ID() != this.getS_Resource_ID()) {
            this.setS_Resource_ID(parent.getS_Resource_ID());
            changed = true;
        }
        if (parent.isActive() != this.isActive()) {
            this.setIsActive(parent.isActive());
            changed = true;
        }
        if (!parent.getValue().equals(this.getValue())) {
            this.setValue(parent.getValue());
            changed = true;
        }
        if (!parent.getName().equals(this.getName())) {
            this.setName(parent.getName());
            changed = true;
        }
        if (parent.getDescription() == null && this.getDescription() != null || parent.getDescription() != null && !parent.getDescription().equals(this.getDescription())) {
            this.setDescription(parent.getDescription());
            changed = true;
        }
        return changed;
    }

    public boolean setResource(MResourceType parent) {
        boolean changed = false;
        if (!"R".equals(this.getProductType())) {
            this.setProductType("R");
            changed = true;
        }
        if (parent.getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(parent.getC_UOM_ID());
            changed = true;
        }
        if (parent.getM_Product_Category_ID() != this.getM_Product_Category_ID()) {
            this.setM_Product_Category_ID(parent.getM_Product_Category_ID());
            changed = true;
        }
        if (parent.getC_TaxCategory_ID() != this.getC_TaxCategory_ID()) {
            this.setC_TaxCategory_ID(parent.getC_TaxCategory_ID());
            changed = true;
        }
        return changed;
    }

    public int getUOMPrecision() {
        if (this.m_precision == null) {
            int C_UOM_ID = this.getC_UOM_ID();
            if (C_UOM_ID == 0) {
                return 0;
            }
            this.m_precision = MUOM.getPrecision(this.getCtx(), C_UOM_ID);
        }
        return this.m_precision;
    }

    public int getA_Asset_Group_ID() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        return pc.getA_Asset_Group_ID();
    }

    public boolean isCreateAsset() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        return pc.getA_Asset_Group_ID() != 0;
    }

    public MAttributeSet getAttributeSet() {
        if (this.getM_AttributeSet_ID() != 0) {
            return MAttributeSet.getCopy(this.getCtx(), this.getM_AttributeSet_ID(), this.get_TrxName());
        }
        return null;
    }

    public boolean isInstanceAttribute() {
        if (this.getM_AttributeSet_ID() == 0) {
            return false;
        }
        MAttributeSet mas = MAttributeSet.get(this.getCtx(), this.getM_AttributeSet_ID());
        return mas.isInstanceAttribute();
    }

    public boolean isOneAssetPerUOM() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        if (pc.getA_Asset_Group_ID() == 0) {
            return false;
        }
        MAssetGroup ag = MAssetGroup.get(this.getCtx(), pc.getA_Asset_Group_ID());
        return ag.isOneAssetPerUOM();
    }

    public boolean isItem() {
        return "I".equals(this.getProductType());
    }

    @Override
    public boolean isStocked() {
        return super.isStocked() && this.isItem();
    }

    public boolean isService() {
        return !this.isItem();
    }

    public String getUOMSymbol() {
        int C_UOM_ID = this.getC_UOM_ID();
        if (C_UOM_ID == 0) {
            return "";
        }
        return MUOM.get(this.getCtx(), C_UOM_ID).getUOMSymbol();
    }

    public MProductDownload[] getProductDownloads(boolean requery) {
        if (this.m_downloads != null && !requery) {
            return this.m_downloads;
        }
        List<MProductDownload> list = new Query(this.getCtx(), "M_ProductDownload", "M_Product_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setOrderBy("Name").setParameters(this.get_ID()).list();
        if (list.size() > 0 && this.is_Immutable()) {
            list.stream().forEach(e -> {
                MProductDownload mProductDownload = e.markImmutable();
            });
        }
        this.m_downloads = list.toArray(new MProductDownload[list.size()]);
        return this.m_downloads;
    }

    public boolean hasDownloads() {
        return this.getProductDownloads(false).length > 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MProduct[");
        sb.append(this.get_ID()).append("-").append(this.getValue()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int oldasiid;
        MAttributeSetInstance asi;
        if (!newRecord && (this.is_ValueChanged("IsActive") && !this.isActive() || this.is_ValueChanged("IsStocked") && !this.isStocked() || this.is_ValueChanged("ProductType") && "I".equals(this.get_ValueOld("ProductType")))) {
            String errMsg = this.verifyStorage();
            if (!Util.isEmpty(errMsg)) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), errMsg));
                return false;
            }
            this.removeStorageRecords();
            if (this.is_ValueChanged("IsActive") && !this.isActive() && !Util.isEmpty(errMsg = this.verifyBOM())) {
                this.log.saveError("Error", errMsg);
                return false;
            }
        }
        if (!newRecord && this.is_ValueChanged("C_UOM_ID") && this.hasInventoryOrCost()) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "SaveUomError"));
            return false;
        }
        if (!"I".equals(this.getProductType())) {
            this.setIsStocked(false);
        }
        if (this.m_precision != null && this.is_ValueChanged("C_UOM_ID")) {
            this.m_precision = null;
        }
        if (this.getM_AttributeSetInstance_ID() > 0 && this.is_ValueChanged("M_AttributeSet_ID") && (asi = new MAttributeSetInstance(this.getCtx(), this.getM_AttributeSetInstance_ID(), this.get_TrxName())).getM_AttributeSet_ID() != this.getM_AttributeSet_ID()) {
            this.setM_AttributeSetInstance_ID(0);
        }
        if (!newRecord && this.is_ValueChanged("M_AttributeSetInstance_ID") && (oldasiid = this.get_ValueOldAsInt("M_AttributeSetInstance_ID")) > 0) {
            MAttributeSetInstance oldasi = new MAttributeSetInstance(this.getCtx(), this.get_ValueOldAsInt("M_AttributeSetInstance_ID"), this.get_TrxName());
            int cnt = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM M_Product WHERE M_AttributeSetInstance_ID=?", oldasi.getM_AttributeSetInstance_ID());
            if (cnt == 1) {
                try {
                    oldasi.deleteEx(true, this.get_TrxName());
                }
                catch (AdempiereException ex) {
                    this.log.saveError("Error", "Error deleting the AttributeSetInstance");
                    return false;
                }
            }
        }
        return true;
    }

    private String verifyStorage() {
        BigDecimal qtyOnHand = Env.ZERO;
        BigDecimal qtyOrdered = Env.ZERO;
        BigDecimal qtyReserved = Env.ZERO;
        PO[] pOArray = MStorageOnHand.getOfProduct(this.getCtx(), this.get_ID(), this.get_TrxName());
        int n = pOArray.length;
        int n2 = 0;
        while (n2 < n) {
            MStorageOnHand ohs = pOArray[n2];
            qtyOnHand = qtyOnHand.add(ohs.getQtyOnHand());
            ++n2;
        }
        pOArray = MStorageReservation.getOfProduct(this.getCtx(), this.get_ID(), this.get_TrxName());
        n = pOArray.length;
        n2 = 0;
        while (n2 < n) {
            PO rs = pOArray[n2];
            if (((X_M_StorageReservation)rs).isSOTrx()) {
                qtyReserved = qtyReserved.add(((X_M_StorageReservation)rs).getQty());
            } else {
                qtyOrdered = qtyOrdered.add(((X_M_StorageReservation)rs).getQty());
            }
            ++n2;
        }
        StringBuilder errMsg = new StringBuilder();
        if (qtyOnHand.signum() != 0) {
            errMsg.append("@QtyOnHand@ = ").append(qtyOnHand);
        }
        if (qtyOrdered.signum() != 0) {
            errMsg.append(" - @QtyOrdered@ = ").append(qtyOrdered);
        }
        if (qtyReserved.signum() != 0) {
            errMsg.append(" - @QtyReserved@").append(qtyReserved);
        }
        return errMsg.toString();
    }

    private void removeStorageRecords() {
        int cnt = 0;
        if (this.isLot() || this.isSerial()) {
            cnt = DB.executeUpdateEx("UPDATE M_StorageOnHand SET QtyOnHand=0 WHERE M_Product_ID=? AND QtyOnHand != 0", new Object[]{this.getM_Product_ID()}, this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.log(Level.INFO, String.valueOf(this.toString()) + " #M_StorageOnHand Updated=" + cnt);
            }
        } else {
            cnt = DB.executeUpdateEx("DELETE FROM M_StorageOnHand WHERE M_Product_ID=?", new Object[]{this.getM_Product_ID()}, this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.log(Level.INFO, String.valueOf(this.toString()) + " #M_StorageOnHand Deleted=" + cnt);
            }
        }
        cnt = DB.executeUpdateEx("DELETE FROM M_StorageReservation WHERE M_Product_ID=?", new Object[]{this.getM_Product_ID()}, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.log(Level.INFO, String.valueOf(this.toString()) + " #M_StorageReservation Deleted=" + cnt);
        }
        cnt = DB.executeUpdateEx("DELETE FROM M_StorageReservationLog WHERE M_Product_ID=?", new Object[]{this.getM_Product_ID()}, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.log(Level.INFO, String.valueOf(this.toString()) + " #M_StorageReservationLog Deleted=" + cnt);
        }
    }

    private String verifyBOM() {
        Query query = new Query(this.getCtx(), "PP_Product_BOMLine", "M_Product_ID=?", this.get_TrxName());
        List list = query.setOnlyActiveRecords(true).setClient_ID().setParameters(this.getM_Product_ID()).list();
        for (MPPProductBOMLine line : list) {
            MPPProductBOM bom = line.getParent();
            if (!bom.isActive()) continue;
            StringBuilder errMsg = new StringBuilder();
            errMsg.append(Msg.getMsg(Env.getCtx(), "DeActivateProductInActiveBOM"));
            String bomName = bom.getName();
            errMsg.append(" (BOM: ").append(bomName);
            String parentValue = MProduct.get(bom.getM_Product_ID()).getValue();
            if (!parentValue.equals(bomName)) {
                errMsg.append(", ").append(parentValue);
            }
            errMsg.append(")");
            return errMsg.toString();
        }
        return null;
    }

    protected boolean hasInventoryOrCost() {
        boolean hasTrx = new Query(this.getCtx(), "M_Transaction", "M_Product_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.get_ID()).match();
        if (hasTrx) {
            return true;
        }
        boolean hasCosts = new Query(this.getCtx(), "M_CostDetail", "M_Product_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.get_ID()).match();
        return hasCosts;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "M_Product_ID=" + this.getM_Product_ID(), this.get_TrxName());
        }
        if (!newRecord && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description"))) {
            String sql = "UPDATE A_Asset a SET (Name, Description)=(SELECT SUBSTR((SELECT bp.Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=a.C_BPartner_ID) || ' - ' || p.Name,1,60), p.Description FROM M_Product p WHERE p.M_Product_ID=a.M_Product_ID) WHERE IsActive='Y'  AND M_Product_ID=" + this.getM_Product_ID();
            int no = DB.executeUpdate(sql, this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Asset Description updated #" + no);
            }
        }
        if (newRecord) {
            this.insert_Accounting("M_Product_Acct", "M_Product_Category_Acct", "p.M_Product_Category_ID=" + (this.getM_Product_Category_ID() > 999999 && Env.isLogMigrationScript(this.get_TableName()) ? "toRecordId('M_Product_Category'," + DB.TO_STRING(MProductCategory.get(this.getM_Product_Category_ID()).getM_Product_Category_UU()) + ")" : Integer.valueOf(this.getM_Product_Category_ID())));
            this.insert_Tree("PR");
        }
        if (newRecord || this.is_ValueChanged("Value")) {
            this.update_Tree("PR");
        }
        if (newRecord || this.is_ValueChanged("M_Product_Category_ID")) {
            MCost.create(this);
        }
        if (!newRecord && success && this.is_ValueChanged("IsActive") && !this.isActive() && this.isBOM()) {
            StringBuilder where = new StringBuilder();
            where.append("AD_Client_ID=? ").append("AND M_Product_ID=? ").append("AND IsActive='Y'");
            Query query = new Query(Env.getCtx(), "PP_Product_BOM", where.toString(), this.get_TrxName());
            List boms = query.setParameters(this.getAD_Client_ID(), this.getM_Product_ID()).list();
            for (MPPProductBOM bom : boms) {
                bom.setIsActive(false);
                bom.saveEx();
            }
        }
        return success;
    }

    @Override
    protected boolean beforeDelete() {
        String errMsg;
        if ("R".equals(this.getProductType()) && this.getS_Resource_ID() > 0) {
            throw new AdempiereException("@S_Resource_ID@<>0");
        }
        if ((this.isStocked() || "I".equals(this.getProductType())) && !Util.isEmpty(errMsg = this.verifyStorage())) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), errMsg));
            return false;
        }
        MCost.delete(this);
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.delete_Tree("PR");
        }
        return success;
    }

    public MAttributeInstance getAttributeInstance(String name, String trxName) {
        MAttributeInstance instance = null;
        MTable table2 = MTable.get(Env.getCtx(), 562);
        MAttribute attribute = (MAttribute)table2.getPO("Name = ?", new Object[]{name}, trxName);
        if (attribute == null) {
            return null;
        }
        table2 = MTable.get(Env.getCtx(), 561);
        instance = (MAttributeInstance)table2.getPO("M_AttributeSetInstance_ID=? and M_Attribute_ID=?", new Object[]{this.getM_AttributeSetInstance_ID(), attribute.getM_Attribute_ID()}, trxName);
        return instance;
    }

    public String getMMPolicy() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        String MMPolicy = pc.getMMPolicy();
        if (MMPolicy == null || MMPolicy.length() == 0) {
            MMPolicy = MClient.get(this.getCtx()).getMMPolicy();
        }
        return MMPolicy;
    }

    public boolean isUseGuaranteeDateForMPolicy() {
        MAttributeSet as = this.getAttributeSet();
        if (as == null) {
            return false;
        }
        if (!as.isGuaranteeDate()) {
            return false;
        }
        return as.isUseGuaranteeDateForMPolicy();
    }

    @Deprecated
    public boolean isASIMandatory(boolean isSOTrx) {
        return this.isASIMandatoryFor(null, isSOTrx);
    }

    public boolean isASIMandatoryFor(String mandatoryType, boolean isSOTrx) {
        MAcctSchema[] mass;
        MAcctSchema[] mAcctSchemaArray = mass = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        int n = mass.length;
        int n2 = 0;
        while (n2 < n) {
            MAcctSchema as = mAcctSchemaArray[n2];
            String cl = this.getCostingLevel(as);
            if ("B".equals(cl)) {
                return true;
            }
            ++n2;
        }
        int M_AttributeSet_ID = this.getM_AttributeSet_ID();
        if (M_AttributeSet_ID != 0) {
            MAttributeSet mas = MAttributeSet.get(this.getCtx(), M_AttributeSet_ID);
            if (mas == null || !mas.isInstanceAttribute()) {
                return false;
            }
            if (isSOTrx) {
                return mas.isMandatoryAlways() || mas.isMandatory() && mas.getMandatoryType().equals(mandatoryType);
            }
            return mas.isMandatoryAlways();
        }
        return false;
    }

    public String getCostingLevel(MAcctSchema as) {
        MProductCategoryAcct pca = MProductCategoryAcct.get(this.getCtx(), this.getM_Product_Category_ID(), as.get_ID(), this.get_TrxName());
        String costingLevel = pca.getCostingLevel();
        if (costingLevel == null) {
            costingLevel = as.getCostingLevel();
        }
        return costingLevel;
    }

    public String getCostingMethod(MAcctSchema as) {
        MProductCategoryAcct pca = MProductCategoryAcct.get(this.getCtx(), this.getM_Product_Category_ID(), as.get_ID(), this.get_TrxName());
        String costingMethod = pca.getCostingMethod();
        if (costingMethod == null) {
            costingMethod = as.getCostingMethod();
        }
        return costingMethod;
    }

    public MCost getCostingRecord(MAcctSchema as, int AD_Org_ID, int M_ASI_ID) {
        return this.getCostingRecord(as, AD_Org_ID, M_ASI_ID, this.getCostingMethod(as));
    }

    public MCost getCostingRecord(MAcctSchema as, int AD_Org_ID, int M_ASI_ID, String costingMethod) {
        String costingLevel = this.getCostingLevel(as);
        if ("C".equals(costingLevel)) {
            AD_Org_ID = 0;
            M_ASI_ID = 0;
        } else if ("O".equals(costingLevel)) {
            M_ASI_ID = 0;
        } else if ("B".equals(costingLevel)) {
            AD_Org_ID = 0;
            if (M_ASI_ID == 0) {
                return null;
            }
        }
        MCostElement ce = MCostElement.getMaterialCostElement(this.getCtx(), costingMethod, AD_Org_ID);
        if (ce == null) {
            return null;
        }
        MCost cost = MCost.get(this, M_ASI_ID, as, AD_Org_ID, ce.getM_CostElement_ID(), this.get_TrxName());
        return cost.is_new() ? null : cost;
    }

    @Override
    public MProduct markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_downloads != null && this.m_downloads.length > 0) {
            Arrays.stream(this.m_downloads).forEach(e -> {
                MProductDownload mProductDownload = e.markImmutable();
            });
        }
        return this;
    }

    public boolean isSerial() {
        if (this.getM_AttributeSet_ID() == 0) {
            return false;
        }
        MAttributeSet as = MAttributeSet.get(this.getM_AttributeSet_ID());
        return as.isInstanceAttribute() && as.isSerNo();
    }

    public boolean isLot() {
        if (this.getM_AttributeSet_ID() == 0) {
            return false;
        }
        MAttributeSet as = MAttributeSet.get(this.getM_AttributeSet_ID());
        return as.isInstanceAttribute() && as.isLot();
    }
}

