/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.process.UUIDGenerator;
import org.compiere.model.Lookup;
import org.compiere.model.MAccountLookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLocationLookup;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.MProcess;
import org.compiere.model.MRefTable;
import org.compiere.model.MReference;
import org.compiere.model.M_Element;
import org.compiere.model.X_AD_Process_Para;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;
import org.idempiere.expression.logic.LogicEvaluator;

public class MProcessPara
extends X_AD_Process_Para
implements ImmutablePOSupport {
    private static final long serialVersionUID = -1357447647930552555L;
    private static CLogger s_log = CLogger.getCLogger(MProcessPara.class);
    private static ImmutableIntPOCache<Integer, MProcessPara> s_cache = new ImmutableIntPOCache("AD_Process_Para", 20);
    public static int WINDOW_NO = 999;
    public static int TAB_NO = 0;
    private Lookup m_lookup = null;

    public static MProcessPara get(int AD_Process_Para_ID) {
        return MProcessPara.get(Env.getCtx(), AD_Process_Para_ID);
    }

    public static MProcessPara get(Properties ctx, int AD_Process_Para_ID) {
        Integer key = AD_Process_Para_ID;
        MProcessPara retValue = s_cache.get(ctx, key, e -> new MProcessPara(ctx, (MProcessPara)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProcessPara(ctx, AD_Process_Para_ID, null);
        if (retValue.get_ID() == AD_Process_Para_ID) {
            s_cache.put(key, retValue, e -> new MProcessPara(Env.getCtx(), (MProcessPara)e));
            return retValue;
        }
        return null;
    }

    public MProcessPara(Properties ctx, int AD_Process_Para_ID, String trxName) {
        super(ctx, AD_Process_Para_ID, trxName);
        if (AD_Process_Para_ID == 0) {
            this.setFieldLength(0);
            this.setSeqNo(0);
            this.setIsCentrallyMaintained(true);
            this.setIsRange(false);
            this.setIsMandatory(false);
            this.setEntityType("U");
        }
    }

    public MProcessPara(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProcessPara(MProcess parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Process_ID(parent.getAD_Process_ID());
        this.setEntityType(parent.getEntityType());
    }

    public MProcessPara(MProcessPara copy) {
        this(Env.getCtx(), copy);
    }

    public MProcessPara(Properties ctx, MProcessPara copy) {
        this(ctx, copy, null);
    }

    public MProcessPara(Properties ctx, MProcessPara copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public boolean isLookup() {
        boolean retValue = false;
        int displayType = this.getAD_Reference_ID();
        if (DisplayType.isLookup(displayType)) {
            retValue = true;
        } else if (displayType == 21 || displayType == 31 || displayType == 25 || displayType == 35) {
            retValue = true;
        }
        return retValue;
    }

    public void loadLookup() {
        int displayType;
        if (!this.isLookup()) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("(" + this.getColumnName() + ")");
        }
        if (DisplayType.isLookup(displayType = this.getAD_Reference_ID())) {
            MLookupInfo lookupInfo = MLookupFactory.getLookupInfo(this.getCtx(), 0, this.getAD_Process_Para_ID(), this.getAD_Reference_ID(), Env.getLanguage(this.getCtx()), this.getColumnName(), this.getAD_Reference_Value_ID(), false, "");
            if (lookupInfo == null) {
                this.log.log(Level.SEVERE, "(" + this.getColumnName() + ") - No LookupInfo");
                return;
            }
            if (displayType == 18 && (this.getColumnName().equals("CreatedBy") || this.getColumnName().equals("UpdatedBy"))) {
                lookupInfo.IsCreadedUpdatedBy = true;
                lookupInfo.DisplayType = 30;
            }
            MLookup ml = new MLookup(lookupInfo, TAB_NO);
            this.m_lookup = ml;
        } else if (displayType == 21) {
            MLocationLookup ml = new MLocationLookup(this.getCtx(), WINDOW_NO);
            this.m_lookup = ml;
        } else if (displayType == 31) {
            MLocatorLookup ml = new MLocatorLookup(this.getCtx(), WINDOW_NO);
            this.m_lookup = ml;
        } else if (displayType == 25) {
            MAccountLookup ma = new MAccountLookup(this.getCtx(), WINDOW_NO);
            this.m_lookup = ma;
        } else if (displayType == 35) {
            MPAttributeLookup pa = new MPAttributeLookup(this.getCtx(), WINDOW_NO);
            this.m_lookup = pa;
        }
        if (this.m_lookup != null) {
            this.m_lookup.loadComplete();
        }
    }

    public Lookup getLookup() {
        if (this.m_lookup == null && this.isLookup()) {
            this.loadLookup();
        }
        return this.m_lookup;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MProcessPara[").append(this.get_ID()).append("]");
        return sb.toString();
    }

    public void copyFrom(MProcessPara source) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Copying from:" + source + ", to: " + this);
        }
        this.setAD_Element_ID(source.getAD_Element_ID());
        this.setAD_Reference_ID(source.getAD_Reference_ID());
        this.setAD_Reference_Value_ID(source.getAD_Reference_Value_ID());
        this.setAD_Val_Rule_ID(source.getAD_Val_Rule_ID());
        this.setColumnName(source.getColumnName());
        this.setDefaultValue(source.getDefaultValue());
        this.setDefaultValue2(source.getDefaultValue2());
        this.setDescription(source.getDescription());
        this.setDisplayLogic(source.getDisplayLogic());
        this.setFieldLength(source.getFieldLength());
        this.setHelp(source.getHelp());
        this.setIsActive(source.isActive());
        this.setIsCentrallyMaintained(source.isCentrallyMaintained());
        this.setIsMandatory(source.isMandatory());
        this.setIsRange(source.isRange());
        this.setName(source.getName());
        this.setReadOnlyLogic(source.getReadOnlyLogic());
        this.setSeqNo(source.getSeqNo());
        this.setValueMax(source.getValueMax());
        this.setValueMin(source.getValueMin());
        this.setVFormat(source.getVFormat());
        this.saveEx();
        String sql = "DELETE FROM AD_Process_Para_Trl WHERE AD_Process_Para_ID = ?";
        int count = DB.executeUpdateEx(sql, new Object[]{this.getAD_Process_Para_ID()}, this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "AD_Process_Para_Trl deleted: " + count);
        }
        sql = "INSERT INTO AD_Process_Para_Trl (AD_Process_Para_ID, AD_Language,  AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,  Name, Description, Help, IsTranslated)  SELECT ?, AD_Language, AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy,  Updated, UpdatedBy, Name, Description, Help, IsTranslated  FROM AD_Process_Para_Trl WHERE AD_Process_Para_ID = ? ";
        count = DB.executeUpdateEx(sql, new Object[]{this.getAD_Process_Para_ID(), source.getAD_Process_Para_ID()}, this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "AD_Process_Para_Trl inserted: " + count);
        }
        if (DB.isGenerateUUIDSupported()) {
            DB.executeUpdateEx("UPDATE AD_Process_Para_Trl SET AD_Process_Para_Trl_UU=generate_uuid() WHERE AD_Process_Para_Trl_UU IS NULL", this.get_TrxName());
        } else {
            UUIDGenerator.updateUUID(MColumn.get(this.getCtx(), "AD_Process_Para_Trl", "AD_Process_Para_Trl_UU"), this.get_TrxName());
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MProcess p2;
        if (this.isCentrallyMaintained() && this.getAD_Element_ID() == 0) {
            this.setIsCentrallyMaintained(false);
        }
        if ((newRecord || this.is_ValueChanged("AD_Element_ID")) && this.getAD_Element_ID() != 0 && this.isCentrallyMaintained()) {
            M_Element element = new M_Element(this.getCtx(), this.getAD_Element_ID(), this.get_TrxName());
            this.setColumnName(element.getColumnName());
            this.setName(element.getName());
            this.setDescription(element.getDescription());
            this.setHelp(element.getHelp());
        }
        if ((newRecord || this.is_ValueChanged("ReadOnlyLogic")) && this.isActive() && !Util.isEmpty(this.getReadOnlyLogic(), true) && !this.getReadOnlyLogic().startsWith("@SQL=")) {
            LogicEvaluator.validate(this.getReadOnlyLogic());
        }
        if ((newRecord || this.is_ValueChanged("DisplayLogic")) && this.isActive() && !Util.isEmpty(this.getDisplayLogic(), true) && !this.getDisplayLogic().startsWith("@SQL=")) {
            LogicEvaluator.validate(this.getDisplayLogic());
        }
        if (newRecord && DisplayType.isChosenMultipleSelection(this.getAD_Reference_ID()) && Util.isEmpty((p2 = MProcess.get(this.getAD_Process_ID())).getClassname()) && Util.isEmpty(p2.getProcedureName()) && Util.isEmpty(p2.getJasperReport())) {
            this.setIsShowNegateButton(true);
        }
        return true;
    }

    public String getReferenceTableName() {
        String foreignTable = null;
        if (19 == this.getAD_Reference_ID() || 30 == this.getAD_Reference_ID() && this.getAD_Reference_Value_ID() == 0) {
            foreignTable = this.getColumnName().substring(0, this.getColumnName().length() - 3);
        } else if (18 == this.getAD_Reference_ID() || 30 == this.getAD_Reference_ID()) {
            MRefTable rt;
            MReference ref = MReference.get(this.getCtx(), this.getAD_Reference_Value_ID(), this.get_TrxName());
            if ("T".equals(ref.getValidationType()) && (rt = MRefTable.get(this.getCtx(), this.getAD_Reference_Value_ID(), this.get_TrxName())) != null) {
                foreignTable = rt.getAD_Table().getTableName();
            }
        } else if (DisplayType.isList(this.getAD_Reference_ID())) {
            foreignTable = "AD_Ref_List";
        }
        return foreignTable;
    }

    @Override
    public MProcessPara markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    public static void validateUnknownParameter(int processId, ProcessInfoParameter para) {
        Level level;
        MProcess process = MProcess.get(processId);
        StringBuilder msg = new StringBuilder("Process ").append(process.getValue()).append(" - ");
        if (process.getParameter(para.getParameterName()) == null) {
            msg.append("Unknown");
            level = Level.SEVERE;
        } else {
            msg.append("Custom");
            level = Level.INFO;
        }
        msg.append(" Parameter: ").append(para.getParameterName()).append("=").append(para.getInfo());
        if (s_log.isLoggable(level)) {
            s_log.log(level, msg.toString());
        }
    }
}

