/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessDrillRulePara;
import org.compiere.model.MProcessPara;
import org.compiere.model.MReportView;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Process_DrillRule;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MProcessDrillRule
extends X_AD_Process_DrillRule
implements ImmutablePOSupport {
    private MProcessDrillRulePara[] m_parameter = null;
    private static final long serialVersionUID = -6543978637922025586L;
    private static ImmutableIntPOCache<Integer, MProcessDrillRule> s_cache = new ImmutableIntPOCache("AD_Process_DrillRule", 20);

    public static MProcessDrillRule get(Properties ctx, int AD_Process_DrillRule_ID) {
        return MProcessDrillRule.get(ctx, AD_Process_DrillRule_ID, null);
    }

    public static MProcessDrillRule get(Properties ctx, int AD_Process_DrillRule_ID, String trxName) {
        Integer ii = AD_Process_DrillRule_ID;
        MProcessDrillRule retValue = s_cache.get(ctx, ii, e -> new MProcessDrillRule(ctx, (MProcessDrillRule)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProcessDrillRule(ctx, AD_Process_DrillRule_ID, null);
        if (retValue.get_ID() == AD_Process_DrillRule_ID) {
            s_cache.put(AD_Process_DrillRule_ID, retValue, e -> new MProcessDrillRule(Env.getCtx(), (MProcessDrillRule)e));
            return retValue;
        }
        return null;
    }

    public MProcessDrillRule(Properties ctx, int AD_Process_DrillRule_ID, String trxName) {
        super(ctx, AD_Process_DrillRule_ID, trxName);
    }

    public MProcessDrillRule(Properties ctx, int AD_Process_DrillRule_ID, String trxName, String[] virtualColumns) {
        super(ctx, AD_Process_DrillRule_ID, trxName, virtualColumns);
    }

    public MProcessDrillRule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProcessDrillRule(MProcessDrillRule copy) {
        this(Env.getCtx(), copy);
    }

    public MProcessDrillRule(Properties ctx, MProcessDrillRule copy) {
        this(ctx, copy, null);
    }

    public MProcessDrillRule(Properties ctx, MProcessDrillRule copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public static MProcessDrillRule[] getByTable(Properties ctx, int AD_Table_ID, String trxName) {
        String whereClause = " AD_Table_ID = ? AND IsValid = 'Y' AND AD_Process_DrillRule.AD_Client_ID IN (0,?)";
        List<MProcessDrillRule> processDrillRules = new Query(ctx, "AD_Process_DrillRule", whereClause, trxName).setParameters(AD_Table_ID, Env.getAD_Client_ID(ctx)).setOnlyActiveRecords(true).list();
        return processDrillRules.toArray(new MProcessDrillRule[processDrillRules.size()]);
    }

    public static MProcessDrillRule[] getByColumnName(Properties ctx, String columnName, String trxName) {
        String whereClause = " IsValid = 'Y' AND AD_Process_DrillRule.AD_Client_ID IN (0,?)";
        List<MProcessDrillRule> processDrillRules = new Query(ctx, "AD_Process_DrillRule", whereClause, trxName).addJoinClause(" INNER JOIN AD_Process_Para pp ON AD_Process_DrillRule.AD_Process_Para_ID = pp.AD_Process_Para_ID AND ColumnName = ?").setParameters(columnName, Env.getAD_Client_ID(ctx)).setOnlyActiveRecords(true).list();
        return processDrillRules.toArray(new MProcessDrillRule[processDrillRules.size()]);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MReportView reportView;
        MProcess process;
        if ((newRecord || this.is_ValueChanged("AD_Process_ID")) && (process = MProcess.get(this.getAD_Process_ID())) != null && process.getAD_ReportView_ID() > 0 && (reportView = MReportView.get(process.getAD_ReportView_ID())) != null && reportView.getAD_Table_ID() > 0) {
            this.setAD_Table_ID(reportView.getAD_Table_ID());
        }
        this.validate();
        return super.beforeSave(newRecord);
    }

    public MProcessDrillRulePara[] getParameters(boolean reload) {
        if (!reload && this.m_parameter != null) {
            return this.m_parameter;
        }
        String whereClause = "AD_Process_DrillRule_ID=?";
        List<MProcessDrillRulePara> list = new Query(this.getCtx(), "AD_Process_DrillRule_Para", "AD_Process_DrillRule_ID=?", this.get_TrxName()).setParameters(this.getAD_Process_DrillRule_ID()).setOnlyActiveRecords(true).list();
        if (list.size() > 0 && this.is_Immutable()) {
            list.stream().forEach(e -> {
                PO pO = e.markImmutable();
            });
        }
        this.m_parameter = new MProcessDrillRulePara[list.size()];
        list.toArray(this.m_parameter);
        return this.m_parameter;
    }

    @Override
    public PO markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    private boolean allMandatoryParaSet() {
        boolean isValid = false;
        MProcess process = new MProcess(Env.getCtx(), this.getAD_Process_ID(), this.get_TrxName());
        MProcessPara[] mProcessParaArray = process.getParameters();
        int n = mProcessParaArray.length;
        int n2 = 0;
        while (n2 < n) {
            MProcessPara processPara = mProcessParaArray[n2];
            if (processPara.isMandatory() && processPara.getAD_Process_Para_ID() != this.getAD_Process_Para_ID()) {
                MProcessDrillRulePara[] mProcessDrillRuleParaArray = this.getParameters(true);
                int n3 = mProcessDrillRuleParaArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    MProcessDrillRulePara drillRulePara = mProcessDrillRuleParaArray[n4];
                    if (drillRulePara.getAD_Process_Para_ID() == processPara.getAD_Process_Para_ID()) {
                        String defPara = drillRulePara.getParameterDefault();
                        String defParaTo = drillRulePara.getParameterToDefault();
                        isValid = processPara.isRange() && !Util.isEmpty(defPara) || !Util.isEmpty(defParaTo) || !processPara.isRange() && !Util.isEmpty(defPara);
                        break;
                    }
                    ++n4;
                }
                if (!isValid) {
                    return false;
                }
                isValid = false;
            }
            ++n2;
        }
        return true;
    }

    public boolean hasMandatoryProcessPara() {
        MProcess process = new MProcess(Env.getCtx(), this.getAD_Process_ID(), null);
        MProcessPara[] mProcessParaArray = process.getParameters();
        int n = mProcessParaArray.length;
        int n2 = 0;
        while (n2 < n) {
            MProcessPara processPara = mProcessParaArray[n2];
            if (processPara.isMandatory()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void validate() {
        if (this.getAD_Client_ID() == 0 && this.hasMandatoryProcessPara() && !"Y".equalsIgnoreCase(this.getShowHelp())) {
            this.setIsValid(false);
        } else if ("Y".equalsIgnoreCase(this.getShowHelp())) {
            this.setIsValid(true);
        } else {
            this.setIsValid(this.allMandatoryParaSet());
        }
    }
}

