/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MMenu;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcessAccess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRole;
import org.compiere.model.MWindow;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Process;
import org.compiere.process.ProcessInfo;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFProcess;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MProcess
extends X_AD_Process
implements ImmutablePOSupport {
    private static final long serialVersionUID = 6928560924056836659L;
    private static ImmutableIntPOCache<Integer, MProcess> s_cache = new ImmutableIntPOCache("AD_Process", 20);
    private static ImmutablePOCache<String, MProcess> s_cacheUU = new ImmutablePOCache("AD_Process", "AD_Process|AD_Process_UU", 20);
    private MProcessPara[] m_parameters = null;

    public static MProcess get(int AD_Process_ID) {
        return MProcess.get(Env.getCtx(), AD_Process_ID);
    }

    public static MProcess get(Properties ctx, int AD_Process_ID) {
        Integer key = AD_Process_ID;
        MProcess retValue = s_cache.get(ctx, key, e -> new MProcess(ctx, (MProcess)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProcess(ctx, AD_Process_ID, null);
        if (retValue.get_ID() == AD_Process_ID) {
            s_cache.put(key, retValue, e -> new MProcess(Env.getCtx(), (MProcess)e));
            return retValue;
        }
        return null;
    }

    public static MProcess getCopy(Properties ctx, int AD_Process_ID, String trxName) {
        MProcess process = MProcess.get(AD_Process_ID);
        if (process != null) {
            process = new MProcess(ctx, process, trxName);
        }
        return process;
    }

    public static MProcess get(String AD_Process_UU) {
        return MProcess.get(Env.getCtx(), AD_Process_UU);
    }

    public static MProcess get(Properties ctx, String AD_Process_UU) {
        MProcess retValue = s_cacheUU.get(ctx, AD_Process_UU, e -> new MProcess(ctx, (MProcess)e));
        if (retValue != null) {
            return retValue;
        }
        int id = DB.getSQLValueEx(null, "SELECT AD_Process_ID FROM AD_Process WHERE AD_Process_UU = ? ", AD_Process_UU);
        if (id > 0 && (retValue = new MProcess(ctx, id, null)).get_ID() == id && !Util.isEmpty(retValue.getAD_Process_UU())) {
            s_cacheUU.put(retValue.getAD_Process_UU(), retValue, e -> new MProcess(Env.getCtx(), (MProcess)e));
            return retValue;
        }
        return null;
    }

    public static MProcess getFromMenu(Properties ctx, int AD_Menu_ID) {
        String whereClause = "EXISTS (SELECT 1 FROM AD_Menu m WHERE m.AD_Process_ID=AD_Process.AD_Process_ID AND m.AD_Menu_ID=?)";
        MProcess p2 = (MProcess)new Query(ctx, "AD_Process", "EXISTS (SELECT 1 FROM AD_Menu m WHERE m.AD_Process_ID=AD_Process.AD_Process_ID AND m.AD_Menu_ID=?)", null).setParameters(AD_Menu_ID).firstOnly();
        if (p2 != null) {
            s_cache.put(p2.get_ID(), p2, e -> new MProcess(Env.getCtx(), (MProcess)e));
        }
        return p2;
    }

    public MProcess(Properties ctx, int AD_Process_ID, String trxName) {
        super(ctx, AD_Process_ID, trxName);
        if (AD_Process_ID == 0) {
            this.setIsReport(false);
            this.setAccessLevel("7");
            this.setEntityType("U");
            this.setIsBetaFunctionality(false);
        }
    }

    public MProcess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProcess(MProcess copy) {
        this(Env.getCtx(), copy);
    }

    public MProcess(Properties ctx, MProcess copy) {
        this(ctx, copy, null);
    }

    public MProcess(Properties ctx, MProcess copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_parameters = copy.m_parameters != null ? (MProcessPara[])Arrays.stream(copy.m_parameters).map(e -> new MProcessPara(ctx, (MProcessPara)e, trxName)).toArray(MProcessPara[]::new) : null;
    }

    public MProcessPara[] getParameters() {
        if (this.m_parameters != null) {
            return this.m_parameters;
        }
        String whereClause = "AD_Process_ID=?";
        List<MProcessPara> list = new Query(this.getCtx(), "AD_Process_Para", "AD_Process_ID=?", this.get_TrxName()).setParameters(this.get_ID()).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        if (list.size() > 0 && this.is_Immutable()) {
            list.stream().forEach(e -> {
                MProcessPara mProcessPara = e.markImmutable();
            });
        }
        this.m_parameters = new MProcessPara[list.size()];
        list.toArray(this.m_parameters);
        return this.m_parameters;
    }

    public MProcessPara getParameter(String name) {
        this.getParameters();
        int i2 = 0;
        while (i2 < this.m_parameters.length) {
            if (this.m_parameters[i2].getColumnName().equals(name)) {
                return this.m_parameters[i2];
            }
            ++i2;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MProcess[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public MPInstance processIt(int Record_ID, Trx trx) {
        return this.processIt(Record_ID, trx, true);
    }

    public MPInstance processIt(int Record_ID, Trx trx, boolean managedTrx) {
        MPInstance pInstance = new MPInstance(this.getCtx(), this.getAD_Process_ID(), Record_ID);
        pInstance.setIsProcessing(true);
        pInstance.saveEx();
        boolean ok = true;
        ProcessInfo processInfo = new ProcessInfo("", this.getAD_Process_ID());
        processInfo.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        processInfo.setRecord_ID(Record_ID);
        ok = this.processIt(processInfo, trx, managedTrx);
        pInstance.setResult(ok ? 1 : 0);
        pInstance.setErrorMsg(processInfo.getSummary());
        pInstance.setIsProcessing(false);
        pInstance.saveEx();
        pInstance.log();
        return pInstance;
    }

    public boolean processIt(ProcessInfo pi, Trx trx) {
        return this.processIt(pi, trx, true);
    }

    public boolean processIt(ProcessInfo pi, Trx trx, boolean managedTrx) {
        if (pi.getAD_PInstance_ID() == 0) {
            MPInstance pInstance = new MPInstance(this.getCtx(), this.getAD_Process_ID(), pi.getRecord_ID());
            pInstance.setIsProcessing(true);
            pInstance.saveEx();
            pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        }
        boolean ok = false;
        if (this.isWorkflow()) {
            pi.setTransactionName(trx.getTrxName());
            MWFProcess wfprocess = ProcessUtil.startWorkFlow(this.getCtx(), pi, this.getAD_Workflow_ID());
            if (wfprocess == null) {
                ok = false;
            } else {
                MPInstance pinstance = new MPInstance(Env.getCtx(), pi.getAD_PInstance_ID(), null);
                String errmsg = pi.getSummary();
                pinstance.setResult(!pi.isError());
                pinstance.setErrorMsg(errmsg);
                pinstance.saveEx();
                ok = !pi.isError();
            }
        } else if (this.isJavaProcess()) {
            pi.setClassName(this.getClassname());
            ok = this.startClass(pi, trx, managedTrx);
        } else if (this.isDatabaseProcedure()) {
            ok = this.startProcess(this.getProcedureName(), pi, trx, managedTrx);
        } else if (this.isReport()) {
            ok = true;
        } else {
            String msg = "No Workflow, Classname or ProcedureName for " + this.getName();
            pi.setSummary(msg, ok);
            this.log.warning(msg);
        }
        return ok;
    }

    public boolean isJavaProcess() {
        return !Util.isEmpty(this.getClassname(), true);
    }

    public boolean isDatabaseProcedure() {
        return !Util.isEmpty(this.getProcedureName(), true);
    }

    public boolean isForceBackground() {
        return "B".equals(this.getExecutionType());
    }

    public boolean isForceForeground() {
        return "F".equals(this.getExecutionType());
    }

    private boolean startProcess(String ProcedureName, ProcessInfo processInfo, Trx trx, boolean managedTrx) {
        int AD_PInstance_ID = processInfo.getAD_PInstance_ID();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(ProcedureName) + "(" + AD_PInstance_ID + ")");
        }
        return ProcessUtil.startDatabaseProcedure(processInfo, ProcedureName, trx, managedTrx);
    }

    private boolean startClass(ProcessInfo pi, Trx trx, boolean managedTrx) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(pi.getClassName());
        }
        if (pi.getClassName().toLowerCase().startsWith("@script:")) {
            return ProcessUtil.startScriptProcess(this.getCtx(), pi, trx);
        }
        return ProcessUtil.startJavaProcess(this.getCtx(), pi, trx, managedTrx);
    }

    public boolean isWorkflow() {
        return this.getAD_Workflow_ID() > 0;
    }

    public void addStatistics(int seconds) {
        this.setStatistic_Count(this.getStatistic_Count() + 1);
        this.setStatistic_Seconds(this.getStatistic_Seconds() + seconds);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        block8: {
            block7: {
                if (!success) {
                    return success;
                }
                if (!newRecord) break block7;
                MRole[] roles = MRole.getOf(this.getCtx(), "IsManual='N'");
                int i2 = 0;
                while (i2 < roles.length) {
                    MProcessAccess pa = new MProcessAccess(this, roles[i2].getAD_Role_ID());
                    pa.saveEx();
                    ++i2;
                }
                break block8;
            }
            if (!this.is_ValueChanged("IsActive") && !this.is_ValueChanged("Name") && !this.is_ValueChanged("Description") && !this.is_ValueChanged("Help")) break block8;
            MMenu[] menues = MMenu.get(this.getCtx(), "AD_Process_ID=" + this.getAD_Process_ID(), this.get_TrxName());
            int i3 = 0;
            while (i3 < menues.length) {
                menues[i3].setIsActive(this.isActive());
                menues[i3].setName(this.getName());
                menues[i3].setDescription(this.getDescription());
                menues[i3].saveEx();
                ++i3;
            }
            MWFNode[] nodes = MWindow.getWFNodes(this.getCtx(), "AD_Process_ID=" + this.getAD_Process_ID(), this.get_TrxName());
            int i4 = 0;
            while (i4 < nodes.length) {
                boolean changed = false;
                if (nodes[i4].isActive() != this.isActive()) {
                    nodes[i4].setIsActive(this.isActive());
                    changed = true;
                }
                if (nodes[i4].isCentrallyMaintained()) {
                    nodes[i4].setName(this.getName());
                    nodes[i4].setDescription(this.getDescription());
                    nodes[i4].setHelp(this.getHelp());
                    changed = true;
                }
                if (changed) {
                    nodes[i4].saveEx();
                }
                ++i4;
            }
        }
        return success;
    }

    public static int getProcess_ID(String value, String trxName) {
        int retValue = DB.getSQLValueEx(trxName, "SELECT AD_Process_ID FROM AD_Process WHERE Value=?", value);
        return retValue;
    }

    public void copyFrom(MProcess source) {
        MProcessPara[] parameters;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Copying from:" + source + ", to: " + this);
        }
        this.setAccessLevel(source.getAccessLevel());
        this.setAD_Form_ID(source.getAD_Form_ID());
        this.setAD_PrintFormat_ID(source.getAD_PrintFormat_ID());
        this.setAD_ReportView_ID(source.getAD_ReportView_ID());
        this.setAD_Workflow_ID(source.getAD_Workflow_ID());
        this.setClassname(source.getClassname());
        this.setDescription(source.getDescription());
        this.setHelp(source.getHelp());
        this.setIsBetaFunctionality(source.isBetaFunctionality());
        this.setIsDirectPrint(source.isDirectPrint());
        this.setIsReport(source.isReport());
        this.setJasperReport(source.getJasperReport());
        this.setProcedureName(source.getProcedureName());
        this.setShowHelp(source.getShowHelp());
        this.saveEx();
        MProcessPara[] mProcessParaArray = parameters = source.getParameters();
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            MProcessPara sourcePara = mProcessParaArray[n2];
            MProcessPara targetPara = new MProcessPara(this);
            targetPara.copyFrom(sourcePara);
            ++n2;
        }
    }

    public boolean processItWithoutTrxClose(ProcessInfo pi, Trx trx) {
        return this.processIt(pi, trx, false);
    }

    @Override
    public MProcess markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_parameters != null && this.m_parameters.length > 0) {
            Arrays.stream(this.m_parameters).forEach(e -> {
                MProcessPara mProcessPara = e.markImmutable();
            });
        }
        return this;
    }
}

