/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MPriceList;
import org.compiere.model.MProductPrice;
import org.compiere.model.Query;
import org.compiere.model.X_M_PriceList_Version;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.idempiere.cache.ImmutablePOSupport;

public class MPriceListVersion
extends X_M_PriceList_Version
implements ImmutablePOSupport {
    private static final long serialVersionUID = 1625884461739604147L;
    private MProductPrice[] m_pp = null;
    protected MPriceList m_pl = null;

    public MPriceListVersion(Properties ctx, int M_PriceList_Version_ID, String trxName) {
        super(ctx, M_PriceList_Version_ID, trxName);
    }

    public MPriceListVersion(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPriceListVersion(MPriceList pl) {
        this(pl.getCtx(), 0, pl.get_TrxName());
        this.setClientOrg(pl);
        this.setM_PriceList_ID(pl.getM_PriceList_ID());
    }

    public MPriceListVersion(MPriceListVersion copy) {
        this(Env.getCtx(), copy);
    }

    public MPriceListVersion(Properties ctx, MPriceListVersion copy) {
        this(ctx, copy, null);
    }

    public MPriceListVersion(Properties ctx, MPriceListVersion copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_pl = null;
        this.m_pp = copy.m_pp != null ? (MProductPrice[])Arrays.stream(copy.m_pp).map(e -> new MProductPrice(ctx, (MProductPrice)e, trxName)).toArray(MProductPrice[]::new) : null;
    }

    public MPriceList getPriceList() {
        if (this.m_pl == null && this.getM_PriceList_ID() != 0) {
            this.m_pl = this.is_Immutable() ? MPriceList.get(this.getCtx(), this.getM_PriceList_ID(), null) : MPriceList.getCopy(this.getCtx(), this.getM_PriceList_ID(), this.get_TrxName());
        }
        return this.m_pl;
    }

    public MProductPrice[] getProductPrice(boolean refresh) {
        if (this.m_pp != null && !refresh) {
            return this.m_pp;
        }
        this.m_pp = this.getProductPrice(null);
        if (this.m_pp != null && this.m_pp.length > 0 && this.is_Immutable()) {
            Arrays.stream(this.m_pp).forEach(e -> {
                MProductPrice mProductPrice = e.markImmutable();
            });
        }
        return this.m_pp;
    }

    public MProductPrice[] getProductPrice(String whereClause) {
        String localWhereClause = "M_PriceList_Version_ID=?";
        if (whereClause != null) {
            localWhereClause = String.valueOf(localWhereClause) + " " + whereClause;
        }
        List<MProductPrice> list = new Query(this.getCtx(), "M_ProductPrice", localWhereClause, this.get_TrxName()).setParameters(this.getM_PriceList_Version_ID()).list();
        MProductPrice[] pp = new MProductPrice[list.size()];
        list.toArray(pp);
        return pp;
    }

    public void setName() {
        if (this.getValidFrom() == null) {
            this.setValidFrom(TimeUtil.getDay(null));
        }
        if (this.getName() == null) {
            String name = DisplayType.getDateFormat(15).format(this.getValidFrom());
            this.setName(name);
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.setName();
        return true;
    }

    @Override
    public MPriceListVersion markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_pl != null) {
            this.m_pl.markImmutable();
        }
        if (this.m_pp != null && this.m_pp.length > 0) {
            Arrays.stream(this.m_pp).forEach(e -> {
                MProductPrice mProductPrice = e.markImmutable();
            });
        }
        return this;
    }
}

