/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDocType;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPeriodControl;
import org.compiere.model.MTable;
import org.compiere.model.MYear;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Period;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MPeriod
extends X_C_Period
implements ImmutablePOSupport {
    private static final long serialVersionUID = -4813116760490243399L;
    private static ImmutableIntPOCache<Integer, MPeriod> s_cache = new ImmutableIntPOCache("C_Period", 10);
    private static CLogger s_log = CLogger.getCLogger(MPeriod.class);
    private int m_C_Calendar_ID = 0;
    private MPeriodControl[] m_controls = null;

    public static MPeriod get(int C_Period_ID) {
        return MPeriod.get(Env.getCtx(), C_Period_ID);
    }

    public static MPeriod get(Properties ctx, int C_Period_ID) {
        if (C_Period_ID <= 0) {
            return null;
        }
        Integer key = C_Period_ID;
        MPeriod retValue = s_cache.get(ctx, key, e -> new MPeriod(ctx, (MPeriod)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MPeriod(ctx, C_Period_ID, null);
        if (retValue.get_ID() == C_Period_ID) {
            s_cache.put(key, retValue, e -> new MPeriod(Env.getCtx(), (MPeriod)e));
            return retValue;
        }
        return null;
    }

    public static MPeriod get(Properties ctx, Timestamp DateAcct) {
        return MPeriod.get(ctx, DateAcct, 0, null);
    }

    public static MPeriod get(Properties ctx, Timestamp DateAcct, int AD_Org_ID, String trxName) {
        if (DateAcct == null) {
            return null;
        }
        int C_Calendar_ID = MPeriod.getC_Calendar_ID(ctx, AD_Org_ID);
        return MPeriod.findByCalendar(ctx, DateAcct, C_Calendar_ID, trxName);
    }

    @Deprecated
    public static MPeriod get(Properties ctx, Timestamp DateAcct, int AD_Org_ID) {
        return MPeriod.get(ctx, DateAcct, AD_Org_ID, null);
    }

    public static MPeriod getCopy(Properties ctx, int C_Period_ID, String trxName) {
        MPeriod period = MPeriod.get(C_Period_ID);
        if (period != null) {
            period = new MPeriod(ctx, period, trxName);
        }
        return period;
    }

    public static MPeriod findByCalendar(Properties ctx, Timestamp DateAcct, int C_Calendar_ID) {
        return MPeriod.findByCalendar(ctx, DateAcct, C_Calendar_ID, null);
    }

    public static MPeriod findByCalendar(Properties ctx, Timestamp DateAcct, int C_Calendar_ID, String trxName) {
        MPeriod retValue;
        int AD_Client_ID;
        block9: {
            MPeriod[] it;
            AD_Client_ID = Env.getAD_Client_ID(ctx);
            MPeriod[] mPeriodArray = it = s_cache.values().toArray(new MPeriod[0]);
            int n = it.length;
            int n2 = 0;
            while (n2 < n) {
                MPeriod period = mPeriodArray[n2];
                if (period.getC_Calendar_ID() == C_Calendar_ID && period.isStandardPeriod() && period.isInPeriod(DateAcct) && period.getAD_Client_ID() == AD_Client_ID) {
                    return period;
                }
                ++n2;
            }
            retValue = null;
            String sql = "SELECT * FROM C_Period WHERE C_Year_ID IN (SELECT C_Year_ID FROM C_Year WHERE C_Calendar_ID= ?) AND ? BETWEEN TRUNC(StartDate) AND TRUNC(EndDate) AND IsActive=? AND PeriodType=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, C_Calendar_ID);
                    pstmt.setTimestamp(2, TimeUtil.getDay(DateAcct));
                    pstmt.setString(3, "Y");
                    pstmt.setString(4, "S");
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPeriod period = new MPeriod(ctx, rs, trxName);
                        Integer key = period.getC_Period_ID();
                        s_cache.put(key, period);
                        if (!period.isStandardPeriod()) continue;
                        retValue = period;
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, "DateAcct=" + DateAcct, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null && s_log.isLoggable(Level.INFO)) {
            s_log.info("No Standard Period for " + DateAcct + " (AD_Client_ID=" + AD_Client_ID + ")");
        }
        return retValue;
    }

    public static int getC_Period_ID(Properties ctx, Timestamp DateAcct) {
        MPeriod period = MPeriod.get(ctx, DateAcct, 0, null);
        if (period == null) {
            return 0;
        }
        return period.getC_Period_ID();
    }

    public static int getC_Period_ID(Properties ctx, Timestamp DateAcct, int AD_Org_ID) {
        MPeriod period = MPeriod.get(ctx, DateAcct, AD_Org_ID, null);
        if (period == null) {
            return 0;
        }
        return period.getC_Period_ID();
    }

    public static boolean isOpen(Properties ctx, Timestamp DateAcct, String DocBaseType) {
        return MPeriod.isOpen(ctx, DateAcct, DocBaseType, 0);
    }

    public static boolean isOpen(Properties ctx, Timestamp DateAcct, String DocBaseType, int AD_Org_ID) {
        if (DateAcct == null) {
            s_log.warning("No DateAcct");
            return false;
        }
        if (DocBaseType == null) {
            s_log.warning("No DocBaseType");
            return false;
        }
        MPeriod period = MPeriod.get(ctx, DateAcct, AD_Org_ID, null);
        if (period == null) {
            s_log.warning("No Period for " + DateAcct + " (" + DocBaseType + ")");
            return false;
        }
        boolean open = period.isOpen(DocBaseType, DateAcct);
        if (!open) {
            s_log.warning(String.valueOf(period.getName()) + ": Not open for " + DocBaseType + " (" + DateAcct + ")");
        }
        return open;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isOpen(Properties ctx, int tableID, int recordID, String trxName) {
        String docBaseType;
        Timestamp dateAcct;
        PO po;
        MTable table2;
        block13: {
            Integer doctypeID;
            block25: {
                Object objint;
                int idxdoctype;
                block26: {
                    block24: {
                        block15: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block19: {
                                                block18: {
                                                    block17: {
                                                        block16: {
                                                            block14: {
                                                                table2 = MTable.get(ctx, tableID);
                                                                po = table2.getPO(recordID, trxName);
                                                                int idxdate = -1;
                                                                idxdate = tableID == 321 || tableID == 323 || tableID == 325 || tableID == 623 ? po.get_ColumnIndex("MovementDate") : (tableID == 702 ? po.get_ColumnIndex("DateDoc") : (tableID == 392 ? po.get_ColumnIndex("StatementDate") : (tableID == 735 || tableID == 472 || tableID == 473 ? po.get_ColumnIndex("DateTrx") : po.get_ColumnIndex("DateAcct"))));
                                                                if (idxdate < 0) {
                                                                    if (s_log.isLoggable(Level.INFO)) {
                                                                        s_log.info("Could not find DateAcct for " + table2.getTableName());
                                                                    }
                                                                    return true;
                                                                }
                                                                dateAcct = null;
                                                                Object objts = po.get_Value(idxdate);
                                                                if (objts == null || !(objts instanceof Timestamp)) break block14;
                                                                dateAcct = (Timestamp)objts;
                                                                docBaseType = null;
                                                                idxdoctype = po.get_ColumnIndex("C_DocType_ID");
                                                                if (idxdoctype >= 0) break block15;
                                                                break block16;
                                                            }
                                                            s_log.warning("Could not find DateAcct (null or not Timestamp) for " + table2.getTableName());
                                                            return true;
                                                        }
                                                        if (tableID != 321) break block17;
                                                        docBaseType = "MMI";
                                                        break block13;
                                                    }
                                                    if (tableID != 325) break block18;
                                                    docBaseType = "MMP";
                                                    break block13;
                                                }
                                                if (tableID != 702) break block19;
                                                docBaseType = "POR";
                                                break block13;
                                            }
                                            if (tableID != 392) break block20;
                                            docBaseType = "CMB";
                                            break block13;
                                        }
                                        if (tableID != 735) break block21;
                                        docBaseType = "CMA";
                                        break block13;
                                    }
                                    if (tableID != 472) break block22;
                                    docBaseType = "MXI";
                                    break block13;
                                }
                                if (tableID != 473) break block23;
                                docBaseType = "MXP";
                                break block13;
                            }
                            if (tableID == 53137 || tableID == 53275 || tableID == 53128) {
                                docBaseType = "GLJ";
                                break block13;
                            } else if (tableID == 53127 || tableID == 53115) {
                                docBaseType = "GLD";
                                break block13;
                            } else {
                                if (tableID != 623) {
                                    s_log.warning("Could not find C_DocType_ID for " + table2.getTableName());
                                    return true;
                                }
                                docBaseType = "PJI";
                            }
                            break block13;
                        }
                        doctypeID = null;
                        objint = po.get_Value(idxdoctype);
                        if (objint == null || !(objint instanceof Integer)) break block24;
                        doctypeID = (Integer)objint;
                        if (doctypeID != 0) break block25;
                        break block26;
                    }
                    s_log.warning("Could not find C_DocType_ID (null or not Integer) for " + table2.getTableName());
                    return true;
                }
                if ((tableID == 259 || tableID == 318) && (objint = po.get_Value(idxdoctype = po.get_ColumnIndex("C_DocTypeTarget_ID"))) != null && objint instanceof Integer) {
                    doctypeID = (Integer)objint;
                }
            }
            MDocType dt = MDocType.get(ctx, doctypeID);
            docBaseType = dt.getDocBaseType();
        }
        if (Util.isEmpty(docBaseType)) {
            s_log.warning("Could not find DocBaseType for " + table2.getTableName());
            return true;
        }
        int orgID = 0;
        int idxorg = po.get_ColumnIndex("AD_Org_ID");
        if (idxorg < 0) {
            s_log.warning("Could not find AD_Org_ID for " + table2.getTableName());
        } else {
            orgID = po.get_ValueAsInt(idxorg);
        }
        if (tableID != 224 && tableID != 225) {
            return MPeriod.isOpen(ctx, dateAcct, docBaseType, orgID);
        }
        int periodID = po.get_ValueAsInt("C_Period_ID");
        MPeriod period = MPeriod.get(ctx, periodID);
        boolean open = period.isOpen(docBaseType, dateAcct);
        if (!open) {
            s_log.warning(String.valueOf(period.getName()) + ": Not open for " + docBaseType + " (" + dateAcct + ")");
        }
        return open;
    }

    public static MPeriod getFirstInYear(Properties ctx, Timestamp DateAcct) {
        return MPeriod.getFirstInYear(ctx, DateAcct, 0);
    }

    public static MPeriod getFirstInYear(Properties ctx, Timestamp DateAcct, int AD_Org_ID) {
        MPeriod retValue;
        block6: {
            retValue = null;
            int C_Calendar_ID = MPeriod.get(ctx, DateAcct, AD_Org_ID, null).getC_Calendar_ID();
            String sql = "SELECT * FROM C_Period WHERE C_Year_ID IN (SELECT p.C_Year_ID FROM C_Year y INNER JOIN C_Period p ON (y.C_Year_ID=p.C_Year_ID) WHERE y.C_Calendar_ID=?     AND ? BETWEEN StartDate AND EndDate) AND IsActive=? AND PeriodType=? ORDER BY StartDate";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, C_Calendar_ID);
                    pstmt.setTimestamp(2, DateAcct);
                    pstmt.setString(3, "Y");
                    pstmt.setString(4, "S");
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MPeriod(ctx, rs, null);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public MPeriod(Properties ctx, int C_Period_ID, String trxName) {
        super(ctx, C_Period_ID, trxName);
        if (C_Period_ID == 0) {
            this.setPeriodType("S");
        }
    }

    public MPeriod(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPeriod(MYear year, int PeriodNo, String name, Timestamp startDate, Timestamp endDate) {
        this(year.getCtx(), 0, year.get_TrxName());
        this.setClientOrg(year);
        this.setC_Year_ID(year.getC_Year_ID());
        this.setPeriodNo(PeriodNo);
        this.setName(name);
        this.setStartDate(startDate);
        this.setEndDate(endDate);
    }

    public MPeriod(MPeriod copy) {
        this(Env.getCtx(), copy);
    }

    public MPeriod(Properties ctx, MPeriod copy) {
        this(ctx, copy, null);
    }

    public MPeriod(Properties ctx, MPeriod copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_C_Calendar_ID = copy.m_C_Calendar_ID;
        this.m_controls = copy.m_controls != null ? (MPeriodControl[])Arrays.stream(copy.m_controls).map(e -> new MPeriodControl(ctx, (MPeriodControl)e, trxName)).toArray(MPeriodControl[]::new) : null;
    }

    public MPeriodControl[] getPeriodControls(boolean requery) {
        ArrayList<MPeriodControl> list;
        block8: {
            if (this.m_controls != null && !requery) {
                return this.m_controls;
            }
            list = new ArrayList<MPeriodControl>();
            String sql = "SELECT * FROM C_PeriodControl WHERE C_Period_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getC_Period_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MPeriodControl(this.getCtx(), rs, null));
                    }
                }
                catch (Exception e2) {
                    this.log.log(Level.SEVERE, sql, e2);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (list.size() > 0 && this.is_Immutable()) {
            list.stream().forEach(e -> {
                MPeriodControl mPeriodControl = e.markImmutable();
            });
        }
        this.m_controls = new MPeriodControl[list.size()];
        list.toArray(this.m_controls);
        return this.m_controls;
    }

    public MPeriodControl getPeriodControl(String DocBaseType) {
        if (DocBaseType == null) {
            return null;
        }
        this.getPeriodControls(false);
        int i2 = 0;
        while (i2 < this.m_controls.length) {
            if (DocBaseType.equals(this.m_controls[i2].getDocBaseType())) {
                return this.m_controls[i2];
            }
            ++i2;
        }
        return null;
    }

    public boolean isInPeriod(Timestamp date) {
        Timestamp from;
        if (date == null) {
            return false;
        }
        Timestamp dateOnly = TimeUtil.getDay(date);
        if (dateOnly.before(from = TimeUtil.getDay(this.getStartDate()))) {
            return false;
        }
        Timestamp to = TimeUtil.getDay(this.getEndDate());
        return !dateOnly.after(to);
    }

    public boolean isOpen(String DocBaseType) {
        return this.isOpen(DocBaseType, null);
    }

    public boolean isOpen(String DocBaseType, Timestamp dateAcct) {
        if (!this.isActive()) {
            s_log.warning("Period not active: " + this.getName());
            return false;
        }
        MAcctSchema as = MClient.get(this.getCtx(), this.getAD_Client_ID()).getAcctSchema();
        if (as != null && as.isAutoPeriodControl()) {
            Timestamp date2;
            Timestamp date1;
            Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
            Timestamp first = TimeUtil.addDays(today, -as.getPeriod_OpenHistory());
            Timestamp last = TimeUtil.addDays(today, as.getPeriod_OpenFuture());
            if (dateAcct != null) {
                date2 = date1 = TimeUtil.trunc(dateAcct, "D");
            } else {
                date1 = this.getStartDate();
                date2 = this.getEndDate();
            }
            if (date1.before(first)) {
                this.log.warning("Automatic Period Control:" + date1 + " before first day - " + first);
                return false;
            }
            if (date2.after(last)) {
                this.log.warning("Automatic Period Control:" + date2 + " after last day - " + last);
                return false;
            }
            if (this.isInPeriod(today) && as.getC_Period_ID() != this.getC_Period_ID() && (as = new MAcctSchema(Env.getCtx(), as.getC_AcctSchema_ID(), null)).getC_Period_ID() != this.getC_Period_ID()) {
                as.setC_Period_ID(this.getC_Period_ID());
                as.saveEx();
            }
            return true;
        }
        if (DocBaseType == null) {
            this.log.warning(String.valueOf(this.getName()) + " - No DocBaseType");
            return false;
        }
        MPeriodControl pc = this.getPeriodControl(DocBaseType);
        if (pc == null) {
            this.log.warning(String.valueOf(this.getName()) + " - Period Control not found for " + DocBaseType);
            return false;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.getName()) + ": " + DocBaseType);
        }
        return pc.isOpen();
    }

    public boolean isStandardPeriod() {
        return "S".equals(this.getPeriodType());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        Timestamp date = this.getStartDate();
        if (date == null) {
            return false;
        }
        this.setStartDate(TimeUtil.getDay(date));
        date = this.getEndDate();
        if (date != null) {
            this.setEndDate(TimeUtil.getDay(date));
        } else {
            this.setEndDate(TimeUtil.getMonthLastDay(this.getStartDate()));
        }
        if (this.getEndDate().before(this.getStartDate())) {
            SimpleDateFormat df = DisplayType.getDateFormat(15);
            this.log.saveError("Error", String.valueOf(df.format(this.getEndDate())) + " < " + df.format(this.getStartDate()));
            return false;
        }
        MYear year = new MYear(this.getCtx(), this.getC_Year_ID(), this.get_TrxName());
        Query query = MTable.get(this.getCtx(), "C_Period").createQuery("C_Year_ID IN (SELECT y.C_Year_ID from C_Year y WHERE                   y.C_Calendar_ID =?) AND (? BETWEEN StartDate AND EndDate OR ? BETWEEN StartDate AND EndDate) AND PeriodType=?", this.get_TrxName());
        query.setParameters(year.getC_Calendar_ID(), this.getStartDate(), this.getEndDate(), this.getPeriodType());
        List periods = query.list();
        int i2 = 0;
        while (i2 < periods.size()) {
            if (((MPeriod)periods.get(i2)).getC_Period_ID() != this.getC_Period_ID()) {
                this.log.saveError("Error", "Period overlaps with: " + ((MPeriod)periods.get(i2)).getName());
                return false;
            }
            ++i2;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord) {
            MDocType[] types = MDocType.getOfClient(this.getCtx());
            int count = 0;
            ArrayList<String> baseTypes = new ArrayList<String>();
            int i2 = 0;
            while (i2 < types.length) {
                MDocType type = types[i2];
                String DocBaseType = type.getDocBaseType();
                if (!baseTypes.contains(DocBaseType)) {
                    MPeriodControl pc = new MPeriodControl(this, DocBaseType);
                    pc.saveEx();
                    ++count;
                    baseTypes.add(DocBaseType);
                }
                ++i2;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("PeriodControl #" + count);
            }
        }
        return success;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MPeriod[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(", ").append(this.getStartDate()).append("-").append(this.getEndDate()).append("]");
        return sb.toString();
    }

    public static void testPeriodOpen(Properties ctx, Timestamp dateAcct, String docBaseType) throws PeriodClosedException {
        if (!MPeriod.isOpen(ctx, dateAcct, docBaseType, 0)) {
            throw new PeriodClosedException(dateAcct, docBaseType);
        }
    }

    public static void testPeriodOpen(Properties ctx, Timestamp dateAcct, String docBaseType, int AD_Org_ID) throws PeriodClosedException {
        if (!MPeriod.isOpen(ctx, dateAcct, docBaseType, AD_Org_ID)) {
            throw new PeriodClosedException(dateAcct, docBaseType);
        }
    }

    public static void testPeriodOpen(Properties ctx, Timestamp dateAcct, int C_DocType_ID) throws PeriodClosedException {
        MDocType dt = MDocType.get(ctx, C_DocType_ID);
        MPeriod.testPeriodOpen(ctx, dateAcct, dt.getDocBaseType(), 0);
    }

    public static void testPeriodOpen(Properties ctx, Timestamp dateAcct, int C_DocType_ID, int AD_Org_ID) throws PeriodClosedException {
        MDocType dt = MDocType.get(ctx, C_DocType_ID);
        MPeriod.testPeriodOpen(ctx, dateAcct, dt.getDocBaseType(), AD_Org_ID);
    }

    public int getC_Calendar_ID() {
        if (this.m_C_Calendar_ID == 0) {
            int calId = DB.getSQLValueEx(null, "SELECT C_Calendar_ID FROM C_Year WHERE C_Year_ID=?", this.getC_Year_ID());
            if (calId >= 0) {
                this.m_C_Calendar_ID = calId;
            } else {
                this.log.severe("@NotFound@ C_Year_ID=" + this.getC_Year_ID());
            }
        }
        return this.m_C_Calendar_ID;
    }

    public static int getC_Calendar_ID(Properties ctx, int AD_Org_ID) {
        int C_Calendar_ID = 0;
        if (AD_Org_ID != 0) {
            MOrgInfo info = MOrgInfo.get(ctx, AD_Org_ID, null);
            C_Calendar_ID = info.getC_Calendar_ID();
        }
        if (C_Calendar_ID == 0) {
            MClientInfo cInfo = MClientInfo.get(ctx);
            C_Calendar_ID = cInfo.getC_Calendar_ID();
        }
        return C_Calendar_ID;
    }

    @Override
    public MPeriod markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_controls != null && this.m_controls.length > 0) {
            Arrays.stream(this.m_controls).forEach(e -> {
                MPeriodControl mPeriodControl = e.markImmutable();
            });
        }
        return this;
    }
}

