/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MPasswordHistory;
import org.compiere.model.X_AD_PasswordRule;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.util.HistoryRuleSupportHash;
import org.passay.CharacterCharacteristicsRule;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.DictionarySubstringRule;
import org.passay.EnglishCharacterData;
import org.passay.EnglishSequenceData;
import org.passay.IllegalSequenceRule;
import org.passay.LengthRule;
import org.passay.MessageResolver;
import org.passay.PasswordData;
import org.passay.PasswordGenerator;
import org.passay.PasswordValidator;
import org.passay.PropertiesMessageResolver;
import org.passay.RepeatCharacterRegexRule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;
import org.passay.SequenceData;
import org.passay.UsernameRule;
import org.passay.WhitespaceRule;
import org.passay.dictionary.ArrayWordList;
import org.passay.dictionary.Dictionary;
import org.passay.dictionary.WordList;
import org.passay.dictionary.WordListDictionary;
import org.passay.dictionary.WordLists;
import org.passay.dictionary.sort.ArraySorter;
import org.passay.dictionary.sort.ArraysSort;

public class MPasswordRule
extends X_AD_PasswordRule {
    private static final long serialVersionUID = 6778305268023192107L;
    private static final String passay_prefix = "PASSAY_";

    public MPasswordRule(Properties ctx, int AD_PasswordRule_ID, String trxName) {
        super(ctx, AD_PasswordRule_ID, trxName);
    }

    public MPasswordRule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MPasswordRule getRules(Properties ctx, String trxName) {
        MClient system = MClient.get(ctx, 0);
        int pwdruleID = system.getAD_PasswordRule_ID();
        MPasswordRule pass = null;
        if (pwdruleID > 0) {
            pass = new MPasswordRule(ctx, pwdruleID, trxName);
        }
        return pass;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isUsingDictionary()) {
            StringBuilder msg = new StringBuilder();
            if (Util.isEmpty(this.getPathDictionary())) {
                msg.append(Msg.getElement(this.getCtx(), "PathDictionary"));
            }
            if (msg.length() > 0) {
                this.log.saveError("FillMandatory", msg.toString());
                return false;
            }
        }
        return true;
    }

    public void validate(String username, String newPassword, List<MPasswordHistory> passwordHistorys) throws AdempiereException {
        ArrayList<Object> ruleList = new ArrayList<Object>();
        if (this.getMinLength() > 0 || this.getMaxLength() > 0) {
            LengthRule lengthRule = new LengthRule();
            if (this.getMinLength() > 0) {
                lengthRule.setMinimumLength(this.getMinLength());
            }
            if (this.getMaxLength() > 0) {
                lengthRule.setMaximumLength(this.getMaxLength());
            }
            ruleList.add(lengthRule);
        }
        if (this.isWhitespace()) {
            ruleList.add(new WhitespaceRule());
        }
        CharacterCharacteristicsRule charRule = new CharacterCharacteristicsRule();
        int numValidations = 0;
        if (this.getDigitCharacter() > 0) {
            ++numValidations;
            charRule.getRules().add(new CharacterRule((CharacterData)EnglishCharacterData.Digit, this.getDigitCharacter()));
        }
        if (this.getNonAlphaNumericCharacter() > 0) {
            ++numValidations;
            charRule.getRules().add(new CharacterRule((CharacterData)EnglishCharacterData.Special, this.getNonAlphaNumericCharacter()));
        }
        if (this.getUppercaseCharacter() > 0) {
            ++numValidations;
            charRule.getRules().add(new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, this.getUppercaseCharacter()));
        }
        if (this.getLowercaseCharacter() > 0) {
            ++numValidations;
            charRule.getRules().add(new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, this.getLowercaseCharacter()));
        }
        if (this.getAlphabeticalCharacter() > 0) {
            ++numValidations;
            charRule.getRules().add(new CharacterRule((CharacterData)EnglishCharacterData.Alphabetical, this.getAlphabeticalCharacter()));
        }
        if (!charRule.getRules().isEmpty()) {
            charRule.setNumberOfCharacteristics(numValidations);
            ruleList.add(charRule);
        }
        if (this.getAlphabeticalSequence() > 0) {
            ruleList.add(new IllegalSequenceRule((SequenceData)EnglishSequenceData.Alphabetical, this.getAlphabeticalSequence(), true));
        }
        if (this.getNumericalSequence() > 0) {
            ruleList.add(new IllegalSequenceRule((SequenceData)EnglishSequenceData.Numerical, this.getNumericalSequence(), true));
        }
        if (this.getQWERTYSequence() > 0) {
            ruleList.add(new IllegalSequenceRule((SequenceData)EnglishSequenceData.USQwerty, this.getQWERTYSequence(), true));
        }
        if (this.getRepeatCharacterRegex() > 0) {
            ruleList.add(new RepeatCharacterRegexRule(this.getRepeatCharacterRegex()));
        }
        if (this.isUserNameRule()) {
            ruleList.add(new UsernameRule(true, true));
        }
        if (this.isUsingDictionary() && this.getPathDictionary().length() > 0) {
            try {
                ArrayWordList awl = WordLists.createFromReader((Reader[])new FileReader[]{new FileReader(this.getPathDictionary())}, (boolean)true, (ArraySorter)new ArraysSort());
                WordListDictionary dict = new WordListDictionary((WordList)awl);
                DictionarySubstringRule dictRule = new DictionarySubstringRule((Dictionary)dict);
                if (this.isDictMatchBackwards()) {
                    dictRule.setMatchBackwards(true);
                }
                ruleList.add(dictRule);
            }
            catch (FileNotFoundException e) {
                throw new AdempiereException("Could not find dictionary file: " + e.getMessage());
            }
            catch (IOException e) {
                throw new AdempiereException("Could not find dictionary file: " + e.getMessage());
            }
        }
        ArrayList<PasswordData.HistoricalReference> historyData = new ArrayList<PasswordData.HistoricalReference>();
        for (MPasswordHistory passwordHistory : passwordHistorys) {
            historyData.add(new PasswordData.HistoricalReference(passwordHistory.getSalt(), passwordHistory.getPassword()));
        }
        HistoryRuleSupportHash historyRule = new HistoryRuleSupportHash();
        ruleList.add((Object)historyRule);
        if (!ruleList.isEmpty()) {
            PasswordValidator validator = new PasswordValidator(this.getCustomResolver(), ruleList);
            PasswordData passwordData = new PasswordData(username, newPassword);
            passwordData.setPasswordReferences(historyData);
            RuleResult result = validator.validate(passwordData);
            if (!result.isValid()) {
                StringBuilder error = new StringBuilder(Msg.getMsg(this.getCtx(), "PasswordErrors"));
                for (RuleResultDetail detail : result.getDetails()) {
                    error.append("\n- ").append(this.resolveMessage(detail));
                }
                throw new AdempiereException(error.toString());
            }
        }
    }

    private String resolveMessage(RuleResultDetail detail) {
        String key = passay_prefix + detail.getErrorCode();
        String message = Msg.translate(Env.getAD_Language(this.getCtx()), key);
        String format = !message.equals(key) ? String.format(message, detail.getValues()) : (!detail.getParameters().isEmpty() ? String.format("%s:%s", key, detail.getParameters()) : String.format("%s", key));
        return format;
    }

    private MessageResolver getCustomResolver() {
        Properties props;
        block15: {
            props = null;
            InputStream in = null;
            try {
                try {
                    StringBuilder file = new StringBuilder("vtpassword_messages_").append(Env.getLoginLanguage(this.getCtx()).getLocale().getLanguage()).append(".properties");
                    in = this.getClass().getResourceAsStream(file.toString());
                    if (in != null) {
                        props = new Properties();
                        props.load(in);
                    }
                }
                catch (Exception e) {
                    props = null;
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    in = null;
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    in = null;
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                in = null;
            }
        }
        if (props == null) {
            return new PropertiesMessageResolver();
        }
        return new PropertiesMessageResolver(props);
    }

    public String generate() {
        int len;
        CharacterCharacteristicsRule charRule = new CharacterCharacteristicsRule();
        int numValidations = 0;
        if (this.getDigitCharacter() > 0) {
            ++numValidations;
            charRule.getRules().add(new CharacterRule((CharacterData)EnglishCharacterData.Digit, this.getDigitCharacter()));
        }
        if (this.getNonAlphaNumericCharacter() > 0) {
            ++numValidations;
            charRule.getRules().add(new CharacterRule((CharacterData)EnglishCharacterData.Special, this.getNonAlphaNumericCharacter()));
        }
        if (this.getUppercaseCharacter() > 0) {
            ++numValidations;
            charRule.getRules().add(new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, this.getUppercaseCharacter()));
        }
        if (this.getLowercaseCharacter() > 0) {
            ++numValidations;
            charRule.getRules().add(new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, this.getLowercaseCharacter()));
        }
        if (this.getAlphabeticalCharacter() > 0) {
            ++numValidations;
            charRule.getRules().add(new CharacterRule((CharacterData)EnglishCharacterData.Alphabetical, this.getAlphabeticalCharacter()));
        }
        if (!charRule.getRules().isEmpty()) {
            charRule.setNumberOfCharacteristics(numValidations);
        }
        if ((len = 10) < this.getMinLength()) {
            len = this.getMinLength();
        }
        if (len > this.getMaxLength()) {
            len = this.getMaxLength();
        }
        return new PasswordGenerator().generatePassword(len, charRule.getRules());
    }
}

