/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MClientInfo;
import org.compiere.model.X_M_PackageMPS;
import org.compiere.util.DB;

public class MPackageMPS
extends X_M_PackageMPS {
    private static final long serialVersionUID = 2426722699419960060L;

    public MPackageMPS(Properties ctx, int M_PackageMPS_ID, String trxName) {
        super(ctx, M_PackageMPS_ID, trxName);
        if (M_PackageMPS_ID == 0) {
            MClientInfo clientInfo = MClientInfo.get(ctx, this.getAD_Client_ID());
            this.setC_UOM_Weight_ID(clientInfo.getC_UOM_Weight_ID());
            this.setC_UOM_Length_ID(clientInfo.getC_UOM_Length_ID());
        }
    }

    public MPackageMPS(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String sql;
        if (this.getSeqNo() == 0) {
            sql = "SELECT COALESCE(MAX(SeqNo),0)+10 FROM M_PackageMPS WHERE M_Package_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getM_Package_ID());
            this.setSeqNo(ii);
        }
        if (this.getWeight() == null || this.getWeight().compareTo(BigDecimal.ZERO) == 0) {
            sql = "SELECT SUM(LineWeight) FROM X_PackageLineWeight plw WHERE plw.M_PackageMPS_ID=?";
            BigDecimal weight = DB.getSQLValueBD(this.get_TrxName(), sql, this.getM_PackageMPS_ID());
            if (weight == null) {
                weight = BigDecimal.ZERO;
            }
            this.setWeight(weight);
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        String sql = "DELETE FROM M_PackageLine WHERE M_PackageMPS_ID = ?";
        DB.executeUpdate(sql, this.getM_PackageMPS_ID(), this.get_TrxName());
        return true;
    }
}

