/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.ShippingUtil;
import org.compiere.model.MAttachment;
import org.compiere.model.MClientInfo;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPackageLine;
import org.compiere.model.MPackageMPS;
import org.compiere.model.MProduct;
import org.compiere.model.MShipper;
import org.compiere.model.MShipperLabels;
import org.compiere.model.MShipperPackaging;
import org.compiere.model.MShipperPickupTypes;
import org.compiere.model.MShippingTransaction;
import org.compiere.model.MShippingTransactionLine;
import org.compiere.model.PO;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_InvoiceLine;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_C_OrderLine;
import org.compiere.model.X_M_MatchPO;
import org.compiere.model.X_M_Package;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class MPackage
extends X_M_Package {
    private static final long serialVersionUID = 6082002551560148518L;
    private String m_errorMessage = null;

    public static MPackage create(MInOut shipment, MShipper shipper, Timestamp shipDate) {
        MPackage retValue = MPackage.createPackage(shipment, shipper, shipDate);
        MPackageMPS packageMPS = new MPackageMPS(shipment.getCtx(), 0, shipment.get_TrxName());
        packageMPS.setSeqNo(10);
        packageMPS.setM_Package_ID(retValue.getM_Package_ID());
        packageMPS.saveEx();
        MClientInfo ci = MClientInfo.get(shipment.getCtx(), shipment.getAD_Client_ID(), shipment.get_TrxName());
        MInOutLine[] lines = shipment.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MInOutLine sLine = lines[i2];
            if (sLine.getM_Product_ID() > 0 && sLine.getM_Product_ID() != ci.getM_ProductFreight_ID()) {
                MProduct product = new MProduct(shipment.getCtx(), sLine.getM_Product_ID(), shipment.get_TrxName());
                if (product.isBOM() && product.isVerified() && product.isPickListPrintDetails()) {
                    MPPProductBOMLine[] bomLines;
                    MPPProductBOM bom = MPPProductBOM.getDefault(product, shipment.get_TrxName());
                    MPPProductBOMLine[] mPPProductBOMLineArray = bomLines = bom.getLines();
                    int n = bomLines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MPPProductBOMLine bomLine = mPPProductBOMLineArray[n2];
                        MPackageLine pLine = new MPackageLine(retValue);
                        pLine.setInOutLine(sLine);
                        pLine.setM_Product_ID(bomLine.getM_Product_ID());
                        pLine.setQty(sLine.getQtyEntered().multiply(bomLine.getQtyBOM()));
                        pLine.setM_PackageMPS_ID(packageMPS.getM_PackageMPS_ID());
                        pLine.saveEx();
                        ++n2;
                    }
                } else {
                    MPackageLine pLine = new MPackageLine(retValue);
                    pLine.setInOutLine(sLine);
                    pLine.setM_Product_ID(sLine.getM_Product_ID());
                    pLine.setM_PackageMPS_ID(packageMPS.getM_PackageMPS_ID());
                    pLine.saveEx();
                }
            }
            ++i2;
        }
        retValue.setBoxCount(1);
        retValue.saveEx();
        return retValue;
    }

    public static MPackage createPackage(MInOut shipment, MShipper shipper, Timestamp shipDate) {
        MPackage retValue = new MPackage(shipment, shipper);
        if (shipDate != null) {
            retValue.setShipDate(shipDate);
        }
        retValue.setBoxCount(0);
        retValue.saveEx();
        return retValue;
    }

    public MPackage(Properties ctx, int M_Package_ID, String trxName) {
        super(ctx, M_Package_ID, trxName);
        if (M_Package_ID == 0) {
            this.setShipDate(new Timestamp(System.currentTimeMillis()));
            MClientInfo clientInfo = MClientInfo.get(ctx, this.getAD_Client_ID());
            this.setC_UOM_Weight_ID(clientInfo.getC_UOM_Weight_ID());
            this.setC_UOM_Length_ID(clientInfo.getC_UOM_Length_ID());
        }
    }

    public MPackage(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPackage(MInOut shipment, MShipper shipper) {
        this(shipment.getCtx(), 0, shipment.get_TrxName());
        int InvoiceLocationID;
        this.setClientOrg(shipment);
        this.setM_InOut_ID(shipment.getM_InOut_ID());
        this.setM_Shipper_ID(shipper.getM_Shipper_ID());
        MOrder order = null;
        if (shipment.getC_Order_ID() > 0) {
            order = new MOrder(this.getCtx(), shipment.getC_Order_ID(), this.get_TrxName());
        } else {
            MMatchPO[] mos;
            MMatchPO[] mMatchPOArray = mos = MMatchPO.getInOut(this.getCtx(), shipment.getM_InOut_ID(), this.get_TrxName());
            int n = mos.length;
            int n2 = 0;
            while (n2 < n) {
                MMatchPO mo = mMatchPOArray[n2];
                MOrderLine ol = new MOrderLine(this.getCtx(), mo.getC_OrderLine_ID(), this.get_TrxName());
                if (ol.getC_Order_ID() > 0) {
                    order = new MOrder(this.getCtx(), ol.getC_Order_ID(), this.get_TrxName());
                    break;
                }
                ++n2;
            }
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Notification for shipment " + shipment.getDocumentNo());
        if (order != null) {
            msg.append(" / order " + order.getDocumentNo());
        }
        this.setNotificationMessage(msg.toString());
        this.setC_Currency_ID(shipment.getC_Currency_ID());
        String whereClause = "M_Shipper_ID = " + shipper.getM_Shipper_ID() + " AND IsDefault='Y' AND IsActive='Y'";
        int[] ids = MShipperLabels.getAllIDs("M_ShipperLabels", whereClause, shipment.get_TrxName());
        if (ids.length > 0) {
            this.setM_ShipperLabels_ID(ids[0]);
        }
        if ((ids = MShipperPackaging.getAllIDs("M_ShipperPackaging", whereClause, shipment.get_TrxName())).length > 0) {
            this.setM_ShipperPackaging_ID(ids[0]);
        }
        if ((ids = MShipperPickupTypes.getAllIDs("M_ShipperPickupTypes", whereClause, shipment.get_TrxName())).length > 0) {
            this.setM_ShipperPickupTypes_ID(ids[0]);
        }
        if ((InvoiceLocationID = ShippingUtil.findRecipientAccountLocationId(shipper.getM_Shipper_ID(), shipment.getC_BPartner_ID(), shipper.getAD_Org_ID(), shipment.getM_InOut_ID(), 0)) > 0) {
            this.setC_BPartner_Location_ID(InvoiceLocationID);
        }
        this.setIsResidential(shipper.isResidential());
        this.setIsSaturdayDelivery(shipper.isSaturdayDelivery());
        this.setTrackingInfo(shipper.getTrackingURL());
        if (shipment.getFreightCharges() != null) {
            String shipperAccount = null;
            String dutiesShipperAccount = null;
            if (shipment.getFreightCharges().equals("D_PP") || shipment.getFreightCharges().equals("E_PPB")) {
                shipperAccount = ShippingUtil.getSenderShipperAccount(shipper.getM_Shipper_ID(), shipper.getAD_Org_ID());
                dutiesShipperAccount = ShippingUtil.getSenderDutiesShipperAccount(shipper.getM_Shipper_ID(), shipper.getAD_Org_ID());
            } else {
                shipperAccount = shipment.getShipperAccount();
            }
            if (shipperAccount != null) {
                this.setShipperAccount(shipperAccount);
            }
            if (dutiesShipperAccount != null) {
                this.setDutiesShipperAccount(dutiesShipperAccount);
            }
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getWeight() == null || this.getWeight().compareTo(BigDecimal.ZERO) == 0) {
            String sql = "SELECT SUM(LineWeight) FROM X_PackageLineWeight plw WHERE plw.M_Package_ID=?";
            BigDecimal weight = DB.getSQLValueBD(this.get_TrxName(), sql, this.getM_Package_ID());
            if (weight == null) {
                weight = BigDecimal.ZERO;
            }
            this.setWeight(weight);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(*) FROM M_PackageMPS ");
        sb.append("WHERE M_Package_ID = ?");
        int packageMPSCount = DB.getSQLValue(this.get_TrxName(), sb.toString(), this.getM_Package_ID());
        if (this.getBoxCount() > 0 && this.getBoxCount() - packageMPSCount > 0) {
            int i2 = 0;
            while (i2 < this.getBoxCount() - packageMPSCount) {
                MPackageMPS packageMPS = new MPackageMPS(this.getCtx(), 0, this.get_TrxName());
                packageMPS.setM_Package_ID(this.getM_Package_ID());
                packageMPS.saveEx();
                ++i2;
            }
        }
        return success;
    }

    @Override
    protected boolean beforeDelete() {
        String sql = "DELETE FROM M_PackageLine WHERE M_PackageMPS_ID IN (SELECT M_PackageMPS_ID FROM M_PackageMPS WHERE M_Package_ID = ?)";
        DB.executeUpdate(sql, this.getM_Package_ID(), this.get_TrxName());
        sql = "DELETE FROM M_PackageMPS WHERE M_Package_ID = ?";
        DB.executeUpdate(sql, this.getM_Package_ID(), this.get_TrxName());
        return true;
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public boolean processOnline(String action, boolean isPriviledgedRate) {
        this.setErrorMessage(null);
        Trx trx = Trx.get(Trx.createTrxName("spt-"), true);
        trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_processOnline");
        boolean ok = false;
        try {
            try {
                MShippingTransaction st = this.createShippingTransaction(action, isPriviledgedRate, trx.getTrxName());
                ok = st.processOnline();
                st.saveEx();
                if (action.equals("PS")) {
                    this.setShippingRespMessage(st.getShippingRespMessage());
                    if (ok) {
                        MShippingTransactionLine[] lines;
                        this.setPrice(st.getPrice());
                        this.setSurcharges(st.getSurcharges());
                        this.setTrackingNo(st.getTrackingNo());
                        this.setProcessed(true);
                        MAttachment stAttachment = st.getAttachment(true);
                        if (stAttachment != null && stAttachment.getEntryCount() > 0) {
                            MAttachment attachment = this.getAttachment(true);
                            if (attachment == null) {
                                attachment = this.createAttachment();
                            }
                            int i2 = 0;
                            while (i2 < stAttachment.getEntryCount()) {
                                if (stAttachment.getEntry(i2).getName().startsWith("shipping_label") || stAttachment.getEntry(i2).getName().startsWith("commercial_invoice") || stAttachment.getEntry(i2).getName().startsWith("auxiliary_label") || stAttachment.getEntry(i2).getName().endsWith("_cod")) {
                                    attachment.addEntry(stAttachment.getEntry(i2));
                                }
                                ++i2;
                            }
                            attachment.saveEx();
                        }
                        MShippingTransactionLine[] mShippingTransactionLineArray = lines = st.getLines("");
                        int n = lines.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MShippingTransactionLine line = mShippingTransactionLineArray[n2];
                            if (line.getM_PackageMPS_ID() != 0) {
                                MPackageMPS packageMPS = new MPackageMPS(this.getCtx(), line.getM_PackageMPS_ID(), null);
                                packageMPS.setMasterTrackingNo(line.getMasterTrackingNo());
                                packageMPS.setTrackingNo(line.getTrackingNo());
                                packageMPS.setPrice(line.getPrice());
                                packageMPS.setProcessed(line.isProcessed());
                                packageMPS.saveEx();
                            }
                            ++n2;
                        }
                    }
                } else if (action.equals("RI")) {
                    this.setRateInquiryMessage(st.getShippingRespMessage());
                } else if (action.equals("VS")) {
                    this.setShippingRespMessage(st.getShippingRespMessage());
                    if (ok) {
                        this.setProcessed(false);
                        MAttachment attachment = this.getAttachment(true);
                        if (attachment != null) {
                            int i3 = attachment.getEntryCount() - 1;
                            while (i3 >= 0) {
                                if (attachment.getEntry(i3).getName().startsWith("shipping_label") || attachment.getEntry(i3).getName().startsWith("commercial_invoice") || attachment.getEntry(i3).getName().startsWith("auxiliary_label") || attachment.getEntry(i3).getName().endsWith("_cod")) {
                                    attachment.deleteEntry(i3);
                                }
                                --i3;
                            }
                            if (attachment.getTitle() != null) {
                                attachment.setTitle(attachment.getTitle());
                            } else {
                                attachment.setTitle("zip");
                            }
                            attachment.saveEx();
                        }
                    }
                }
                if (!ok) {
                    this.setErrorMessage(st.getErrorMessage());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "processOnline", e);
                this.setErrorMessage(String.valueOf(Msg.getMsg(Env.getCtx(), "ShippingNotProcessed")) + ": " + e.getMessage());
                if (trx != null) {
                    trx.commit();
                    trx.close();
                }
            }
        }
        finally {
            if (trx != null) {
                trx.commit();
                trx.close();
            }
        }
        return ok;
    }

    public MShippingTransaction createShippingTransaction(String action, boolean isPriviledgedRate, String trxName) {
        int n;
        int n2;
        PO[] pOArray;
        PO ol;
        MInOut ioOut = null;
        X_C_Invoice invoice = null;
        X_C_Order order = null;
        if (this.getM_InOut_ID() > 0) {
            int C_Invoice_ID;
            StringBuilder sb;
            int n3;
            PO[] pOArray2;
            ioOut = new MInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
            if (ioOut.getC_Invoice_ID() > 0) {
                invoice = new MInvoice(this.getCtx(), ioOut.getC_Invoice_ID(), this.get_TrxName());
            } else {
                MMatchInv[] mis = MMatchInv.getInOut(this.getCtx(), ioOut.getM_InOut_ID(), this.get_TrxName());
                pOArray2 = mis;
                n3 = mis.length;
                int n4 = 0;
                while (n4 < n3) {
                    MMatchInv mi = pOArray2[n4];
                    MInvoiceLine iol = new MInvoiceLine(this.getCtx(), mi.getC_InvoiceLine_ID(), this.get_TrxName());
                    if (iol.getC_Invoice_ID() > 0) {
                        invoice = new MInvoice(this.getCtx(), iol.getC_Invoice_ID(), this.get_TrxName());
                        break;
                    }
                    ++n4;
                }
                if (invoice == null) {
                    sb = new StringBuilder();
                    sb.append("SELECT C_Invoice_ID ");
                    sb.append("FROM C_InvoiceLine ");
                    sb.append("WHERE M_InOutLine_ID IN (");
                    sb.append("SELECT M_InOutLine_ID ");
                    sb.append("FROM M_InOutLine ");
                    sb.append("WHERE M_InOut_ID = ?) ");
                    sb.append("ORDER BY C_InvoiceLine_ID DESC");
                    C_Invoice_ID = DB.getSQLValue(this.get_TrxName(), sb.toString(), this.getM_InOut_ID());
                    if (C_Invoice_ID > 0) {
                        invoice = new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName());
                    }
                }
            }
            if (ioOut.getC_Order_ID() > 0) {
                order = new MOrder(this.getCtx(), ioOut.getC_Order_ID(), this.get_TrxName());
            } else {
                MMatchPO[] mos = MMatchPO.getInOut(this.getCtx(), ioOut.getM_InOut_ID(), this.get_TrxName());
                pOArray2 = mos;
                n3 = mos.length;
                C_Invoice_ID = 0;
                while (C_Invoice_ID < n3) {
                    PO mo = pOArray2[C_Invoice_ID];
                    ol = new MOrderLine(this.getCtx(), ((X_M_MatchPO)mo).getC_OrderLine_ID(), this.get_TrxName());
                    if (((X_C_OrderLine)ol).getC_Order_ID() > 0) {
                        order = new MOrder(this.getCtx(), ((X_C_OrderLine)ol).getC_Order_ID(), this.get_TrxName());
                        break;
                    }
                    ++C_Invoice_ID;
                }
                if (order == null) {
                    sb = new StringBuilder();
                    sb.append("SELECT C_Order_ID ");
                    sb.append("FROM C_OrderLine ");
                    sb.append("WHERE C_OrderLine_ID IN (");
                    sb.append("SELECT C_OrderLine_ID ");
                    sb.append("FROM M_InOutLine ");
                    sb.append("WHERE M_InOut_ID = ?) ");
                    sb.append("ORDER BY C_OrderLine_ID DESC");
                    int C_Order_ID = DB.getSQLValue(this.get_TrxName(), sb.toString(), this.getM_InOut_ID());
                    if (C_Order_ID > 0) {
                        order = new MOrder(this.getCtx(), C_Order_ID, this.get_TrxName());
                    }
                }
            }
            if (invoice == null && order != null) {
                StringBuilder sb2 = new StringBuilder();
                sb2.append("SELECT C_Invoice_ID ");
                sb2.append("FROM C_Invoice ");
                sb2.append("WHERE C_Order_ID = ? ");
                sb2.append("ORDER BY C_Invoice_ID DESC");
                int C_Invoice_ID2 = DB.getSQLValue(this.get_TrxName(), sb2.toString(), order.getC_Order_ID());
                if (C_Invoice_ID2 > 0) {
                    invoice = new MInvoice(this.getCtx(), C_Invoice_ID2, this.get_TrxName());
                }
            }
        }
        MClientInfo ci = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        BigDecimal CODAmount = BigDecimal.ZERO;
        BigDecimal CustomsValue = BigDecimal.ZERO;
        BigDecimal FreightAmt = BigDecimal.ZERO;
        if (invoice != null) {
            CODAmount = invoice.getGrandTotal();
            MInvoiceLine[] ils = ((MInvoice)invoice).getLines();
            pOArray = ils;
            n2 = ils.length;
            n = 0;
            while (n < n2) {
                PO il = pOArray[n];
                if (((X_C_InvoiceLine)il).getM_Product_ID() == ci.getM_ProductFreight_ID() || ((X_C_InvoiceLine)il).getC_Charge_ID() == ci.getC_ChargeFreight_ID()) {
                    FreightAmt = FreightAmt.add(((X_C_InvoiceLine)il).getLineNetAmt());
                }
                ++n;
            }
            CustomsValue = CODAmount.subtract(FreightAmt);
        } else if (order != null) {
            CODAmount = order.getGrandTotal();
            MOrderLine[] ols = ((MOrder)order).getLines();
            pOArray = ols;
            n2 = ols.length;
            n = 0;
            while (n < n2) {
                ol = pOArray[n];
                if (((X_C_OrderLine)ol).getM_Product_ID() > 0 && ((X_C_OrderLine)ol).getM_Product_ID() == ci.getM_ProductFreight_ID() || ((X_C_OrderLine)ol).getC_Charge_ID() > 0 && ((X_C_OrderLine)ol).getC_Charge_ID() == ci.getC_ChargeFreight_ID()) {
                    FreightAmt = FreightAmt.add(((X_C_OrderLine)ol).getLineNetAmt());
                }
                ++n;
            }
            CustomsValue = CODAmount.subtract(FreightAmt);
        }
        MShippingTransaction st = new MShippingTransaction(this.getCtx(), 0, trxName);
        st.setAction(action);
        st.setAD_Client_ID(this.getAD_Client_ID());
        st.setAD_Org_ID(this.getAD_Org_ID());
        st.setAD_User_ID(ioOut.getAD_User_ID() > 0 ? ioOut.getAD_User_ID() : order.getAD_User_ID());
        st.setBill_Location_ID(this.getC_BPartner_Location_ID());
        st.setBoxCount(this.getBoxCount());
        st.setC_BP_ShippingAcct_ID(this.getC_BP_ShippingAcct_ID());
        st.setC_BPartner_ID(ioOut.getC_BPartner_ID());
        st.setC_BPartner_Location_ID(ioOut.getC_BPartner_Location_ID());
        st.setC_Currency_ID(this.getC_Currency_ID());
        st.setC_Invoice_ID(invoice != null ? invoice.getC_Invoice_ID() : 0);
        st.setC_Order_ID(order != null ? order.getC_Order_ID() : 0);
        st.setC_UOM_Length_ID(this.getC_UOM_Length_ID());
        st.setC_UOM_Weight_ID(this.getC_UOM_Weight_ID());
        st.setCashOnDelivery(this.isCashOnDelivery());
        st.setCODAmount(CODAmount);
        st.setCustomsValue(CustomsValue);
        st.setDateReceived(this.getDateReceived());
        st.setDeliveryConfirmation(this.isDeliveryConfirmation());
        st.setDeliveryConfirmationType(this.getDeliveryConfirmationType());
        st.setDescription(this.getDescription());
        st.setDotHazardClassOrDivision(this.getDotHazardClassOrDivision());
        st.setDryIceWeight(this.getDryIceWeight());
        st.setDutiesShipperAccount(this.getDutiesShipperAccount());
        st.setFOB(this.getFOB());
        st.setFreightAmt(FreightAmt);
        st.setFreightCharges(this.getFreightCharges());
        st.setHandlingCharge(this.getHandlingCharge());
        st.setHeight(this.getHeight());
        st.setHoldAddress_ID(this.getHoldAddress_ID());
        st.setHomeDeliveryPremiumDate(this.getHomeDeliveryPremiumDate());
        st.setHomeDeliveryPremiumPhone(this.getHomeDeliveryPremiumPhone());
        st.setHomeDeliveryPremiumType(this.getHomeDeliveryPremiumType());
        st.setInsurance(this.getInsurance());
        st.setInsuredAmount(this.getInsuredAmount());
        st.setIsAccessible(this.isAccessible());
        st.setIsActive(this.isActive());
        st.setIsAddedHandling(this.isAddedHandling());
        st.setIsAlternateReturnAddress(ioOut.isAlternateReturnAddress());
        st.setIsCargoAircraftOnly(this.isCargoAircraftOnly());
        st.setIsDryIce(this.isDryIce());
        st.setIsDutiable(this.isDutiable());
        st.setIsFutureDayShipment(this.isFutureDayShipment());
        st.setIsHazMat(this.isHazMat());
        st.setIsHoldAtLocation(this.isHoldAtLocation());
        st.setIsIgnoreZipNotFound(this.isIgnoreZipNotFound());
        st.setIsIgnoreZipStateNotMatch(this.isIgnoreZipStateNotMatch());
        st.setIsPriviledgedRate(isPriviledgedRate);
        st.setIsResidential(this.isResidential());
        st.setIsSaturdayDelivery(this.isSaturdayDelivery());
        st.setIsSaturdayPickup(this.isSaturdayPickup());
        st.setIsVerbalConfirmation(this.isVerbalConfirmation());
        st.setLatestPickupTime(this.getLatestPickupTime());
        st.setLength(this.getLength());
        st.setM_InOut_ID(this.getM_InOut_ID());
        st.setM_Package_ID(this.getM_Package_ID());
        st.setM_Shipper_ID(this.getM_Shipper_ID());
        st.setM_ShipperLabels_ID(this.getM_ShipperLabels_ID());
        st.setM_ShipperPackaging_ID(this.getM_ShipperPackaging_ID());
        st.setM_ShipperPickupTypes_ID(this.getM_ShipperPickupTypes_ID());
        st.setM_ShippingProcessor_ID(this.getM_ShippingProcessor_ID());
        st.setM_Warehouse_ID(ioOut.getM_Warehouse_ID());
        st.setNotificationMessage(this.getNotificationMessage());
        st.setNotificationType(this.getNotificationType());
        st.setPaymentRule(this.getPaymentRule());
        st.setPOReference(ioOut.getPOReference() != null ? ioOut.getPOReference() : order.getPOReference());
        st.setPrice(this.getPrice());
        st.setPriceActual(this.getPriceActual());
        st.setProcessed(this.isProcessed());
        st.setReceivedInfo(this.getReceivedInfo());
        st.setReturnBPartner_ID(ioOut.getReturnBPartner_ID());
        st.setReturnLocation_ID(ioOut.getReturnLocation_ID());
        st.setReturnUser_ID(ioOut.getReturnUser_ID());
        st.setSalesRep_ID(ioOut.getSalesRep_ID());
        st.setShipDate(this.getShipDate());
        st.setShipperAccount(this.getShipperAccount());
        st.setSurcharges(this.getSurcharges());
        st.setTrackingInfo(this.getTrackingInfo());
        st.setTrackingNo(this.getTrackingNo());
        st.setWeight(this.getWeight());
        st.setWidth(this.getWidth());
        st.saveEx();
        int[] ids = MPackageMPS.getAllIDs("M_PackageMPS", "M_Package_ID = " + this.getM_Package_ID(), this.get_TrxName());
        int i2 = 0;
        while (i2 < ids.length) {
            MPackageMPS packageMPS = new MPackageMPS(this.getCtx(), ids[i2], null);
            if (packageMPS.getWeight() == null || packageMPS.getWeight().compareTo(BigDecimal.ZERO) == 0) {
                String sql = "SELECT SUM(LineWeight) FROM X_PackageLineWeight plw WHERE plw.M_PackageMPS_ID=?";
                BigDecimal weight = DB.getSQLValueBD(this.get_TrxName(), sql, packageMPS.getM_PackageMPS_ID());
                if (weight == null) {
                    weight = BigDecimal.ZERO;
                }
                packageMPS.setWeight(weight);
                packageMPS.saveEx();
            }
            MShippingTransactionLine stl = new MShippingTransactionLine(st.getCtx(), 0, st.get_TrxName());
            stl.setAD_Client_ID(packageMPS.getAD_Client_ID());
            stl.setAD_Org_ID(packageMPS.getAD_Org_ID());
            stl.setC_UOM_Length_ID(packageMPS.getC_UOM_Length_ID());
            stl.setC_UOM_Weight_ID(packageMPS.getC_UOM_Weight_ID());
            stl.setDescription(packageMPS.getDescription());
            stl.setHeight(packageMPS.getHeight());
            stl.setIsActive(packageMPS.isActive());
            stl.setLength(packageMPS.getLength());
            stl.setM_PackageMPS_ID(packageMPS.getM_PackageMPS_ID());
            stl.setM_ShippingTransaction_ID(st.getM_ShippingTransaction_ID());
            stl.setMasterTrackingNo(packageMPS.getMasterTrackingNo());
            stl.setPrice(packageMPS.getPrice());
            stl.setProcessed(packageMPS.isProcessed());
            stl.setSeqNo(packageMPS.getSeqNo());
            stl.setTrackingNo(packageMPS.getTrackingNo());
            stl.setWeight(packageMPS.getWeight());
            stl.setWidth(packageMPS.getWidth());
            stl.saveEx();
            ++i2;
        }
        return st;
    }
}

