/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrder;
import org.compiere.model.MPaySchedule;
import org.compiere.model.X_C_OrderPaySchedule;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MOrderPaySchedule
extends X_C_OrderPaySchedule {
    private static final long serialVersionUID = 2158181283878369676L;
    private static CLogger s_log = CLogger.getCLogger(MOrderPaySchedule.class);
    private MOrder m_parent = null;

    public static MOrderPaySchedule[] getOrderPaySchedule(Properties ctx, int C_Order_ID, int C_OrderPaySchedule_ID, String trxName) {
        ArrayList<MOrderPaySchedule> list;
        block8: {
            String sql = "SELECT * FROM C_OrderPaySchedule ips WHERE IsActive='Y' ";
            sql = C_Order_ID != 0 ? String.valueOf(sql) + "AND C_Order_ID=? " : String.valueOf(sql) + "AND EXISTS (SELECT * FROM C_OrderPaySchedule x WHERE x.C_OrderPaySchedule_ID=? AND ips.C_Order_ID=x.C_Order_ID) ";
            sql = String.valueOf(sql) + "ORDER BY DueDate";
            list = new ArrayList<MOrderPaySchedule>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    if (C_Order_ID != 0) {
                        pstmt.setInt(1, C_Order_ID);
                    } else {
                        pstmt.setInt(1, C_OrderPaySchedule_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MOrderPaySchedule(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, "getOrderPaySchedule", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MOrderPaySchedule[] retValue = new MOrderPaySchedule[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MOrderPaySchedule(Properties ctx, int C_OrderPaySchedule_ID, String trxName) {
        super(ctx, C_OrderPaySchedule_ID, trxName);
        if (C_OrderPaySchedule_ID == 0) {
            this.setIsValid(false);
        }
    }

    public MOrderPaySchedule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MOrderPaySchedule(MOrder order, MPaySchedule paySchedule) {
        super(order.getCtx(), 0, order.get_TrxName());
        this.m_parent = order;
        this.setClientOrg(order);
        this.setC_Order_ID(order.getC_Order_ID());
        this.setC_PaySchedule_ID(paySchedule.getC_PaySchedule_ID());
        int scale = MCurrency.getStdPrecision(this.getCtx(), order.getC_Currency_ID());
        BigDecimal due = order.getGrandTotal();
        if (due.compareTo(Env.ZERO) == 0) {
            this.setDueAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setIsValid(false);
        } else {
            due = due.multiply(paySchedule.getPercentage()).divide(Env.ONEHUNDRED, scale, RoundingMode.HALF_UP);
            this.setDueAmt(due);
            BigDecimal discount = due.multiply(paySchedule.getDiscount()).divide(Env.ONEHUNDRED, scale, RoundingMode.HALF_UP);
            this.setDiscountAmt(discount);
            this.setIsValid(true);
        }
        Timestamp dueDate = TimeUtil.addDays(order.getDateOrdered(), paySchedule.getNetDays());
        this.setDueDate(dueDate);
        Timestamp discountDate = TimeUtil.addDays(order.getDateOrdered(), paySchedule.getDiscountDays());
        this.setDiscountDate(discountDate);
    }

    public MOrder getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setParent(MOrder parent) {
        this.m_parent = parent;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MOrderPaySchedule[");
        sb.append(this.get_ID()).append("-Due=" + this.getDueDate() + "/" + this.getDueAmt()).append(";Discount=").append(this.getDiscountDate() + "/" + this.getDiscountAmt()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.is_ValueChanged("DueAmt")) {
            this.log.fine("beforeSave");
            this.setIsValid(false);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (this.is_ValueChanged("DueAmt") || this.is_ValueChanged("IsActive")) {
            this.log.fine("afterSave");
            this.getParent();
            this.m_parent.validatePaySchedule();
            this.m_parent.saveEx();
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        this.log.fine("afterDelete");
        this.getParent();
        this.m_parent.validatePaySchedule();
        this.m_parent.saveEx();
        return success;
    }
}

