/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import org.adempiere.apps.graph.GraphColumn;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.MeasureInterface;
import org.compiere.model.MAchievement;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MProjectType;
import org.compiere.model.MRequestType;
import org.compiere.model.MRole;
import org.compiere.model.MRule;
import org.compiere.model.MStatus;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.X_PA_Measure;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MMeasure
extends X_PA_Measure
implements ImmutablePOSupport {
    private static final long serialVersionUID = -3584012092877837973L;
    private static ImmutableIntPOCache<Integer, MMeasure> s_cache = new ImmutableIntPOCache("PA_Measure", 10);

    public static MMeasure get(int PA_Measure_ID) {
        return MMeasure.get(Env.getCtx(), PA_Measure_ID);
    }

    public static MMeasure get(Properties ctx, int PA_Measure_ID) {
        Integer key = PA_Measure_ID;
        MMeasure retValue = s_cache.get(ctx, key, e -> new MMeasure(ctx, (MMeasure)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MMeasure(ctx, PA_Measure_ID, null);
        if (retValue.get_ID() == PA_Measure_ID) {
            s_cache.put(key, retValue, e -> new MMeasure(Env.getCtx(), (MMeasure)e));
            return retValue;
        }
        return null;
    }

    public MMeasure(Properties ctx, int PA_Measure_ID, String trxName) {
        super(ctx, PA_Measure_ID, trxName);
    }

    public MMeasure(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMeasure(MMeasure copy) {
        this(Env.getCtx(), copy);
    }

    public MMeasure(Properties ctx, MMeasure copy) {
        this(ctx, copy, null);
    }

    public MMeasure(Properties ctx, MMeasure copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public ArrayList<GraphColumn> getGraphColumnList(MGoal goal) {
        ArrayList<GraphColumn> list;
        block43: {
            list = new ArrayList<GraphColumn>();
            if ("C".equals(this.getMeasureType())) {
                MMeasureCalc mc = MMeasureCalc.get(this.getPA_MeasureCalc_ID());
                String sql = mc.getSqlBarChart(goal.getRestrictions(false), goal.getMeasureDisplay(), goal.getDateFrom(), MRole.getDefault());
                if (sql.indexOf("@") >= 0) {
                    sql = Env.parseContext(this.getCtx(), 0, sql, false, false);
                }
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        rs = pstmt.executeQuery();
                        ArrayList<Timestamp> dataList = new ArrayList<Timestamp>();
                        while (rs.next()) {
                            BigDecimal data = rs.getBigDecimal(1);
                            Timestamp date = rs.getTimestamp(2);
                            GraphColumn bgc = new GraphColumn(mc, data);
                            bgc.setLabel(date, goal.getMeasureDisplay());
                            int pos = 0;
                            int i2 = 0;
                            while (i2 < dataList.size()) {
                                if (((Timestamp)dataList.get(i2)).before(date)) {
                                    ++pos;
                                }
                                ++i2;
                            }
                            dataList.add(date);
                            list.add(pos, bgc);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            } else if ("A".equals(this.getMeasureType())) {
                if ("S".equals(this.getMeasureDataType())) {
                    MAchievement[] achievements = MAchievement.get(this);
                    int i3 = 0;
                    while (i3 < achievements.length) {
                        MAchievement achievement = achievements[i3];
                        GraphColumn bgc = new GraphColumn(achievement);
                        list.add(bgc);
                        ++i3;
                    }
                } else {
                    String MeasureDisplay = goal.getMeasureDisplay();
                    String trunc = "D";
                    if ("1".equals(MeasureDisplay)) {
                        trunc = "Y";
                    } else if ("3".equals(MeasureDisplay)) {
                        trunc = "Q";
                    } else if ("5".equals(MeasureDisplay)) {
                        trunc = "MM";
                    } else if ("7".equals(MeasureDisplay)) {
                        trunc = "W";
                    }
                    trunc = "TRUNC(DateDoc,'" + trunc + "')";
                    StringBuilder sql = new StringBuilder("SELECT SUM(ManualActual), ").append(trunc).append(" FROM PA_Achievement WHERE PA_Measure_ID=? AND IsAchieved='Y' ").append("GROUP BY ").append(trunc).append(" ORDER BY ").append(trunc);
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement(sql.toString(), null);
                            pstmt.setInt(1, this.getPA_Measure_ID());
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                BigDecimal data = rs.getBigDecimal(1);
                                Timestamp date = rs.getTimestamp(2);
                                GraphColumn bgc = new GraphColumn(goal, data);
                                bgc.setLabel(date, goal.getMeasureDisplay());
                                list.add(bgc);
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql.toString(), e);
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            break block43;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            } else if ("Q".equals(this.getMeasureType())) {
                MRequestType rt = MRequestType.get(Env.getCtx(), this.getR_RequestType_ID());
                String sql = rt.getSqlBarChart(goal.getRestrictions(false), goal.getMeasureDisplay(), this.getMeasureDataType(), goal.getDateFrom(), MRole.getDefault());
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            BigDecimal data = rs.getBigDecimal(1);
                            int R_Status_ID = rs.getInt(3);
                            GraphColumn bgc = new GraphColumn(rt, data, R_Status_ID);
                            if (R_Status_ID == 0) {
                                Timestamp date = rs.getTimestamp(2);
                                bgc.setLabel(date, goal.getMeasureDisplay());
                            } else {
                                MStatus status = MStatus.get(Env.getCtx(), R_Status_ID);
                                bgc.setLabel(status.getName());
                            }
                            list.add(bgc);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            } else if ("P".equals(this.getMeasureType())) {
                MProjectType pt = MProjectType.get(Env.getCtx(), this.getC_ProjectType_ID());
                String sql = pt.getSqlBarChart(goal.getRestrictions(false), goal.getMeasureDisplay(), this.getMeasureDataType(), goal.getDateFrom(), MRole.getDefault());
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            BigDecimal data = rs.getBigDecimal(1);
                            Timestamp date = rs.getTimestamp(2);
                            int id = rs.getInt(3);
                            GraphColumn bgc = new GraphColumn(pt, data, id);
                            bgc.setLabel(date, goal.getMeasureDisplay());
                            list.add(bgc);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MMeasure[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if ("C".equals(this.getMeasureType()) && this.getPA_MeasureCalc_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "PA_MeasureCalc_ID"));
            return false;
        }
        if ("R".equals(this.getMeasureType()) && this.getPA_Ratio_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "PA_Ratio_ID"));
            return false;
        }
        if ("U".equals(this.getMeasureType()) && (this.getCalculationClass() == null || this.getCalculationClass().length() == 0)) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "CalculationClass"));
            return false;
        }
        if ("Q".equals(this.getMeasureType()) && this.getR_RequestType_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "R_RequestType_ID"));
            return false;
        }
        if ("P".equals(this.getMeasureType()) && this.getC_ProjectType_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "C_ProjectType_ID"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success && "M".equals(this.getMeasureType())) {
            this.updateManualGoals();
        }
        return success;
    }

    public boolean updateGoals() {
        String mt = this.getMeasureType();
        try {
            if ("M".equals(mt)) {
                return this.updateManualGoals();
            }
            if ("A".equals(mt)) {
                return this.updateAchievementGoals();
            }
            if ("C".equals(mt)) {
                return this.updateCalculatedGoals();
            }
            if ("R".equals(mt)) {
                return this.updateRatios();
            }
            if ("Q".equals(mt)) {
                return this.updateRequests();
            }
            if ("P".equals(mt)) {
                return this.updateProjects();
            }
            if ("U".equals(mt)) {
                return this.updateUserDefined();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "MeasureType=" + mt, e);
        }
        return false;
    }

    private boolean updateManualGoals() {
        if (!"M".equals(this.getMeasureType())) {
            return false;
        }
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        int i2 = 0;
        while (i2 < goals.length) {
            MGoal goal = goals[i2];
            goal.setMeasureActual(this.getManualActual());
            goal.saveEx(this.get_TrxName());
            ++i2;
        }
        return true;
    }

    private boolean updateAchievementGoals() {
        if (!"A".equals(this.getMeasureType())) {
            return false;
        }
        Timestamp today = new Timestamp(System.currentTimeMillis());
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        int i2 = 0;
        while (i2 < goals.length) {
            MGoal goal = goals[i2];
            String MeasureScope = goal.getMeasureScope();
            String trunc = "D";
            if ("1".equals(MeasureScope)) {
                trunc = "Y";
            } else if ("3".equals(MeasureScope)) {
                trunc = "Q";
            } else if ("5".equals(MeasureScope)) {
                trunc = "MM";
            } else if ("7".equals(MeasureScope)) {
                trunc = "W";
            }
            Timestamp compare = TimeUtil.trunc(today, trunc);
            MAchievement[] achievements = MAchievement.getOfMeasure(this.getCtx(), this.getPA_Measure_ID());
            BigDecimal ManualActual = Env.ZERO;
            int j = 0;
            while (j < achievements.length) {
                Timestamp ach;
                MAchievement achievement = achievements[j];
                if (achievement.isAchieved() && achievement.getDateDoc() != null && compare.equals(ach = TimeUtil.trunc(achievement.getDateDoc(), trunc))) {
                    ManualActual = ManualActual.add(achievement.getManualActual());
                }
                ++j;
            }
            goal.setMeasureActual(ManualActual);
            goal.saveEx(this.get_TrxName());
            ++i2;
        }
        return true;
    }

    private boolean updateCalculatedGoals() {
        if (!"C".equals(this.getMeasureType())) {
            return false;
        }
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        int i2 = 0;
        while (i2 < goals.length) {
            MMeasureCalc mc;
            MUser user;
            MRole[] roles;
            MGoal goal = goals[i2];
            MRole role = null;
            if (goal.getAD_Role_ID() != 0) {
                role = MRole.get(this.getCtx(), goal.getAD_Role_ID());
            } else if (goal.getAD_User_ID() != 0 && (roles = (user = MUser.get(this.getCtx(), goal.getAD_User_ID())).getRoles(goal.getAD_Org_ID())).length > 0) {
                role = roles[0];
            }
            if (role == null) {
                role = MRole.getDefault(this.getCtx(), false);
            }
            if ((mc = MMeasureCalc.get(this.getPA_MeasureCalc_ID())) == null || mc.get_ID() == 0 || mc.get_ID() != this.getPA_MeasureCalc_ID()) {
                this.log.log(Level.SEVERE, "Not found PA_MeasureCalc_ID=" + this.getPA_MeasureCalc_ID());
                return false;
            }
            String sql = mc.getSqlPI(goal.getRestrictions(false), goal.getMeasureScope(), this.getMeasureDataType(), null, role);
            BigDecimal ManualActual = DB.getSQLValueBD(null, sql, new Object[0]);
            if (ManualActual == null) {
                ManualActual = Env.ZERO;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("No Value = " + sql);
                }
            }
            goal.setMeasureActual(ManualActual);
            goal.saveEx(this.get_TrxName());
            ++i2;
        }
        return true;
    }

    private boolean updateRatios() {
        if (!"R".equals(this.getMeasureType())) {
            return false;
        }
        return false;
    }

    private boolean updateRequests() {
        if (!"Q".equals(this.getMeasureType()) || this.getR_RequestType_ID() == 0) {
            return false;
        }
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        int i2 = 0;
        while (i2 < goals.length) {
            MRequestType rt;
            String sql;
            BigDecimal ManualActual;
            MUser user;
            MRole[] roles;
            MGoal goal = goals[i2];
            MRole role = null;
            if (goal.getAD_Role_ID() != 0) {
                role = MRole.get(this.getCtx(), goal.getAD_Role_ID());
            } else if (goal.getAD_User_ID() != 0 && (roles = (user = MUser.get(this.getCtx(), goal.getAD_User_ID())).getRoles(goal.getAD_Org_ID())).length > 0) {
                role = roles[0];
            }
            if (role == null) {
                role = MRole.getDefault(this.getCtx(), false);
            }
            if ((ManualActual = DB.getSQLValueBD(null, sql = (rt = MRequestType.get(this.getCtx(), this.getR_RequestType_ID())).getSqlPI(goal.getRestrictions(false), goal.getMeasureScope(), this.getMeasureDataType(), null, role), new Object[0])) == null) {
                ManualActual = Env.ZERO;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("No Value = " + sql);
                }
            }
            goal.setMeasureActual(ManualActual);
            goal.saveEx(this.get_TrxName());
            ++i2;
        }
        return true;
    }

    private boolean updateProjects() {
        if (!"P".equals(this.getMeasureType()) || this.getC_ProjectType_ID() == 0) {
            return false;
        }
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        int i2 = 0;
        while (i2 < goals.length) {
            MProjectType pt;
            String sql;
            BigDecimal ManualActual;
            MUser user;
            MRole[] roles;
            MGoal goal = goals[i2];
            MRole role = null;
            if (goal.getAD_Role_ID() != 0) {
                role = MRole.get(this.getCtx(), goal.getAD_Role_ID());
            } else if (goal.getAD_User_ID() != 0 && (roles = (user = MUser.get(this.getCtx(), goal.getAD_User_ID())).getRoles(goal.getAD_Org_ID())).length > 0) {
                role = roles[0];
            }
            if (role == null) {
                role = MRole.getDefault(this.getCtx(), false);
            }
            if ((ManualActual = DB.getSQLValueBD(null, sql = (pt = MProjectType.get(this.getCtx(), this.getC_ProjectType_ID())).getSqlPI(goal.getRestrictions(false), goal.getMeasureScope(), this.getMeasureDataType(), null, role), new Object[0])) == null) {
                ManualActual = Env.ZERO;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("No Value = " + sql);
                }
            }
            goal.setMeasureActual(ManualActual);
            goal.saveEx(this.get_TrxName());
            ++i2;
        }
        return true;
    }

    private boolean updateUserDefined() {
        MGoal[] goals;
        MGoal[] mGoalArray = goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        int n = goals.length;
        int n2 = 0;
        while (n2 < n) {
            MGoal goal = mGoalArray[n2];
            BigDecimal amt = Env.ZERO;
            PO po = new MTable(this.getCtx(), this.get_Table_ID(), this.get_TrxName()).getPO(this.get_ID(), this.get_TrxName());
            StringTokenizer st = new StringTokenizer(this.getCalculationClass(), ";,", false);
            while (st.hasMoreTokens()) {
                String cmd = st.nextToken().trim();
                StringBuilder retValue = new StringBuilder();
                if (cmd.toLowerCase().startsWith("@script:")) {
                    MRule rule = MRule.get(this.getCtx(), cmd.substring("@script:".length()));
                    if (rule == null) {
                        retValue = new StringBuilder("Script ").append(cmd).append(" not found");
                        this.log.log(Level.SEVERE, retValue.toString());
                        break;
                    }
                    if (!rule.getEventType().equals("M") || !rule.getRuleType().equals("S")) {
                        retValue = new StringBuilder("Script ").append(cmd).append(" must be of type JSR 223 and event measure");
                        this.log.log(Level.SEVERE, retValue.toString());
                        break;
                    }
                    ScriptEngine engine = rule.getScriptEngine();
                    if (engine == null) {
                        throw new AdempiereException("Engine not found: " + rule.getEngineName());
                    }
                    MRule.setContext(engine, po.getCtx(), 0);
                    engine.put("A_Ctx", po.getCtx());
                    engine.put("A_PO", po);
                    try {
                        Object value = engine.eval(rule.getScript());
                        amt = (BigDecimal)value;
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "", e);
                        retValue = new StringBuilder("Script Invalid: ").append(e.toString());
                        return false;
                    }
                }
                MeasureInterface custom = null;
                try {
                    Class<?> clazz = Class.forName(cmd);
                    custom = (MeasureInterface)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "No custom measure class " + cmd + " - " + e.toString(), e);
                    return false;
                }
                try {
                    amt = custom.getValue();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, custom.toString(), e);
                    return false;
                }
                if (Util.isEmpty(retValue.toString())) continue;
                this.log.severe(retValue.toString());
                return false;
            }
            goal.setMeasureActual(amt);
            goal.saveEx(this.get_TrxName());
            ++n2;
        }
        return true;
    }

    @Override
    public MMeasure markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

