/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.IMFAMechanism;
import org.compiere.model.MMFAMethod;
import org.compiere.model.Query;
import org.compiere.model.X_MFA_Registration;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MMFARegistration
extends X_MFA_Registration {
    private static final long serialVersionUID = -2032862057961778934L;

    public MMFARegistration(Properties ctx, int MFA_Registration_ID, String trxName) {
        super(ctx, MFA_Registration_ID, trxName);
    }

    public MMFARegistration(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static boolean alreadyExistsValid(MMFAMethod method, String prm) {
        int cnt;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Env.getAD_User_ID(method.getCtx()));
        params.add(method.getMFA_Method_ID());
        params.add(Env.getAD_Client_ID(method.getCtx()));
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(*) FROM MFA_Registration WHERE AD_User_ID=?  AND MFA_Method_ID=?  AND IsValid='Y'  AND AD_Client_ID IN (0,?)  AND IsActive='Y'");
        if (prm != null) {
            sql.append(" AND ParameterValue=?");
            params.add(prm);
        }
        return (cnt = DB.getSQLValueEx(method.get_TrxName(), sql.toString(), params)) != 0;
    }

    public static void invalidatePreviousPending(MMFAMethod method, String prm, MMFARegistration reg) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Env.getAD_User_ID(method.getCtx()));
        params.add(method.getMFA_Method_ID());
        params.add(reg.getAD_Client_ID());
        params.add(reg.getMFA_Registration_ID());
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE MFA_Registration SET IsActive='N' WHERE AD_User_ID=?  AND MFA_Method_ID=?  AND AD_Client_ID IN (0,?)  AND IsValid='N'  AND IsActive='Y'  AND MFA_Registration_ID!=?");
        if (prm != null) {
            sql.append(" AND ParameterValue=?");
            params.add(prm);
        }
        DB.executeUpdateEx(sql.toString(), params.toArray(), method.get_TrxName());
    }

    @Override
    public void setIsUserMFAPreferred(boolean IsUserMFAPreferred) {
        super.setIsUserMFAPreferred(IsUserMFAPreferred);
        if (IsUserMFAPreferred) {
            int userId = this.getAD_User_ID();
            int clientId = this.getAD_Client_ID();
            int regId = this.getMFA_Registration_ID();
            String sql = "UPDATE MFA_Registration SET IsUserMFAPreferred='N' WHERE AD_User_ID=?  AND AD_Client_ID=?  AND IsUserMFAPreferred='Y'  AND MFA_Registration_ID!=?";
            DB.executeUpdateEx("UPDATE MFA_Registration SET IsUserMFAPreferred='N' WHERE AD_User_ID=?  AND AD_Client_ID=?  AND IsUserMFAPreferred='Y'  AND MFA_Registration_ID!=?", new Object[]{userId, clientId, regId}, this.get_TrxName());
        }
    }

    public static List<MMFARegistration> getValidRegistrationsFromUser() {
        String where = "IsValid ='Y' AND AD_User_ID=? AND AD_Client_ID IN (0,?)";
        List<MMFARegistration> ret = new Query(Env.getCtx(), "MFA_Registration", "IsValid ='Y' AND AD_User_ID=? AND AD_Client_ID IN (0,?)", null).setParameters(Env.getAD_User_ID(Env.getCtx()), Env.getAD_Client_ID(Env.getCtx())).setOnlyActiveRecords(true).setOrderBy("IsUserMFAPreferred DESC, Name").list();
        return ret;
    }

    public static boolean userHasValidRegistration() {
        String sql = "SELECT COUNT(*) FROM MFA_Registration WHERE IsActive='Y' AND IsValid ='Y' AND AD_User_ID=? AND AD_Client_ID IN (0,?)";
        int cnt = DB.getSQLValueEx(null, "SELECT COUNT(*) FROM MFA_Registration WHERE IsActive='Y' AND IsValid ='Y' AND AD_User_ID=? AND AD_Client_ID IN (0,?)", Env.getAD_User_ID(Env.getCtx()), Env.getAD_Client_ID(Env.getCtx()));
        return cnt > 0;
    }

    public String generateValidationCode(MMFARegistration reg) {
        MMFAMethod method = new MMFAMethod(this.getCtx(), this.getMFA_Method_ID(), this.get_TrxName());
        IMFAMechanism mechanism = method.getMFAMechanism();
        String msg = mechanism.generateValidationCode(reg);
        return msg;
    }

    public String validateCode(MMFARegistration reg, String code, boolean setPreferred) {
        MMFAMethod method = new MMFAMethod(this.getCtx(), this.getMFA_Method_ID(), this.get_TrxName());
        IMFAMechanism mechanism = method.getMFAMechanism();
        String msg = mechanism.validateCode(reg, code, setPreferred);
        return msg;
    }

    @Override
    public void setAD_User_ID(int AD_User_ID) {
        if (AD_User_ID == 0) {
            this.set_ValueNoCheck("AD_User_ID", AD_User_ID);
        } else {
            super.setAD_User_ID(AD_User_ID);
        }
    }
}

