/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_M_Locator;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MLocator
extends X_M_Locator
implements ImmutablePOSupport {
    private static final long serialVersionUID = 539879105479299988L;
    private static final ImmutableIntPOCache<Integer, MLocator> s_cache = new ImmutableIntPOCache("M_Locator", 20);
    private static CLogger s_log = CLogger.getCLogger(MLocator.class);

    public static MLocator getDefault(Properties ctx, int M_Locator_ID) {
        MLocator retValue;
        block6: {
            String trxName = null;
            retValue = null;
            String sql = "SELECT * FROM M_Locator l WHERE IsActive = 'Y' AND  IsDefault='Y' AND EXISTS (SELECT * FROM M_Locator lx WHERE l.M_Warehouse_ID=lx.M_Warehouse_ID AND lx.M_Locator_ID=?) ORDER BY Created";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, M_Locator_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        retValue = new MLocator(ctx, rs, trxName);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public static MLocator getDefault(MWarehouse warehouse) {
        MLocator retValue;
        block6: {
            String trxName = null;
            retValue = null;
            String sql = "SELECT * FROM M_Locator l WHERE IsActive = 'Y' AND IsDefault='Y' AND l.M_Warehouse_ID=? ORDER BY PriorityNo";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, warehouse.getM_Warehouse_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        retValue = new MLocator(warehouse.getCtx(), rs, trxName);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public static MLocator get(Properties ctx, int M_Warehouse_ID, String Value, String X, String Y, String Z) {
        return MLocator.get(ctx, M_Warehouse_ID, Value, X, Y, Z, 0);
    }

    public static MLocator get(Properties ctx, int M_Warehouse_ID, String Value, String X, String Y, String Z, int M_LocatorType_ID) {
        MLocator retValue;
        block7: {
            retValue = null;
            String sql = "SELECT * FROM M_Locator WHERE IsActive = 'Y' AND M_Warehouse_ID=? AND X=? AND Y=? AND Z=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, M_Warehouse_ID);
                    pstmt.setString(2, X);
                    pstmt.setString(3, Y);
                    pstmt.setString(4, Z);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MLocator(ctx, rs, null);
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, "get", ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null && MRole.getDefault().isTableAccess(207, false)) {
            MWarehouse wh = MWarehouse.get(ctx, M_Warehouse_ID);
            retValue = new MLocator(wh, Value);
            retValue.setXYZ(X, Y, Z);
            retValue.setM_LocatorType_ID(M_LocatorType_ID);
            retValue.saveEx();
        }
        return retValue;
    }

    public static MLocator get(int M_Locator_ID) {
        return MLocator.get(Env.getCtx(), M_Locator_ID);
    }

    public static MLocator get(Properties ctx, int M_Locator_ID) {
        return MLocator.get(ctx, M_Locator_ID, null);
    }

    public static MLocator get(Properties ctx, int M_Locator_ID, String trxName) {
        Integer key = M_Locator_ID;
        MLocator retValue = s_cache.get(ctx, key, e -> new MLocator(ctx, (MLocator)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MLocator(ctx, M_Locator_ID, trxName);
        if (retValue.get_ID() == M_Locator_ID) {
            s_cache.put(key, retValue, e -> new MLocator(Env.getCtx(), (MLocator)e));
            return retValue;
        }
        return null;
    }

    public static MLocator getCopy(Properties ctx, int M_Locator_ID, String trxName) {
        MLocator locator = MLocator.get(M_Locator_ID);
        if (locator != null) {
            locator = new MLocator(ctx, locator, trxName);
        }
        return locator;
    }

    public MLocator(Properties ctx, int M_Locator_ID, String trxName) {
        super(ctx, M_Locator_ID, trxName);
        if (M_Locator_ID == 0) {
            this.setIsDefault(false);
            this.setPriorityNo(50);
        }
    }

    public MLocator(MWarehouse warehouse, String Value) {
        this(warehouse.getCtx(), 0, warehouse.get_TrxName());
        this.setClientOrg(warehouse);
        this.setM_Warehouse_ID(warehouse.getM_Warehouse_ID());
        this.setValue(Value);
        this.setXYZ("0", "0", "0");
    }

    public MLocator(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MLocator(MLocator copy) {
        this(Env.getCtx(), copy);
    }

    public MLocator(Properties ctx, MLocator copy) {
        this(ctx, copy, null);
    }

    public MLocator(Properties ctx, MLocator copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public void setXYZ(String X, String Y, String Z) {
        this.setX(X);
        this.setY(Y);
        this.setZ(Z);
    }

    public String getWarehouseName() {
        MWarehouse wh = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID());
        if (wh.get_ID() == 0) {
            StringBuilder msgreturn = new StringBuilder("<").append(this.getM_Warehouse_ID()).append(">");
            return msgreturn.toString();
        }
        return wh.getName();
    }

    public boolean isCanStoreProduct(int M_Product_ID) {
        return true;
    }

    @Override
    public MLocator markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

