/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_GL_JournalBatch;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MJournalBatch
extends X_GL_JournalBatch
implements DocAction {
    private static final long serialVersionUID = 4447134860127309777L;
    protected String m_processMsg = null;
    protected boolean m_justPrepared = false;

    public static MJournalBatch copyFrom(Properties ctx, int GL_JournalBatch_ID, Timestamp dateDoc, String trxName) {
        MJournalBatch from = new MJournalBatch(ctx, GL_JournalBatch_ID, trxName);
        if (from.getGL_JournalBatch_ID() == 0) {
            throw new IllegalArgumentException("From Journal Batch not found GL_JournalBatch_ID=" + GL_JournalBatch_ID);
        }
        MJournalBatch to = new MJournalBatch(ctx, 0, trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("DocumentNo", null);
        to.set_ValueNoCheck("C_Period_ID", null);
        to.setDateAcct(dateDoc);
        to.setDateDoc(dateDoc);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setIsApproved(false);
        to.setProcessed(false);
        if (!to.save()) {
            throw new IllegalStateException("Could not create Journal Batch");
        }
        if (to.copyDetailsFrom(from) == 0) {
            throw new IllegalStateException("Could not create Journal Batch Details");
        }
        return to;
    }

    public MJournalBatch(Properties ctx, int GL_JournalBatch_ID, String trxName) {
        super(ctx, GL_JournalBatch_ID, trxName);
        if (GL_JournalBatch_ID == 0) {
            this.setPostingType("A");
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setTotalCr(Env.ZERO);
            this.setTotalDr(Env.ZERO);
            this.setProcessed(false);
            this.setProcessing(false);
            this.setIsApproved(false);
        }
    }

    public MJournalBatch(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MJournalBatch(MJournalBatch original) {
        this(original.getCtx(), 0, original.get_TrxName());
        this.setClientOrg(original);
        this.setGL_Category_ID(original.getGL_Category_ID());
        this.setPostingType(original.getPostingType());
        this.setDescription(original.getDescription());
        this.setC_DocType_ID(original.getC_DocType_ID());
        this.setControlAmt(original.getControlAmt());
        this.setC_Currency_ID(original.getC_Currency_ID());
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    @Override
    public void setDateAcct(Timestamp DateAcct) {
        super.setDateAcct(DateAcct);
        if (DateAcct == null) {
            return;
        }
        int C_Period_ID = MPeriod.getC_Period_ID(this.getCtx(), DateAcct, this.getAD_Org_ID());
        if (C_Period_ID == 0) {
            this.log.saveError("PeriodNotFound", " : " + DisplayType.getDateFormat().format(this.getDateAcct()));
        } else if (C_Period_ID != this.getC_Period_ID()) {
            this.setC_Period_ID(C_Period_ID);
        }
    }

    public MJournal[] getJournals(boolean requery) {
        ArrayList<MJournal> list;
        block6: {
            list = new ArrayList<MJournal>();
            String sql = "SELECT * FROM GL_Journal WHERE GL_JournalBatch_ID=? ORDER BY DocumentNo";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getGL_JournalBatch_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MJournal(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (SQLException ex) {
                    this.log.log(Level.SEVERE, sql, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MJournal[] retValue = new MJournal[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int copyDetailsFrom(MJournalBatch jb) {
        if (this.isProcessed() || jb == null) {
            return 0;
        }
        int count = 0;
        int lineCount = 0;
        MJournal[] fromJournals = jb.getJournals(false);
        int i2 = 0;
        while (i2 < fromJournals.length) {
            MJournal toJournal = new MJournal(this.getCtx(), 0, jb.get_TrxName());
            PO.copyValues(fromJournals[i2], toJournal, this.getAD_Client_ID(), this.getAD_Org_ID());
            toJournal.setGL_JournalBatch_ID(this.getGL_JournalBatch_ID());
            toJournal.set_ValueNoCheck("DocumentNo", null);
            toJournal.set_ValueNoCheck("C_Period_ID", null);
            toJournal.setDateDoc(this.getDateDoc());
            toJournal.setDateAcct(this.getDateAcct());
            toJournal.setDocStatus("DR");
            toJournal.setDocAction("CO");
            toJournal.setTotalCr(Env.ZERO);
            toJournal.setTotalDr(Env.ZERO);
            toJournal.setIsApproved(false);
            toJournal.setIsPrinted(false);
            toJournal.setPosted(false);
            toJournal.setProcessed(false);
            if (toJournal.save()) {
                ++count;
                lineCount += toJournal.copyLinesFrom(fromJournals[i2], this.getDateAcct(), 'x');
            }
            ++i2;
        }
        if (fromJournals.length != count) {
            this.log.log(Level.SEVERE, "Line difference - Journals=" + fromJournals.length + " <> Saved=" + count);
        }
        return count + lineCount;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        return true;
    }

    @Override
    public String prepareIt() {
        MJournal journal;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MJournal[] journals = this.getJournals(false);
        if (journals.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal TotalDr = Env.ZERO;
        BigDecimal TotalCr = Env.ZERO;
        int i2 = 0;
        while (i2 < journals.length) {
            journal = journals[i2];
            if (journal.isActive()) {
                if (!("CL".equals(journal.getDocStatus()) || "VO".equals(journal.getDocStatus()) || "RE".equals(journal.getDocStatus()) || "CO".equals(journal.getDocStatus()))) {
                    String status = journal.prepareIt();
                    if (!"IP".equals(status)) {
                        journal.setDocStatus(status);
                        journal.saveEx();
                        this.m_processMsg = journal.getProcessMsg();
                        return status;
                    }
                    journal.setDocStatus("IP");
                    journal.saveEx();
                }
                TotalDr = TotalDr.add(journal.getTotalDr());
                TotalCr = TotalCr.add(journal.getTotalCr());
            }
            ++i2;
        }
        this.setTotalDr(TotalDr);
        this.setTotalCr(TotalCr);
        if (Env.ZERO.compareTo(this.getControlAmt()) != 0 && this.getControlAmt().compareTo(this.getTotalDr()) != 0) {
            this.m_processMsg = "@ControlAmtError@";
            return "IN";
        }
        i2 = 0;
        while (i2 < journals.length) {
            MJournalLine line;
            int j;
            journal = journals[i2];
            MJournalLine[] lines = journal.getLines(true);
            if (journal.getCurrencyRate() != null && journal.getCurrencyRate().compareTo(Env.ZERO) != 0) {
                j = 0;
                while (j < lines.length) {
                    line = lines[j];
                    line.setCurrencyRate(journal.getCurrencyRate());
                    line.saveEx();
                    ++j;
                }
            }
            if (journal.getC_ConversionType_ID() > 0) {
                j = 0;
                while (j < lines.length) {
                    line = lines[j];
                    line.setC_ConversionType_ID(journal.getC_ConversionType_ID());
                    line.saveEx();
                    ++j;
                }
            }
            ++i2;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("completeIt - " + this.toString());
        }
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.approveIt();
        MJournal[] journals = this.getJournals(true);
        BigDecimal TotalDr = Env.ZERO;
        BigDecimal TotalCr = Env.ZERO;
        int i2 = 0;
        while (i2 < journals.length) {
            MJournal journal = journals[i2];
            if (!journal.isActive()) {
                journal.setProcessed(true);
                journal.setDocStatus("VO");
                journal.setDocAction("--");
                journal.saveEx();
            } else {
                if (!("CL".equals(journal.getDocStatus()) || "VO".equals(journal.getDocStatus()) || "RE".equals(journal.getDocStatus()) || "CO".equals(journal.getDocStatus()))) {
                    if (!journal.processIt("CO")) {
                        throw new AdempiereException(String.valueOf(Msg.getMsg(this.getCtx(), "FailedProcessingDocument")) + " - " + journal.getProcessMsg());
                    }
                    journal.saveEx();
                    if (!"CO".equals(journal.getDocStatus())) {
                        this.m_processMsg = journal.getProcessMsg();
                        return journal.getDocStatus();
                    }
                }
                TotalDr = TotalDr.add(journal.getTotalDr());
                TotalCr = TotalCr.add(journal.getTotalCr());
            }
            ++i2;
        }
        this.setTotalDr(TotalDr);
        this.setTotalCr(TotalCr);
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    protected void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(TimeUtil.getDay(0L));
            if (this.getDateAcct().before(this.getDateDoc())) {
                this.setDateAcct(this.getDateDoc());
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
            }
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("voidIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        MJournal[] journals = this.getJournals(true);
        int i2 = 0;
        while (i2 < journals.length) {
            MJournal journal = journals[i2];
            if (!journal.isActive() && !journal.isProcessed()) {
                journal.setProcessed(true);
                journal.setDocStatus("VO");
                journal.setDocAction("--");
                journal.saveEx();
            } else {
                if ("DR".equals(journal.getDocStatus()) || "IP".equals(journal.getDocStatus()) || "IN".equals(journal.getDocStatus())) {
                    this.m_processMsg = "Journal not Completed: " + journal.getSummary();
                    return false;
                }
                if (!("CL".equals(journal.getDocStatus()) || "VO".equals(journal.getDocStatus()) || "RE".equals(journal.getDocStatus()))) {
                    if (!journal.closeIt()) {
                        this.m_processMsg = "Cannot close: " + journal.getSummary();
                        return false;
                    }
                    journal.saveEx();
                }
            }
            ++i2;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseCorrectIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MJournal[] journals = this.getJournals(true);
        int i2 = 0;
        while (i2 < journals.length) {
            MJournal journal = journals[i2];
            if (journal.isActive() && !"CO".equals(journal.getDocStatus())) {
                this.m_processMsg = "All Journals need to be Completed: " + journal.getSummary();
                return false;
            }
            ++i2;
        }
        MJournalBatch reverse = new MJournalBatch(this);
        reverse.setDateDoc(this.getDateDoc());
        reverse.setC_Period_ID(this.getC_Period_ID());
        reverse.setDateAcct(this.getDateAcct());
        StringBuilder msgd = new StringBuilder("(->").append(this.getDocumentNo()).append(")");
        reverse.addDescription(msgd.toString());
        reverse.setControlAmt(this.getControlAmt().negate());
        reverse.setReversal_ID(this.getGL_JournalBatch_ID());
        reverse.saveEx();
        int i3 = 0;
        while (i3 < journals.length) {
            MJournal journal = journals[i3];
            if (journal.isActive()) {
                if (journal.reverseCorrectIt(reverse.getGL_JournalBatch_ID()) == null) {
                    this.m_processMsg = "Could not reverse " + journal;
                    return false;
                }
                journal.saveEx();
            }
            ++i3;
        }
        if (!reverse.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reverse.getProcessMsg();
            return false;
        }
        reverse.closeIt();
        reverse.setProcessing(false);
        reverse.setDocStatus("RE");
        reverse.setDocAction("--");
        reverse.saveEx(this.get_TrxName());
        msgd = new StringBuilder("(").append(reverse.getDocumentNo()).append("<-)");
        this.addDescription(msgd.toString());
        this.setProcessed(true);
        this.setReversal_ID(reverse.getGL_JournalBatch_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        this.saveEx();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseAccrualIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        MJournal[] journals = this.getJournals(true);
        int i2 = 0;
        while (i2 < journals.length) {
            MJournal journal = journals[i2];
            if (journal.isActive() && !"CO".equals(journal.getDocStatus())) {
                this.m_processMsg = "All Journals need to be Completed: " + journal.getSummary();
                return false;
            }
            ++i2;
        }
        MJournalBatch reverse = new MJournalBatch(this);
        reverse.setC_Period_ID(0);
        Timestamp reversalDate = Env.getContextAsDate(this.getCtx(), "#Date");
        if (reversalDate == null) {
            reversalDate = new Timestamp(System.currentTimeMillis());
        }
        reverse.setDateDoc(reversalDate);
        reverse.setDateAcct(reversalDate);
        StringBuilder msgd = new StringBuilder("(->").append(this.getDocumentNo()).append(")");
        reverse.addDescription(msgd.toString());
        reverse.setReversal_ID(this.getGL_JournalBatch_ID());
        reverse.saveEx();
        int i3 = 0;
        while (i3 < journals.length) {
            MJournal journal = journals[i3];
            if (journal.isActive()) {
                if (journal.reverseAccrualIt(reverse.getGL_JournalBatch_ID()) == null) {
                    this.m_processMsg = "Could not reverse " + journal;
                    return false;
                }
                journal.saveEx();
            }
            ++i3;
        }
        if (!reverse.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reverse.getProcessMsg();
            return false;
        }
        reverse.closeIt();
        reverse.setProcessing(false);
        reverse.setDocStatus("RE");
        reverse.setDocAction("--");
        reverse.saveEx(this.get_TrxName());
        msgd = new StringBuilder("(").append(reverse.getDocumentNo()).append("<-)");
        this.addDescription(msgd.toString());
        this.setProcessed(true);
        this.setReversal_ID(reverse.getGL_JournalBatch_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        this.saveEx();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reActivateIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MJournal[] mJournalArray = this.getJournals(true);
        int n = mJournalArray.length;
        int n2 = 0;
        while (n2 < n) {
            MJournal journal = mJournalArray[n2];
            if ("CO".equals(journal.getDocStatus())) {
                if (journal.processIt("RE")) {
                    journal.saveEx();
                } else {
                    throw new AdempiereException(journal.getProcessMsg());
                }
            }
            ++n2;
        }
        this.setProcessed(false);
        this.setDocAction("CO");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "TotalDr")).append("=").append(this.getTotalDr()).append(" ").append(Msg.translate(this.getCtx(), "TotalCR")).append("=").append(this.getTotalCr()).append(" (#").append(this.getJournals(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MJournalBatch[");
        sb.append(this.get_ID()).append(",").append(this.getDescription()).append(",DR=").append(this.getTotalDr()).append(",CR=").append(this.getTotalCr()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        StringBuilder msgreturn = new StringBuilder().append(dt.getNameTrl()).append(" ").append(this.getDocumentNo());
        return msgreturn.toString();
    }

    @Override
    public File createPDF() {
        try {
            StringBuilder msgfile = new StringBuilder().append(this.get_TableName()).append(this.get_ID()).append("_");
            File temp = File.createTempFile(msgfile.toString(), ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getTotalDr();
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateDoc() == null) {
            if (this.getDateAcct() == null) {
                this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            } else {
                this.setDateDoc(this.getDateAcct());
            }
        }
        if (this.getDateAcct() == null) {
            this.setDateAcct(this.getDateDoc());
            if (CLogger.peekError() != null) {
                return false;
            }
        } else if (!this.isProcessed()) {
            MPeriod currentPeriod;
            int C_Period_ID = MPeriod.getC_Period_ID(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID());
            if (C_Period_ID == 0) {
                this.log.saveError("PeriodNotFound", " : " + DisplayType.getDateFormat().format(this.getDateAcct()));
                return false;
            }
            if (C_Period_ID != this.getC_Period_ID() && (currentPeriod = MPeriod.get(this.getCtx(), this.getC_Period_ID())).isStandardPeriod()) {
                this.setC_Period_ID(C_Period_ID);
            }
        }
        return true;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

