/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchemaGL;
import org.compiere.model.MClientInfo;
import org.compiere.model.MConversionType;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MRefList;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_GL_Journal;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MJournal
extends X_GL_Journal
implements DocAction {
    private static final long serialVersionUID = 4661098755828765138L;
    protected String m_processMsg = null;
    protected boolean m_justPrepared = false;

    public MJournal(Properties ctx, int GL_Journal_ID, String trxName) {
        super(ctx, GL_Journal_ID, trxName);
        if (GL_Journal_ID == 0) {
            this.setCurrencyRate(Env.ONE);
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setPostingType("A");
            this.setTotalCr(Env.ZERO);
            this.setTotalDr(Env.ZERO);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MJournal(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MJournal(MJournalBatch parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setGL_JournalBatch_ID(parent.getGL_JournalBatch_ID());
        this.setC_DocType_ID(parent.getC_DocType_ID());
        this.setPostingType(parent.getPostingType());
        this.setDateDoc(parent.getDateDoc());
        this.setC_Period_ID(parent.getC_Period_ID());
        this.setDateAcct(parent.getDateAcct());
        this.setC_Currency_ID(parent.getC_Currency_ID());
    }

    public MJournal(MJournal original) {
        this(original.getCtx(), 0, original.get_TrxName());
        this.setClientOrg(original);
        this.setGL_JournalBatch_ID(original.getGL_JournalBatch_ID());
        this.setC_AcctSchema_ID(original.getC_AcctSchema_ID());
        this.setGL_Budget_ID(original.getGL_Budget_ID());
        this.setGL_Category_ID(original.getGL_Category_ID());
        this.setPostingType(original.getPostingType());
        this.setDescription(original.getDescription());
        this.setC_DocType_ID(original.getC_DocType_ID());
        this.setControlAmt(original.getControlAmt());
        this.setC_Currency_ID(original.getC_Currency_ID());
        this.setC_ConversionType_ID(original.getC_ConversionType_ID());
        this.setCurrencyRate(original.getCurrencyRate());
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    @Override
    public void setDateAcct(Timestamp DateAcct) {
        super.setDateAcct(DateAcct);
        if (DateAcct == null) {
            return;
        }
        int C_Period_ID = MPeriod.getC_Period_ID(this.getCtx(), DateAcct, this.getAD_Org_ID());
        if (C_Period_ID == 0) {
            this.log.saveError("PeriodNotFound", " : " + DisplayType.getDateFormat().format(this.getDateAcct()));
        } else if (C_Period_ID != this.getC_Period_ID()) {
            this.setC_Period_ID(C_Period_ID);
        }
    }

    public void setCurrency(int C_Currency_ID, int C_ConversionType_ID, BigDecimal CurrencyRate) {
        if (C_Currency_ID != 0) {
            this.setC_Currency_ID(C_Currency_ID);
        }
        if (C_ConversionType_ID != 0) {
            this.setC_ConversionType_ID(C_ConversionType_ID);
        }
        if (CurrencyRate != null && CurrencyRate.compareTo(Env.ZERO) == 0) {
            this.setCurrencyRate(CurrencyRate);
        }
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    public MJournalLine[] getLines(boolean requery) {
        String whereClause = "GL_Journal_ID=?";
        List<MJournalLine> list = new Query(this.getCtx(), "GL_JournalLine", "GL_Journal_ID=?", this.get_TrxName()).setParameters(this.getGL_Journal_ID()).setOrderBy("Line,GL_JournalLine_ID").list();
        MJournalLine[] retValue = new MJournalLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int copyLinesFrom(MJournal fromJournal, Timestamp dateAcct, char typeCR) {
        if (this.isProcessed() || fromJournal == null) {
            return 0;
        }
        int count = 0;
        MJournalLine[] fromLines = fromJournal.getLines(false);
        int i2 = 0;
        while (i2 < fromLines.length) {
            MJournalLine toLine = new MJournalLine(this.getCtx(), 0, fromJournal.get_TrxName());
            PO.copyValues(fromLines[i2], toLine, this.getAD_Client_ID(), this.getAD_Org_ID());
            toLine.setGL_Journal_ID(this.getGL_Journal_ID());
            if (dateAcct != null) {
                toLine.setDateAcct(dateAcct);
            }
            if (typeCR == 'C') {
                toLine.setAmtSourceDr(fromLines[i2].getAmtSourceDr().negate());
                toLine.setAmtSourceCr(fromLines[i2].getAmtSourceCr().negate());
            } else if (typeCR == 'R') {
                toLine.setAmtSourceDr(fromLines[i2].getAmtSourceCr());
                toLine.setAmtSourceCr(fromLines[i2].getAmtSourceDr());
            }
            toLine.setIsGenerated(true);
            toLine.setProcessed(false);
            if (toLine.save()) {
                ++count;
            }
            ++i2;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - JournalLines=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder("UPDATE GL_JournalLine SET Processed='").append(processed ? "Y" : "N").append("' WHERE GL_Journal_ID=").append(this.getGL_Journal_ID());
        int noLine = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(processed) + " - Lines=" + noLine);
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getGL_JournalBatch_ID() > 0) {
            MJournalBatch parent = new MJournalBatch(this.getCtx(), this.getGL_JournalBatch_ID(), this.get_TrxName());
            if (newRecord && parent.isProcessed()) {
                this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "GL_JournalBatch_ID"));
                return false;
            }
        }
        if (this.getDateDoc() == null) {
            if (this.getDateAcct() == null) {
                this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            } else {
                this.setDateDoc(this.getDateAcct());
            }
        }
        if (this.getDateAcct() == null) {
            this.setDateAcct(this.getDateDoc());
            if (CLogger.peekError() != null) {
                return false;
            }
        } else if (!this.isProcessed()) {
            MPeriod currentPeriod;
            int C_Period_ID = MPeriod.getC_Period_ID(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID());
            if (C_Period_ID == 0) {
                this.log.saveError("PeriodNotFound", " : " + DisplayType.getDateFormat().format(this.getDateAcct()));
                return false;
            }
            if (C_Period_ID != this.getC_Period_ID() && (currentPeriod = MPeriod.get(this.getCtx(), this.getC_Period_ID())).isStandardPeriod()) {
                this.setC_Period_ID(C_Period_ID);
            }
        }
        if (this.getGL_Category_ID() == 0 && this.getC_DocType_ID() > 0) {
            this.setGL_Category_ID(MDocType.get(this.getCtx(), this.getC_DocType_ID()).getGL_Category_ID());
        }
        if (this.getC_AcctSchema_ID() == 0) {
            this.setC_AcctSchema_ID(MClientInfo.get(this.getCtx(), this.getAD_Client_ID()).getC_AcctSchema1_ID());
        }
        if (this.getC_ConversionType_ID() == 0) {
            this.setC_ConversionType_ID(MConversionType.getDefault(this.getAD_Client_ID()));
        }
        BigDecimal previousProcessedOn = (BigDecimal)this.get_ValueOld("ProcessedOn");
        if (!newRecord && previousProcessedOn != null && previousProcessedOn.signum() > 0) {
            int previousDocTypeID = (Integer)this.get_ValueOld("C_DocType_ID");
            MDocType previousdt = MDocType.get(this.getCtx(), previousDocTypeID);
            if (this.is_ValueChanged("C_DocType_ID") && previousdt.isOverwriteSeqOnComplete()) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotChangeProcessedDocType"));
                return false;
            }
            if (this.is_ValueChanged("DateDoc") && previousdt.isOverwriteDateOnComplete()) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotChangeProcessedDate"));
                return false;
            }
        }
        if (this.is_ValueChanged("DateAcct")) {
            int no = DB.executeUpdate("UPDATE GL_JournalLine SET DateAcct=? WHERE GL_Journal_ID=?", new Object[]{this.getDateAcct(), this.getGL_Journal_ID()}, false, this.get_TrxName());
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Updated GL_JournalLine.DateAcct #" + no);
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateBatch();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateBatch();
    }

    protected boolean updateBatch() {
        if (this.getGL_JournalBatch_ID() != 0) {
            StringBuilder sql = new StringBuilder("UPDATE GL_JournalBatch jb").append(" SET (TotalDr, TotalCr) = (SELECT COALESCE(SUM(TotalDr),0), COALESCE(SUM(TotalCr),0)").append(" FROM GL_Journal j WHERE j.IsActive='Y' AND jb.GL_JournalBatch_ID=j.GL_JournalBatch_ID) ").append("WHERE GL_JournalBatch_ID=").append(this.getGL_JournalBatch_ID());
            int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            if (no != 1) {
                this.log.warning("afterSave - Update Batch #" + no);
            }
            return no == 1;
        }
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        return true;
    }

    @Override
    public String prepareIt() {
        MAcctSchemaGL gl;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_processMsg = this.validatePeriod(this.getDateAcct());
        if (this.m_processMsg != null) {
            return "IN";
        }
        MJournalLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal AmtSourceDr = Env.ZERO;
        BigDecimal AmtSourceCr = Env.ZERO;
        int i2 = 0;
        while (i2 < lines.length) {
            MJournalLine line = lines[i2];
            if (this.isActive()) {
                if (!line.getDateAcct().equals(this.getDateAcct())) {
                    this.m_processMsg = this.validatePeriod(line.getDateAcct());
                    if (this.m_processMsg != null) {
                        return "IN";
                    }
                }
                if (!line.getAccountElementValue().isActive()) {
                    this.m_processMsg = "@InActiveAccount@ - @Line@=" + line.getLine() + " - " + line.getAccountElementValue();
                    return "IN";
                }
                if (line.isDocControlled() && (this.getPostingType().equals("A") || this.getPostingType().equals("E") || this.getPostingType().equals("R"))) {
                    this.m_processMsg = "@DocControlledError@ - @Line@=" + line.getLine() + " - " + line.getAccountElementValue();
                    return "IN";
                }
                if (this.getPostingType().equals("A") && !line.getAccountElementValue().isPostActual()) {
                    this.m_processMsg = "@PostingTypeActualError@ - @Line@=" + line.getLine() + " - " + line.getAccountElementValue();
                    return "IN";
                }
                if (this.getPostingType().equals("B") && !line.getAccountElementValue().isPostBudget()) {
                    this.m_processMsg = "@PostingTypeBudgetError@ - @Line@=" + line.getLine() + " - " + line.getAccountElementValue();
                    return "IN";
                }
                if (this.getPostingType().equals("S") && !line.getAccountElementValue().isPostStatistical()) {
                    this.m_processMsg = "@PostingTypeStatisticalError@ - @Line@=" + line.getLine() + " - " + line.getAccountElementValue();
                    return "IN";
                }
                AmtSourceDr = AmtSourceDr.add(line.getAmtAcctDr());
                AmtSourceCr = AmtSourceCr.add(line.getAmtAcctCr());
            }
            ++i2;
        }
        this.setTotalDr(AmtSourceDr);
        this.setTotalCr(AmtSourceCr);
        if (Env.ZERO.compareTo(this.getControlAmt()) != 0 && this.getControlAmt().compareTo(this.getTotalDr()) != 0) {
            this.m_processMsg = "@ControlAmtError@";
            return "IN";
        }
        if (!(AmtSourceDr.compareTo(AmtSourceCr) == 0 || (gl = MAcctSchemaGL.get(this.getCtx(), this.getC_AcctSchema_ID())) != null && gl.isUseSuspenseBalancing())) {
            this.m_processMsg = "@UnbalancedJornal@";
            return "IN";
        }
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    private String validatePeriod(Timestamp dateAcct) {
        boolean open;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        MPeriod period = (MPeriod)this.getC_Period();
        SimpleDateFormat dateFormat = DisplayType.getDateFormat(15);
        if (!period.isInPeriod(dateAcct)) {
            period = MPeriod.get(this.getCtx(), dateAcct, this.getAD_Org_ID(), this.get_TrxName());
            if (period == null) {
                this.log.warning("No Period for " + dateAcct);
                return "@PeriodNotFound@ -> " + dateFormat.format(dateAcct);
            }
            if (period.getC_Period_ID() != this.getC_Period_ID() && period.isStandardPeriod()) {
                this.log.warning("No Period for " + dateAcct);
                return "@PeriodNotValid@ -> " + dateFormat.format(dateAcct);
            }
        }
        if (!(open = period.isOpen(dt.getDocBaseType(), dateAcct))) {
            this.log.warning(String.valueOf(period.getName()) + ": Not open for " + dt.getDocBaseType() + " (" + dateAcct + ")");
            return "@PeriodClosed@ -> " + dateFormat.format(dateAcct);
        }
        return null;
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String valid;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    protected void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete() && this.getProcessedOn().signum() == 0) {
            this.setDateDoc(TimeUtil.getDay(0L));
            if (this.getDateAcct().before(this.getDateDoc())) {
                this.setDateAcct(this.getDateDoc());
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
            }
        }
        if (dt.isOverwriteSeqOnComplete() && this.getProcessedOn().signum() == 0 && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean ok_to_void = false;
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus())) {
            MJournalLine[] lines = this.getLines(false);
            int i2 = 0;
            while (i2 < lines.length) {
                MJournalLine line = lines[i2];
                if (line.getAmtAcctDr().signum() != 0 || line.getAmtAcctCr().signum() != 0) {
                    line.setAmtAcctDr(Env.ZERO);
                    line.setAmtAcctCr(Env.ZERO);
                    line.setAmtSourceDr(Env.ZERO);
                    line.setAmtSourceCr(Env.ZERO);
                    line.setQty(Env.ZERO);
                    line.saveEx(this.get_TrxName());
                }
                ++i2;
            }
        } else {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        ok_to_void = true;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        return ok_to_void;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean ok_to_close = false;
        if (!"CO".equals(this.getDocStatus())) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        ok_to_close = true;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        if (this.m_processMsg != null) {
            return false;
        }
        return ok_to_close;
    }

    @Override
    public boolean reverseCorrectIt() {
        boolean ok_correct;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean bl = ok_correct = this.reverseCorrectIt(this.getGL_JournalBatch_ID()) != null;
        if (!ok_correct) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return ok_correct;
    }

    public MJournal reverseCorrectIt(int GL_JournalBatch_ID) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        MJournal reverse = new MJournal(this);
        reverse.setGL_JournalBatch_ID(GL_JournalBatch_ID);
        reverse.setDateDoc(this.getDateDoc());
        reverse.setC_Period_ID(this.getC_Period_ID());
        reverse.setDateAcct(this.getDateAcct());
        StringBuilder msgd = new StringBuilder("(->").append(this.getDocumentNo()).append(")");
        reverse.addDescription(msgd.toString());
        reverse.setControlAmt(this.getControlAmt().negate());
        reverse.setReversal_ID(this.getGL_Journal_ID());
        if (!reverse.save()) {
            return null;
        }
        reverse.copyLinesFrom(this, null, 'C');
        if (!reverse.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reverse.getProcessMsg();
            return null;
        }
        reverse.closeIt();
        reverse.setProcessing(false);
        reverse.setDocStatus("RE");
        reverse.setDocAction("--");
        reverse.saveEx(this.get_TrxName());
        msgd = new StringBuilder("(").append(reverse.getDocumentNo()).append("<-)");
        this.addDescription(msgd.toString());
        this.setProcessed(true);
        this.setReversal_ID(reverse.getGL_Journal_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        return reverse;
    }

    @Override
    public boolean reverseAccrualIt() {
        boolean ok_reverse;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean bl = ok_reverse = this.reverseAccrualIt(this.getGL_JournalBatch_ID()) != null;
        if (!ok_reverse) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return ok_reverse;
    }

    public MJournal reverseAccrualIt(int GL_JournalBatch_ID) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        MJournal reverse = new MJournal(this);
        reverse.setGL_JournalBatch_ID(GL_JournalBatch_ID);
        Timestamp reversalDate = Env.getContextAsDate(this.getCtx(), "#Date");
        if (reversalDate == null) {
            reversalDate = new Timestamp(System.currentTimeMillis());
        }
        reverse.setDateDoc(reversalDate);
        reverse.set_ValueNoCheck("C_Period_ID", null);
        reverse.setDateAcct(reversalDate);
        StringBuilder msgd = new StringBuilder("(->").append(this.getDocumentNo()).append(")");
        reverse.addDescription(msgd.toString());
        reverse.setReversal_ID(this.getGL_Journal_ID());
        if (!reverse.save()) {
            return null;
        }
        reverse.copyLinesFrom(this, reverse.getDateAcct(), 'R');
        if (!reverse.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reverse.getProcessMsg();
            return null;
        }
        reverse.closeIt();
        reverse.setProcessing(false);
        reverse.setDocStatus("RE");
        reverse.setDocAction("--");
        reverse.saveEx(this.get_TrxName());
        msgd = new StringBuilder("(").append(reverse.getDocumentNo()).append("<-)");
        this.addDescription(msgd.toString());
        this.setProcessed(true);
        this.setReversal_ID(reverse.getGL_Journal_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        return reverse;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
        MFactAcct.deleteEx(224, this.get_ID(), this.get_TrxName());
        this.setPosted(false);
        this.setProcessed(false);
        this.setDocAction("CO");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "TotalDr")).append("=").append(this.getTotalDr()).append(" ").append(Msg.translate(this.getCtx(), "TotalCR")).append("=").append(this.getTotalCr()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MJournal[");
        sb.append(this.get_ID()).append(",").append(this.getDescription()).append(",DR=").append(this.getTotalDr()).append(",CR=").append(this.getTotalCr()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        StringBuilder msgreturn = new StringBuilder().append(dt.getNameTrl()).append(" ").append(this.getDocumentNo());
        return msgreturn.toString();
    }

    @Override
    public File createPDF() {
        try {
            StringBuilder msgfile = new StringBuilder().append(this.get_TableName()).append(this.get_ID()).append("_");
            File temp = File.createTempFile(msgfile.toString(), ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getTotalDr();
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }
}

