/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MIssue;
import org.compiere.model.X_R_IssueSystem;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MIssueSystem
extends X_R_IssueSystem {
    private static final long serialVersionUID = -1652388382466287269L;
    private static CLogger s_log = CLogger.getCLogger(MIssueSystem.class);

    public static MIssueSystem get(MIssue issue) {
        X_R_IssueSystem system;
        block11: {
            if (issue.getDBAddress() == null) {
                return null;
            }
            system = null;
            String sql = "SELECT * FROM R_IssueSystem WHERE DBAddress=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setString(1, issue.getDBAddress());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        system = new MIssueSystem(issue.getCtx(), rs, null);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (system == null) {
            system = new MIssueSystem(issue.getCtx(), 0, null);
            system.setDBAddress(issue.getDBAddress());
            system.setA_Asset_ID(issue.getA_Asset_ID());
        }
        system.setSystemStatus(issue.getSystemStatus());
        system.setStatisticsInfo(issue.getStatisticsInfo());
        system.setProfileInfo(issue.getProfileInfo());
        if (issue.getA_Asset_ID() != 0 && system.getA_Asset_ID() != issue.getA_Asset_ID()) {
            system.setA_Asset_ID(issue.getA_Asset_ID());
        }
        if (!system.save()) {
            return null;
        }
        issue.setR_IssueSystem_ID(system.getR_IssueSystem_ID());
        if (system.getA_Asset_ID() != 0) {
            issue.setA_Asset_ID(system.getA_Asset_ID());
        }
        return system;
    }

    public MIssueSystem(Properties ctx, int R_IssueSystem_ID, String trxName) {
        super(ctx, R_IssueSystem_ID, trxName);
    }

    public MIssueSystem(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MIssueSystem[");
        sb.append(this.get_ID()).append("-").append(this.getDBAddress()).append(",A_Asset_ID=").append(this.getA_Asset_ID()).append("]");
        return sb.toString();
    }
}

