/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.model.X_C_InvoiceTax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MInvoiceTax
extends X_C_InvoiceTax {
    private static final long serialVersionUID = -5560880305482497098L;
    private static CLogger s_log = CLogger.getCLogger(MInvoiceTax.class);
    private MTax m_tax = null;
    private Integer m_precision = null;

    public static MInvoiceTax get(MInvoiceLine line, int precision, boolean oldTax, String trxName) {
        boolean isOldTax;
        MInvoiceTax retValue = null;
        if (line == null || line.getC_Invoice_ID() == 0) {
            return null;
        }
        int C_Tax_ID = line.getC_Tax_ID();
        boolean bl = isOldTax = oldTax && line.is_ValueChanged("C_Tax_ID");
        if (isOldTax) {
            Object old = line.get_ValueOld("C_Tax_ID");
            if (old == null) {
                return null;
            }
            C_Tax_ID = (Integer)old;
        }
        if (C_Tax_ID == 0) {
            if (!line.isDescription()) {
                s_log.warning("C_Tax_ID=0");
            }
            return null;
        }
        retValue = (MInvoiceTax)new Query(line.getCtx(), "C_InvoiceTax", "C_Invoice_ID=? AND C_Tax_ID=?", trxName).setParameters(line.getC_Invoice_ID(), C_Tax_ID).firstOnly();
        if (retValue != null) {
            retValue.set_TrxName(trxName);
            retValue.setPrecision(precision);
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("(old=" + oldTax + ") " + retValue);
            }
            return retValue;
        }
        if (isOldTax) {
            return null;
        }
        retValue = new MInvoiceTax(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setClientOrg(line);
        retValue.setC_Invoice_ID(line.getC_Invoice_ID());
        retValue.setC_Tax_ID(line.getC_Tax_ID());
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(line.isTaxIncluded());
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("(new) " + retValue);
        }
        return retValue;
    }

    public static MInvoiceTax[] getChildTaxes(MInvoiceLine line, int precision, boolean oldTax, String trxName) {
        MTax[] cTaxes;
        ArrayList<MInvoiceTax> invoiceTaxes = new ArrayList<MInvoiceTax>();
        if (line == null || line.getC_Invoice_ID() == 0) {
            return invoiceTaxes.toArray(new MInvoiceTax[0]);
        }
        int C_Tax_ID = line.getC_Tax_ID();
        if (oldTax) {
            Object old = line.get_ValueOld("C_Tax_ID");
            if (old == null) {
                return invoiceTaxes.toArray(new MInvoiceTax[0]);
            }
            C_Tax_ID = (Integer)old;
        }
        if (C_Tax_ID == 0) {
            return invoiceTaxes.toArray(new MInvoiceTax[0]);
        }
        MTax tax = MTax.get(C_Tax_ID);
        if (!tax.isSummary()) {
            return invoiceTaxes.toArray(new MInvoiceTax[0]);
        }
        MTax[] mTaxArray = cTaxes = tax.getChildTaxes(false);
        int n = cTaxes.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                MInvoiceTax invoiceTax;
                MTax cTax;
                block11: {
                    block10: {
                        cTax = mTaxArray[n2];
                        invoiceTax = (MInvoiceTax)new Query(line.getCtx(), "C_InvoiceTax", "C_Invoice_ID=? AND C_Tax_ID=?", trxName).setParameters(line.getC_Invoice_ID(), cTax.getC_Tax_ID()).firstOnly();
                        if (invoiceTax == null) break block10;
                        invoiceTax.set_TrxName(trxName);
                        invoiceTax.setPrecision(precision);
                        invoiceTaxes.add(invoiceTax);
                        break block11;
                    }
                    if (oldTax) break block12;
                }
                if (invoiceTax == null) {
                    invoiceTax = new MInvoiceTax(line.getCtx(), 0, trxName);
                    invoiceTax.set_TrxName(trxName);
                    invoiceTax.setClientOrg(line);
                    invoiceTax.setC_Invoice_ID(line.getC_Invoice_ID());
                    invoiceTax.setC_Tax_ID(cTax.getC_Tax_ID());
                    invoiceTax.setPrecision(precision);
                    invoiceTax.setIsTaxIncluded(line.isTaxIncluded());
                    invoiceTaxes.add(invoiceTax);
                }
            }
            ++n2;
        }
        return invoiceTaxes.toArray(new MInvoiceTax[0]);
    }

    public MInvoiceTax(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setTaxAmt(Env.ZERO);
        this.setTaxBaseAmt(Env.ZERO);
        this.setIsTaxIncluded(false);
    }

    public MInvoiceTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInvoiceTax(MInvoiceTax copy) {
        this(Env.getCtx(), copy);
    }

    public MInvoiceTax(Properties ctx, MInvoiceTax copy) {
        this(ctx, copy, null);
    }

    public MInvoiceTax(Properties ctx, MInvoiceTax copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_precision = copy.m_precision;
        this.m_tax = copy.m_tax != null ? new MTax(ctx, copy.m_tax, trxName) : null;
    }

    private int getPrecision() {
        if (this.m_precision == null) {
            return 2;
        }
        return this.m_precision;
    }

    protected void setPrecision(int precision) {
        this.m_precision = precision;
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public boolean calculateTaxFromLines() {
        BigDecimal taxBaseAmt = Env.ZERO;
        BigDecimal taxAmt = Env.ZERO;
        boolean documentLevel = this.getTax().isDocumentLevel();
        MTax tax = this.getTax();
        int parentTaxId = tax.getParent_Tax_ID();
        String sql = "SELECT il.LineNetAmt, COALESCE(il.TaxAmt,0), i.IsSOTrx FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) WHERE il.C_Invoice_ID=? ";
        sql = parentTaxId > 0 ? String.valueOf(sql) + "AND il.C_Tax_ID IN (?, ?) " : String.valueOf(sql) + "AND il.C_Tax_ID=? ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getC_Invoice_ID());
                pstmt.setInt(2, this.getC_Tax_ID());
                if (parentTaxId > 0) {
                    pstmt.setInt(3, parentTaxId);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    BigDecimal baseAmt = rs.getBigDecimal(1);
                    taxBaseAmt = taxBaseAmt.add(baseAmt);
                    BigDecimal amt = rs.getBigDecimal(2);
                    if (amt == null) {
                        amt = Env.ZERO;
                    }
                    boolean isSOTrx = "Y".equals(rs.getString(3));
                    if (documentLevel || amt.signum() == 0 || isSOTrx) {
                        amt = documentLevel || baseAmt.signum() == 0 ? Env.ZERO : tax.calculateTax(baseAmt, this.isTaxIncluded(), this.getPrecision());
                    }
                    taxAmt = taxAmt.add(amt);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (documentLevel || taxAmt.signum() == 0) {
            taxAmt = tax.calculateTax(taxBaseAmt, this.isTaxIncluded(), this.getPrecision());
        }
        this.setTaxAmt(taxAmt);
        if (this.isTaxIncluded()) {
            this.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            this.setTaxBaseAmt(taxBaseAmt);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MInvoiceTax[");
        sb.append("C_Invoice_ID=").append(this.getC_Invoice_ID()).append(",C_Tax_ID=").append(this.getC_Tax_ID()).append(", Base=").append(this.getTaxBaseAmt()).append(",Tax=").append(this.getTaxAmt()).append("]");
        return sb.toString();
    }
}

