/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MDocType;
import org.compiere.model.MInventory;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.model.X_M_InventoryLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInventoryLine
extends X_M_InventoryLine {
    private static final long serialVersionUID = 3973418005721380194L;
    protected MInventory m_parent = null;
    protected MProduct m_product = null;

    public static MInventoryLine get(MInventory inventory, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID) {
        String whereClause = "M_Inventory_ID=? AND M_Locator_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?";
        return (MInventoryLine)new Query(inventory.getCtx(), "M_InventoryLine", "M_Inventory_ID=? AND M_Locator_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?", inventory.get_TrxName()).setParameters(inventory.get_ID(), M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID).firstOnly();
    }

    public MInventoryLine(Properties ctx, int M_InventoryLine_ID, String trxName) {
        this(ctx, M_InventoryLine_ID, trxName, null);
    }

    public MInventoryLine(Properties ctx, int M_InventoryLine_ID, String trxName, String ... virtualColumns) {
        super(ctx, M_InventoryLine_ID, trxName, virtualColumns);
        if (M_InventoryLine_ID == 0) {
            this.setLine(0);
            this.setM_AttributeSetInstance_ID(0);
            this.setInventoryType("D");
            this.setQtyBook(Env.ZERO);
            this.setQtyCount(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MInventoryLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInventoryLine(MInventory inventory, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal QtyBook, BigDecimal QtyCount, BigDecimal QtyInternalUse) {
        this(inventory.getCtx(), 0, inventory.get_TrxName());
        if (inventory.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.m_parent = inventory;
        this.setM_Inventory_ID(inventory.getM_Inventory_ID());
        this.setClientOrg(inventory.getAD_Client_ID(), inventory.getAD_Org_ID());
        this.setM_Locator_ID(M_Locator_ID);
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        if (QtyBook != null) {
            this.setQtyBook(QtyBook);
        }
        if (QtyCount != null && QtyCount.signum() != 0) {
            this.setQtyCount(QtyCount);
        }
        if (QtyInternalUse != null && QtyInternalUse.signum() != 0) {
            this.setQtyInternalUse(QtyInternalUse);
        }
    }

    public MInventoryLine(MInventory inventory, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal QtyBook, BigDecimal QtyCount) {
        this(inventory, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, QtyBook, QtyCount, null);
    }

    public MInventoryLine(MInventoryLine copy) {
        this(Env.getCtx(), copy);
    }

    public MInventoryLine(Properties ctx, MInventoryLine copy) {
        this(ctx, copy, null);
    }

    public MInventoryLine(Properties ctx, MInventoryLine copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_parent = null;
        this.m_product = copy.m_product != null ? new MProduct(ctx, copy.m_product, trxName) : null;
    }

    public MProduct getProduct() {
        int M_Product_ID = this.getM_Product_ID();
        if (M_Product_ID == 0) {
            return null;
        }
        if (this.m_product != null && this.m_product.getM_Product_ID() != M_Product_ID) {
            this.m_product = null;
        }
        if (this.m_product == null) {
            this.m_product = MProduct.get(this.getCtx(), M_Product_ID, this.get_TrxName());
        }
        return this.m_product;
    }

    @Override
    public void setQtyCount(BigDecimal QtyCount) {
        MProduct product;
        if (QtyCount != null && (product = this.getProduct()) != null) {
            int precision = product.getUOMPrecision();
            QtyCount = QtyCount.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyCount(QtyCount);
    }

    @Override
    public void setQtyInternalUse(BigDecimal QtyInternalUse) {
        MProduct product;
        if (QtyInternalUse != null && (product = this.getProduct()) != null) {
            int precision = product.getUOMPrecision();
            QtyInternalUse = QtyInternalUse.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyInternalUse(QtyInternalUse);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    protected void setParent(MInventory parent) {
        this.m_parent = parent;
    }

    public MInventory getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInventory(this.getCtx(), this.getM_Inventory_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MInventoryLine[");
        sb.append(this.get_ID()).append("-M_Product_ID=").append(this.getM_Product_ID()).append(",QtyCount=").append(this.getQtyCount()).append(",QtyInternalUse=").append(this.getQtyInternalUse()).append(",QtyBook=").append(this.getQtyBook()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MDocType dt;
        String docSubTypeInv;
        if (newRecord && this.getParent().isProcessed()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_Inventory_ID"));
            return false;
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM M_InventoryLine WHERE M_Inventory_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getM_Inventory_ID());
            this.setLine(ii);
        }
        if (newRecord || this.is_ValueChanged("QtyCount")) {
            this.setQtyCount(this.getQtyCount());
        }
        if (newRecord || this.is_ValueChanged("QtyInternalUse")) {
            this.setQtyInternalUse(this.getQtyInternalUse());
        }
        if ("IU".equals(docSubTypeInv = (dt = MDocType.get(this.getCtx(), this.getParent().getC_DocType_ID())).getDocSubTypeInv())) {
            if (!"C".equals(this.getInventoryType())) {
                this.setInventoryType("C");
            }
            if (this.getC_Charge_ID() == 0) {
                this.log.saveError("InternalUseNeedsCharge", "");
                return false;
            }
            if (this.getQtyBook().signum() != 0) {
                this.log.saveError("Quantity", Msg.getElement(this.getCtx(), "QtyBook"));
                return false;
            }
            if (this.getQtyCount().signum() != 0) {
                this.log.saveError("Quantity", Msg.getElement(this.getCtx(), "QtyCount"));
                return false;
            }
            if (this.getQtyInternalUse().signum() == 0 && !this.getParent().getDocAction().equals("VO")) {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "QtyInternalUse"));
                return false;
            }
        } else if ("PI".equals(docSubTypeInv)) {
            if ("C".equals(this.getInventoryType())) {
                if (this.getC_Charge_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "C_Charge_ID"));
                    return false;
                }
            } else if (this.getC_Charge_ID() != 0) {
                this.setC_Charge_ID(0);
            }
            if (this.getQtyInternalUse().signum() != 0) {
                this.log.saveError("Quantity", Msg.getElement(this.getCtx(), "QtyInternalUse"));
                return false;
            }
        } else if ("CA".equals(docSubTypeInv)) {
            MClient client;
            MAcctSchema as;
            int M_ASI_ID = this.getM_AttributeSetInstance_ID();
            MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
            String costingLevel = product.getCostingLevel(as = (client = MClient.get(this.getCtx())).getAcctSchema());
            if ("B".equals(costingLevel) && M_ASI_ID == 0) {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "M_AttributeSetInstance_ID"));
                return false;
            }
            int C_Currency_ID = this.getParent().getC_Currency_ID();
            if (as.getC_Currency_ID() != C_Currency_ID) {
                MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(this.getCtx(), client.get_ID());
                int i2 = 0;
                while (i2 < ass.length) {
                    MAcctSchema a2 = ass[i2];
                    if (a2.getC_Currency_ID() == C_Currency_ID) {
                        as = a2;
                    }
                    ++i2;
                }
            }
            String costingMethod = this.getParent().getCostingMethod();
            int AD_Org_ID = this.getAD_Org_ID();
            MCost cost = product.getCostingRecord(as, AD_Org_ID, M_ASI_ID, costingMethod);
            if (cost == null) {
                if (!"S".equals(costingMethod)) {
                    this.log.saveError("NoCostingRecord", "");
                    return false;
                }
            } else if (this.is_new() || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("M_AttributeSetInstance_ID")) {
                this.setCurrentCostPrice(cost.getCurrentCostPrice());
            }
            this.setM_Locator_ID(0);
        } else {
            this.log.saveError("Error", "Document inventory subtype not configured, cannot complete");
            return false;
        }
        if (this.getC_Charge_ID() == 0) {
            this.setAD_Org_ID(this.getParent().getAD_Org_ID());
        }
        return true;
    }

    public boolean isInternalUseInventory() {
        MDocType dt = MDocType.get(this.getCtx(), this.getParent().getC_DocType_ID());
        String docSubTypeInv = dt.getDocSubTypeInv();
        return "IU".equals(docSubTypeInv);
    }

    public BigDecimal getMovementQty() {
        if (this.isInternalUseInventory()) {
            return this.getQtyInternalUse().negate();
        }
        return this.getQtyCount().subtract(this.getQtyBook());
    }

    public boolean isSOTrx() {
        return this.getMovementQty().signum() < 0;
    }
}

