/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ImportTemplate;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.cache.ImmutablePOSupport;

public class MImportTemplate
extends X_AD_ImportTemplate
implements ImmutablePOSupport {
    private static final long serialVersionUID = -4681075469110529774L;
    private static CLogger s_log = CLogger.getCLogger(MImportTemplate.class);
    private static CCache<String, List<MImportTemplate>> s_cacheRoleTab = new CCache("AD_ImportTemplate", "AD_ImportTemplate_Of_Role", 5);

    public MImportTemplate(Properties ctx, int AD_ImportTemplate_ID, String trxName) {
        super(ctx, AD_ImportTemplate_ID, trxName);
    }

    public MImportTemplate(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MImportTemplate(MImportTemplate copy) {
        this(Env.getCtx(), copy);
    }

    public MImportTemplate(Properties ctx, MImportTemplate copy) {
        this(ctx, copy, null);
    }

    public MImportTemplate(Properties ctx, MImportTemplate copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getCharacterSet() == null) {
            this.setCharacterSet(Charset.defaultCharset().displayName());
        }
        if (this.getCharacterSet() == null || !Charset.isSupported(this.getCharacterSet())) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Invalid@ @CharacterSet@"));
            return false;
        }
        return super.beforeSave(newRecord);
    }

    public static List<MImportTemplate> getTemplates(int roleid, int tabid) {
        String key = String.valueOf(roleid) + "_" + tabid;
        List<MImportTemplate> retValue = s_cacheRoleTab.get(key);
        if (retValue != null) {
            return retValue;
        }
        String where = "IsActive = 'Y' AND AD_Client_ID IN ( 0, ? ) AND AD_Tab_ID = ? AND EXISTS (SELECT 1             FROM   AD_ImportTemplateAccess ita             WHERE  ita.AD_ImportTemplate_ID = AD_ImportTemplate.AD_ImportTemplate_ID                    AND ita.IsActive = 'Y'                    AND ( ita.AD_Role_ID = ?                           OR ita.AD_Role_ID IN (SELECT Included_Role_ID                                                 FROM   AD_Role_Included                                                 WHERE  AD_Role_ID = ? AND IsActive = 'Y') )                    AND ( IsAllowInsert = 'Y'                           OR IsAllowMerge = 'Y'                           OR IsAllowUpdate = 'Y' ))";
        retValue = new Query(Env.getCtx(), "AD_ImportTemplate", "IsActive = 'Y' AND AD_Client_ID IN ( 0, ? ) AND AD_Tab_ID = ? AND EXISTS (SELECT 1             FROM   AD_ImportTemplateAccess ita             WHERE  ita.AD_ImportTemplate_ID = AD_ImportTemplate.AD_ImportTemplate_ID                    AND ita.IsActive = 'Y'                    AND ( ita.AD_Role_ID = ?                           OR ita.AD_Role_ID IN (SELECT Included_Role_ID                                                 FROM   AD_Role_Included                                                 WHERE  AD_Role_ID = ? AND IsActive = 'Y') )                    AND ( IsAllowInsert = 'Y'                           OR IsAllowMerge = 'Y'                           OR IsAllowUpdate = 'Y' ))", null).setParameters(Env.getAD_Client_ID(Env.getCtx()), tabid, roleid, roleid).setOrderBy("Name").list();
        if (retValue.size() > 0) {
            retValue.stream().forEach(e -> {
                MImportTemplate mImportTemplate = e.markImmutable();
            });
        }
        s_cacheRoleTab.put(key, retValue);
        return retValue;
    }

    public boolean isAllowed(String importMode, int roleID) {
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) FROM   AD_ImportTemplateaccess WHERE  IsActive = 'Y'        AND AD_ImportTemplate_ID = ?        AND ( AD_Role_ID = ?               OR AD_Role_ID IN (SELECT Included_Role_ID                                 FROM   AD_Role_Included                                 WHERE  AD_Role_id = ?                                        AND IsActive = 'Y') )        AND IsAllow");
        if ("I".equals(importMode)) {
            sql.append("Insert");
        } else if ("U".equals(importMode)) {
            sql.append("Update");
        } else if ("M".equals(importMode)) {
            sql.append("Merge");
        } else {
            return false;
        }
        sql.append("='Y'");
        int cnt = DB.getSQLValueEx(this.get_TrxName(), sql.toString(), this.getAD_ImportTemplate_ID(), roleID, roleID);
        return cnt > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream validateFile(InputStream in) {
        Charset charset = Charset.forName(this.getCharacterSet());
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        File tmpfile = null;
        FileInputStream is = null;
        BufferedWriter bw = null;
        try {
            try {
                tmpfile = File.createTempFile("CSVImportAction", "csv");
                bw = new BufferedWriter(new FileWriter(tmpfile, charset));
                String firstLine = null;
                String line = null;
                while (true) {
                    if ((line = reader.readLine()) == null) {
                        is = new FileInputStream(tmpfile);
                        return is;
                    }
                    if (firstLine == null) {
                        firstLine = line;
                        if (!firstLine.equals(this.getCSVHeader()) && !firstLine.equals(this.getCSVAliasHeader())) {
                            reader.close();
                            throw new AdempiereException(Msg.getMsg(Env.getCtx(), "WrongCSVHeader"));
                        }
                        bw.write(this.getCSVHeader());
                    } else {
                        bw.write(line);
                    }
                    bw.write(10);
                }
            }
            catch (IOException e) {
                throw new AdempiereException(e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public MImportTemplate markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

