/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MColorSchema;
import org.compiere.model.MGoalRestriction;
import org.compiere.model.MMeasure;
import org.compiere.model.MRefList;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.X_PA_Goal;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MGoal
extends X_PA_Goal {
    private static final long serialVersionUID = -4612113288233473730L;
    private static CLogger s_log = CLogger.getCLogger(MGoal.class);
    private MGoalRestriction[] m_restrictions = null;
    private Color m_color = null;

    public static MGoal[] getUserGoals(Properties ctx, int AD_User_ID) {
        ArrayList<MGoal> list;
        block8: {
            if (AD_User_ID < 0) {
                return MGoal.getTestGoals(ctx);
            }
            list = new ArrayList<MGoal>();
            String sql = "SELECT * FROM PA_Goal g WHERE IsActive='Y' AND AD_Client_ID=? AND ((AD_User_ID IS NULL AND AD_Role_ID IS NULL) OR AD_User_ID=? OR EXISTS (SELECT * FROM AD_User_Roles ur WHERE ur.AD_User_ID=? AND g.AD_Role_ID=ur.AD_Role_ID AND ur.IsActive='Y')) ORDER BY SeqNo";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, Env.getAD_Client_ID(ctx));
                    pstmt.setInt(2, AD_User_ID);
                    pstmt.setInt(3, AD_User_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MGoal goal = new MGoal(ctx, rs, null);
                        goal.updateGoal(false);
                        list.add(goal);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (list.size() == 0) {
            s_log.log(Level.INFO, Msg.getMsg(ctx, "FindZeroRecords"));
        }
        MGoal[] retValue = new MGoal[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MGoal[] getGoals(Properties ctx) {
        List<MGoal> list = new Query(ctx, "PA_Goal", null, null).setOrderBy("SeqNo").setApplyAccessFilter(false, true).setOnlyActiveRecords(true).list();
        for (MGoal goal : list) {
            goal.updateGoal(false);
        }
        MGoal[] retValue = new MGoal[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MGoal[] getTestGoals(Properties ctx) {
        MGoal[] retValue = new MGoal[4];
        retValue[0] = new MGoal(ctx, "Test 1", "Description 1", new BigDecimal(1000), null);
        retValue[0].setMeasureActual(new BigDecimal(200));
        retValue[1] = new MGoal(ctx, "Test 2", "Description 2", new BigDecimal(1000), null);
        retValue[1].setMeasureActual(new BigDecimal(900));
        retValue[2] = new MGoal(ctx, "Test 3", "Description 3", new BigDecimal(1000), null);
        retValue[2].setMeasureActual(new BigDecimal(1200));
        retValue[3] = new MGoal(ctx, "Test 4", "Description 4", new BigDecimal(1000), null);
        retValue[3].setMeasureActual(new BigDecimal(3200));
        return retValue;
    }

    public static MGoal[] getMeasureGoals(Properties ctx, int PA_Measure_ID) {
        ArrayList<MGoal> list;
        block6: {
            list = new ArrayList<MGoal>();
            String sql = "SELECT * FROM PA_Goal WHERE IsActive='Y' AND PA_Measure_ID=? ORDER BY SeqNo";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, PA_Measure_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MGoal(ctx, rs, null));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MGoal[] retValue = new MGoal[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static BigDecimal getMultiplier(MGoal goal) {
        String MeasureScope = goal.getMeasureScope();
        String MeasureDisplay = goal.getMeasureDisplay();
        if (MeasureDisplay == null || MeasureScope.equals(MeasureDisplay)) {
            return Env.ONE;
        }
        if (MeasureScope.equals("0") || MeasureDisplay.equals("0")) {
            return null;
        }
        BigDecimal Multiplier = null;
        if (MeasureScope.equals("1")) {
            if (MeasureDisplay.equals("3")) {
                Multiplier = BigDecimal.valueOf(0.25);
            } else if (MeasureDisplay.equals("5")) {
                Multiplier = BigDecimal.valueOf(0.08333333333333333);
            } else if (MeasureDisplay.equals("7")) {
                Multiplier = BigDecimal.valueOf(0.019230769230769232);
            } else if (MeasureDisplay.equals("8")) {
                Multiplier = BigDecimal.valueOf(0.0027472527472527475);
            }
        } else if (MeasureScope.equals("3")) {
            if (MeasureDisplay.equals("1")) {
                Multiplier = BigDecimal.valueOf(4.0);
            } else if (MeasureDisplay.equals("5")) {
                Multiplier = BigDecimal.valueOf(0.3333333333333333);
            } else if (MeasureDisplay.equals("7")) {
                Multiplier = BigDecimal.valueOf(0.07692307692307693);
            } else if (MeasureDisplay.equals("8")) {
                Multiplier = BigDecimal.valueOf(0.01098901098901099);
            }
        } else if (MeasureScope.equals("5")) {
            if (MeasureDisplay.equals("1")) {
                Multiplier = BigDecimal.valueOf(12.0);
            } else if (MeasureDisplay.equals("3")) {
                Multiplier = BigDecimal.valueOf(3.0);
            } else if (MeasureDisplay.equals("7")) {
                Multiplier = BigDecimal.valueOf(0.25);
            } else if (MeasureDisplay.equals("8")) {
                Multiplier = BigDecimal.valueOf(0.03333333333333333);
            }
        } else if (MeasureScope.equals("7")) {
            if (MeasureDisplay.equals("1")) {
                Multiplier = BigDecimal.valueOf(52.0);
            } else if (MeasureDisplay.equals("3")) {
                Multiplier = BigDecimal.valueOf(13.0);
            } else if (MeasureDisplay.equals("5")) {
                Multiplier = BigDecimal.valueOf(4.0);
            } else if (MeasureDisplay.equals("8")) {
                Multiplier = BigDecimal.valueOf(0.14285714285714285);
            }
        } else if (MeasureScope.equals("8")) {
            if (MeasureDisplay.equals("1")) {
                Multiplier = BigDecimal.valueOf(364.0);
            } else if (MeasureDisplay.equals("3")) {
                Multiplier = BigDecimal.valueOf(91.0);
            } else if (MeasureDisplay.equals("5")) {
                Multiplier = BigDecimal.valueOf(30.0);
            } else if (MeasureDisplay.equals("7")) {
                Multiplier = BigDecimal.valueOf(7.0);
            }
        }
        return Multiplier;
    }

    public MGoal(Properties ctx, int PA_Goal_ID, String trxName) {
        super(ctx, PA_Goal_ID, trxName);
        if (PA_Goal_ID == 0) {
            this.setSeqNo(0);
            this.setIsSummary(false);
            this.setMeasureScope("1");
            this.setGoalPerformance(Env.ZERO);
            this.setRelativeWeight(Env.ONE);
            this.setMeasureTarget(Env.ZERO);
            this.setMeasureActual(Env.ZERO);
        }
    }

    public MGoal(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MGoal(Properties ctx, String Name2, String Description, BigDecimal MeasureTarget, String trxName) {
        super(ctx, 0, trxName);
        this.setName(Name2);
        this.setDescription(Description);
        this.setMeasureTarget(MeasureTarget);
    }

    public MGoalRestriction[] getRestrictions(boolean reload) {
        ArrayList<MGoalRestriction> list;
        block7: {
            if (this.m_restrictions != null && !reload) {
                return this.m_restrictions;
            }
            list = new ArrayList<MGoalRestriction>();
            String sql = "SELECT * FROM PA_GoalRestriction WHERE PA_Goal_ID=? AND IsActive='Y' ORDER BY Org_ID, C_BPartner_ID, M_Product_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getPA_Goal_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MGoalRestriction(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_restrictions = new MGoalRestriction[list.size()];
        list.toArray(this.m_restrictions);
        return this.m_restrictions;
    }

    public MMeasure getMeasure() {
        if (this.getPA_Measure_ID() != 0) {
            return MMeasure.get(this.getPA_Measure_ID());
        }
        return null;
    }

    public boolean updateGoal(boolean force) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Force=" + force);
        }
        MMeasure measure = MMeasure.get(this.getPA_Measure_ID());
        boolean isUpdateByInterfal = false;
        if (this.getDateLastRun() != null) {
            long interval = MSysConfig.getIntValue("ZK_DASHBOARD_PERFORMANCE_REFRESH_INTERVAL", 1800000, Env.getAD_Client_ID(Env.getCtx()));
            boolean bl = isUpdateByInterfal = System.currentTimeMillis() - this.getDateLastRun().getTime() > interval;
        }
        if ((force || this.getDateLastRun() == null || isUpdateByInterfal) && (measure = new MMeasure(Env.getCtx(), measure, this.get_TrxName())).updateGoals()) {
            this.load(this.get_ID(), this.get_TrxName(), new String[0]);
            return true;
        }
        return false;
    }

    @Override
    public void setMeasureActual(BigDecimal MeasureActual) {
        if (MeasureActual == null) {
            return;
        }
        super.setMeasureActual(MeasureActual);
        this.setDateLastRun(new Timestamp(System.currentTimeMillis()));
        this.setGoalPerformance();
    }

    public void setGoalPerformance() {
        BigDecimal MeasureTarget = this.getMeasureTarget();
        BigDecimal MeasureActual = this.getMeasureActual();
        BigDecimal GoalPerformance = Env.ZERO;
        if (MeasureTarget.signum() != 0) {
            GoalPerformance = MeasureActual.divide(MeasureTarget, 6, RoundingMode.HALF_UP);
        }
        super.setGoalPerformance(GoalPerformance);
        this.m_color = null;
    }

    public double getGoalPerformanceDouble() {
        BigDecimal bd = this.getGoalPerformance();
        return bd.doubleValue();
    }

    public int getPercent() {
        BigDecimal bd = this.getGoalPerformance().multiply(Env.ONEHUNDRED);
        return bd.intValue();
    }

    public Color getColor() {
        if (this.m_color == null) {
            this.m_color = this.getMeasureTarget().signum() == 0 ? Color.white : MColorSchema.getColor(this.getCtx(), this.getPA_ColorSchema_ID(), this.getPercent());
        }
        return this.m_color;
    }

    public MColorSchema getColorSchema() {
        return MColorSchema.getCopy(this.getCtx(), this.getPA_ColorSchema_ID(), this.get_TrxName());
    }

    @Override
    public String getMeasureDisplay() {
        String s = super.getMeasureDisplay();
        if (s == null) {
            s = "7".equals(this.getMeasureScope()) ? "7" : ("8".equals(this.getMeasureScope()) ? "8" : "5");
        }
        return s;
    }

    public String getXAxisText() {
        MMeasure measure = this.getMeasure();
        if (measure != null && "S".equals(measure.getMeasureDataType())) {
            if ("Q".equals(measure.getMeasureType())) {
                return Msg.getElement(this.getCtx(), "R_Status_ID");
            }
            if ("P".equals(measure.getMeasureType())) {
                return Msg.getElement(this.getCtx(), "C_Phase_ID");
            }
        }
        String value = this.getMeasureDisplay();
        String display = MRefList.getListName(this.getCtx(), 367, value);
        return display == null ? value : display;
    }

    public boolean isTarget() {
        return this.getMeasureTarget().signum() != 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MGoal[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",").append(this.getGoalPerformance()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!this.isSummary() && this.getPA_Measure_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "PA_Measure_ID"));
            return false;
        }
        if (this.isSummary() && this.getPA_Measure_ID() != 0) {
            this.setPA_Measure_ID(0);
        }
        if ((newRecord || this.is_ValueChanged("AD_User_ID") || this.is_ValueChanged("AD_Role_ID")) && this.getAD_User_ID() != 0) {
            MUser user = MUser.get(this.getCtx(), this.getAD_User_ID());
            MRole[] roles = user.getRoles(this.getAD_Org_ID());
            if (roles.length == 0) {
                this.setAD_Role_ID(0);
            } else if (roles.length == 1) {
                this.setAD_Role_ID(roles[0].getAD_Role_ID());
            } else {
                int AD_Role_ID = this.getAD_Role_ID();
                if (AD_Role_ID != 0) {
                    boolean found = false;
                    int i2 = 0;
                    while (i2 < roles.length) {
                        if (AD_Role_ID == roles[i2].getAD_Role_ID()) {
                            found = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!found) {
                        AD_Role_ID = 0;
                    }
                }
                if (AD_Role_ID == 0) {
                    this.setAD_Role_ID(roles[0].getAD_Role_ID());
                }
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord || this.is_ValueChanged("MeasureTarget") || this.is_ValueChanged("MeasureScope")) {
            this.updateGoal(true);
        }
        return success;
    }
}

