/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.BPartnerNoAddressException;
import org.compiere.model.I_C_DunningLevel;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MDunningRun;
import org.compiere.model.MDunningRunLine;
import org.compiere.model.MPayment;
import org.compiere.model.MUser;
import org.compiere.model.X_C_BPartner_Location;
import org.compiere.model.X_C_DunningRunEntry;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MDunningRunEntry
extends X_C_DunningRunEntry {
    private static final long serialVersionUID = -3838792682143065656L;
    private static CLogger s_log = CLogger.getCLogger(MPayment.class);
    private MDunningRun m_parent = null;

    public MDunningRunEntry(Properties ctx, int C_DunningRunEntry_ID, String trxName) {
        super(ctx, C_DunningRunEntry_ID, trxName);
        if (C_DunningRunEntry_ID == 0) {
            this.setAmt(Env.ZERO);
            this.setQty(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MDunningRunEntry(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDunningRunEntry(MDunningRun parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setC_DunningRun_ID(parent.getC_DunningRun_ID());
        this.m_parent = parent;
    }

    public void setBPartner(MBPartner bp, boolean isSOTrx) {
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        MBPartnerLocation[] locations = bp.getLocations(false);
        if (locations.length == 1) {
            this.setC_BPartner_Location_ID(locations[0].getC_BPartner_Location_ID());
        } else {
            MBPartnerLocation firstActive = null;
            X_C_BPartner_Location firstBillTo = null;
            int i2 = 0;
            while (i2 < locations.length) {
                MBPartnerLocation location = locations[i2];
                if (location.isActive()) {
                    if (firstActive == null) {
                        firstActive = location;
                    }
                    if (location.isPayFrom() && isSOTrx || location.isRemitTo() && !isSOTrx) {
                        this.setC_BPartner_Location_ID(location.getC_BPartner_Location_ID());
                        break;
                    }
                    if (firstBillTo == null && location.isBillTo()) {
                        firstBillTo = location;
                    }
                }
                ++i2;
            }
            if (this.getC_BPartner_Location_ID() == 0) {
                if (firstBillTo != null) {
                    this.setC_BPartner_Location_ID(firstBillTo.getC_BPartner_Location_ID());
                } else if (firstActive != null) {
                    StringBuilder msg = new StringBuilder("@C_BPartner_ID@ ").append(bp.getName());
                    if (isSOTrx) {
                        msg.append(" @No@ @IsPayFrom@");
                    } else {
                        msg.append(" @No@ @IsRemitTo@");
                    }
                    msg.append(" & @IsBillTo@");
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info(msg.toString());
                    }
                    this.setC_BPartner_Location_ID(firstActive.getC_BPartner_Location_ID());
                }
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            throw new BPartnerNoAddressException(bp);
        }
        MUser[] users = MUser.getOfBPartner(this.getCtx(), bp.getC_BPartner_ID(), this.get_TrxName());
        if (users.length == 1) {
            this.setAD_User_ID(users[0].getAD_User_ID());
        } else {
            int i3 = 0;
            while (i3 < users.length) {
                MUser user = users[i3];
                if (user.getC_BPartner_Location_ID() == this.getC_BPartner_Location_ID()) {
                    this.setAD_User_ID(users[i3].getAD_User_ID());
                    break;
                }
                ++i3;
            }
        }
        int SalesRep_ID = bp.getSalesRep_ID();
        if (SalesRep_ID != 0) {
            this.setSalesRep_ID(SalesRep_ID);
        }
    }

    public MDunningRunLine[] getLines() {
        return this.getLines(false);
    }

    public MDunningRunLine[] getLines(boolean onlyInvoices) {
        ArrayList<MDunningRunLine> list;
        block7: {
            list = new ArrayList<MDunningRunLine>();
            StringBuilder sql = new StringBuilder("SELECT * FROM C_DunningRunLine WHERE C_DunningRunEntry_ID=?");
            if (onlyInvoices) {
                sql.append(" AND C_Invoice_ID IS NOT NULL");
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
                    pstmt.setInt(1, this.get_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MDunningRunLine(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MDunningRunLine[] retValue = new MDunningRunLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public boolean hasInvoices() {
        boolean retValue;
        block6: {
            retValue = false;
            String sql = "SELECT COUNT(*) FROM C_DunningRunLine WHERE C_DunningRunEntry_ID=? AND C_Invoice_ID IS NOT NULL";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.get_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next() && rs.getInt(1) > 0) {
                        retValue = true;
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        I_C_DunningLevel level = this.getC_DunningLevel();
        if (this.isProcessed()) {
            MDunningRunLine[] theseLines = this.getLines();
            int i2 = 0;
            while (i2 < theseLines.length) {
                theseLines[i2].setProcessed(true);
                theseLines[i2].saveEx(this.get_TrxName());
                ++i2;
            }
            if (level.isSetCreditStop() || level.isSetPaymentTerm()) {
                MBPartner thisBPartner = MBPartner.get(this.getCtx(), this.getC_BPartner_ID());
                if (level.isSetCreditStop()) {
                    thisBPartner.setSOCreditStatus("S");
                }
                if (level.isSetPaymentTerm()) {
                    thisBPartner.setC_PaymentTerm_ID(level.getC_PaymentTerm_ID());
                }
                thisBPartner.saveEx();
            }
        }
        return true;
    }
}

